/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.TransientSpec;
import com.cognos.viewer.view.ReportBodyGenerator;
import com.cognos.xts.ext.XTSExt;
import java.util.List;
import org.dom4j.Element;

public class CognosViewerFragmentJavaScriptObject {
    private ICognosViewerActionResponse m_actionResponse = null;
    private StringBuilder m_sbOutput = null;
    private String m_sNamespace = "";

    public CognosViewerFragmentJavaScriptObject(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        this.m_actionResponse = actionResponse;
        this.m_sbOutput = sbOutput;
        if (this.m_actionResponse != null) {
            this.m_sNamespace = this.m_actionResponse.getFormFieldAsString("cv.id");
        }
    }

    public void render() {
        ReportBodyGenerator.writeScriptOpeningTag(this.m_sbOutput, false);
        this.constructObject();
        this.renderSharedPrompts();
        this.renderSharedDrillEvents();
        this.renderSharedAuthoredDrillEvents();
        this.renderBUXFlag();
        ReportBodyGenerator.writeScriptClosingTag(this.m_sbOutput, false);
    }

    public void constructObject() {
        if (this.m_sbOutput != null) {
            this.m_sbOutput.append("window.oCV" + this.m_sNamespace + ".m_viewerFragment = new CCognosViewerFragment(" + "window.oCV" + this.m_sNamespace + ");\n");
        }
    }

    public void renderSharedPrompts() {
        String sPromptChannel;
        String sSharePromptEvents = this.m_actionResponse.getFormFieldAsString("fragment.sharePromptValues");
        if ("true".equals(sSharePromptEvents)) {
            List burstItemList;
            sPromptChannel = this.m_actionResponse.getFormFieldAsString("fragment.promptChannel");
            if (sPromptChannel.length() > 0) {
                sPromptChannel = "PROMPTCHANNEL_" + sPromptChannel;
            }
            this.m_sbOutput.append("window.oCV" + this.m_sNamespace + ".m_viewerFragment.m_bSharePromptValues = true;\n");
            this.m_sbOutput.append("window.oCV" + this.m_sNamespace + ".m_viewerFragment.m_bMatchOnParameterNameOnly = ");
            if ("true".equals(this.m_actionResponse.getFormFieldAsString("fragment.matchOnParameterNameOnly"))) {
                this.m_sbOutput.append("true;\n");
            } else {
                this.m_sbOutput.append("false;\n");
            }
            TransientSpec transientSpec = new TransientSpec(this.m_actionResponse);
            try {
                transientSpec.initialize(this.m_actionResponse.getFormFieldAsString("cv.transientSpec"));
            }
            catch (Exception exception) {
                IPFLogger.getInstance().error("Caught exception in renderSharedPrompts: " + exception.getMessage(), this.getClass().getName());
                return;
            }
            List reportParameterList = transientSpec.getReportParameterList();
            if (reportParameterList != null) {
                int reportParameterListSize = reportParameterList.size();
                for (int index = 0; index < reportParameterListSize; ++index) {
                    Element reportParameter = (Element)reportParameterList.get(index);
                    String sParameterName = reportParameter.attributeValue("parameterName");
                    String sModelItem = reportParameter.attributeValue("modelItem");
                    this.m_sbOutput.append("window.oCV" + this.m_sNamespace + ".m_viewerFragment.m_reportParameters[\"" + XTSExt.javascriptencode((String)(sPromptChannel + sParameterName)) + "\"] = \"" + XTSExt.javascriptencode((String)sModelItem) + "\";\n");
                }
            }
            if ((burstItemList = transientSpec.getBurstItemList()) != null) {
                int burstItemListSize = burstItemList.size();
                for (int index = 0; index < burstItemListSize; ++index) {
                    Element burstItem = (Element)burstItemList.get(index);
                    String sBurstName = burstItem.attributeValue("burstName");
                    String sModelItem = burstItem.attributeValue("modelItem");
                    this.m_sbOutput.append("window.oCV" + this.m_sNamespace + ".m_viewerFragment.m_burstItems[\"" + XTSExt.javascriptencode((String)(sPromptChannel + sBurstName)) + "\"] = \"" + XTSExt.javascriptencode((String)sModelItem) + "\";\n");
                }
            }
        }
        if (!"".equals(sPromptChannel = this.m_actionResponse.getFormFieldAsString("fragment.promptChannel"))) {
            this.m_sbOutput.append("window.oCV" + this.m_sNamespace + ".m_viewerFragment.m_promptChannel = \"" + XTSExt.javascriptencode((String)sPromptChannel) + "\";\n");
        }
    }

    public void renderSharedDrillEvents() {
        if (this.m_actionResponse != null && this.m_sbOutput != null) {
            String sDrillChannel;
            String sShareDrillEvents = this.m_actionResponse.getFormFieldAsString("fragment.shareDrillEvents");
            if ("true".equals(sShareDrillEvents)) {
                this.m_sbOutput.append("window.oCV" + this.m_sNamespace + ".m_viewerFragment.m_bShareDrillEvents = true;\n");
            }
            if (!"".equals(sDrillChannel = this.m_actionResponse.getFormFieldAsString("fragment.drillChannel"))) {
                this.m_sbOutput.append("window.oCV" + this.m_sNamespace + ".m_viewerFragment.m_drillChannel = \"" + XTSExt.javascriptencode((String)sDrillChannel) + "\";\n");
            }
        }
    }

    public void renderSharedAuthoredDrillEvents() {
        if (this.m_actionResponse != null && this.m_sbOutput != null) {
            String sAuthoredDrillChannel;
            String sShareAuthoredDrillEvents = this.m_actionResponse.getFormFieldAsString("fragment.shareAuthoredDrillEvents");
            if ("true".equals(sShareAuthoredDrillEvents)) {
                this.m_sbOutput.append("window.oCV" + this.m_sNamespace + ".m_viewerFragment.m_bShareAuthoredDrillEvents = true;\n");
            }
            if (!"".equals(sAuthoredDrillChannel = this.m_actionResponse.getFormFieldAsString("fragment.authoredDrillChannel"))) {
                this.m_sbOutput.append("window.oCV" + this.m_sNamespace + ".m_viewerFragment.m_authoredDrillChannel = \"" + XTSExt.javascriptencode((String)sAuthoredDrillChannel) + "\";\n");
            }
        }
    }

    public void renderBUXFlag() {
        if (this.m_actionResponse != null && "true".equals(this.m_actionResponse.getFormFieldAsString("bux"))) {
            this.m_sbOutput.append("window.oCV" + this.m_sNamespace + ".m_viewerFragment.m_bBux = true;");
        }
    }
}

