/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.toolbar.ToolbarFactory;
import com.cognos.viewer.toolbar.ToolbarRule;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.xts.ext.XTSExt;
import com.ibm.cognos.i18n.util.Bidi;
import java.lang.reflect.Method;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class CognosViewerJSONToolbar {
    public static final String JSON_TOOLBAR_SPECIFICATION = "S";
    public static final String JSON_TOOLBAR_BUTTON = "B";
    public static final String JSON_TOOLBAR_STATIC_TEXT = "T";
    public static final String JSON_TOOLBAR_LINK = "L";
    public static final String JSON_TOOLBAR_SEPERATOR = "P";
    public static final String JSON_TOOLBAR_MENU = "M";
    public static final String JSON_TOOLBAR_MENU_ITEM = "I";
    public static final String JSON_TOOLBAR_MENU_ITEMS = "IS";
    public static final String JSON_TOOLBAR_MENU_TYPE_DROPDOWN = "dropDown";
    public static final String JSON_TOOLBAR_MENU_TYPE_CASCADED = "cascaded";
    public static final String JSON_TOOLBAR_ICON = "C";
    public static final String JSON_TOOLBAR_NAME = "N";
    public static final String JSON_TOOLBAR_TEXT = "E";
    public static final String JSON_TOOLBAR_TOOLTIP = "O";
    public static final String JSON_TOOLBAR_ACTION = "A";
    public static final String JSON_TOOLBAR_DISABLED = "D";
    public static final String JSON_TOOLBAR_TYPE = "Y";
    public static final String JSON_TOOLBAR_HIDE_SINGLE_ITEM_MENU = "H";
    public static final String JSON_TOOLBAR_ALT_TEXT = "ALT";
    public static final String JSON_TOOLBAR_CVID = "_CVID_";
    private ICognosViewerActionResponse m_actionResponse = null;
    private String m_sCognosViewerID = "";
    private String m_sProductLocale = "";
    private String m_sWebContent = "";
    private String m_sEncodedWebContent = "";
    private boolean m_bIsRTL = false;

    public CognosViewerJSONToolbar(ICognosViewerActionResponse actionResponse) {
        this.m_actionResponse = actionResponse;
        if (actionResponse != null) {
            this.m_sWebContent = actionResponse.getWebContentRoot();
            this.m_sCognosViewerID = actionResponse.getFormFieldAsString("cv.id");
            this.m_sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
            if (Bidi.isLocaleRTL((String)this.m_sProductLocale)) {
                this.m_bIsRTL = true;
            }
        }
        this.m_sEncodedWebContent = XTSExt.javascriptencode((String)this.m_sWebContent);
    }

    public static void writeJavaScript(ICognosViewerActionResponse actionResponse, Element xmlSpecification, StringBuilder sbOutput) {
        List javascriptNodes = xmlSpecification.selectNodes("javascript");
        for (int iIndex = 0; iIndex < javascriptNodes.size(); ++iIndex) {
            Element javascriptElement = (Element)javascriptNodes.get(iIndex);
            String src = javascriptElement.attributeValue("src");
            if (src == null || "".equals(src)) continue;
            if (src.indexOf("#webContent#") != -1) {
                src = src.replaceAll("#webContent#", actionResponse.getWebContentRoot());
            }
            sbOutput.append("<script type=\"text/javascript\" src=\"" + src + "\"></script>\n");
        }
    }

    public StringBuffer render(Element xmlSpecification) {
        if (this.m_actionResponse == null) {
            return new StringBuffer();
        }
        StringBuffer sbOutput = new StringBuffer();
        String itemState = ToolbarFactory.getRuleObject(xmlSpecification).getState(this.m_actionResponse, xmlSpecification).getValue();
        if (!"hidden".equals(itemState)) {
            Attribute toolbarStyleAttribute;
            sbOutput.append("{\"namespace\":\"");
            sbOutput.append(this.m_sCognosViewerID);
            sbOutput.append('\"');
            Attribute divIDAttribute = xmlSpecification.attribute("divID");
            if (divIDAttribute != null) {
                sbOutput.append(",\"divId\":\"");
                sbOutput.append(this.replaceCVID(divIDAttribute.getStringValue()));
                sbOutput.append('\"');
            }
            if ((toolbarStyleAttribute = xmlSpecification.attribute("style")) != null) {
                sbOutput.append(",\"style\":\"");
                sbOutput.append(toolbarStyleAttribute.getStringValue());
                sbOutput.append('\"');
            }
            sbOutput.append(',');
            sbOutput.append('\"');
            sbOutput.append(JSON_TOOLBAR_SPECIFICATION);
            sbOutput.append('\"');
            sbOutput.append(':');
            sbOutput.append('[');
            try {
                sbOutput.append(this.genJSONFromChildren(xmlSpecification, "{", "}", ""));
            }
            catch (CognosViewerException ex) {
                IPFLogger.getInstance().error(ex.getMessage(), ex, this.getClass().getName());
            }
            sbOutput.append(']');
            sbOutput.append('}');
        }
        return sbOutput;
    }

    private StringBuffer genJSONFromChildren(Element elementItem, String sOpeningDelimiter, String sClosingDelimiter, String sItemState) throws CognosViewerException {
        StringBuffer sbOutput = new StringBuffer();
        List toolbarItems = elementItem.elements();
        int iNumberOfItems = toolbarItems.size();
        boolean emptyArrayMember = true;
        try {
            for (int iIndex = 0; iIndex < iNumberOfItems; ++iIndex) {
                Element currentItem = (Element)toolbarItems.get(iIndex);
                String sItemName = currentItem.getName();
                if (sItemName.equals("javascript") || sItemName.equals("resourceBundle")) continue;
                Method jsonMethod = this.getClass().getMethod(sItemName, Element.class);
                StringBuffer sbJSON = (StringBuffer)jsonMethod.invoke((Object)this, currentItem);
                if (sbJSON.length() <= 0) continue;
                if (iIndex > 0 && !emptyArrayMember) {
                    sbOutput.append(',');
                }
                sbOutput.append(sOpeningDelimiter);
                sbOutput.append(sbJSON);
                sbOutput.append(sClosingDelimiter);
                emptyArrayMember = false;
            }
            if ("disabled".equals(sItemState)) {
                if (sbOutput.length() > 0 && !emptyArrayMember) {
                    sbOutput.append(',');
                }
                sbOutput.append('\"');
                sbOutput.append(JSON_TOOLBAR_DISABLED);
                sbOutput.append("\":\"true\"");
            }
        }
        catch (Exception exception) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
            throw cognosViewerException;
        }
        return sbOutput;
    }

    public StringBuffer action(Element elementItem) {
        StringBuffer sbOutput = new StringBuffer();
        sbOutput.append('\"');
        sbOutput.append(JSON_TOOLBAR_ACTION);
        sbOutput.append('\"');
        sbOutput.append(':');
        sbOutput.append('\"');
        sbOutput.append(XTSExt.javascriptencode((String)this.replaceCVID(elementItem.getStringValue())));
        sbOutput.append('\"');
        return sbOutput;
    }

    public StringBuffer button(Element elementItem) {
        StringBuffer sbOutput = new StringBuffer();
        String itemState = ToolbarFactory.getRuleObject(elementItem).getState(this.m_actionResponse, elementItem).getValue();
        if (!"hidden".equals(itemState)) {
            Element newElement = this.checkForDynamic(elementItem);
            sbOutput.append('\"');
            sbOutput.append(JSON_TOOLBAR_BUTTON);
            sbOutput.append('\"');
            sbOutput.append(':');
            sbOutput.append('{');
            try {
                sbOutput.append(this.genJSONFromChildren(newElement, "", "", itemState));
            }
            catch (CognosViewerException ex) {
                IPFLogger.getInstance().error(ex.getMessage(), ex, this.getClass().getName());
            }
            sbOutput.append('}');
        }
        return sbOutput;
    }

    public StringBuffer dropDownMenu(Element elementItem) {
        StringBuffer sbOutput = new StringBuffer();
        String itemState = ToolbarFactory.getRuleObject(elementItem).getState(this.m_actionResponse, elementItem).getValue();
        if (!"hidden".equals(itemState)) {
            String menuName = "";
            Element parentNameElement = elementItem.getParent();
            if (parentNameElement != null && parentNameElement.element("name") != null) {
                menuName = parentNameElement.element("name").getStringValue();
            }
            sbOutput.append('\"');
            sbOutput.append(JSON_TOOLBAR_MENU);
            sbOutput.append('\"');
            sbOutput.append(':');
            sbOutput.append('{');
            sbOutput.append("\"id\":\"");
            sbOutput.append(menuName);
            sbOutput.append(this.m_actionResponse.getFormFieldAsString("CV_jsID"));
            sbOutput.append('\"');
            if (elementItem.attribute("type") != null && JSON_TOOLBAR_MENU_TYPE_CASCADED.equals(elementItem.attribute("type").getStringValue())) {
                sbOutput.append(',');
                sbOutput.append('\"');
                sbOutput.append(JSON_TOOLBAR_TYPE);
                sbOutput.append('\"');
                sbOutput.append(':');
                sbOutput.append('\"');
                sbOutput.append(JSON_TOOLBAR_MENU_TYPE_CASCADED);
                sbOutput.append('\"');
            } else {
                sbOutput.append(',');
                sbOutput.append('\"');
                sbOutput.append(JSON_TOOLBAR_TYPE);
                sbOutput.append('\"');
                sbOutput.append(':');
                sbOutput.append('\"');
                sbOutput.append(JSON_TOOLBAR_MENU_TYPE_DROPDOWN);
                sbOutput.append('\"');
            }
            if (elementItem.attribute("showSingleItemMenu") != null && "false".equals(elementItem.attribute("showSingleItemMenu").getStringValue())) {
                sbOutput.append(',');
                sbOutput.append('\"');
                sbOutput.append(JSON_TOOLBAR_HIDE_SINGLE_ITEM_MENU);
                sbOutput.append('\"');
                sbOutput.append(':');
                sbOutput.append('\"');
                sbOutput.append("true");
                sbOutput.append('\"');
            }
            if (elementItem.attribute("callback") != null && "true".equals(elementItem.attribute("callback").getStringValue())) {
                sbOutput.append(",");
                sbOutput.append(this.action(elementItem.element("action")));
            } else {
                sbOutput.append(',');
                sbOutput.append('\"');
                sbOutput.append(JSON_TOOLBAR_MENU_ITEMS);
                sbOutput.append('\"');
                sbOutput.append(':');
                sbOutput.append('[');
                try {
                    sbOutput.append(this.genJSONFromChildren(elementItem, "{", "}", itemState));
                }
                catch (CognosViewerException ex) {
                    IPFLogger.getInstance().error(ex.getMessage(), ex, this.getClass().getName());
                }
                sbOutput.append(']');
            }
            sbOutput.append('}');
        }
        return sbOutput;
    }

    public StringBuffer icon(Element elementItem) {
        int iDotIndex;
        StringBuffer sbOutput = new StringBuffer();
        Attribute useSkinAttribute = elementItem.attribute("useSkin");
        Attribute rtlAvailable = elementItem.attribute("rtlAvailable");
        String sIconPath = elementItem.getStringValue();
        if (this.m_bIsRTL && rtlAvailable != null && "true".equals(rtlAvailable.getStringValue()) && (iDotIndex = sIconPath.indexOf(".")) > 0) {
            sIconPath = sIconPath.substring(0, iDotIndex) + "_rtl" + sIconPath.substring(iDotIndex);
        }
        if (useSkinAttribute != null && "true".equals(useSkinAttribute.getStringValue())) {
            String sSkin = this.m_sEncodedWebContent + "/skins/" + this.m_actionResponse.getUserPreference("skin");
            sbOutput.append('\"');
            sbOutput.append(JSON_TOOLBAR_ICON);
            sbOutput.append('\"');
            sbOutput.append(':');
            sbOutput.append('\"');
            sbOutput.append(sSkin);
            sbOutput.append(sIconPath);
            sbOutput.append('\"');
        } else {
            sbOutput.append('\"');
            sbOutput.append(JSON_TOOLBAR_ICON);
            sbOutput.append('\"');
            sbOutput.append(':');
            sbOutput.append('\"');
            sbOutput.append(this.m_sEncodedWebContent);
            sbOutput.append(sIconPath);
            sbOutput.append('\"');
        }
        return sbOutput;
    }

    public StringBuffer link(Element elementItem) {
        StringBuffer sbOutput = new StringBuffer();
        String itemState = ToolbarFactory.getRuleObject(elementItem).getState(this.m_actionResponse, elementItem).getValue();
        if (!"hidden".equals(itemState)) {
            sbOutput.append('\"');
            sbOutput.append(JSON_TOOLBAR_LINK);
            sbOutput.append('\"');
            sbOutput.append(':');
            sbOutput.append('{');
            try {
                sbOutput.append(this.genJSONFromChildren(elementItem, "", "", itemState));
            }
            catch (CognosViewerException ex) {
                IPFLogger.getInstance().error(ex.getMessage(), ex, this.getClass().getName());
            }
            sbOutput.append('}');
        }
        return sbOutput;
    }

    public StringBuffer menuItem(Element elementItem) {
        StringBuffer sbOutput = new StringBuffer();
        String itemState = ToolbarFactory.getRuleObject(elementItem).getState(this.m_actionResponse, elementItem).getValue();
        if (!"hidden".equals(itemState)) {
            Element newElement = this.checkForDynamic(elementItem);
            sbOutput.append('\"');
            sbOutput.append(JSON_TOOLBAR_MENU_ITEM);
            sbOutput.append('\"');
            sbOutput.append(':');
            sbOutput.append('{');
            try {
                sbOutput.append(this.genJSONFromChildren(newElement, "", "", itemState));
            }
            catch (CognosViewerException ex) {
                IPFLogger.getInstance().error(ex.getMessage(), ex, this.getClass().getName());
            }
            sbOutput.append('}');
        }
        return sbOutput;
    }

    public StringBuffer name(Element elementItem) {
        StringBuffer sbOutput = new StringBuffer();
        sbOutput.append('\"');
        sbOutput.append(JSON_TOOLBAR_NAME);
        sbOutput.append('\"');
        sbOutput.append(':');
        sbOutput.append('\"');
        sbOutput.append(elementItem.getStringValue());
        sbOutput.append('\"');
        return sbOutput;
    }

    public StringBuffer separator(Element elementItem) {
        StringBuffer sbOutput = new StringBuffer();
        sbOutput.append('\"');
        sbOutput.append(JSON_TOOLBAR_SEPERATOR);
        sbOutput.append('\"');
        sbOutput.append(':');
        sbOutput.append('{');
        sbOutput.append('\"');
        sbOutput.append(JSON_TOOLBAR_TYPE);
        sbOutput.append('\"');
        sbOutput.append(':');
        sbOutput.append('\"');
        sbOutput.append("vertical_line");
        sbOutput.append('\"');
        sbOutput.append('}');
        return sbOutput;
    }

    public StringBuffer staticText(Element elementItem) {
        StringBuffer sbOutput = new StringBuffer();
        String itemState = ToolbarFactory.getRuleObject(elementItem).getState(this.m_actionResponse, elementItem).getValue();
        if (!"hidden".equals(itemState)) {
            Element newElement = this.checkForDynamic(elementItem);
            sbOutput.append('\"');
            sbOutput.append(JSON_TOOLBAR_STATIC_TEXT);
            sbOutput.append('\"');
            sbOutput.append(':');
            sbOutput.append('{');
            try {
                sbOutput.append(this.genJSONFromChildren(newElement, "", "", itemState));
            }
            catch (CognosViewerException ex) {
                IPFLogger.getInstance().error(ex.getMessage(), ex, this.getClass().getName());
            }
            sbOutput.append('}');
        }
        return sbOutput;
    }

    public StringBuffer text(Element elementItem) {
        return this.addTextProperty(elementItem, JSON_TOOLBAR_TEXT);
    }

    public StringBuffer tooltip(Element elementItem) {
        return this.addTextProperty(elementItem, JSON_TOOLBAR_TOOLTIP);
    }

    public StringBuffer alt(Element elementItem) {
        return this.addTextProperty(elementItem, JSON_TOOLBAR_ALT_TEXT);
    }

    private StringBuffer addTextProperty(Element elementItem, String jsonName) {
        StringBuffer sbOutput = new StringBuffer();
        Element stringElement = elementItem.element("string");
        sbOutput.append('\"');
        sbOutput.append(jsonName);
        sbOutput.append('\"');
        sbOutput.append(':');
        sbOutput.append('\"');
        if (stringElement != null) {
            Attribute id = stringElement.attribute("id");
            sbOutput.append(XTSExt.javascriptencode((String)MessageManager.convert(id.getStringValue(), this.m_sProductLocale)));
        } else {
            sbOutput.append(XTSExt.javascriptencode((String)elementItem.getStringValue()));
        }
        sbOutput.append('\"');
        return sbOutput;
    }

    private String replaceCVID(String sValue) {
        return sValue.replaceAll(JSON_TOOLBAR_CVID, this.m_sCognosViewerID);
    }

    private Element checkForDynamic(Element elementItem) {
        if (elementItem.attribute("dynamic") != null && "true".equals(elementItem.attribute("dynamic").getStringValue())) {
            Element newElement = (Element)elementItem.clone();
            ToolbarRule ruleObject = ToolbarFactory.getRuleObject(newElement);
            if (ruleObject != null) {
                ruleObject.processDynamicElement(this.m_actionResponse, newElement);
            }
            return newElement;
        }
        return elementItem;
    }
}

