/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.caf.CAFLibrary;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.GenericOptionXMLEncodedXML;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.util.NameValuePair;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.configuration.CognosViewerBlacklist;
import com.cognos.viewer.configuration.CognosViewerSystemParams;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.Capabilities;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.utility.BrowserUtility;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.JSONObject;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.view.CognosViewerResponseStateExtention;
import com.cognos.xts.ext.XTSExt;
import com.ibm.cognos.i18n.util.Bidi;
import java.util.Hashtable;
import org.dom4j.Element;

public class CognosViewerJavaScriptObject {
    protected ICognosViewerState m_state = null;
    protected StringBuilder m_sbOutput = null;
    protected String m_sCVId = "";
    protected String m_sCVObject = "oCV";
    protected String m_sCVObjectRef = "window.oCV";
    private static Hashtable m_cachedNavigationLinks = new Hashtable();

    public CognosViewerJavaScriptObject(ICognosViewerState state, StringBuilder sbOutput) {
        this.m_state = state;
        this.m_sbOutput = sbOutput;
        if (this.m_state != null && this.m_sbOutput != null) {
            this.m_sCVId = this.m_state.getFormFieldAsString("cv.id");
            this.m_sCVObject = this.m_sCVObject + this.m_sCVId;
            this.m_sCVObjectRef = this.m_sCVObjectRef + this.m_sCVId;
        }
    }

    public String getCvId() {
        return this.m_sCVId;
    }

    public void constructObject() {
        SearchPathSingleObject searchPath;
        if ("true".equals(this.m_state.getFormFieldAsString("cv.detachRelease"))) {
            this.m_sbOutput.append("if (window.detachLeavingRV) { window.detachLeavingRV(); };\n");
        }
        this.m_sbOutput.append(this.m_sCVObject + " = new CCognosViewer(\"" + this.m_sCVId + "\", \"" + XTSExt.javascriptencode((String)this.m_state.getEnvironmentVariable("SCRIPT_NAME")) + "\");\n");
        String sHttpUserAgent = this.m_state.getEnvironmentVariable("HTTP_USER_AGENT");
        String sBrowser = BrowserUtility.getBrowser(sHttpUserAgent);
        this.m_sbOutput.append(this.m_sCVObjectRef + ".sBrowser = \"" + sBrowser + "\";\n");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".sGateway = \"" + CognosViewerDispatcherHandler.getGateway() + "\";\n");
        String sCAFContextId = this.getCAFContextId(this.m_state.getCAMPassport());
        if (sCAFContextId != null && !sCAFContextId.isEmpty()) {
            this.m_sbOutput.append(this.m_sCVObjectRef + ".setCAFContext(\"" + XTSExt.javascriptencode((String)sCAFContextId) + "\");\n");
        }
        boolean bIsSavedReport = (searchPath = this.m_state.getObjectPath()) != null && searchPath.get_value().length() != 0 && this.m_state.getSpecification() == null;
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bIsSavedReport = " + Boolean.toString(bIsSavedReport) + ";\n");
        String sEncodedWebContentRoot = XTSExt.javascriptencode((String)this.m_state.getWebContentRoot());
        String sEncodedSkin = XTSExt.javascriptencode((String)this.m_state.getUserPreference("skin"));
        String SKIN_ROOT = sEncodedWebContentRoot + "/skins/";
        this.m_sbOutput.append(this.m_sCVObjectRef + ".sWebContentRoot = \"" + sEncodedWebContentRoot + "\";\n");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".sSkin = \"" + SKIN_ROOT + sEncodedSkin + "\";\n");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".sBrandImages = \"" + SKIN_ROOT + sEncodedSkin + "/branding/" + "\";\n");
        String locale = CognosViewerDispatcherHandlerState.getProductLocale(this.m_state);
        String dir = Bidi.isLocaleRTL((String)locale) ? "rtl" : "ltr";
        this.m_sbOutput.append(this.m_sCVObjectRef + ".sProductLocale = \"" + XTSExt.javascriptencode((String)locale) + "\";\n");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".sDirection = \"" + dir + "\";\n");
        boolean bidiEnabled = CognosViewerDispatcherHandlerState.isViewerBidiEnabled(this.m_state);
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bIsBidiEnabled = " + Boolean.toString(bidiEnabled) + ";\n");
        if (bidiEnabled) {
            String baseTextDirection = CognosViewerDispatcherHandlerState.getViewerBaseTextDirection(this.m_state);
            this.m_sbOutput.append(this.m_sCVObjectRef + ".sBaseTextDirection = \"" + baseTextDirection + "\";\n");
        }
        if ("true".equalsIgnoreCase(this.m_state.getFormFieldAsString("bux"))) {
            this.m_sbOutput.append(this.m_sCVObjectRef + ".m_bUseSafeMode = false;\n");
        }
        if (this.m_state.isAccessibleMode()) {
            this.m_sbOutput.append(this.m_sCVObjectRef + ".m_bAccessibleMode = true;\n");
        }
    }

    public void generateCreateCallback() {
        String createCallback = this.m_state.getFormFieldAsString("cv.createCallback");
        if (createCallback.length() > 0) {
            this.m_sbOutput.append("if (typeof window.parent['" + createCallback + "'] == 'function') {\n");
            this.m_sbOutput.append("  window.parent['" + createCallback + "']('" + this.m_sCVObject + "');\n");
            this.m_sbOutput.append("}\n");
        }
    }

    public void disableBrowserHotkeyPageNavigation() {
        this.m_sbOutput.append(this.m_sCVObjectRef + ".disableBrowserHotkeyPageNavigation();\n");
    }

    public void setUseWaitPage(boolean bUseWaitPage) {
        this.m_sbOutput.append(this.m_sCVObjectRef + ".setUseWorkingDialog(" + Boolean.toString(bUseWaitPage) + ");\n");
    }

    public void setUsePageRequests(boolean bUsePageRequest) {
        if (!"iWidget".equals(this.m_state.getFormFieldAsString("cv.responseFormat"))) {
            this.m_sbOutput.append(this.m_sCVObjectRef + ".setUsePageRequest(" + Boolean.toString(bUsePageRequest) + ");\n");
        }
    }

    public void setCancelAction(String sAction) {
        this.m_sbOutput.append(this.m_sCVObjectRef + ".setCancelAction(\"" + XTSExt.javascriptencode((String)sAction) + "\");\n");
    }

    public void setViewerCapabities() {
        Capabilities capabilities = this.m_state.getCapabilities();
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bCanUseCognosViewerContextMenu = " + Boolean.toString(capabilities.hasCapability("canUseCognosViewerContextMenu")) + ";\n");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bCanUseCognosViewerRunWithOptions = " + Boolean.toString(capabilities.hasCapability("canUseCognosViewerRunWithOptions")) + ";\n");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bCanUseCognosViewerIndexSearch = " + Boolean.toString(capabilities.hasCapability("canUseIndexSearch")) + ";\n");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bCanUseCognosViewerSelection = " + Boolean.toString(capabilities.hasCapability("canUseCognosViewerSelection")) + ";\n");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bCanUseCognosViewerToolbar = " + Boolean.toString(capabilities.hasCapability("canUseCognosViewerToolbar")) + ";\n");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bCanUseCognosViewerConditionalSubscriptions = " + Boolean.toString(capabilities.hasCapability("canUseConditionalSubscriptions")) + ";\n");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bCanUseLineage = " + Boolean.toString(capabilities.hasCapability("canUseLineage")) + ";\n");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bCanUseGlossary = " + Boolean.toString(capabilities.hasCapability("canUseGlossary")) + ";\n");
        this.customizeCapabilities(capabilities);
    }

    public void addEnvironmentVariables(ICognosViewerActionResponse actionResponse, String sProductLocale) {
        NameValuePair[] formFields;
        String sSpec = this.m_state.getFormFieldAsString("ui.spec");
        if (sSpec.startsWith("<") && "iWidget".equals(this.m_state.getFormFieldAsString("cv.responseFormat"))) {
            sSpec = EncodingUtility.xmlencode(sSpec);
            this.m_state.setFormFieldFromString("ui.spec", sSpec);
        }
        if ((formFields = this.m_state.getFormFields()) != null) {
            String freezeDefaultWrap;
            String useAlternateErrorCodeRendering;
            StringBuilder sbEnvironmentVariables = new StringBuilder(1024);
            JSONObject jsonObject = new JSONObject(sbEnvironmentVariables);
            for (int iIndex = 0; iIndex < formFields.length; ++iIndex) {
                if (formFields[iIndex].getName().startsWith("mock")) continue;
                jsonObject.addMember(formFields[iIndex].getName(), formFields[iIndex].getValue(), true, true);
            }
            String sAction = this.m_state.getFormFieldAsString("ui.action");
            if (sAction.compareTo("view") == 0) {
                if (this.m_state.getFormFieldAsString("ui.format").length() == 0) {
                    jsonObject.addMember("ui.format", actionResponse.getContentFormat(), false, false);
                }
            } else if (this.m_state.getFormFieldAsString("run.outputFormat").length() == 0) {
                jsonObject.addMember("run.outputFormat", actionResponse.getContentFormat(), false, false);
            }
            String sReportName = this.m_state.getFormFieldAsString("ui.name");
            String sReportViewerTitle = MessageManager.convert("REPORT_VIEWER_WINDOW_TITLE", sProductLocale);
            if (sReportName.length() > 0) {
                sReportViewerTitle = sReportViewerTitle + " - " + sReportName;
            }
            jsonObject.addMember("reportTitle", sReportViewerTitle, false, true);
            String sTitle = MessageManager.convert("REPORT_VIEWER_WINDOW_TITLE", sProductLocale);
            jsonObject.addMember("viewerTitle", sTitle, false, true);
            String excelWindowOpenProperties = CognosViewerDispatcherHandler.getConfigValues().getProperty("excelWindowOpenProperties", "");
            if (excelWindowOpenProperties.length() > 0) {
                jsonObject.addMember("cv.excelWindowOpenProperties", excelWindowOpenProperties, false, true);
            }
            if ((useAlternateErrorCodeRendering = CognosViewerDispatcherHandler.getConfigValues().getProperty("useAlternateErrorCodeRendering", "")).length() > 0) {
                jsonObject.addMember("useAlternateErrorCodeRendering", useAlternateErrorCodeRendering, false, false);
            }
            if ((freezeDefaultWrap = CognosViewerDispatcherHandler.getConfigValues().getProperty("VIEWER_JS_FREEZE_DEFAULT_NOWRAP", "")).length() > 0) {
                jsonObject.addMember("freezeDefaultWrap", freezeDefaultWrap, false, false);
            }
            this.customizeEnvironmentVariables(jsonObject);
            this.m_sbOutput.append(this.m_sCVObjectRef + ".envParams = { " + sbEnvironmentVariables + " };\n");
        }
    }

    public void setCustomizableFeatures() {
        Capabilities capabilities = this.m_state.getCapabilities();
        String cvToolbarValue = this.m_state.getFormFieldAsString("cv.toolbar");
        boolean bEnableToolbar = cvToolbarValue.compareTo("false") != 0 && capabilities.hasCapability("canUseCognosViewerToolbar");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bEnableToolbar = " + Boolean.toString(bEnableToolbar) + ";\n");
        String cvContextMenuValue = this.m_state.getFormFieldAsString("cv.contextmenu");
        boolean bEnableContextMenu = cvContextMenuValue.compareTo("false") != 0 && capabilities.hasCapability("canUseCognosViewerContextMenu");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bEnableContextMenu = " + Boolean.toString(bEnableContextMenu) + ";\n");
        String sShowHeaderWithPrompts = CognosViewerSystemParams.getSystemParam("showHeaderWithPrompts");
        boolean bShowHeaderWithPrompts = sShowHeaderWithPrompts.compareTo("true") == 0;
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bShowHeaderWithPrompts = " + Boolean.toString(bShowHeaderWithPrompts) + ";\n");
    }

    public void setBlackListedItems() {
        CognosViewerBlacklist cognosViewerBlacklist = this.m_state.getUIBlacklist();
        this.m_sbOutput.append(this.m_sCVObjectRef + ".UIBlacklist = \"" + cognosViewerBlacklist.genJSONBlacklist() + "\";\n");
    }

    public void addResponseCallback(String sEventName, String sFunction, boolean bCaptureEvent) {
        this.m_sbOutput.append(this.m_sCVObjectRef + ".addCallback(\"" + sEventName + "\"," + sFunction + "," + Boolean.toString(bCaptureEvent) + ");\n");
    }

    public void initViewer(ICognosViewerActionResponse actionResponse, CognosViewerResponseStateExtention responseStateExtention) {
        this.m_sbOutput.append(this.m_sCVObjectRef + ".initViewer(");
        this.generateJSONState(actionResponse, responseStateExtention);
        this.m_sbOutput.append(");\n");
    }

    public void generateJSONState(ICognosViewerActionResponse actionResponse, CognosViewerResponseStateExtention responseStateExtention) {
        String[] availableSecondaryRequests;
        this.m_sbOutput.append("{ ");
        CAMPassport passport = actionResponse.getCAMPassport();
        JSONObject jsonObject = new JSONObject(this.m_sbOutput);
        jsonObject.addMember("m_sStatus", actionResponse.getStatus(), false, false);
        BIBusEnvelope busResponse = actionResponse.getBusEnvelope();
        Element soapBody = null;
        if (busResponse != null) {
            Element trackingNode;
            Element soapEnvelope;
            soapBody = busResponse.getBody();
            if (soapBody != null) {
                Element asynchRequestNode = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='primaryRequest']");
                String sConversation = "";
                if (asynchRequestNode != null && passport != null) {
                    sConversation = Protect.cafaction("sign_wrap_setpassportid_" + passport.getId(), XTSExt.web64encode((String)asynchRequestNode.asXML(), (boolean)true));
                }
                if (sConversation.length() > 0) {
                    jsonObject.addMember("m_sConversation", sConversation, false, true);
                }
            }
            if (actionResponse.getStatus().compareTo("fault") == 0 && (soapEnvelope = busResponse.getEnvelope()) != null) {
                jsonObject.addMember("m_sSoapFault", soapEnvelope.asXML(), false, true);
            }
            if ((trackingNode = busResponse.getTracking()) != null && !(actionResponse instanceof CMServerResponse)) {
                Element id;
                Element conversationContextNode = trackingNode.element(BIBusEnvelope.BUS_CONVERSATION_CONTEXT);
                String sTracking = "";
                if (conversationContextNode != null && passport != null && (id = conversationContextNode.element("id")) != null && !"".equals(id.getText())) {
                    sTracking = Protect.cafaction("sign_wrap_setpassportid_" + passport.getId(), XTSExt.web64encode((String)conversationContextNode.asXML(), (boolean)true));
                }
                jsonObject.addMember("m_sTracking", sTracking, false, true);
            }
        }
        if ((availableSecondaryRequests = actionResponse.getAvailableSecondaryRequests()) != null && availableSecondaryRequests.length > 0) {
            jsonObject.addArrayMember("m_aSecRequests", true);
            for (int iIndex = 0; iIndex < availableSecondaryRequests.length; ++iIndex) {
                jsonObject.addArrayValue(availableSecondaryRequests[iIndex], true);
            }
            jsonObject.endArray();
        }
        String sCAFContextId = this.getCAFContextId(passport);
        jsonObject.addMember("m_sCAFContext", sCAFContextId, false, true);
        jsonObject.addMember("outputFormat", actionResponse.getContentFormat(), false, false);
        if (soapBody != null) {
            Element executionParameters = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='primaryRequest']/*[local-name()='parameters']");
            String sExecutionParameters = "";
            if (executionParameters != null && passport != null) {
                String sUnencodedExecutionParameters = executionParameters.asXML();
                String sShowUnencodedFormFields = CognosViewerSystemParams.getSystemParam("cvShowUnencodedFormFields");
                if ("true".equals(sShowUnencodedFormFields)) {
                    jsonObject.addMember("clientunencodedexecutionparameters", sUnencodedExecutionParameters, false, true);
                }
                sExecutionParameters = actionResponse.doParametersNeedCafProtection() ? Protect.cafaction("sign_wrap_setpassportid_" + passport.getId(), XTSExt.web64encode((String)sUnencodedExecutionParameters, (boolean)true)) : sUnencodedExecutionParameters;
            }
            jsonObject.addMember("m_sParameters", sExecutionParameters, false, true);
        }
        this.addRSVPStateData(actionResponse, jsonObject);
        String sActionState = actionResponse.getFormFieldAsString("cv.actionState");
        jsonObject.addMember("m_sActionState", sActionState, false, true);
        if (responseStateExtention != null) {
            responseStateExtention.addResponseStateDetails(jsonObject, actionResponse);
        }
        jsonObject.addObjectMember("envParams", false);
        jsonObject.addMember("ui.primaryAction", actionResponse.getFormFieldAsString("ui.primaryAction"), false, true);
        String sSpec = this.m_state.getFormFieldAsString("ui.spec");
        if (sSpec.length() > 0 && !"iWidget".equals(this.m_state.getFormFieldAsString("cv.responseFormat"))) {
            jsonObject.addMember("ui.spec", sSpec, false, true);
        }
        this.addRAPJSONState(actionResponse, jsonObject);
        this.customizeJSONState(actionResponse, jsonObject);
        jsonObject.endObject();
        this.m_sbOutput.append(" }");
    }

    public void addRSVPStateData(ICognosViewerActionResponse actionResponse, JSONObject jsonObject) {
        if (CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_DRILL_CONTEXT")) {
            if (actionResponse.isConversationComplete() && ("drill".equals(this.m_state.getFormFieldAsString("ui.action")) || "drill".equals(this.m_state.getFormFieldAsString("ui.primaryAction")))) {
                jsonObject.addMember("m_sStateData", actionResponse.getStateData(), false, true);
            } else {
                GenericOptionXMLEncodedXML drillState = (GenericOptionXMLEncodedXML)this.m_state.getOptionManager().getOption("http://developer.cognos.com/ceba/constants/runOptionEnum#drill");
                if (drillState != null) {
                    jsonObject.addMember("m_sStateData", drillState.getValue().get_value(), false, true);
                }
            }
        }
    }

    private String getCAFContextId(CAMPassport passport) {
        String sCAFContextId = "";
        try {
            if (null != passport && !CognosViewerDispatcherHandlerState.isMasters()) {
                sCAFContextId = CAFLibrary.getContextId((String)"rv", (String)passport.getId());
            }
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error("Caught exception in generateJSONState: " + exception.getMessage(), this.getClass().getName());
        }
        return sCAFContextId;
    }

    protected void addRAPJSONState(ICognosViewerActionResponse actionResponse, JSONObject jsonObject) {
        String resend;
        String sRapReportInfo;
        String sRapState = this.m_state.getFormFieldAsString("rap.state");
        if (sRapState.length() > 0) {
            jsonObject.addMember("rapState", sRapState, false, true);
        }
        if ((sRapReportInfo = this.m_state.getFormFieldAsString("rap.reportInfo")).length() > 0) {
            jsonObject.addMember("rapReportInfo", sRapReportInfo, false, true);
        }
        if ((resend = this.m_state.getFormFieldAsString("rapWait")).length() > 0) {
            String requestCache = this.m_state.getFormFieldAsString("rapRequestCache");
            if (requestCache.length() > 0) {
                jsonObject.addMember("rapRequestCache", requestCache, false, false);
            }
            jsonObject.addMember("rapWait", "true", false, false);
            if (actionResponse.getFormFieldAsString("mainTracking").length() > 0) {
                jsonObject.addMember("mainTracking", actionResponse.getFormFieldAsString("mainTracking"), false, true);
                actionResponse.setFormFieldFromString("mainTracking", "");
            }
            if (actionResponse.getFormFieldAsString("mainConversation").length() > 0) {
                jsonObject.addMember("mainConversation", actionResponse.getFormFieldAsString("mainConversation"), false, true);
                actionResponse.setFormFieldFromString("mainConversation", "");
            }
        }
    }

    public void addNavigationLinks(String sProductLocale) {
        StringBuffer sbNavlinks = (StringBuffer)m_cachedNavigationLinks.get(sProductLocale);
        if (sbNavlinks == null) {
            sbNavlinks = new StringBuffer();
            sbNavlinks.append("oFirst:{sText:'" + XTSExt.javascriptencode((String)MessageManager.convert("FIRST_PAGE", sProductLocale)) + "',sImg:'/viewer/images/top.gif',sImgDisabled:'/viewer/images/top_dis.gif'},");
            sbNavlinks.append("oPrevious:{sText:'" + XTSExt.javascriptencode((String)MessageManager.convert("PREV_PAGE", sProductLocale)) + "',sImg:'/viewer/images/pageup.gif',sImgDisabled:'/viewer/images/pageup_dis.gif'},");
            sbNavlinks.append("oNext:{sText:'" + XTSExt.javascriptencode((String)MessageManager.convert("NEXT_PAGE", sProductLocale)) + "',sImg:'/viewer/images/pagedown.gif',sImgDisabled:'/viewer/images/pagedown_dis.gif'},");
            sbNavlinks.append("oLast:{sText:'" + XTSExt.javascriptencode((String)MessageManager.convert("LAST_PAGE", sProductLocale)) + "',sImg:'/viewer/images/bottom.gif',sImgDisabled:'/viewer/images/bottom_dis.gif'}");
            m_cachedNavigationLinks.put(sProductLocale, sbNavlinks);
        }
        this.m_sbOutput.append(this.m_sCVObjectRef + ".oNavLinks = {" + sbNavlinks + "};\n");
    }

    public void setCognosViewerState(ICognosViewerActionResponse actionResponse) {
        this.m_sbOutput.append(this.m_sCVObjectRef + ".setStatus(\"" + actionResponse.getStatus() + "\");\n");
    }

    protected void customizeEnvironmentVariables(JSONObject jsonObject) {
    }

    protected void customizeJSONState(ICognosViewerActionResponse actionResponse, JSONObject jsonObject) {
        String sRapReportInfo;
        if (CognosViewerDispatcherHandler.isSortEnabled(actionResponse) && (sRapReportInfo = this.m_state.getFormFieldAsString("rap.reportInfo")).length() > 0) {
            jsonObject.addMember("rapReportInfo", sRapReportInfo, false, true);
        }
    }

    protected void customizeCapabilities(Capabilities capabilities) {
    }

    public void setMobileContextDataPlaceholder() {
        this.m_sbOutput.append("var mobileContextData" + this.m_sCVId + " = \"####MobileContextData####\";\n");
        this.m_sbOutput.append("if (mobileContextData" + this.m_sCVId + " !== \"####MobileContextData####\" && " + this.m_sCVObjectRef + ".getSelectionController()) {\n");
        this.m_sbOutput.append(this.m_sCVObjectRef + ".getSelectionController().addContextData(mobileContextData" + this.m_sCVId + ");\n");
        this.m_sbOutput.append("}\n");
    }

    public void addAdvancedServerProperties() {
        if (CognosViewerDispatcherHandler.getConfigJSONString().length() > 0) {
            this.m_sbOutput.append(this.m_sCVObjectRef + ".m_advancedProperties = " + CognosViewerDispatcherHandler.getConfigJSONString() + ";\n");
        }
    }
}

