/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.model.Capabilities;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.JSONObject;
import com.cognos.viewer.view.BUXJSONToolbar;
import com.cognos.viewer.view.CognosViewerJavaScriptObject;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.dom4j.Element;

public class CognosViewerJavaScriptObjectForIWidgets
extends CognosViewerJavaScriptObject {
    private boolean m_bMissingMemberRecoveryMode = false;

    public CognosViewerJavaScriptObjectForIWidgets(ICognosViewerState state, StringBuilder sbOutput) {
        super(state, sbOutput);
    }

    @Override
    protected void customizeEnvironmentVariables(JSONObject jsonObject) {
        String aafBaseURL;
        StringBuilder flashChartOption = this.getFlashChartOption();
        jsonObject.addMember("flashChartOption", "[" + flashChartOption.toString() + "]", false, true);
        if (this.m_state.getFormFieldAsString("reportPrompts").length() != 0) {
            jsonObject.addMember("reportPrompts", this.m_state.getFormFieldAsString("reportPrompts"), false, true);
        }
        if ("true".equals(this.m_state.getObject("enableToolbarOnFault"))) {
            jsonObject.addMember("updateToolbar", "true", false, true);
        }
        if ((aafBaseURL = (String)this.m_state.getObject("AAFBaseUrl")) != null) {
            jsonObject.addMember("aafBaseURL", aafBaseURL, false, true);
        }
    }

    @Override
    protected void customizeJSONState(ICognosViewerActionResponse actionResponse, JSONObject jsonObject) {
        Element parametersElem;
        String contentLocale;
        String productLocale;
        String sBaseReportModificationTime;
        String sAnnotationData;
        String sMetaDataModelModificationTime;
        this.addRAPJSONState(actionResponse, jsonObject);
        StringBuilder flashChartOption = this.getFlashChartOption();
        jsonObject.addMember("flashChartOption", "[" + flashChartOption.toString() + "]", false, true);
        String sMetadataModel = this.m_state.getFormFieldAsString("modelPath");
        if (sMetadataModel.length() > 0) {
            jsonObject.addMember("modelPath", sMetadataModel, false, true);
        }
        if ((sMetaDataModelModificationTime = this.m_state.getFormFieldAsString("metaDataModelModificationTime")).length() > 0) {
            jsonObject.addMember("metaDataModelModificationTime", sMetaDataModelModificationTime, false, true);
        }
        if ((sAnnotationData = this.m_state.getFormFieldAsString("cv.annotationData")) != null && sAnnotationData.length() > 0) {
            jsonObject.addMember("cv.annotationData", sAnnotationData, false, true);
        }
        if ((sBaseReportModificationTime = this.m_state.getFormFieldAsString("baseReportModificationTime")) != null && sBaseReportModificationTime.length() > 0) {
            jsonObject.addMember("baseReportModificationTime", sBaseReportModificationTime, false, true);
        }
        if (this.m_state.getFormFieldAsString("creationTime").length() > 0) {
            jsonObject.addMember("creationTime", this.m_state.getFormFieldAsString("creationTime"), false, true);
        }
        if (this.m_state.getFormFieldAsString("originalReportLocation").length() > 0) {
            jsonObject.addMember("originalReportLocation", this.m_state.getFormFieldAsString("originalReportLocation"), false, true);
        }
        jsonObject.addMember("action", this.m_state.getFormFieldAsString("ui.action"), false, true);
        jsonObject.addMember("object", this.m_state.getFormFieldAsString("ui.object"), false, true);
        jsonObject.addMember("reRunObject", this.m_state.getFormFieldAsString("ui.reRunObj"), false, true);
        if (this.m_state.getFormFieldAsString("cv.objectPermissions").length() > 0) {
            jsonObject.addMember("cv.objectPermissions", this.m_state.getFormFieldAsString("cv.objectPermissions"), false, true);
        }
        if (this.m_state.getFormFieldAsString("reportPrompts").length() != 0) {
            jsonObject.addMember("reportPrompts", this.m_state.getFormFieldAsString("reportPrompts"), false, true);
        }
        String toolbarPayload = null;
        if ("true".equals(this.m_state.getFormFieldAsString("widget.reloadToolbar"))) {
            if ("view".equals(this.m_state.getFormFieldAsString("ui.action"))) {
                toolbarPayload = BUXJSONToolbar.render(actionResponse, "buxSavedOutputToolbar").toString();
                jsonObject.addMember("buxToolbarPayload", toolbarPayload, false, true);
                jsonObject.addMember("buxContextMenuPayload", BUXJSONToolbar.render(actionResponse, "buxSavedOutputContextMenu").toString(), false, true);
            } else {
                toolbarPayload = BUXJSONToolbar.render(actionResponse, "buxToolbar").toString();
                jsonObject.addMember("buxToolbarPayload", toolbarPayload, false, true);
                jsonObject.addMember("buxContextMenuPayload", BUXJSONToolbar.render(actionResponse, "buxContextMenu").toString(), false, true);
            }
        }
        if (this.m_state.getFormFieldAsString("limitedInteractiveMode").length() > 0) {
            jsonObject.addMember("limitedInteractiveMode", this.m_state.getFormFieldAsString("limitedInteractiveMode"), false, true);
        }
        if ((productLocale = CognosViewerDispatcherHandlerState.getProductLocale(this.m_state)) != null && productLocale.length() > 0) {
            jsonObject.addMember("productLocale", productLocale, false, true);
        }
        if ((contentLocale = CognosViewerDispatcherHandlerState.getContentLocale(actionResponse)) != null && contentLocale.length() > 0) {
            jsonObject.addMember("contentLocale", contentLocale, false, false);
            Locale locale = new Locale(contentLocale);
            jsonObject.addMember("contentDecimalSeparator", String.valueOf(new DecimalFormatSymbols(locale).getDecimalSeparator()), false, false);
        }
        if ("false".equals(this.m_state.getFormFieldAsString("widget.runReport")) && this.m_state.getObject("parameters") != null && (parametersElem = (Element)this.m_state.getObject("parameters")) != null) {
            jsonObject.addMember("delayedLoadingExecutionParams", parametersElem.asXML(), false, true);
        }
        if (this.m_bMissingMemberRecoveryMode) {
            this.insertDetailsForMissingMemberRecovery(actionResponse, toolbarPayload, jsonObject);
        }
    }

    @Override
    protected void customizeCapabilities(Capabilities capabilities) {
        this.m_sbOutput.append(this.m_sCVObjectRef + ".bCanUseReportStudio = " + Boolean.toString(capabilities.hasCapability("canUseReportStudio")) + ";\n");
    }

    private StringBuilder getFlashChartOption() {
        StringBuilder flashChartOption = new StringBuilder("{");
        JSONObject sTemp = new JSONObject(flashChartOption);
        sTemp.addMember("isOptionDisabled", this.m_state.isFlashChartOptionDisabled(), true);
        sTemp.addMember("defaultValue", this.m_state.getDefaultFlashChartOptionValue(), true);
        flashChartOption.append("}");
        return flashChartOption;
    }

    public void setMissingMemberRecoveryMode(boolean bMode) {
        this.m_bMissingMemberRecoveryMode = bMode;
    }

    protected void insertDetailsForMissingMemberRecovery(ICognosViewerActionResponse faultResponse, String toolbarPayload, JSONObject jsonObject) {
        jsonObject.addMember("bMissingMemberException", "true", false, false);
        boolean bCanEditContent = toolbarPayload != null && toolbarPayload.indexOf("name: \"EditContent\"") != -1;
        jsonObject.addMember("bCanEditContent", Boolean.toString(bCanEditContent), false, false);
        Element paramElement = (Element)faultResponse.getObject("parameters");
        if (paramElement != null && paramElement.hasContent()) {
            jsonObject.addMember("bHasParameters", "true", false, false);
        }
        jsonObject.addMember("ui.spec", EncodingUtility.xmlencode(faultResponse.getFormFieldAsString("ui.spec")), false, true);
    }
}

