/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.configuration.CognosViewerSystemParams;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.view.CognosViewerJSONToolbar;
import com.cognos.viewer.view.CognosViewerJavaScriptObject;
import com.cognos.viewer.view.PageOutput;
import com.cognos.viewer.view.ReportBodyGenerator;
import com.cognos.xts.ext.XTSExt;
import com.ibm.cognos.i18n.util.Bidi;

public class CvOutput
extends PageOutput {
    @Override
    protected void writeHeadDetails(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String enableNewSelectionContext;
        this.writeCSSLinks(actionResponse, sbOutput);
        this.writeJSIncludes(actionResponse, sbOutput);
        if (!"fragment".equals(actionResponse.getFormFieldAsString("cv.responseFormat"))) {
            String sNamespace = actionResponse.getFormFieldAsString("cv.id");
            ReportBodyGenerator.writeScriptOpeningTag(sbOutput, actionResponse);
            sbOutput.append("function getFormWarpRequest()\n{\n");
            sbOutput.append("return document.getElementById('formWarpRequest" + XTSExt.javascriptencode((String)sNamespace) + "');\n");
            sbOutput.append("}\n");
            ReportBodyGenerator.writeScriptClosingTag(sbOutput, actionResponse);
        }
        if ("false".equals(enableNewSelectionContext = CognosViewerDispatcherHandler.getConfigValues().getProperty("enableNewSelectionContext"))) {
            ReportBodyGenerator.writeScriptOpeningTag(sbOutput, actionResponse);
            sbOutput.append("var gUseNewSelectionContext = false;\n");
            ReportBodyGenerator.writeScriptClosingTag(sbOutput, actionResponse);
        }
    }

    @Override
    protected void writeBody(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        String dirAttribute = "";
        String dirClass = "";
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        if (Bidi.isLocaleRTL((String)sProductLocale)) {
            dirAttribute = " dir=\"rtl\"";
            dirClass = " rtl";
        }
        sbOutput.append("<body" + dirAttribute + " role=\"document\" aria-label=\"" + EncodingUtility.htmlencode(MessageManager.convert("IMAGE_COGNOS_LOGO", sProductLocale)) + "\" onclick=\"if (typeof " + "window.oCV" + sNamespace + " != 'undefined'){" + "window.oCV" + sNamespace + ".rvMainWnd.hideOpenMenus();}\" class=\"viewer" + dirClass + "\">\n");
        this.writeBodyContents(actionResponse, sbOutput, true);
        sbOutput.append("</body>");
    }

    public void writeBodyContents(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput, boolean bUseCDATA) throws CognosViewerException {
        this.writeAccessibilityNavLinks(actionResponse, sbOutput);
        this.writeForm(actionResponse, sbOutput);
        String sShowUnencodedFormFields = CognosViewerSystemParams.getSystemParam("cvShowUnencodedFormFields");
        if ("true".equals(sShowUnencodedFormFields)) {
            this.writeNestleForm(actionResponse, sbOutput);
        }
        this.writeBackJaxForm(actionResponse, sbOutput);
        this.writeOnload(actionResponse, sbOutput, bUseCDATA);
    }

    public void writeNestleForm(ICognosViewerActionResponse actionResponse, StringBuilder sbFormOutput) {
        ReportBodyGenerator.writeOpeningFormWarpRequest(actionResponse, sbFormOutput, "");
        sbFormOutput.append(ReportBodyGenerator.writeHiddenInputs(actionResponse));
        ReportBodyGenerator.writeClosingFormWarpRequest(sbFormOutput);
    }

    public void writeOnload(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput, boolean bUseCDATA) {
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        ReportBodyGenerator.writeScriptOpeningTag(sbOutput, bUseCDATA);
        StringBuilder sOCVReference = new StringBuilder("window.oCV").append(sNamespace);
        if (!ReportBodyGenerator.isExcelFormat(actionResponse.getContentFormat()) || !"complete".equals(actionResponse.getStatus())) {
            sbOutput.append("(function(oCV, sNamespace){\n").append("var sOldOnLoad=sNamespace+'originalOnLoad';").append("function _onLoad() {").append("if (oCV) {").append("oCV.initViewer(");
            CognosViewerJavaScriptObject cognosViewerJavaScriptObject = this.getCognosViewerJavaScriptObject(actionResponse, sbOutput);
            cognosViewerJavaScriptObject.generateJSONState(actionResponse, null);
            sbOutput.append(");").append("oCV.updateOutputForA11ySupport();").append("}").append("if (typeof window[sOldOnLoad] == 'function') {").append("window[sOldOnLoad]();").append("}").append("}\n").append("if (typeof require == 'function') {").append("require(['dojo/ready'], function(ready){").append("_onLoad();").append("});").append("} else if (typeof dojo != 'undefined' && typeof dojo != null && dojo.addOnLoad) {").append("dojo.addOnLoad(_onLoad);").append("} else {").append("window[sOldOnLoad] = window.onload;").append("window.onload = _onLoad;").append("}\n").append("})(").append((CharSequence)sOCVReference).append(", '").append(sNamespace).append("');");
        } else {
            sbOutput.append("(function(oCV, sNamespace){\n").append("if (oCV) {").append("oCV.initViewer(");
            CognosViewerJavaScriptObject cognosViewerJavaScriptObject = this.getCognosViewerJavaScriptObject(actionResponse, sbOutput);
            cognosViewerJavaScriptObject.generateJSONState(actionResponse, null);
            sbOutput.append(");").append("oCV.updateOutputForA11ySupport();").append("}").append("})(").append((CharSequence)sOCVReference).append(", '").append(sNamespace).append("');");
        }
        ReportBodyGenerator.writeScriptClosingTag(sbOutput, bUseCDATA);
    }

    public void writeForm(ICognosViewerActionResponse actionResponse, StringBuilder sbFormOutput) throws CognosViewerException {
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        ReportBodyGenerator.writeOpeningFormWarpRequest(actionResponse, sbFormOutput, sNamespace);
        sbFormOutput.append(ReportBodyGenerator.writeHiddenInputs(actionResponse));
        this.writeFormTable(actionResponse, sbFormOutput);
        ReportBodyGenerator.writeClosingFormWarpRequest(sbFormOutput);
    }

    public void writeFormTable(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        sbOutput.append("<table class=\"mainViewerTable\" id=\"mainViewerTable" + sNamespace + "\" role=\"presentation\">");
        this.writeViewerHeader(actionResponse, sbOutput);
        ReportBodyGenerator.writeReportBody(sbOutput, actionResponse);
        sbOutput.append(ReportBodyGenerator.writeNavigationLinks(actionResponse));
        sbOutput.append("</table>");
    }

    protected void writeJSIncludes(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        boolean isJsDebugEnabled;
        String sWebContentRoot = actionResponse.getWebContentRoot();
        DebugLogger debugLogger = actionResponse.getDebugLogger();
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/cognoslaunch.js\"></script>\n");
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/cr1/caf.js\"></script>\n");
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/drill/CSelectionContextBuilder.js\"></script>\n");
        boolean bl = isJsDebugEnabled = debugLogger != null && debugLogger.isJsDebugEnabled();
        if (isJsDebugEnabled) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/util/CViewerHelper.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/util/XMLParser.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/objectModel/parameters.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/ui/TabControl.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/ActionFactory.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cvui.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cv.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CDrillManager.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CDrillThroughTarget.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/cr1/drill.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/selectionContext.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CViewerToolbar.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cvactions.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/utils/DrillContextMenuHelper.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/standalone/DrillAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/standalone/DrillDownAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/standalone/DrillUpAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/standalone/ResizeChartAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/GlossaryAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/AuthoredDrillAction.js\"></script>\n");
        } else {
            this.writeCoreFileInclude(sWebContentRoot, sbOutput);
        }
        this.writeStandaloneRequestJavascriptIncludes(sWebContentRoot, isJsDebugEnabled, sbOutput);
        this.writeCustomJavascriptIncludes(sWebContentRoot, isJsDebugEnabled, sbOutput, actionResponse);
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/mdsrv/lineage.js\"></script>\n");
        if ("true".equals(actionResponse.getFormFieldAsString("cv.useRAPDrill"))) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/ModifyReportAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/iWidget/DrillAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/iWidget/DrillUpDownAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/iWidget/DrillDownAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/iWidget/DrillUpAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/helpers/ActionFormFields.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/ModifyReportDispatcherEntry.js\"></script>\n");
        }
        if (isJsDebugEnabled && CognosViewerDispatcherHandler.isInteractivityEnabled()) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/interactive/CCognosViewer.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/RapReportInfo.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/ModifyReportAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/helpers/ActionFormFields.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/ModifyReportDispatcherEntry.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/HiddenIframeDispatcherEntry.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/ExpandCollapseMemberAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/ExpandMemberAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/CollapseMemberAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/iWidget/DrillAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/iWidget/DrillUpDownAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/iWidget/DrillDownAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/iWidget/DrillUpAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cvsort.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/standalone/SortAction.js\"></script>\n");
        }
        if (isJsDebugEnabled && CognosViewerDispatcherHandler.isPageActionsEnabled()) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/FindAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/FindNextAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/FindNextOnServerAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/GotoPageAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/PrintAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/DownloadReportAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/configuration/ViewerFindActionConfig.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/state/ViewerFindState.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/state/ViewerPageState.js\"></script>\n");
        }
        CognosViewerJSONToolbar.writeJavaScript(actionResponse, this.getToolbarSpec(), sbOutput);
        CognosViewerJSONToolbar.writeJavaScript(actionResponse, this.getBannerSpec(), sbOutput);
    }

    protected void writeCustomJavascriptIncludes(String sWebContentRoot, boolean isJsDebugEnabled, StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
    }

    protected void writeCoreFileInclude(String sWebContentRoot, StringBuilder sbOutput) {
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/viewer.standalone.core.js\"></script>\n");
        if (CognosViewerDispatcherHandler.isInteractivityEnabled()) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/viewer.interactive.core.js\"></script>\n");
        }
        if (CognosViewerDispatcherHandler.isPageActionsEnabled()) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/viewer.pageActions.core.js\"></script>\n");
        }
    }

    public void writeCSSLinks(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String SKIN_ROOT = actionResponse.getWebContentRoot() + "/skins/";
        String sSkin = SKIN_ROOT + actionResponse.getUserPreference("skin");
        sbOutput.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + sSkin + "/viewer/QSRVCommonUI.css\"/>\n");
        sbOutput.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + sSkin + "/viewer/QSRVall.css\"/>\n");
        sbOutput.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + sSkin + "/viewer/CRN.css\"/>\n");
    }

    @Override
    protected void customizeCognosViewerJavaScriptObject(CognosViewerJavaScriptObject cvObject, ICognosViewerActionResponse actionResponse) {
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        cvObject.addNavigationLinks(sProductLocale);
        cvObject.setCustomizableFeatures();
        cvObject.setViewerCapabities();
        cvObject.setBlackListedItems();
        this.addCallbacks(cvObject, actionResponse);
        if (CognosViewerDispatcherHandler.isSortEnabled(actionResponse) && !"true".equals("limitedInteractiveMode")) {
            cvObject.addResponseCallback("done", "function(){window.oCV" + cvObject.getCvId() + ".insertSortIcons();}", false);
        }
    }

    protected void addCallbacks(CognosViewerJavaScriptObject cvObject, ICognosViewerActionResponse actionResponse) {
        cvObject.addResponseCallback("cancel", "function(){ var sCVId = \"" + actionResponse.getFormFieldAsString("cv.id") + "\"; executeBackURL(sCVId);}", false);
        cvObject.addResponseCallback("wait", "function(){window.oCV" + cvObject.getCvId() + ".wait();}", false);
    }

    @Override
    protected void insertInlineScript(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String cognosViewerNamespace = actionResponse.getFormFieldAsString("cv.id");
        sbOutput.append("window.oCV" + cognosViewerNamespace + ".rvMainWnd = new CMainWnd(" + "window.oCV" + cognosViewerNamespace + ");\n");
        this.writeToolbarSpecifications(actionResponse, sbOutput);
        sbOutput.append("window.oCV" + cognosViewerNamespace + ".rvMainWnd.init();\n");
        sbOutput.append("window.oCVSC" + cognosViewerNamespace + ".attachObserver(" + "window.oCV" + cognosViewerNamespace + ".rvMainWnd);\n");
    }

    protected void writeToolbarSpecifications(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        ReportBodyGenerator.writeToolbarObject(actionResponse, this.getToolbarSpec(), sbOutput);
        ReportBodyGenerator.writeBannerObject(actionResponse, this.getBannerSpec(), sbOutput);
    }

    public void writeBackJaxForm(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        String label = MessageManager.convert("IDS_A11Y_HIDDEN_FORM", sProductLocale);
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        sbOutput.append("<form role=\"form\" aria-label=\"" + EncodingUtility.encodeXMLAttribute(label) + "\" name=\"formBackJax" + sNamespace + "\" id=\"formBackJax" + sNamespace + "\" style=\"display:none;\">");
        sbOutput.append("<input type=\"hidden\" name=\"state\" value=\"\">");
        sbOutput.append("<input type=\"hidden\" name=\"result\" value=\"\">");
        sbOutput.append("<input type=\"hidden\" name=\"working\" value=\"\">");
        sbOutput.append("</form>");
    }
}

