/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.ExceptionUtility;
import com.cognos.viewer.view.CognosViewerJavaScriptObject;
import com.cognos.viewer.view.CognosViewerJavaScriptObjectForIWidgets;
import com.cognos.viewer.view.ICognosViewerOutputResponse;
import com.cognos.viewer.view.PageOutputResponse;
import com.cognos.viewer.view.ReportBodyGenerator;
import com.cognos.viewer.view.TextOutput;

public class DataOutput
extends TextOutput {
    @Override
    public void generateText(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        sbOutput.append("<xml><state>");
        StringBuilder sbState = new StringBuilder(1024);
        CognosViewerJavaScriptObject cvJSObj = this.getCognosViewerJavaScriptObject(actionResponse, sbState);
        cvJSObj.generateJSONState(actionResponse, null);
        sbOutput.append(EncodingUtility.xmlencode(sbState.toString()));
        sbOutput.append("</state></xml>");
        if (actionResponse.hasDetailOutput()) {
            this.generateTextDetails(actionResponse, sbOutput);
        }
    }

    public void generateTextDetails(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        ReportBodyGenerator.render(sbOutput, actionResponse);
        String sStatus = actionResponse.getStatus();
        if (actionResponse.isBUX() && !"working".equals(sStatus) && !"stillWorking".equals(sStatus) && !"prompting".equals(sStatus)) {
            String cvObjectRef = "window.oCV" + actionResponse.getFormFieldAsString("cv.id");
            ReportBodyGenerator.writeScriptOpeningTag(sbOutput, false);
            sbOutput.append(cvObjectRef + ".inlineScriptsDoneExecuting = true;");
            ReportBodyGenerator.writeScriptClosingTag(sbOutput, false);
        }
    }

    @Override
    public ICognosViewerOutputResponse handleFault(ICognosViewerActionResponse faultResponse) {
        if ("false".equals(faultResponse.getFormFieldAsString("cv.showFaultPage")) || CognosViewerDispatcherHandlerState.isAuthenticationFaultEnvelope(faultResponse.getBusEnvelope()) && "true".equals(faultResponse.getFormFieldAsString("cv.catchLogOnFault"))) {
            StringBuilder sbOutput = new StringBuilder(1024);
            sbOutput.append("Content-Type: application/xml; charset=utf-8");
            sbOutput.append("\r\n\r\n");
            sbOutput.append("<xml><state>");
            StringBuilder sbState = new StringBuilder();
            CognosViewerJavaScriptObject cvJSObj = this.getCognosViewerJavaScriptObject(faultResponse, sbState);
            if (ExceptionUtility.isMissingMemberError(faultResponse) && cvJSObj instanceof CognosViewerJavaScriptObjectForIWidgets) {
                CognosViewerJavaScriptObjectForIWidgets cvJSObjForIwidgets = (CognosViewerJavaScriptObjectForIWidgets)cvJSObj;
                cvJSObjForIwidgets.setMissingMemberRecoveryMode(true);
            }
            cvJSObj.generateJSONState(faultResponse, null);
            sbOutput.append(EncodingUtility.xmlencode(sbState.toString()));
            sbOutput.append("</state></xml>");
            return new PageOutputResponse(sbOutput);
        }
        return null;
    }
}

