/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.view.ICognosViewerOutputResponse;
import com.cognos.viewer.view.JSONOutput;
import com.cognos.viewer.view.OutputResponseHelper;
import com.cognos.viewer.view.PageOutputResponse;
import com.cognos.viewer.view.helper.DownloadObject;
import com.ibm.json.java.JSONObject;

public class DownloadObjectJSONOutput
extends JSONOutput {
    @Override
    public void generateText(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        try {
            JSONObject jsonResponse = new JSONObject();
            String status = actionResponse.getStatus();
            jsonResponse.put((Object)"status", (Object)status);
            if ("working".equalsIgnoreCase(status) || "stillWorking".equalsIgnoreCase(status)) {
                JSONObject waitParameters = new JSONObject();
                waitParameters.put((Object)"b_action", (Object)"cognosViewer");
                waitParameters.put((Object)"ui.action", (Object)"wait");
                waitParameters.put((Object)"cv.responseFormat", (Object)"downloadObjectJSON");
                waitParameters.put((Object)"m_tracking", (Object)OutputResponseHelper.getTracking(actionResponse));
                waitParameters.put((Object)"ui.conversation", (Object)OutputResponseHelper.getConversation(actionResponse));
                waitParameters.put((Object)"ui.primaryAction", (Object)actionResponse.getFormFieldAsString("ui.primaryAction"));
                waitParameters.put((Object)"cv.actionState", (Object)actionResponse.getFormFieldAsString("cv.actionState"));
                jsonResponse.put((Object)"parameters", (Object)waitParameters);
            } else {
                jsonResponse.put((Object)"url", (Object)DownloadObject.generateDownloadUrl(actionResponse));
            }
            sbOutput.append(jsonResponse.toString());
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error(exception.getLocalizedMessage(), DownloadObjectJSONOutput.class.getName());
        }
    }

    @Override
    public ICognosViewerOutputResponse handleFault(ICognosViewerActionResponse faultResponse) {
        JSONObject jsonResponse = new JSONObject();
        String status = CognosViewerDispatcherHandlerState.isAuthenticationFaultEnvelope(faultResponse.getBusEnvelope()) ? "authenticationFault" : "fault";
        jsonResponse.put((Object)"status", (Object)status);
        jsonResponse.put((Object)"fault", (Object)faultResponse.getBusEnvelope().getEnvelope().asXML());
        StringBuilder sbOutput = new StringBuilder();
        this.addResponseHeader(sbOutput);
        sbOutput.append(jsonResponse.toString());
        return new PageOutputResponse(sbOutput);
    }
}

