/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerBlankResponse;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.render.Renderer;
import com.cognos.viewer.render.RendererFactory;
import com.cognos.viewer.render.RendererHelper;
import com.cognos.viewer.utility.BrowserUtility;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.view.AsynchReportOutput;
import com.cognos.viewer.view.CognosViewerJavaScriptObject;
import com.cognos.viewer.view.ReportBodyGenerator;
import com.cognos.viewer.view.helper.DownloadObject;
import com.cognos.xts.ext.XTSExt;

public class DownloadObjectOutput
extends AsynchReportOutput {
    Renderer renderer;

    public DownloadObjectOutput() {
        this(RendererFactory.getRenderer());
    }

    public DownloadObjectOutput(Renderer renderer) {
        this.renderer = renderer;
    }

    @Override
    protected void insertInlineScript(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        boolean cmResponse;
        String sGateway = XTSExt.javascriptencode((String)actionResponse.getEnvironmentVariable("SCRIPT_NAME"));
        sbOutput.append("function downloadObject()\n");
        sbOutput.append("{\n");
        boolean bl = cmResponse = actionResponse instanceof CMServerResponse || actionResponse instanceof CMServerBlankResponse;
        if (CognosViewerDispatcherHandler.useRestAPI() && cmResponse) {
            String url = XTSExt.javascriptencode((String)DownloadObject.getDetailOutput(actionResponse));
            url = RendererHelper.appendDownloadParameter(url);
            sbOutput.append("var url = \"" + url + "\";\n");
            sbOutput.append("url = constructGETRequestParamsString(url);\n");
            sbOutput.append("url = \"" + sGateway + "\" + url;\n");
        } else {
            String sOutputLocation = CognosViewerDispatcherHandler.getOutputLocation(actionResponse);
            if (!cmResponse && CognosViewerDispatcherHandlerState.isIROTReport(actionResponse) && "http://developer.cognos.com/ceba/constants/temporaryObjectLocationEnum#serverFileSystem".equals(sOutputLocation)) {
                String url = XTSExt.javascriptencode((String)DownloadObject.getDetailOutput(actionResponse));
                url = RendererHelper.appendDownloadParameter(url);
                sbOutput.append("var url = \"" + url + "\";\n");
                sbOutput.append("url = constructGETRequestParamsString(url);\n");
                sbOutput.append("url = \"" + sGateway + "\" + url;\n");
            } else {
                String downloadURL = DownloadObject.generateDownloadUrl(actionResponse);
                sbOutput.append("var url = \"" + downloadURL + "\";\n");
                sbOutput.append("url = constructGETRequestParamsString(url);\n");
                if (downloadURL.startsWith("/repository")) {
                    sbOutput.append("url = \"" + sGateway + "\" + url;\n");
                } else {
                    sbOutput.append("url = \"" + sGateway + "\" + '?' + url;\n");
                }
            }
        }
        String sHttpUserAgent = actionResponse.getEnvironmentVariable("HTTP_USER_AGENT");
        if (CognosViewerDispatcherHandlerState.isIROTReport(actionResponse)) {
            boolean isIE = BrowserUtility.isInternetExplorer(sHttpUserAgent);
            sbOutput.append("window.open(url, \"\", \"\");\n");
            sbOutput.append("if(typeof window.opener != \"undefined\" && window.opener != null)");
            sbOutput.append("{\n");
            if (isIE) {
                this.writeWindowClose(sbOutput);
            }
            sbOutput.append("}\n");
            sbOutput.append("else {\n");
            String backURL = actionResponse.getFormFieldAsString("ui.backURL");
            if (backURL.length() > 0) {
                sbOutput.append("setTimeout(\"executeBackURL('" + XTSExt.javascriptencode((String)actionResponse.getFormFieldAsString("cv.id")) + "');\", 1000);\n");
            } else if (isIE) {
                this.writeWindowClose(sbOutput);
            }
            sbOutput.append("}\n");
        } else {
            boolean isChrome = BrowserUtility.isChrome(sHttpUserAgent);
            boolean isSafari = BrowserUtility.isSafari(sHttpUserAgent);
            if (isChrome || isSafari) {
                sbOutput.append("location.href = url;\n");
            } else {
                sbOutput.append("if(typeof window.opener != \"undefined\" && window.opener != null)");
                sbOutput.append("{\n");
                sbOutput.append("if(typeof window.opener.setWindowHref != 'undefined'){\n");
                sbOutput.append("window.opener.setWindowHref(url);\n");
                this.writeWindowClose(sbOutput);
                sbOutput.append("}else{\n");
                sbOutput.append("location.href = url;\n");
                sbOutput.append("}\n");
                sbOutput.append("}\n");
                sbOutput.append("else\n");
                sbOutput.append("{\n");
                sbOutput.append("location.href = url;\n");
                String backURL = actionResponse.getFormFieldAsString("ui.backURL");
                if (backURL.length() > 0) {
                    sbOutput.append("setTimeout(\"executeBackURL('" + XTSExt.javascriptencode((String)actionResponse.getFormFieldAsString("cv.id")) + "');\", 2000);\n");
                } else {
                    this.writeWindowClose(sbOutput);
                }
                sbOutput.append("}\n");
            }
        }
        sbOutput.append("};\n");
    }

    private void writeWindowClose(StringBuilder sbOutput) {
        sbOutput.append("if (!window.performance) { \n");
        sbOutput.append("setTimeout(\"window.close();\", 1000);\n");
        sbOutput.append("}\n");
    }

    @Override
    protected void writeBody(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        sbOutput.append("<body onload=\"window['bodyLoaded']=true\">\n");
        sbOutput.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td style=\"padding-left:10px;\">");
        sbOutput.append("<img src=\"" + actionResponse.getWebContentRoot() + "/ps/portal/images/msg_information.gif\"></img>");
        sbOutput.append("</td><td style=\"padding-left:3px;vertical-align:top;\" class=\"formText\" width=\"100%\">");
        sbOutput.append(MessageManager.convert("RV_REPORT_IS_READY", CognosViewerDispatcherHandlerState.getContentLocale(actionResponse)));
        sbOutput.append("</td></tr></table>\n");
        ReportBodyGenerator.writeOpeningFormWarpRequest(actionResponse, sbOutput, sNamespace);
        sbOutput.append(ReportBodyGenerator.writeHiddenInputs(actionResponse));
        ReportBodyGenerator.writeClosingFormWarpRequest(sbOutput);
        sbOutput.append("</body>\n");
        ReportBodyGenerator.writeScriptOpeningTag(sbOutput, actionResponse);
        CognosViewerJavaScriptObject cognosViewerJavaScriptObject = this.getCognosViewerJavaScriptObject(actionResponse, sbOutput);
        cognosViewerJavaScriptObject.initViewer(actionResponse, null);
        ReportBodyGenerator.writeScriptClosingTag(sbOutput, actionResponse);
    }

    @Override
    protected void customizeCognosViewerJavaScriptObject(CognosViewerJavaScriptObject cvObject, ICognosViewerActionResponse actionResponse) {
        cvObject.addResponseCallback("cancel", "function(){ var sCVId = \"" + actionResponse.getFormFieldAsString("cv.id") + "\"; executeBackURL(sCVId);}", false);
        cvObject.addResponseCallback("wait", "function(){window.oCV" + cvObject.getCvId() + ".wait();}", false);
        cvObject.addResponseCallback("done", "function(){ downloadObject(); }", false);
    }

    @Override
    protected void writeUsePageRequest(ICognosViewerActionResponse actionResponse, CognosViewerJavaScriptObject cognosViewerJavaScriptObject) {
        cognosViewerJavaScriptObject.setUsePageRequests(true);
    }
}

