/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.AsyncResponse;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.ParameterValueManager;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.FragmentUtility;
import com.cognos.viewer.utility.JSONObject;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.utility.TransientSpec;
import com.cognos.viewer.utility.UrlType;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.viewer.view.CognosViewerFragmentJavaScriptObject;
import com.cognos.viewer.view.CognosViewerJavaScriptObject;
import com.cognos.viewer.view.CvOutput;
import com.cognos.viewer.view.ICognosViewerOutputResponse;
import com.cognos.viewer.view.ReportBodyGenerator;
import com.cognos.viewer.view.StringBufferedOutput;
import com.cognos.viewer.view.ViewOutput;
import com.cognos.viewer.view.XmlOutput;
import com.cognos.xts.ext.XTSExt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FragmentOutput
extends XmlOutput {
    private static String[] ViewerCSSPaths = new String[]{"/viewer/QSRVCommonUI.css", "/viewer/QSRVall.css", "/viewer/CRNFragment.css"};

    @Override
    public void generateXML(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        this.fixupUIObjectValue(actionResponse);
        boolean bMetaOnly = "meta-only".equals(actionResponse.getFormFieldAsString("frag-directive"));
        String uiAction = actionResponse.getFormFieldAsString("ui.action");
        String outputHint = actionResponse.getFormFieldAsString("fragment.outputHint");
        sbOutput.append("<fragment>");
        if (!bMetaOnly) {
            FragmentOutput.writeTitles(sbOutput, actionResponse);
            FragmentOutput.writeLibraries(sbOutput, actionResponse);
        }
        FragmentOutput.writeMeta(sbOutput, actionResponse);
        String sFragId = actionResponse.getFormFieldAsString("frag-id");
        if (sFragId != null && sFragId.length() > 0) {
            sbOutput.append("<id>" + sFragId + "</id>");
        }
        if (!bMetaOnly) {
            FragmentOutput.writeMarkup(sbOutput, actionResponse);
            FragmentOutput.writeCustomLibraries(sbOutput, actionResponse);
            FragmentOutput.writeState(sbOutput, actionResponse, outputHint);
            if (!"runIcon".equals(uiAction)) {
                FragmentOutput.writeStyles(sbOutput, actionResponse);
            }
        }
        sbOutput.append("</fragment>");
        this.logTransientInformation(actionResponse);
    }

    public void fixupUIObjectValue(ICognosViewerActionResponse actionResponse) {
        String newSearchPath;
        String sOriginalValue = actionResponse.getFormFieldAsString("ui.object");
        if (sOriginalValue != null && sOriginalValue.indexOf("storeID") == 0 && (newSearchPath = (String)actionResponse.getObject("searchPath")) != null) {
            actionResponse.setFormFieldFromString("ui.object", newSearchPath, true);
        }
    }

    private static void writeCustomProperties(StringBuilder sbOutput) {
        sbOutput.append("<customProperties name=\"savedReport\">");
        sbOutput.append("</customProperties>");
    }

    public void logTransientInformation(ICognosViewerActionResponse actionResponse) {
        if (actionResponse.getDebugLogger() == null) {
            return;
        }
        String sTransientSpec = "";
        if (actionResponse.getFormFieldAsString("cv.transientSpec") != null && actionResponse.getFormFieldAsString("cv.transientSpec").length() > 0) {
            sTransientSpec = XTSExt.web64decode((String)actionResponse.getFormFieldAsString("cv.transientSpec"), (boolean)true);
        }
        actionResponse.getDebugLogger().log(sTransientSpec.getBytes(), "transientSpec.xml", false, "fragmentInformation");
        String sGlobalViewerFragment = "";
        if (actionResponse.getFormFieldAsString("globalViewerTransient") != null && actionResponse.getFormFieldAsString("globalViewerTransient").length() > 0) {
            sGlobalViewerFragment = actionResponse.getFormFieldAsString("globalViewerTransient");
        }
        actionResponse.getDebugLogger().log(sGlobalViewerFragment.getBytes(), "globalViewerTransient.xml", false, "fragmentInformation");
    }

    public static void writeInlineDebuggingInfo(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        List burstList;
        if (actionResponse.getDebugLogger() == null || !actionResponse.getDebugLogger().isFragmentDebugEnabled()) {
            return;
        }
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        MessageManager.initialize();
        TransientSpec transientSpec = actionResponse.getTransientSpec();
        if (actionResponse instanceof CMServerResponse) {
            sbOutput.append("<span class=\"portlet-font\"><b>" + EncodingUtility.htmlencode(MessageManager.convert("RV_VIEW", sProductLocale)) + ": </b></span>");
            CMServerResponse cmResponse = (CMServerResponse)actionResponse;
            sbOutput.append(cmResponse.getProperty("searchPath"));
            if (cmResponse.getProperty("burstID").length() > 0) {
                sbOutput.append("<br/>");
                sbOutput.append("<span class=\"portlet-font\"><b>" + EncodingUtility.htmlencode(MessageManager.convert("RV_BURST", sProductLocale)) + " </b></span>");
                sbOutput.append(cmResponse.getProperty("burstID"));
            }
        } else if (actionResponse instanceof AsyncResponse) {
            sbOutput.append("<span class=\"portlet-font\"><b>" + EncodingUtility.htmlencode(MessageManager.convert("RV_RUN", sProductLocale)) + ": </b></span>");
            sbOutput.append(actionResponse.getFormFieldAsString("fragment.object"));
        }
        sbOutput.append("<br/>");
        ParameterValueManager parameterValueManager = actionResponse.getParameterValueManager();
        StringBuffer tableStart = new StringBuffer();
        tableStart.append("<table id=\"_THIS_debugging\" width=\"100%\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">");
        tableStart.append("<tr><td class=\"portlet-font\" style=\"background-color:#dddddd\">" + EncodingUtility.htmlencode(MessageManager.convert("RV_DEBUG_CHANNEL", sProductLocale)) + "</td>");
        tableStart.append("<td class=\"portlet-font\" style=\"background-color:#dddddd\">" + EncodingUtility.htmlencode(MessageManager.convert("RV_DEBUG_PARAMETER_NAME", sProductLocale)) + "</td>");
        tableStart.append("<td class=\"portlet-font\" style=\"background-color:#dddddd\">" + EncodingUtility.htmlencode(MessageManager.convert("RV_DEBUG_MODEL_ITEM", sProductLocale)) + "</td>");
        tableStart.append("<td class=\"portlet-font\" style=\"background-color:#dddddd\">" + EncodingUtility.htmlencode(MessageManager.convert("RV_DEBUG_VALUE", sProductLocale)) + "</td></tr>");
        List parameterList = transientSpec.getReportParameterList();
        if (parameterList != null && parameterList.size() > 0) {
            sbOutput.append("<span class=\"portlet-font\"><b>Parameters</b></span>");
            sbOutput.append(tableStart);
            for (int iParameterIndex = 0; iParameterIndex < parameterList.size(); ++iParameterIndex) {
                Element parameter = (Element)parameterList.get(iParameterIndex);
                FragmentOutput.buildDebuggingRow(parameter.attributeValue("parameterName"), actionResponse.getFormFieldAsString("fragment.promptChannel"), parameter.attributeValue("modelItem"), parameterValueManager, sbOutput);
            }
            sbOutput.append("</table>");
        }
        if ((burstList = transientSpec.getBurstItemList()) != null && burstList.size() > 0) {
            sbOutput.append("<span class=\"portlet-font\"><b>Bursting</b></span>");
            sbOutput.append(tableStart);
            for (int iBurstIndex = 0; iBurstIndex < burstList.size(); ++iBurstIndex) {
                Element burst = (Element)burstList.get(iBurstIndex);
                FragmentOutput.buildDebuggingRow(burst.attributeValue("burstName"), actionResponse.getFormFieldAsString("fragment.promptChannel"), burst.attributeValue("modelItem"), parameterValueManager, sbOutput);
            }
            sbOutput.append("</table>");
        }
    }

    private static void buildDebuggingRow(String paramName, String sChannel, String modelItem, ParameterValueManager parameterValueManager, StringBuilder sbOutput) {
        sbOutput.append("<tr><td class=\"portlet-font\">");
        if (sChannel.length() == 0) {
            sbOutput.append("&nbsp;");
        } else {
            sbOutput.append(sChannel);
        }
        sbOutput.append("</td>");
        sbOutput.append("<td class=\"portlet-font\">" + paramName + "</td>");
        sbOutput.append("<td class=\"portlet-font\">" + modelItem + "</td>");
        sbOutput.append("<td class=\"portlet-font\">");
        StringBuilder sValue = new StringBuilder("");
        if (parameterValueManager.getParameterValue(paramName) != null) {
            ParmValueItem[] parmValueItems = parameterValueManager.getParameterValue(paramName).getValue();
            for (int iParamIndex = 0; iParamIndex < parmValueItems.length; ++iParamIndex) {
                SimpleParmValueItem simpleParmValueItem = (SimpleParmValueItem)parmValueItems[iParamIndex];
                if (sValue.length() > 0) {
                    sValue.append("<br/>");
                }
                sValue.append(simpleParmValueItem.getDisplay());
            }
        }
        if (sValue.length() == 0) {
            sValue.append("&nbsp;");
        }
        sbOutput.append((CharSequence)sValue);
        sbOutput.append("</td>");
    }

    public static void writeTitles(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        sbOutput.append("<info>");
        sbOutput.append("<title>");
        sbOutput.append(MessageManager.convert("IMAGE_COGNOS_LOGO", CognosViewerDispatcherHandlerState.getProductLocale(actionResponse)));
        sbOutput.append("</title>");
        sbOutput.append("</info>");
        sbOutput.append("<preferredTitle>");
        String sReportName = actionResponse.getFormFieldAsString("ui.name");
        if (sReportName.length() == 0 && actionResponse instanceof CMServerResponse) {
            sReportName = ((CMServerResponse)actionResponse).getProperty("defaultName");
        }
        sbOutput.append(EncodingUtility.xmlencode(sReportName));
        sbOutput.append("</preferredTitle>");
    }

    public static void writeMarkup(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) throws CognosViewerException {
        Element originalParameters = null;
        if ("complete".equals(actionResponse.getStatus()) && actionResponse.getFormFieldAsString("originalParameters").length() > 0) {
            String sOriginalParameters = actionResponse.getFormFieldAsString("originalParameters");
            actionResponse.setFormFieldFromString("originalParameters", "");
            try {
                originalParameters = XMLUtility.createXMLDocument(sOriginalParameters).getRootElement();
            }
            catch (Exception e) {
                originalParameters = null;
            }
        }
        String outputHint = actionResponse.getFormFieldAsString("fragment.outputHint");
        actionResponse.setFormFieldFromString("fragment.outputHint", "");
        sbOutput.append("<markup>");
        sbOutput.append("<mimeType>text/html</mimeType>");
        sbOutput.append("<markupString>");
        sbOutput.append("<![CDATA[");
        String sAction = actionResponse.getAction();
        CvOutput pageOutput = StringBufferedOutput.getOutputObject(actionResponse);
        pageOutput.writeInlineScript(actionResponse, sbOutput, false);
        if ("showProgress".equals(outputHint)) {
            FragmentOutput.writeShowProgressMarkup(sbOutput, actionResponse);
        } else if (!"blankPage".equals(outputHint)) {
            if ("runIcon".equals(sAction) || "missingBurstOutput".equals(outputHint)) {
                FragmentOutput.writeRunActionMarkup(sbOutput, actionResponse, outputHint);
            } else if ("view".equals(sAction)) {
                ViewOutput viewOutput = new ViewOutput();
                viewOutput.writeForm(actionResponse, sbOutput);
            } else {
                pageOutput.writeForm(actionResponse, sbOutput);
            }
        }
        CognosViewerFragmentJavaScriptObject viewerFragment = new CognosViewerFragmentJavaScriptObject(actionResponse, sbOutput);
        viewerFragment.render();
        if (!FragmentOutput.isFragmentSafe(sbOutput)) {
            FragmentOutput.writeUnsupportedJavaScriptMessage(sbOutput, actionResponse);
        } else {
            if (CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_ENABLE_OLD_PORTLET_BEHAVIOR")) {
                String sRsvpOutput = sbOutput.toString();
                sRsvpOutput = sRsvpOutput.replaceAll("\\/\\/<\\!\\[CDATA\\[", "");
                sRsvpOutput = sRsvpOutput.replaceAll("\\/\\/\\]\\]>", "");
                sbOutput.setLength(0);
                sbOutput.append(sRsvpOutput);
            }
            FragmentOutput.writeEventHandlers(sbOutput, actionResponse, originalParameters);
        }
        FragmentOutput.writeInlineDebuggingInfo(actionResponse, sbOutput);
        sbOutput.append("]]>");
        sbOutput.append("</markupString>");
        sbOutput.append("</markup>");
    }

    public static boolean isFragmentSafe(StringBuilder sRsvpOutput) {
        return sRsvpOutput.indexOf("document.write") == -1;
    }

    private static void writeCustomLibraries(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        if (CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_ENABLE_OLD_PORTLET_BEHAVIOR")) {
            String markup = sbOutput.toString();
            Pattern scriptPattern = Pattern.compile("(?:<script[^>]*src=\"([^\"]*)\"[^>]*>)", 10);
            Pattern srcPattern = Pattern.compile("(?:src\\s*=\\s*)(\"|')([^(\"|')]*?)(\"|')", 10);
            Matcher scriptMatcher = scriptPattern.matcher(markup);
            while (scriptMatcher.find()) {
                Matcher srcMatcher = srcPattern.matcher(scriptMatcher.group());
                while (srcMatcher.find()) {
                    String src = srcMatcher.group();
                    sbOutput.append("<library type=\"text/javascript\" href=\"" + EncodingUtility.encodeXMLAttribute(src.substring(5, src.length() - 1)) + "\"></library>\n");
                }
            }
        } else {
            ArrayList<String> scriptHrefs = actionResponse.getFragmentState().getScriptHrefs();
            int size = scriptHrefs.size();
            for (int i = 0; i < size; ++i) {
                String src = scriptHrefs.get(i);
                sbOutput.append("<library type=\"text/javascript\" href=\"" + EncodingUtility.encodeXMLAttribute(src.substring(5, src.length() - 1)) + "\"></library>\n");
            }
        }
    }

    public static ArrayList stripDynamicStyles(StringBuilder sbOutput) {
        ArrayList<UrlType> linkTags = new ArrayList<UrlType>();
        String markup = sbOutput.toString();
        Pattern linkPattern = Pattern.compile("(?:<link[^>]*>)", 10);
        Pattern hrefPattern = Pattern.compile("(?:href\\s*=\\s*)(\"|')([^(\"|')]*?)(\"|')", 10);
        Matcher linkMatcher = linkPattern.matcher(markup);
        sbOutput = sbOutput.replace(0, sbOutput.length(), markup);
        while (linkMatcher.find()) {
            Matcher hrefMatcher = hrefPattern.matcher(linkMatcher.group());
            while (hrefMatcher.find()) {
                String href = hrefMatcher.group();
                linkTags.add(new UrlType("dynamic", href));
            }
        }
        markup = linkMatcher.replaceAll("");
        sbOutput.replace(0, sbOutput.length(), markup);
        return linkTags;
    }

    public static ArrayList initViewerStyles(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        ArrayList<UrlType> cssLinks = null;
        cssLinks = CognosViewerDispatcherHandler.getConfigValues().getBoolean("VIEWER_ENABLE_OLD_PORTLET_BEHAVIOR") ? FragmentOutput.stripDynamicStyles(sbOutput) : actionResponse.getFragmentState().getLinkTags();
        for (int i = 0; i < ViewerCSSPaths.length; ++i) {
            cssLinks.add(new UrlType("static", ViewerCSSPaths[i]));
        }
        return cssLinks;
    }

    public static void writeShowProgressMarkup(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        String sBrandImages = actionResponse.getWebContentRoot() + "/skins/corporate/branding/";
        sbOutput.append("<table width=\"300\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        sbOutput.append("<td valign=\"middle\">");
        sbOutput.append("<img src=\"" + sBrandImages + "progress.gif\" height=\"48\" border=\"0\" name=\"progress\" align=\"top\"/></td>");
        sbOutput.append("<td width=\"5\">&nbsp;</td>");
        sbOutput.append("<td width=\"100%\" class=\"tableText\"><br/>");
        sbOutput.append(MessageManager.convert("RV_PLEASE_WAIT", CognosViewerDispatcherHandlerState.getProductLocale(actionResponse)));
        sbOutput.append("</td></tr><tr><td colspan=\"3\">&nbsp;</td></tr></table>");
    }

    public static void writeRunActionMarkup(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse, String sOutputHint) {
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        MessageManager.initialize();
        String messageString = "";
        messageString = "missingBurstOutput".equals(sOutputHint) ? MessageManager.convert("RV_MISSING_OUTPUT_CLICK_TO_RUN_REPORT_CAPTION", sProductLocale) : MessageManager.convert("RV_CLICK_TO_RUN_REPORT_CAPTION", sProductLocale);
        String sTooltip = MessageManager.convert("RV_RUN", sProductLocale);
        sbOutput.append("<script type=\"text/javascript\">");
        sbOutput.append("function _THIS_runReport(){");
        sbOutput.append("if (window.oCV" + sNamespace + "){" + "window.oCV" + sNamespace + ".m_viewerFragment.viewerEvent(\"<run></run>\");}");
        sbOutput.append("}</script>");
        ReportBodyGenerator.writeOpeningFormWarpRequest(actionResponse, sbOutput, sNamespace);
        sbOutput.append("<input type=\"hidden\" ");
        sbOutput.append("name=\"reRunObj\" ");
        sbOutput.append("value=\"" + EncodingUtility.htmlencode(actionResponse.getFormFieldAsString("fragment.object")) + "\"/>");
        sbOutput.append("<table id=\"_THIS_default\" border=\"0\" cellspacing=\"0\"");
        sbOutput.append("cellpadding=\"0\" width=\"100%\">");
        sbOutput.append("<tr><td class=\"portlet-font\" align=\"center\" valign=\"middle\" height=\"100\">");
        sbOutput.append("<p>" + EncodingUtility.htmlencode(messageString) + "</p>");
        sbOutput.append("<a href=\"#\" onclick=\"_THIS_runReport();\">");
        sbOutput.append("<img style=\"border:none\" src=\"_THIS?frag-resource=/rv/images/action_run.gif/THIS_\" title=\"" + sTooltip + "\"/></a>");
        sbOutput.append("</td></tr></table>");
        ReportBodyGenerator.writeClosingFormWarpRequest(sbOutput);
    }

    public static void writeLibraries(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        String sLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        if (!"en".equals(sLocale)) {
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/res/viewer_en.js\"></library>\n");
        }
        sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/res/viewer_" + EncodingUtility.htmlencode(sLocale) + ".js\"></library>\n");
        boolean bIsBidiEnabled = CognosViewerDispatcherHandlerState.isViewerBidiEnabled(actionResponse);
        if (bIsBidiEnabled) {
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/ccl/i18n/bidi/BidiUtils.js\"></library>\n");
        }
        sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/prompting/prmt_core.js\"></library>\n");
        sbOutput.append("<library  href=\"$WEB$/prompting/prompting.js\"></library>\n");
        sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/cognoslaunch.js\"></library>\n");
        sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/cr1/caf.js\"></library>\n");
        DebugLogger debugLogger = actionResponse.getDebugLogger();
        if (debugLogger != null && debugLogger.isJsDebugEnabled()) {
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/common/framework/util/CViewerHelper.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/common/framework/notification/CObserver.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/common/framework/objectModel/parameters.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/common/framework/util/XMLParser.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/common/framework/util/CDictionary.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/common/framework/ui/TabControl.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/actions/ActionFactory.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/cvactions.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/actions/GlossaryAction.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/actions/AuthoredDrillAction.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/utils/DrillContextMenuHelper.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/actions/standalone/DrillAction.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/actions/standalone/DrillDownAction.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/actions/standalone/DrillUpAction.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/CSelectionDefaultStyles.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/cvselection.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/cvui.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/cv.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/CDrillManager.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/CDrillThroughTarget.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/cr1/drill.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/CCognosViewerUtilities.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/ViewerA11YHelper.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/CCognosViewer.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/configuration/ViewerConfig.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/configuration/ViewerUIConfig.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/configuration/ViewerHttpRequestConfig.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/configuration/ViewerEventsConfig.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/state/ViewerState.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/CCDataManager.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/cvSelectionXml.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/cvSubscriptionManager.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/GUtil.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/CViewerToolbar.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/common.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/CCognosViewerDebugLogger.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/selectionContext.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/ajaxWrappers/XmlHttpObject.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/ajaxWrappers/AsynchRequest.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/ajaxWrappers/AsynchDATARequest.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/ajaxWrappers/AsynchJSONRequest.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/handlers/IFaultDialog.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/handlers/ILogOnDialog.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/handlers/IPromptDialog.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/handlers/IRequestHandler.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/handlers/IRequestIndicator.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/handlers/BaseRequestHandler.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/handlers/standalone/LogOnDialog.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/handlers/standalone/PromptDialog.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/handlers/standalone/FaultDialog.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/handlers/standalone/ViewerBaseWorkingDialog.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/handlers/standalone/WorkingDialog.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/handlers/standalone/RequestExecutedIndicator.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/handlers/standalone/RequestHandler.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/requests/helpers/ActionFormFields.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/requests/ViewerDispatcher.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/requests/DispatcherEntry.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/requests/DataDispatcherEntry.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/requests/JSONDispatcherEntry.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/requests/AsynchDataDispatcherEntry.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/requests/AsynchJSONDispatcherEntry.js\"></library>\n");
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/requests/ReportDispatcherEntry.js\"></library>\n");
        } else {
            if (debugLogger != null && debugLogger.isJsonLoggingOn()) {
                sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/CCognosViewerDebugLogger.js\"></library>\n");
            }
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/viewer.standalone.core.js\"></library>\n");
        }
        sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/serverrequest/requests/fragments/ViewerDispatcherEntry.js\"></library>\n");
        sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/CCognosViewerFragment.js\"></library>\n");
        sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/drill/CSelectionContextBuilder.js\"></library>\n");
        sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/mdsrv/lineage.js\"></library>\n");
        if ("true".equals(actionResponse.getFormFieldAsString("bux"))) {
            sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/rv/cvcalculations.js\"></library>\n");
        }
        sbOutput.append("<library type=\"text/javascript\" href=\"$WEB$/prompting/properties.js\"></library>\n");
    }

    public static void writeStyles(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        ArrayList styleSheetPaths = FragmentOutput.initViewerStyles(sbOutput, actionResponse);
        String sSkin = actionResponse.getUserPreference("skin");
        ListIterator iter = styleSheetPaths.listIterator();
        while (iter.hasNext()) {
            UrlType uType = (UrlType)iter.next();
            if ("static".equals(uType.getType())) {
                sbOutput.append("<css type=\"text/css\" href=\"$WEB$/skins/" + sSkin + uType.getHref() + "\"/>\n");
                continue;
            }
            sbOutput.append("<css type=\"text/css\" " + uType.getHref() + "/>\n");
        }
    }

    public static void writeState(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse, String outputHint) {
        StringBuffer sbFragmentState = new StringBuffer("<CognosViewer>");
        if (!"runIcon".equals(actionResponse.getAction()) && !"blankPage".equals(outputHint)) {
            sbFragmentState.append(ReportBodyGenerator.generateStateParam(actionResponse));
            sbFragmentState.append(ReportBodyGenerator.generateDefaultStateParam(actionResponse));
        }
        sbFragmentState.append("</CognosViewer>");
        if (actionResponse.getDebugLogger() != null) {
            actionResponse.getDebugLogger().log(sbFragmentState.toString().getBytes(), "state.xml", true, "fragmentInformation");
        }
        String sFragmentState = XTSExt.web64encode((String)sbFragmentState.toString(), (boolean)true);
        FragmentUtility.setPortalSessionField(actionResponse, sFragmentState);
        sbOutput.append("<state>" + sFragmentState + "</state>");
    }

    public static void writeMeta(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        sbOutput.append("<meta bypassValidation='true'>");
        boolean bMetaOnly = "meta-only".equals(actionResponse.getFormFieldAsString("frag-directive"));
        if (!bMetaOnly) {
            FragmentOutput.writeCustomProperties(sbOutput);
        }
        FragmentOutput.writeMetaTransients(sbOutput, actionResponse);
        sbOutput.append("</meta>");
    }

    public static void writeMetaTransients(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        StringBuffer sbTransients = new StringBuffer();
        actionResponse.getTransientSpec().writeMetaTags(sbTransients);
        if (sbTransients.length() > 0) {
            sbOutput.append(sbTransients);
            sbOutput.append("<transientProperties name=\"globalViewerTransient\"></transientProperties>");
        }
    }

    public static void writeEventHandlers(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse, Element originalParameters) {
        String sUIAction = actionResponse.getAction();
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        sbOutput.append("<script type=\"text/javascript\">\n");
        sbOutput.append("function _THIS_handleFragmentLoadEvent(evt){ if (evt.eventPhase == evt.AT_TARGET){");
        sbOutput.append("window.oCV" + sNamespace + ".m_viewerFragment.onloadEvent(evt,");
        if (!("view".equals(sUIAction) || "noop".equals(sUIAction) || "runIcon".equals(sUIAction))) {
            CognosViewerJavaScriptObject cvJSObj = new CognosViewerJavaScriptObject(actionResponse, sbOutput);
            cvJSObj.generateJSONState(actionResponse, null);
        } else {
            sbOutput.append("null");
        }
        sbOutput.append(");");
        if ("view".equals(sUIAction)) {
            sbOutput.append("window.oCV_THIS_.renderTabs();");
        }
        sbOutput.append("} }");
        sbOutput.append("function _THIS_handleFragmentRefreshEvent(evt) { if (evt.eventPhase == evt.AT_TARGET){ window.oCV" + sNamespace + ".m_viewerFragment.refreshEvent();}}");
        sbOutput.append("function _THIS_handleFragmentUnloadEvent(evt) { if (evt.eventPhase == evt.AT_TARGET){ window.oCV" + sNamespace + ".m_viewerFragment.unloadEvent();}}");
        sbOutput.append("function _THIS_handleWindowStateChangeEvent(evt){ window.oCV" + sNamespace + ".m_viewerFragment.windowStateChangedEvent(evt);}");
        sbOutput.append("function _THIS_handleViewerEvent(evt){if (evt.source.id != \"" + sNamespace + "\"){ " + "window.oCV" + sNamespace + ".m_viewerFragment.viewerEvent(evt.payload);}}");
        sbOutput.append("function _THIS_handleVisibilityChangeEvent(evt){ window.oCV" + sNamespace + ".m_viewerFragment.visibilityChangedEvent(evt);}");
        sbOutput.append("function _THIS_handleRetrieveBeforeEvent(evt){ window.oCV" + sNamespace + ".m_viewerFragment.retrieveBeforeEvent(evt);}");
        sbOutput.append("function _THIS_handleCustomContextMenu(evt){ window.oCV" + sNamespace + ".m_viewerFragment.customContextMenuEvent(evt);}");
        sbOutput.append("function _THIS_handleFragmentPreSaveEvent(evt){ window.oCV" + sNamespace + ".m_viewerFragment.presaveEvent(evt);}");
        sbOutput.append("function _THIS_handleRetrieveAfterEvent(evt){}");
        sbOutput.append(sNamespace + ".addEventListener(\"fragment.load\",\"_THIS_handleFragmentLoadEvent\",false);");
        sbOutput.append(sNamespace + ".addEventListener(\"fragment.unload\",\"_THIS_handleFragmentUnloadEvent\",false);");
        sbOutput.append(sNamespace + ".addEventListener(\"fragment.refresh\",\"_THIS_handleFragmentRefreshEvent\",false);");
        sbOutput.append(sNamespace + ".addEventListener(\"fragment.windowstate.change\",\"_THIS_handleWindowStateChangeEvent\",false);");
        sbOutput.append(sNamespace + ".addEventListener(\"cognos.viewer.*\",\"_THIS_handleViewerEvent\",false);");
        sbOutput.append(sNamespace + ".addEventListener(\"fragment.visibility.change\",\"_THIS_handleVisibilityChangeEvent\",false);");
        sbOutput.append(sNamespace + ".addEventListener(\"fragment.retrieve.before\",\"_THIS_handleRetrieveBeforeEvent\",false);");
        sbOutput.append(sNamespace + ".addEventListener(\"fragment.contextmenu\",\"_THIS_handleCustomContextMenu\",false);");
        sbOutput.append(sNamespace + ".addEventListener(\"com.ibm.bux.presave\",\"_THIS_handleFragmentPreSaveEvent\",false);");
        sbOutput.append(sNamespace + ".addEventListener(\"fragment.retrieve.after\",\"_THIS_handleRetrieveAfterEvent\",false);");
        String sFragmentEvent = actionResponse.getFormFieldAsString("cv.fragmentEvent");
        if ("drill".equals(sUIAction) && !"true".equals(sFragmentEvent)) {
            String drillSpecification = XTSExt.javascriptencode((String)FragmentOutput.buildDrillEventSpecification(actionResponse));
            sbOutput.append(sNamespace + ".raiseEvent(\"cognos.viewer.*\", \"" + drillSpecification + "\", \"page\");");
        }
        FragmentOutput.writeChangePromptValues(sbOutput, actionResponse, originalParameters);
        if ("true".equals(actionResponse.getFormFieldAsString("bux"))) {
            sbOutput.append("oCV_THIS_.patURI = \"_THIS?frag-resource=/pat/rsapp.htm/THIS_\"");
        }
        sbOutput.append("</script>\n");
    }

    public static void writeChangePromptValues(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse, Element originalParameters) {
        String sUIAction = actionResponse.getAction();
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        if (originalParameters != null && ("forward".equals(sUIAction) || "back".equals(sUIAction) || "getOutput".equals(sUIAction))) {
            JSONObject jsonObject = new JSONObject();
            HashSet reportParameterNameSet = FragmentOutput.getReportParameterNameSet(actionResponse);
            List parameterItems = ((SOAPResponse)actionResponse).getNodes("./*/*[local-name()='result']/*[local-name()='primaryRequest']/*[local-name()='parameters']/item");
            boolean parametersChanged = false;
            if (parameterItems != null) {
                for (int iIndex = 0; iIndex < parameterItems.size(); ++iIndex) {
                    Element parameter = (Element)parameterItems.get(iIndex);
                    Element parameterName = (Element)parameter.selectSingleNode("./*[local-name()='name']");
                    if (parameterName == null) continue;
                    String sParameterName = parameterName.getText();
                    String sParameterValue = "";
                    Element parameterValue = (Element)parameter.selectSingleNode("./*[local-name()='value']/*");
                    if (parameterValue != null) {
                        sParameterValue = parameterValue.asXML();
                    }
                    String originalValue = "";
                    Element originalParam = (Element)originalParameters.selectSingleNode("./parameter[./name = 'p_" + sParameterName + "']/value");
                    if (originalParam != null) {
                        originalValue = originalParam.getText();
                    }
                    if (originalValue != null && !"".equals(originalValue) && !"<selectChoices></selectChoices>".equals(originalValue) && "".equals(sParameterValue)) {
                        parametersChanged = true;
                    }
                    if ("".equals(sParameterValue)) {
                        jsonObject.addMember("p_" + sParameterName, "<selectChoices></selectChoices>", true, true);
                        actionResponse.getParameterValueManager().removeParameterValue(sParameterName);
                    } else if (originalValue != null) {
                        jsonObject.addMember("p_" + sParameterName, originalValue, true, true);
                    }
                    reportParameterNameSet.remove(sParameterName);
                }
            }
            if (parametersChanged = FragmentOutput.resetObsoletedParamValue(actionResponse, jsonObject, reportParameterNameSet, parametersChanged)) {
                StringBuilder parameters = new StringBuilder();
                jsonObject.write(parameters);
                sbOutput.append("var changedParams = window.oCV" + sNamespace + ".m_viewerFragment.createCDictionary(" + parameters.toString() + ");");
                sbOutput.append("window.oCV" + sNamespace + ".m_viewerFragment.changePromptValues(changedParams);");
            }
        }
    }

    private static boolean resetObsoletedParamValue(ICognosViewerActionResponse actionResponse, JSONObject jsonObject, HashSet reportParameterNameSet, boolean parametersChanged) {
        if (!reportParameterNameSet.isEmpty()) {
            for (String sPName : reportParameterNameSet) {
                String originalValue = actionResponse.getInitialBusEnvelope().getFormValue("p_" + sPName);
                if (originalValue == null || "".equals(originalValue) || "<selectChoices></selectChoices>".equals(originalValue)) continue;
                jsonObject.addMember("p_" + sPName, "<selectChoices></selectChoices>", true, true);
                actionResponse.getParameterValueManager().removeParameterValue(sPName);
                parametersChanged = true;
            }
            reportParameterNameSet.clear();
        }
        return parametersChanged;
    }

    private static HashSet getReportParameterNameSet(ICognosViewerActionResponse actionResponse) {
        HashSet<String> reportParameterNameSet = new HashSet<String>();
        List reportParameterList = actionResponse.getTransientSpec().getReportParameterList();
        if (reportParameterList != null) {
            for (int index = 0; index < reportParameterList.size(); ++index) {
                Element reportParameter = (Element)reportParameterList.get(index);
                String sParameterName = reportParameter.attributeValue("parameterName");
                reportParameterNameSet.add(sParameterName);
            }
        }
        return reportParameterNameSet;
    }

    public static String buildDrillEventSpecification(ICognosViewerActionResponse actionResponse) {
        Element drillNode = DocumentHelper.createElement((String)"drill");
        Element drillChannel = drillNode.addElement("drillChannel");
        drillChannel.setText(actionResponse.getFormFieldAsString("fragment.drillChannel"));
        String sDrillOptionName = actionResponse.getFormFieldAsString("rv_drillOption");
        Element drillOption = drillNode.addElement("DrillOption");
        drillOption.setText(sDrillOptionName);
        String sDrillParameters = actionResponse.getFormFieldAsString("rv_drillparams");
        try {
            Document document = XMLUtility.createXMLDocument(sDrillParameters);
            Element drillParameters = (Element)document.selectSingleNode("./DrillParameters");
            drillNode.add((Element)drillParameters.clone());
        }
        catch (Exception exception) {
            return "";
        }
        return drillNode.asXML();
    }

    public static void writeUnsupportedJavaScriptMessage(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        MessageManager.initialize();
        String messageString = "";
        messageString = MessageManager.convert("IDS_UNSUPPORTED_FRAGMENT_JAVASCRIPT", sProductLocale);
        sbOutput.append("<table id=\"_THIS_default\" border=\"0\" cellspacing=\"0\"");
        sbOutput.append("cellpadding=\"0\" width=\"100%\">");
        sbOutput.append("<tr><td class=\"portlet-font\" align=\"center\" valign=\"middle\" height=\"100\">");
        sbOutput.append("<p>" + EncodingUtility.htmlencode(messageString) + "</p>");
        sbOutput.append("</td></tr></table>");
    }

    @Override
    public ICognosViewerOutputResponse handleFault(ICognosViewerActionResponse faultResponse) {
        return null;
    }
}

