/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.MultipleServerResponse;
import com.cognos.viewer.utility.JSONObject;
import com.cognos.viewer.view.AnnotationInfo;
import com.cognos.viewer.view.JSONOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;

public class GetAnnotationsOutput
extends JSONOutput {
    private boolean allowAnnotations;
    private List annotations = null;

    @Override
    public void generateText(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        MultipleServerResponse response = (MultipleServerResponse)actionResponse;
        String locale = actionResponse.getInitialBusEnvelope().getUserPreferenceValue("contentLocale");
        String timezone = actionResponse.getInitialBusEnvelope().getUserPreferenceValue("timeZoneID");
        this.getAllowAnnotations(response);
        this.getAnnotationsInfo(response, locale, timezone);
        Collections.sort(this.annotations);
        sbOutput.append("{ \"annotationInfo\" : {  ");
        StringBuilder sbAnnotationInfo = new StringBuilder(512);
        JSONObject jsonObject = new JSONObject(sbAnnotationInfo);
        this.toJSON(jsonObject, response);
        sbOutput.append((CharSequence)sbAnnotationInfo);
        sbOutput.append("} }");
    }

    private void getAllowAnnotations(MultipleServerResponse response) {
        String allowAnnotationsText;
        Element output;
        Element allowAnnotationsElement;
        List outputList = response.getSoapResponse(0).getNodes("*[local-name()='queryResponse']/returns/item/queryResult/item[./objectClass/value='output']");
        this.allowAnnotations = false;
        if (outputList != null && outputList.size() == 1 && (allowAnnotationsElement = (Element)(output = (Element)outputList.get(0)).selectSingleNode("./parent/value/item/allowAnnotations/value")) != null && (allowAnnotationsText = allowAnnotationsElement.getText()) != null && allowAnnotationsText.length() > 0) {
            this.allowAnnotations = Boolean.valueOf(allowAnnotationsText);
        }
    }

    private void getAnnotationsInfo(MultipleServerResponse response, String locale, String timezone) {
        this.annotations = new ArrayList();
        if (response.getSoapResponse(1) != null) {
            List annotationList = response.getSoapResponse(1).getNodes("*[local-name()='queryResponse']/returns/item/queryResult/item[./objectClass/value='annotation']");
            ListIterator iterator = annotationList.listIterator();
            while (iterator.hasNext()) {
                Element annotationElement = (Element)iterator.next();
                AnnotationInfo annotationInfo = new AnnotationInfo(annotationElement, timezone, locale);
                this.annotations.add(annotationInfo);
            }
        }
    }

    private void toJSON(JSONObject jsonObject, MultipleServerResponse response) {
        jsonObject.addMember("allowAnnotations", this.allowAnnotations, true);
        Element permissions = ((CMServerResponse)response.getSoapResponse(0)).getComplexProperty("permissions", 1);
        if (permissions != null) {
            Element traverse;
            Element write;
            Element read = (Element)permissions.selectSingleNode("value/item[text()='read']");
            if (read != null && "read".equals(read.getText())) {
                jsonObject.addNotNullMember("read", "true", false, false);
            }
            if ((write = (Element)permissions.selectSingleNode("value/item[text()='write']")) != null && "write".equals(write.getText())) {
                jsonObject.addNotNullMember("write", "true", false, false);
            }
            if ((traverse = (Element)permissions.selectSingleNode("value/item[text()='traverse']")) != null && "traverse".equals(traverse.getText())) {
                jsonObject.addNotNullMember("traverse", "true", false, false);
            }
        }
        jsonObject.addArrayMember("annotations", false);
        ListIterator iterator = this.annotations.listIterator();
        while (iterator.hasNext()) {
            jsonObject.addArrayObject((AnnotationInfo)iterator.next());
        }
        jsonObject.endArray();
    }
}

