/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.SOAPResponse;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.utility.XMLUtility;
import com.cognos.viewer.view.CognosViewerJavaScriptObject;
import com.cognos.viewer.view.HtmlOutput;
import com.cognos.viewer.view.ReportBodyGenerator;
import com.cognos.xts.ext.XTSExt;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GetTransientsOutput
extends HtmlOutput {
    private Element m_reportSpecNode = null;
    static HashMap m_dataItemExpressionXPath = null;

    @Override
    public void generateHTML(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        this.parseReportSecification(actionResponse);
        this.writeOpeningHTMLElement(sbOutput, actionResponse);
        this.writeHead(sbOutput, actionResponse);
        sbOutput.append("</html>");
    }

    public void writeHead(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        sbOutput.append("<head>\n");
        sbOutput.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>\n");
        this.writeJavaScriptIncludes(actionResponse, sbOutput);
        this.writeInlineScript(actionResponse, sbOutput);
        sbOutput.append("</head>\n");
    }

    private void writeJavaScriptIncludes(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String sWebContentRoot = actionResponse.getWebContentRoot();
        DebugLogger debugLogger = actionResponse.getDebugLogger();
        if (debugLogger != null && debugLogger.isJsDebugEnabled()) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCognosViewerUtilities.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCognosViewer.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/configuration/ViewerConfig.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/configuration/ViewerUIConfig.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/configuration/ViewerHttpRequestConfig.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/configuration/ViewerEventsConfig.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/state/ViewerState.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CViewerToolbar.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCognosViewerDebugLogger.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/IRequestHandler.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/BaseRequestHandler.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/standalone/RequestHandler.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/common.js\"></script>\n");
        } else {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/util/XMLParser.js\"></script>\n");
            if (debugLogger != null && debugLogger.isJsonLoggingOn()) {
                sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCognosViewerDebugLogger.js\"></script>\n");
            }
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/viewer.standalone.core.js\"></script>\n");
        }
    }

    public void writeInlineScript(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        this.updateFormFields(actionResponse);
        ReportBodyGenerator.writeScriptOpeningTag(sbOutput, actionResponse);
        CognosViewerJavaScriptObject cognosViewerJavaScriptObject = this.getCognosViewerJavaScriptObject(actionResponse, sbOutput);
        cognosViewerJavaScriptObject.constructObject();
        cognosViewerJavaScriptObject.setCognosViewerState(actionResponse);
        cognosViewerJavaScriptObject.addEnvironmentVariables(actionResponse, CognosViewerDispatcherHandlerState.getProductLocale(actionResponse));
        ReportBodyGenerator.writeScriptClosingTag(sbOutput, actionResponse);
    }

    public void updateFormFields(ICognosViewerActionResponse actionResponse) {
        Element transientSpec = this.generateTransientSpec(actionResponse);
        if (transientSpec != null) {
            actionResponse.setFormFieldFromString("cv.transientSpec", XTSExt.web64encode((String)transientSpec.asXML(), (boolean)true));
        }
        actionResponse.setFormFieldFromString("ui.spec", "");
    }

    public Element generateTransientSpec(ICognosViewerActionResponse actionResponse) {
        return this.generateTransientSpec(actionResponse, null);
    }

    public Element generateTransientSpec(ICognosViewerActionResponse actionResponse, Set includeParameters) {
        Element transientSpecNode = DocumentHelper.createElement((String)"CognosViewerTransientSpecification");
        this.writeReportParametersSpec(actionResponse, transientSpecNode, includeParameters);
        this.writeBurstSpec(actionResponse, transientSpecNode);
        return transientSpecNode;
    }

    private void writeReportParametersSpec(ICognosViewerActionResponse actionResponse, Element transientSpecNode, Set includeParameters) {
        Element reportParametersNode = transientSpecNode.addElement("reportParameters");
        List parametersList = ((SOAPResponse)actionResponse).getNodes("./*/*[local-name()='result']/*[local-name()='details']/*[local-name()='item'][@xsi:type='bus:asynchDetailParameters']/*[local-name()='parameters']/item");
        if (parametersList != null) {
            for (int index = 0; index < parametersList.size(); ++index) {
                Element parameter = (Element)parametersList.get(index);
                Element name = (Element)parameter.selectSingleNode("./*[local-name()='name']");
                Element modelFilterItem = (Element)parameter.selectSingleNode("./*[local-name()='modelFilterItem']");
                String sModelFilterItemValue = "";
                if (modelFilterItem != null) {
                    sModelFilterItemValue = modelFilterItem.getText();
                } else if (name != null) {
                    sModelFilterItemValue = this.getModelFilterItemFromSpec(name.getText());
                }
                if (name == null || includeParameters != null && !includeParameters.contains(name.getText())) continue;
                Element reportParameterNode = reportParametersNode.addElement("reportParameter");
                reportParameterNode.addAttribute("parameterName", name.getText());
                reportParameterNode.addAttribute("modelItem", sModelFilterItemValue);
                List capabilities = com.cognos.rap.utility.XMLUtility.selectNodes(parameter, ".//*[local-name()='capabilities']/*[local-name()='item']");
                for (Element c : capabilities) {
                    if (!"multivalued".equalsIgnoreCase(c.getText())) continue;
                    reportParameterNode.addAttribute("multivalued", "true");
                }
            }
        }
    }

    private String getModelFilterItemFromSpec(String parameterName) {
        Element promptNode;
        String sModelFilterItemValue = "";
        if (this.m_reportSpecNode != null && (promptNode = (Element)this.m_reportSpecNode.selectSingleNode("//*[@parameter='" + parameterName + "']")) != null) {
            String sRefQuery = promptNode.attributeValue("refQuery");
            Element promptChild = (Element)promptNode.selectSingleNode("*[@refDataItem != '']");
            if (promptChild != null) {
                sModelFilterItemValue = this.getRefDataItemExpression(sRefQuery, promptChild.attributeValue("refDataItem"));
            }
        }
        return sModelFilterItemValue;
    }

    private void writeBurstSpec(ICognosViewerActionResponse actionResponse, Element transientSpecNode) {
        Element specBurstNode;
        Element burstNode = transientSpecNode.addElement("burst");
        Element brustItemsNode = burstNode.addElement("burstItems");
        if (this.m_reportSpecNode != null && (specBurstNode = this.m_reportSpecNode.element("burst")) != null) {
            Element burstGroupsNode = specBurstNode.element("burstGroups");
            String sRefQuery = specBurstNode.attributeValue("refQuery");
            List burstGroupsList = burstGroupsNode.elements("burstGroup");
            for (int burstGroupIndex = 0; burstGroupIndex < burstGroupsList.size(); ++burstGroupIndex) {
                Element burstGroup = (Element)burstGroupsList.get(burstGroupIndex);
                String sRefDataItem = burstGroup.attributeValue("refDataItem");
                String sModelFilterItemValue = this.getRefDataItemExpression(sRefQuery, sRefDataItem);
                Element burstItemNode = brustItemsNode.addElement("burstItem");
                burstItemNode.addAttribute("burstName", sRefDataItem);
                burstItemNode.addAttribute("modelItem", sModelFilterItemValue);
            }
        }
    }

    public String getRefDataItemExpression(String sRefQuery, String sRefDataItem) {
        Element expression;
        String sRefDataItemTag;
        String sExpressionXPath;
        if (sRefDataItem == null || sRefDataItem.length() == 0 || sRefQuery == null || sRefQuery.length() == 0) {
            return "";
        }
        Element refDataItem = (Element)this.m_reportSpecNode.selectSingleNode("./*[local-name()='queries']/*[local-name()='query'][@name='" + sRefQuery + "']/*[local-name()='selection']/*[@name='" + sRefDataItem + "']");
        if (refDataItem != null && (sExpressionXPath = (String)m_dataItemExpressionXPath.get(sRefDataItemTag = refDataItem.getName())) != null && (expression = (Element)refDataItem.selectSingleNode(sExpressionXPath)) != null) {
            return expression.getText();
        }
        return "";
    }

    public void parseReportSecification(ICognosViewerActionResponse actionResponse) {
        String sV5ReportSpecification = actionResponse.getFormFieldAsString("ui.spec");
        if (sV5ReportSpecification.length() > 0) {
            try {
                if (!sV5ReportSpecification.startsWith("<")) {
                    sV5ReportSpecification = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", sV5ReportSpecification), (boolean)true);
                }
                Document document = XMLUtility.createXMLDocument(sV5ReportSpecification);
                this.m_reportSpecNode = document.getRootElement();
            }
            catch (Exception exception) {
                IPFLogger.getInstance().error(exception.getMessage(), exception, this.getClass().getName());
            }
        }
    }

    public Element getReportSpecNode() {
        return this.m_reportSpecNode;
    }

    static {
        m_dataItemExpressionXPath = new HashMap();
        m_dataItemExpressionXPath.put("dataItem", "./*[local-name()='expression']");
        m_dataItemExpressionXPath.put("dataItemChildrenSet", "./*[local-name()='dmMember']/*[local-name()='MUN']");
        m_dataItemExpressionXPath.put("dataItemSetExpression", "./*[local-name()='expression']");
        m_dataItemExpressionXPath.put("dataItemLevelSet", "./*[local-name()='dmLevel']/*[local-name()='LUN']");
        m_dataItemExpressionXPath.put("dataItemHierarchySet", "./*[local-name()='dmHierarchy']/*[local-name()='HUN']");
        m_dataItemExpressionXPath.put("dataItemNamedSet", "./*[local-name()='NSUN']");
    }
}

