/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.toolbar.ToolbarFactory;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.view.StringBufferedOutput;
import org.dom4j.Element;

public abstract class HtmlOutput
extends StringBufferedOutput {
    @Override
    public void generateOutput(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        this.addResponseHeader(sbOutput);
        this.generateHTML(actionResponse, sbOutput);
    }

    protected void addResponseHeader(StringBuilder sbOutput) {
        sbOutput.append("Content-Type: text/html; charset=utf-8");
        sbOutput.append("\r\n\r\n");
        sbOutput.append("<!DOCTYPE HTML>");
        sbOutput.append("\n");
    }

    public abstract void generateHTML(ICognosViewerActionResponse var1, StringBuilder var2) throws CognosViewerException;

    protected Element getBannerSpec() {
        return ToolbarFactory.getToolbarSpec("viewerBanner");
    }

    protected Element getToolbarSpec() {
        return ToolbarFactory.getToolbarSpec("viewerToolbar");
    }

    protected void writeOpeningHTMLElement(StringBuilder sbOutput, ICognosViewerState state) {
        sbOutput.append("<html lang=\"").append(EncodingUtility.htmlencode(CognosViewerDispatcherHandlerState.getProductLocale(state))).append("\" class=\"viewer\">");
    }

    protected String getCvObjectRef(ICognosViewerState state) {
        String cvObjectRef = "window.oCV" + state.getFormFieldAsString("cv.id");
        return cvObjectRef;
    }
}

