/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.caf.CAFLibrary;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.viewer.action.GetQualityOfServiceAction;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.ExceptionUtility;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.view.BUXJSONToolbar;
import com.cognos.viewer.view.CognosViewerJavaScriptObject;
import com.cognos.viewer.view.CvOutput;
import com.cognos.viewer.view.ICognosViewerOutputResponse;
import com.cognos.viewer.view.ReportBodyGenerator;
import com.cognos.viewer.view.ViewOutput;
import com.cognos.xts.ext.XTSExt;
import com.ibm.cognos.i18n.util.Bidi;
import org.dom4j.Element;

public class IWidgetOutput
extends CvOutput {
    private static String[] buxCalculations = new String[]{"AdditionCalculation", "SubtractionCalculation", "SubtractionCalculationSwapOrder", "MultiplicationCalculation", "DivisionCalculation", "DivisionCalculationSwapOrder", "PercentDifferenceCalculation", "PercentDifferenceCalculationSwapOrder"};
    private static String[] buxAnnotations = new String[]{"NewAnnotation", "EditAnnotation", "DeleteAnnotation", "NewWidgetAnnotation", "EditWidgetAnnotation", "DeleteWidgetAnnotation"};
    private boolean m_bMissingMemberException = false;

    @Override
    protected void addResponseHeader(StringBuilder sbOutput) {
        sbOutput.append("Content-Type: text/plain; charset=utf-8");
        sbOutput.append("\r\n\r\n");
    }

    @Override
    public void generateHTML(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        actionResponse.setFormFieldFromString("cv.toolbar", "false");
        actionResponse.setFormFieldFromString("cv.header", "false");
        sbOutput.append("<br style=\"display:none\" />");
        this.writeResources(actionResponse, sbOutput);
        this.writeInlineScript(actionResponse, sbOutput, false);
        if ("view".equals(actionResponse.getFormFieldAsString("ui.action"))) {
            ViewOutput viewOutput = new ViewOutput();
            viewOutput.writeBodyContents(actionResponse, sbOutput);
        } else {
            this.writeBodyContents(actionResponse, sbOutput, false);
        }
        this.writeScriptExecutionDone(actionResponse, sbOutput);
    }

    @Override
    public void writeFormTable(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        String dirAttribute = "";
        String dirClass = "";
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        if (Bidi.isLocaleRTL((String)sProductLocale)) {
            dirAttribute = " dir=\"rtl\"";
            dirClass = " class=\"rtl\"";
        }
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        sbOutput.append("<table " + dirAttribute + "role=\"presentation\" id=\"mainViewerTable" + sNamespace + "\"" + dirClass + " class=\"mainViewerTable\">");
        ReportBodyGenerator.writeReportBody(sbOutput, actionResponse);
        sbOutput.append(ReportBodyGenerator.writeNavigationLinks(actionResponse));
        sbOutput.append("</table>");
    }

    private void writeScriptExecutionDone(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String cvObjectRef = this.getCvObjectRef(actionResponse);
        ReportBodyGenerator.writeScriptOpeningTag(sbOutput, false);
        sbOutput.append(cvObjectRef + ".inlineScriptsDoneExecuting = true;");
        ReportBodyGenerator.writeScriptClosingTag(sbOutput, false);
    }

    @Override
    protected void customizeCognosViewerJavaScriptObject(CognosViewerJavaScriptObject cvObject, ICognosViewerActionResponse actionResponse) {
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        cvObject.addNavigationLinks(sProductLocale);
        cvObject.setCustomizableFeatures();
        cvObject.setViewerCapabities();
        cvObject.setBlackListedItems();
        cvObject.addResponseCallback("wait", "function(){setTimeout(\"window.oCV" + cvObject.getCvId() + ".wait()\", 1);}", false);
    }

    @Override
    protected void insertInlineScript(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        StringBuilder contextMenuPayload;
        StringBuilder toolbarPayload;
        String cvObjectRef = this.getCvObjectRef(actionResponse);
        if ("view".equals(actionResponse.getFormFieldAsString("ui.action"))) {
            toolbarPayload = BUXJSONToolbar.render(actionResponse, "buxSavedOutputToolbar");
            contextMenuPayload = BUXJSONToolbar.render(actionResponse, "buxSavedOutputContextMenu");
        } else {
            toolbarPayload = BUXJSONToolbar.render(actionResponse, "buxToolbar");
            contextMenuPayload = BUXJSONToolbar.render(actionResponse, "buxContextMenu");
        }
        if (this.m_bMissingMemberException) {
            this.insertDetailsForMissingMemberRecovery(actionResponse, toolbarPayload, sbOutput, cvObjectRef);
        }
        sbOutput.append(cvObjectRef + ".setToolbar(");
        sbOutput.append((CharSequence)toolbarPayload);
        sbOutput.append(");\n");
        sbOutput.append(cvObjectRef + ".setContextMenu(");
        sbOutput.append((CharSequence)contextMenuPayload);
        sbOutput.append(");\n");
        String cafContextId = IWidgetOutput.getCafContentId(actionResponse);
        sbOutput.append(cvObjectRef + ".cafContextId = \"" + XTSExt.javascriptencode((String)cafContextId) + "\";\n");
        this.setCalculationInfo(sbOutput, actionResponse);
        this.setAnnotationInfo(sbOutput, actionResponse);
        sbOutput.append(cvObjectRef + ".isBux = true;\n");
        boolean bUseReportAuthoredStyles = CognosViewerDispatcherHandler.getConfigValues().getBoolean("useReportAuthoredStyles");
        sbOutput.append(cvObjectRef + ".useReportAuthoredStyles = " + bUseReportAuthoredStyles + ";\n");
        sbOutput.append(cvObjectRef + ".capabilitiesXML = \"" + XTSExt.javascriptencode((String)actionResponse.getCapabilities().getCapabilitiesXML()) + "\";\n");
        if (actionResponse.getFormFieldAsString("widget.id").length() > 0) {
            sbOutput.append(cvObjectRef + ".widgetId = \"" + XTSExt.javascriptencode((String)actionResponse.getFormFieldAsString("widget.id")) + "\";\n");
        }
    }

    public static String getCafContentId(ICognosViewerActionResponse actionResponse) {
        String cafContextId = "";
        try {
            CAMPassport passport = actionResponse.getCAMPassport();
            cafContextId = CAFLibrary.getContextId((String)"rs", (String)passport.getId());
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error(exception.getMessage(), IWidgetOutput.class.getName());
            cafContextId = "";
        }
        return cafContextId;
    }

    @Override
    public String getMaxSecondarySelection() {
        String maxSecondarySelection = CognosViewerDispatcherHandler.getConfigValues().getProperty("buxMaxSecondarySelection");
        if (maxSecondarySelection == null || maxSecondarySelection.length() == 0) {
            maxSecondarySelection = "500";
        }
        return maxSecondarySelection;
    }

    private void writeResources(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        this.writeJavascriptResources(sbOutput, actionResponse);
    }

    private void writeJavascriptResources(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        DebugLogger debugLogger;
        String sWebContentRoot = actionResponse.getWebContentRoot();
        String sLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        if (!"en".equals(sLocale)) {
            sbOutput.append(this.writeJavascriptResource(sWebContentRoot, "/rv/res/viewer_" + EncodingUtility.htmlencode(sLocale) + ".js"));
        }
        if ((debugLogger = actionResponse.getDebugLogger()) != null && debugLogger.isJsonLoggingOn()) {
            sbOutput.append(this.writeJavascriptResource(sWebContentRoot, "/rv/CCognosViewerDebugLogger.js"));
        }
    }

    private StringBuffer writeJavascriptResource(String webContentRoot, String path) {
        return new StringBuffer("<script src=\"").append(webContentRoot).append(path).append("\" type=\"text/javascript\"></script>\n");
    }

    private void setCalculationInfo(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        String cvObjectRef = this.getCvObjectRef(actionResponse);
        String qosFunctions = GetQualityOfServiceAction.getCachedQoSValue(actionResponse);
        if (qosFunctions != null) {
            sbOutput.append(cvObjectRef + ".aQoSFunctions = ");
            sbOutput.append(qosFunctions);
            sbOutput.append(";\n");
        }
        this.setArrayInfo(sbOutput, actionResponse, buxCalculations, "aBuxCalculations");
    }

    private void setAnnotationInfo(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        this.setArrayInfo(sbOutput, actionResponse, buxAnnotations, "aBuxAnnotations");
        String cvObjectRef = this.getCvObjectRef(actionResponse);
        String annotationsAvailable = CognosViewerDispatcherHandler.isAnnotationServiceEnabled() ? "true" : "false";
        sbOutput.append(cvObjectRef + ".bBuxAnnotationsAvailable = " + annotationsAvailable + ";\n");
    }

    private void setArrayInfo(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse, String[] array, String arrayName) {
        String cvObjectRef = this.getCvObjectRef(actionResponse);
        sbOutput.append(cvObjectRef + "." + arrayName + " = ");
        sbOutput.append("[ ");
        for (int index = 0; index < array.length; ++index) {
            sbOutput.append("\"");
            sbOutput.append(array[index]);
            sbOutput.append("\"");
            if (index + 1 >= array.length) continue;
            sbOutput.append(",");
        }
        sbOutput.append("];\n");
    }

    @Override
    public ICognosViewerOutputResponse handleFault(ICognosViewerActionResponse faultResponse) {
        try {
            if (ExceptionUtility.isMissingMemberError(faultResponse)) {
                this.m_bMissingMemberException = true;
            }
            return this.render(faultResponse);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void writeBackJaxForm(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
    }

    @Override
    protected void writeAccessibilityNavLinks(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
    }

    private void insertDetailsForMissingMemberRecovery(ICognosViewerActionResponse faultResponse, StringBuilder toolbarPayload, StringBuilder sbOutput, String cvObjectRef) {
        sbOutput.append(cvObjectRef + "." + "bMissingMemberException" + " = true;\n");
        boolean bCanEditContent = toolbarPayload.indexOf("name: \"EditContent\"") != -1;
        sbOutput.append(cvObjectRef + "." + "bCanEditContent" + " = " + bCanEditContent + ";\n");
        Element paramElement = (Element)faultResponse.getObject("parameters");
        if (paramElement != null && paramElement.hasContent()) {
            sbOutput.append(cvObjectRef + "." + "bHasParameters" + " = true;\n");
        }
    }
}

