/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.view.ICognosViewerOutputResponse;
import com.cognos.viewer.view.PageOutputResponse;
import com.cognos.viewer.view.StringBufferedOutput;
import com.cognos.xts.ext.XTSExt;
import com.ibm.json.java.JSONObject;

public class JSONOutput
extends StringBufferedOutput {
    @Override
    public void generateOutput(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        this.addResponseHeader(sbOutput);
        this.generateText(actionResponse, sbOutput);
    }

    protected void addResponseHeader(StringBuilder sbOutput) {
        sbOutput.append("Content-Type: application/json; charset=utf-8");
        sbOutput.append("\r\n\r\n");
    }

    public void generateText(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String responseContent = (String)actionResponse.getObject("JSONOutput");
        if ((responseContent == null || responseContent.isEmpty()) && actionResponse.getObject("XMLOutput_reportSpec") != null) {
            JSONObject tempJSON = new JSONObject();
            if (!actionResponse.getCapabilities().hasCapability("canUseReportStudio") && actionResponse.isBUX()) {
                CAMPassport passport = actionResponse.getCAMPassport();
                tempJSON.put((Object)"reportSpec", (Object)Protect.cafaction("sign_wrap_setpassportid_" + passport.getId(), XTSExt.web64encode((String)((String)actionResponse.getObject("XMLOutput_reportSpec")), (boolean)true)));
                responseContent = tempJSON.toString();
            } else {
                tempJSON.put((Object)"reportSpec", actionResponse.getObject("XMLOutput_reportSpec"));
                responseContent = tempJSON.toString();
            }
        }
        sbOutput.append(responseContent);
    }

    @Override
    public ICognosViewerOutputResponse handleFault(ICognosViewerActionResponse faultResponse) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"status", (Object)"fault");
        jsonResponse.put((Object)"fault", (Object)faultResponse.getBusEnvelope().getEnvelope().asXML());
        StringBuilder sbOutput = new StringBuilder();
        this.addResponseHeader(sbOutput);
        sbOutput.append(jsonResponse.toString());
        return new PageOutputResponse(sbOutput);
    }
}

