/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.toolbar.ToolbarFactory;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.xts.ext.XTSExt;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class JSONToolbar {
    public static final String ITEM_ID = "id";
    public static final String ITEM_NAME = "name";
    public static final String ITEM_TOOLTIP = "tooltip";
    public static final String ITEM_LABEL = "label";
    public static final String ITEM_ACTION = "action";
    public static final String ITEM_CLICK_ACTION = "clickaction";
    public static final String ITEM_ICON_CLASS = "iconClass";
    public static final String ITEM_DISABLED = "disabled";
    public static final String ITEM_SUB_MENU = "submenu";
    public static final String ITEM_SUB_MENU_ITEMS = "items";
    public static final String ITEM_PLACE_TYPE = "placeType";

    public static StringBuilder render(ICognosViewerActionResponse actionResponse, String key) {
        StringBuilder stringBuffer = new StringBuilder(2048);
        Element toolbar = ToolbarFactory.getToolbarSpec(key);
        if (toolbar != null) {
            String productLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
            List nodes = toolbar.selectNodes("./*[name() = 'item' or name() = 'separator']");
            Iterator iterator = nodes.iterator();
            stringBuffer.append("[ ");
            JSONToolbar.processItems(actionResponse, stringBuffer, iterator, productLocale);
            stringBuffer.append("]");
        }
        return stringBuffer;
    }

    protected static void processItems(ICognosViewerActionResponse actionResponse, StringBuilder stringBuffer, Iterator iterator, String productLocale) {
        boolean lastItemWasSeperator = false;
        boolean itemAdded = false;
        while (iterator.hasNext()) {
            boolean isSeperator;
            StringBuilder renderItemBuffer = JSONToolbar.renderItem(actionResponse, (Element)iterator.next(), productLocale);
            if (renderItemBuffer.length() <= 0) continue;
            boolean bl = isSeperator = renderItemBuffer.indexOf("{separator: true}") == 0;
            if (!isSeperator) {
                if (itemAdded) {
                    stringBuffer.append(",");
                }
                if (lastItemWasSeperator) {
                    stringBuffer.append("{separator: true},");
                }
                stringBuffer.append((CharSequence)renderItemBuffer);
                itemAdded = true;
            }
            lastItemWasSeperator = isSeperator;
        }
    }

    private static StringBuilder renderItem(ICognosViewerActionResponse actionResponse, Element item, String productLocale) {
        StringBuilder stringBuffer = new StringBuilder(256);
        if (item != null) {
            if (item.getName().equals("separator")) {
                stringBuffer.append("{separator: true}");
            } else {
                String itemState = ToolbarFactory.getRuleObject(item).getState(actionResponse, item).getValue();
                if (!"hidden".equals(itemState)) {
                    stringBuffer.append("{");
                    Element id = item.element(ITEM_ID);
                    Element name = item.element(ITEM_NAME);
                    Element tooltip = item.element(ITEM_TOOLTIP);
                    Element action = item.element(ITEM_ACTION);
                    Element clickaction = item.element(ITEM_CLICK_ACTION);
                    Element iconClass = item.element(ITEM_ICON_CLASS);
                    Element placeType = item.element(ITEM_PLACE_TYPE);
                    Element dropDownMenu = item.element(ITEM_SUB_MENU);
                    if (id != null) {
                        JSONToolbar.addItem(stringBuffer, ITEM_ID, id.getText(), false);
                        stringBuffer.append(", ");
                    }
                    if (name != null) {
                        JSONToolbar.addItem(stringBuffer, ITEM_NAME, name.getText(), false);
                        stringBuffer.append(", ");
                    }
                    if (tooltip != null) {
                        Element string = tooltip.element("string");
                        String stringId = string.attributeValue(ITEM_ID);
                        JSONToolbar.addItem(stringBuffer, ITEM_LABEL, MessageManager.convert(stringId, productLocale), true);
                        stringBuffer.append(", ");
                    }
                    if (action != null) {
                        String itemtype = action.attributeValue("type");
                        if (itemtype != null && "item".equals(itemtype)) {
                            JSONToolbar.addItem(stringBuffer, ITEM_ACTION, action.getText(), false);
                        } else {
                            JSONToolbar.addObject(stringBuffer, ITEM_ACTION, action.getText());
                        }
                        stringBuffer.append(", ");
                    }
                    if (clickaction != null) {
                        JSONToolbar.addObject(stringBuffer, ITEM_CLICK_ACTION, clickaction.getText());
                        stringBuffer.append(", ");
                    }
                    if (iconClass != null) {
                        JSONToolbar.addItem(stringBuffer, ITEM_ICON_CLASS, iconClass.getText(), false);
                        stringBuffer.append(", ");
                    }
                    if (placeType != null) {
                        JSONToolbar.addItem(stringBuffer, ITEM_PLACE_TYPE, placeType.getText(), false);
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(ITEM_SUB_MENU_ITEMS);
                    stringBuffer.append(": ");
                    if (dropDownMenu != null) {
                        Iterator iterator = dropDownMenu.elementIterator();
                        stringBuffer.append('[');
                        while (iterator.hasNext()) {
                            JSONToolbar.processItems(actionResponse, stringBuffer, iterator, productLocale);
                        }
                        stringBuffer.append(']');
                    } else {
                        stringBuffer.append("null");
                    }
                    stringBuffer.append("}");
                }
            }
        }
        return stringBuffer;
    }

    private static void addItem(StringBuilder stringBuffer, String name, boolean value) {
        stringBuffer.append(name);
        stringBuffer.append(": ");
        stringBuffer.append(Boolean.toString(value));
    }

    private static void addItem(StringBuilder stringBuffer, String name, String value, boolean encode) {
        stringBuffer.append(name);
        stringBuffer.append(": ");
        stringBuffer.append('\"');
        if (encode) {
            stringBuffer.append(XTSExt.javascriptencode((String)value));
        } else {
            stringBuffer.append(value);
        }
        stringBuffer.append('\"');
    }

    private static void addObject(StringBuilder stringBuffer, String name, String value) {
        stringBuffer.append(name);
        stringBuffer.append(": ");
        stringBuffer.append('{');
        stringBuffer.append(value);
        stringBuffer.append('}');
    }
}

