/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.view.CognosViewerJavaScriptObject;
import com.cognos.viewer.view.CvOutput;
import com.cognos.viewer.view.ICognosViewerOutputResponse;
import com.cognos.viewer.view.JSONToolbar;
import com.cognos.viewer.view.MobileXmlOutput;
import com.cognos.viewer.view.helper.MobileHelper;

public class MobileOutput
extends CvOutput {
    private boolean m_bAddResponseHeaders = true;

    @Override
    protected void addResponseHeader(StringBuilder sbOutput) {
        if (this.m_bAddResponseHeaders) {
            super.addResponseHeader(sbOutput);
        }
    }

    public void setAddResponseHeaders(boolean addResponseHeaders) {
        this.m_bAddResponseHeaders = addResponseHeaders;
    }

    @Override
    public ICognosViewerOutputResponse render(ICognosViewerActionResponse actionResponse) throws CognosViewerException {
        if (MobileHelper.shouldReturnHTML(actionResponse)) {
            return super.render(actionResponse);
        }
        MobileXmlOutput output = new MobileXmlOutput();
        return output.render(actionResponse);
    }

    @Override
    public void writeCustomJavascriptIncludes(String sWebContentRoot, boolean isJsDebugEnabled, StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        String sGateway = EncodingUtility.htmlencode(actionResponse.getEnvironmentVariable("SCRIPT_NAME"));
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sGateway + "/mobileService/mobile_interface.js\"></script>\n");
        if (isJsDebugEnabled) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/GotoAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/mobile/DrillDownAction_override.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/mobile/DrillUpAction_override.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/mobile/AuthoredDrillAction_override.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/utils/CCognosViewerToolbarHelper.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/mobile/cv_override.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/mobile/CCognosViewer_override.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/helpers/ViewerMobileRequest.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/standalone/ViewerDispatcherEntry_mobile.js\"></script>\n");
        } else {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/viewer.mobile.core.js\"></script>\n");
        }
    }

    @Override
    public void writeViewerHeader(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
    }

    @Override
    public void writeUsePageRequest(ICognosViewerActionResponse actionResponse, CognosViewerJavaScriptObject cognosViewerJavaScriptObject) {
        cognosViewerJavaScriptObject.setUsePageRequests(true);
    }

    @Override
    public void writeToolbarSpecifications(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String cvObjectRef = "window.oCV" + actionResponse.getFormFieldAsString("cv.id");
        StringBuilder contextMenuPayload = JSONToolbar.render(actionResponse, "mobileContextMenu");
        sbOutput.append(cvObjectRef + ".setContextMenu(");
        sbOutput.append((CharSequence)contextMenuPayload);
        sbOutput.append(");\n");
    }

    @Override
    public ICognosViewerOutputResponse handleFault(ICognosViewerActionResponse faultResponse) {
        MobileXmlOutput output = new MobileXmlOutput();
        return output.handleFault(faultResponse);
    }

    @Override
    protected void addCallbacks(CognosViewerJavaScriptObject cvObject, ICognosViewerActionResponse actionResponse) {
    }
}

