/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.action.CognosViewerAction;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.view.ICognosViewerOutputResponse;
import com.cognos.viewer.view.OutputResponseHelper;
import com.cognos.viewer.view.PageOutputResponse;
import com.cognos.viewer.view.XmlOutput;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class MobileXmlOutput
extends XmlOutput {
    private static final String BUS_ASYNCHDETAILUNSTRUCTUREDDATA_XPATH = "./*/*[local-name()='result']/*[local-name()='details']/item[@xsi:type='bus:asynchDetailUnstructuredData']";
    private static final QName BUS_DATA = DocumentHelper.createQName((String)"data", (Namespace)BIBusEnvelope.NS_BUS);
    private boolean m_bAddResponseHeaders = true;

    @Override
    protected void addResponseHeader(StringBuilder sbOutput) {
        if (this.m_bAddResponseHeaders) {
            super.addResponseHeader(sbOutput);
        }
    }

    public void setAddResponseHeaders(boolean addResponseHeaders) {
        this.m_bAddResponseHeaders = addResponseHeaders;
    }

    @Override
    public void generateXML(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        sbOutput.append("<response><status>");
        String sStatus = actionResponse.getStatus();
        sbOutput.append(EncodingUtility.xmlencode(sStatus));
        sbOutput.append("</status>");
        if ("fault".equals(sStatus)) {
            this.addFaultEnvelope(actionResponse, sbOutput);
        } else if ("working".equals(sStatus) || "stillWorking".equals(sStatus)) {
            this.addWaitURL(actionResponse, sbOutput);
            this.addCancelURL(actionResponse, sbOutput);
        } else if ("complete".equals(sStatus)) {
            Element context;
            Element busAsynchDetailContextOutput;
            Element soapBody;
            boolean bNextPage = false;
            String[] availableSecondaryRequests = actionResponse.getAvailableSecondaryRequests();
            if (availableSecondaryRequests != null && availableSecondaryRequests.length > 0) {
                sbOutput.append("<secondaryRequests>");
                for (int i = 0; i < availableSecondaryRequests.length; ++i) {
                    String secondaryRequest;
                    if (i > 0) {
                        sbOutput.append(" ");
                    }
                    if ("nextPage".equals(secondaryRequest = availableSecondaryRequests[i])) {
                        bNextPage = true;
                    }
                    sbOutput.append(EncodingUtility.xmlencode(secondaryRequest));
                }
                sbOutput.append("</secondaryRequests>");
                if (bNextPage) {
                    this.addNextPageURL(actionResponse, sbOutput);
                }
            }
            if (CognosViewerDispatcherHandlerState.isIROTReport(actionResponse)) {
                this.addActiveReportURL(actionResponse, sbOutput);
                this.addReleaseURL(actionResponse, sbOutput);
            }
            if ((soapBody = actionResponse.getBusEnvelope().getBody()) != null && (busAsynchDetailContextOutput = (Element)soapBody.selectSingleNode(BUS_ASYNCHDETAILUNSTRUCTUREDDATA_XPATH)) != null && (context = busAsynchDetailContextOutput.element(BUS_DATA)) != null) {
                try {
                    Document xml = DocumentHelper.parseText((String)context.getText());
                    Element rootNode = xml.getRootElement();
                    Element selectedTab = (Element)rootNode.selectSingleNode("./CurrentPageGroup");
                    if (selectedTab != null) {
                        sbOutput.append("<selectedTab>" + EncodingUtility.xmlencode(selectedTab.getText()) + "</selectedTab>");
                    }
                }
                catch (Exception exception) {
                    CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
                    throw cognosViewerException;
                }
            }
        }
        sbOutput.append("</response>");
    }

    private void addCancelURL(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        sbOutput.append("<cancelURL>b_action=cognosViewer&amp;cv.responseFormat=successfulRequest&amp;ui.action=cancel");
        this.addTrackingToURL(actionResponse, sbOutput);
        this.addDebugDirectoryToURL(actionResponse, sbOutput);
        sbOutput.append("</cancelURL>");
    }

    private void addActiveReportURL(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        StringBuilder sbActiveReportLink = actionResponse.getDetailOutput();
        if (sbActiveReportLink != null) {
            sbOutput.append("<activereportURL>");
            sbOutput.append(EncodingUtility.xmlencode(sbActiveReportLink.toString()));
            sbOutput.append("</activereportURL>");
        }
    }

    private void addDebugDirectoryToURL(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        if (actionResponse.getFormFieldAsString("cv.debugDirectory").length() > 0) {
            sbOutput.append("&amp;cv.debugDirectory=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("cv.debugDirectory"))));
        }
    }

    private void addTrackingToURL(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String sTracking = OutputResponseHelper.getTracking(actionResponse);
        if (sTracking.length() > 0) {
            sbOutput.append("&amp;m_tracking=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(sTracking)));
        }
    }

    private void addNextPageURL(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        sbOutput.append("<nextPage>b_action=cognosViewer&amp;ui.action=nextPage");
        this.addTrackingToURL(actionResponse, sbOutput);
        String sConversation = OutputResponseHelper.getConversation(actionResponse);
        if (sConversation.length() > 0) {
            sbOutput.append("&amp;ui.conversation=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(sConversation)));
        }
        if (actionResponse.getFormFieldAsString("ui.cafcontextid").length() > 0) {
            sbOutput.append("&amp;ui.cafcontextid=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("ui.cafcontextid"))));
        }
        if (actionResponse.getFormFieldAsString("cv.responseFormat").length() > 0) {
            sbOutput.append("&amp;cv.responseFormat=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("cv.responseFormat"))));
        }
        if (actionResponse.getFormFieldAsString("ui.backURL").length() > 0) {
            sbOutput.append("&amp;ui.backURL=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("ui.backURL"))));
        }
        if (actionResponse.getFormFieldAsString("errURL").length() > 0) {
            sbOutput.append("&amp;errURL=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("errURL"))));
        }
        if (actionResponse.getFormFieldAsString("cv.showFaultPage").length() > 0) {
            sbOutput.append("&amp;cv.showFaultPage=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("cv.showFaultPage"))));
        }
        if (actionResponse.getFormFieldAsString("cv.catchLogOnFault").length() > 0) {
            sbOutput.append("&amp;cv.catchLogOnFault=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("cv.catchLogOnFault"))));
        }
        Element cvCompressedFormFields = DocumentHelper.createElement((String)"cvCompressedFormFields");
        CognosViewerAction.serializeActionState(cvCompressedFormFields, null, actionResponse.getFormFields());
        String compressedFormFields = CognosViewerAction.signAndEncodeXML(cvCompressedFormFields, actionResponse.getCAMPassport());
        sbOutput.append("&amp;").append("cv.compressedFormFields").append("=").append(compressedFormFields);
        this.addDebugDirectoryToURL(actionResponse, sbOutput);
        sbOutput.append("</nextPage>");
    }

    private void addWaitURL(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        sbOutput.append("<waitURL>b_action=cognosViewer&amp;ui.action=wait");
        this.addTrackingToURL(actionResponse, sbOutput);
        if (actionResponse.getFormFieldAsString("ui.primaryAction").length() > 0) {
            sbOutput.append("&amp;ui.primaryAction=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("ui.primaryAction"))));
        }
        if (actionResponse.getFormFieldAsString("cv.responseFormat").length() > 0) {
            sbOutput.append("&amp;cv.responseFormat=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("cv.responseFormat"))));
        }
        if (actionResponse.getFormFieldAsString("cv.actionState").length() > 0) {
            sbOutput.append("&amp;cv.actionState=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("cv.actionState"))));
        }
        if (actionResponse.getFormFieldAsString("ui.backURL").length() > 0) {
            sbOutput.append("&amp;ui.backURL=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("ui.backURL"))));
        }
        if (actionResponse.getFormFieldAsString("errURL").length() > 0) {
            sbOutput.append("&amp;errURL=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("errURL"))));
        }
        if (actionResponse.getFormFieldAsString("cv.showFaultPage").length() > 0) {
            sbOutput.append("&amp;cv.showFaultPage=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("cv.showFaultPage"))));
        }
        if (actionResponse.getFormFieldAsString("cv.catchLogOnFault").length() > 0) {
            sbOutput.append("&amp;cv.catchLogOnFault=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("cv.catchLogOnFault"))));
        }
        this.addDebugDirectoryToURL(actionResponse, sbOutput);
        sbOutput.append("</waitURL>");
    }

    private void addReleaseURL(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        sbOutput.append("<release>b_action=cognosViewer&amp;ui.action=release&amp;cv.responseFormat=successfulRequest");
        this.addTrackingToURL(actionResponse, sbOutput);
        if (actionResponse.getFormFieldAsString("cv.showFaultPage").length() > 0) {
            sbOutput.append("&amp;cv.showFaultPage=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("cv.showFaultPage"))));
        }
        if (actionResponse.getFormFieldAsString("cv.catchLogOnFault").length() > 0) {
            sbOutput.append("&amp;cv.catchLogOnFault=");
            sbOutput.append(EncodingUtility.xmlencode(EncodingUtility.urlencode(actionResponse.getFormFieldAsString("cv.catchLogOnFault"))));
        }
        this.addDebugDirectoryToURL(actionResponse, sbOutput);
        sbOutput.append("</release>");
    }

    @Override
    public ICognosViewerOutputResponse handleFault(ICognosViewerActionResponse faultResponse) {
        StringBuilder sbOutput = new StringBuilder();
        this.addResponseHeader(sbOutput);
        sbOutput.append("<response><status>fault</status>");
        this.addFaultEnvelope(faultResponse, sbOutput);
        sbOutput.append("</response>");
        return new PageOutputResponse(sbOutput);
    }

    private void addFaultEnvelope(ICognosViewerActionResponse faultResponse, StringBuilder sbOutput) {
        sbOutput.append("<camHeader>");
        BIBusEnvelope faultEnvelope = faultResponse.getBusEnvelope();
        Element camHeader = faultEnvelope.getCAM();
        if (camHeader != null) {
            sbOutput.append(camHeader.asXML());
        }
        sbOutput.append("</camHeader>");
        sbOutput.append("<faultEnvelope>");
        Element fault = faultEnvelope.getFault();
        sbOutput.append(fault.asXML());
        sbOutput.append("</faultEnvelope>");
    }
}

