/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.view.AsynchDetailContextOutput;
import com.cognos.viewer.view.AsynchDetailUnstructuredDataOutput;
import com.cognos.viewer.view.AsynchReportOutput;
import com.cognos.viewer.view.CachedOutput;
import com.cognos.viewer.view.CvOutput;
import com.cognos.viewer.view.DataOutput;
import com.cognos.viewer.view.DownloadObjectOutput;
import com.cognos.viewer.view.FragmentOutput;
import com.cognos.viewer.view.GetAnnotationsOutput;
import com.cognos.viewer.view.ICognosViewerOutput;
import com.cognos.viewer.view.IWidgetOutput;
import com.cognos.viewer.view.JSONOutput;
import com.cognos.viewer.view.MobileDataOutput;
import com.cognos.viewer.view.MobileOutput;
import com.cognos.viewer.view.MobileViewOutput;
import com.cognos.viewer.view.PowerPlayOutput;
import com.cognos.viewer.view.PrintOutput;
import com.cognos.viewer.view.QsOutput;
import com.cognos.viewer.view.RsOutput;
import com.cognos.viewer.view.StudioLaunchOutput;
import com.cognos.viewer.view.SubscriptionManagerOutput;
import com.cognos.viewer.view.SuccessfulRequestOutput;
import com.cognos.viewer.view.ViewOutput;
import com.cognos.viewer.view.XmlOutput;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class OutputFactory {
    private HashMap m_outputClasses = new HashMap();

    public OutputFactory() throws CognosViewerException {
        this.initializeOutputMap();
    }

    private void initializeOutputMap() throws CognosViewerException {
        try {
            this.m_outputClasses.put("qs", QsOutput.class.getConstructor(null));
            this.m_outputClasses.put("view", ViewOutput.class.getConstructor(null));
            this.m_outputClasses.put("rs", RsOutput.class.getConstructor(null));
            this.m_outputClasses.put("cv", CvOutput.class.getConstructor(null));
            this.m_outputClasses.put("page", CvOutput.class.getConstructor(null));
            this.m_outputClasses.put("data", DataOutput.class.getConstructor(null));
            this.m_outputClasses.put("fragment", FragmentOutput.class.getConstructor(null));
            this.m_outputClasses.put("iWidget", IWidgetOutput.class.getConstructor(null));
            this.m_outputClasses.put("asynchDetailContext", AsynchDetailContextOutput.class.getConstructor(null));
            this.m_outputClasses.put("asynchDetailUnstructuredData", AsynchDetailUnstructuredDataOutput.class.getConstructor(null));
            this.m_outputClasses.put("cached", CachedOutput.class.getConstructor(null));
            this.m_outputClasses.put("subscriptionManager", SubscriptionManagerOutput.class.getConstructor(null));
            this.m_outputClasses.put("successfulRequest", SuccessfulRequestOutput.class.getConstructor(null));
            this.m_outputClasses.put("studioLaunchOutput", StudioLaunchOutput.class.getConstructor(null));
            this.m_outputClasses.put("powerPlay", PowerPlayOutput.class.getConstructor(null));
            this.m_outputClasses.put("getAnnotations", GetAnnotationsOutput.class.getConstructor(null));
            this.m_outputClasses.put("xmlResponse", XmlOutput.class.getConstructor(null));
            this.m_outputClasses.put("json", JSONOutput.class.getConstructor(null));
            this.m_outputClasses.put("mobileData", MobileDataOutput.class.getConstructor(null));
            this.m_outputClasses.put("mobile", MobileOutput.class.getConstructor(null));
            this.m_outputClasses.put("mobileView", MobileViewOutput.class.getConstructor(null));
            this.m_outputClasses.put("print", PrintOutput.class.getConstructor(null));
        }
        catch (Exception exception) {
            CognosViewerException cognosViewerException = new CognosViewerException(null, exception.getMessage(), exception);
            throw cognosViewerException;
        }
    }

    public ICognosViewerOutput getOutput(ICognosViewerActionResponse actionResponse) throws CognosViewerException {
        ICognosViewerOutput output = null;
        if (actionResponse != null) {
            boolean bDownload = "true".equals(actionResponse.getFormFieldAsString("cv.promptForDownload"));
            if (CognosViewerDispatcherHandlerState.isIROTReport(actionResponse) && bDownload && !actionResponse.isBUX() && !"view".equals(actionResponse.getAction()) && !"release".equals(actionResponse.getAction()) && !"mobileData".equals(actionResponse.getResponseFormat())) {
                boolean requestComplete;
                String sStatus = actionResponse.getStatus();
                boolean bl = requestComplete = !"working".equals(sStatus) && !"stillWorking".equals(sStatus) && !"prompting".equals(sStatus);
                output = requestComplete && bDownload ? new DownloadObjectOutput() : new AsynchReportOutput();
            } else if (actionResponse.getFormFieldAsString("cv.useAsynchReportOutput").equals("true") && !"fragment".equals(actionResponse.getResponseFormat())) {
                actionResponse.setFormFieldFromString("cv.useAsynchReportOutput", "");
                output = new AsynchReportOutput();
            } else {
                String sResponseFormat = actionResponse.getResponseFormat();
                output = this.load(sResponseFormat, actionResponse);
            }
        }
        return output;
    }

    public ICognosViewerOutput load(String sResponseFormat, ICognosViewerState state) throws CognosViewerException {
        ICognosViewerOutput output = null;
        if (sResponseFormat != null && sResponseFormat.length() > 0) {
            try {
                Constructor<?> constructor = (Constructor<?>)this.m_outputClasses.get(sResponseFormat);
                if (constructor == null) {
                    char[] acResponseFormat = sResponseFormat.toCharArray();
                    acResponseFormat[0] = Character.toUpperCase(acResponseFormat[0]);
                    sResponseFormat = new String(acResponseFormat) + "Output";
                    Class<?> outputClass = Class.forName("com.cognos.viewer.view." + sResponseFormat);
                    constructor = outputClass.getConstructor(null);
                }
                if (constructor != null) {
                    output = (ICognosViewerOutput)constructor.newInstance(null);
                    output.initialize(state);
                }
            }
            catch (CognosViewerException exception) {
                throw exception;
            }
            catch (Exception exception) {
                IPFLogger.getInstance().error(exception.getMessage(), exception, this.getClass().getName());
                return null;
            }
        }
        return output;
    }
}

