/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.caf.CAFLibrary;
import com.cognos.caf.CAFLibraryException;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.view.CognosViewerJavaScriptObject;
import com.cognos.viewer.view.HtmlOutput;
import com.cognos.viewer.view.ReportBodyGenerator;
import com.cognos.viewer.view.ViewerHeader;

public abstract class PageOutput
extends HtmlOutput {
    protected abstract void writeHeadDetails(ICognosViewerActionResponse var1, StringBuilder var2);

    protected abstract void writeBody(ICognosViewerActionResponse var1, StringBuilder var2) throws CognosViewerException;

    protected abstract void customizeCognosViewerJavaScriptObject(CognosViewerJavaScriptObject var1, ICognosViewerActionResponse var2);

    protected abstract void insertInlineScript(ICognosViewerActionResponse var1, StringBuilder var2);

    @Override
    public void generateHTML(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        this.writeOpeningHTMLElement(sbOutput, actionResponse);
        this.writeHead(actionResponse, sbOutput);
        this.writeBody(actionResponse, sbOutput);
        sbOutput.append("</html>");
    }

    protected void writeHead(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        sbOutput.append("<head>\n");
        this.writeMetaTags(sbOutput);
        this.writeTitle(actionResponse, sbOutput);
        this.writeJavaScriptIncludes(actionResponse, sbOutput);
        this.writeCSSLinks(actionResponse, sbOutput);
        this.writeHeadDetails(actionResponse, sbOutput);
        this.writeInlineScript(actionResponse, sbOutput, true);
        sbOutput.append("</head>\n");
    }

    private void writeMetaTags(StringBuilder sbOutput) {
        sbOutput.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>\n");
        sbOutput.append("<meta name=\"copyright\" content=\"(C) Copyright IBM Corporation and its licensors 2001, 2014.\"/>\n");
        sbOutput.append("<meta name=\"trademark\" content=\"IBM, the IBM logo, and Cognos are trademarks of IBM Corp., registered in many jurisdictions worldwide.\"/>\n");
        sbOutput.append("<meta http-equiv=\"MSThemeCompatible\" content=\"no\"/>\n");
        this.customizeMetaTags(sbOutput);
    }

    protected void customizeMetaTags(StringBuilder sbOutput) {
        sbOutput.append("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=Edge\"/>\n");
    }

    private void writeTitle(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        String sReportName = actionResponse.getFormFieldAsString("ui.name");
        String sAppTitle = MessageManager.convert("REPORT_VIEWER_WINDOW_TITLE", sProductLocale);
        String sWindowTitleFormat = actionResponse.getFormFieldAsString("ui.windowtitleformat");
        if (this.useOriginalStyleWindowTitle(sWindowTitleFormat)) {
            this.writeOriginalStyleWindowTitle(sbOutput, sReportName, sAppTitle);
        } else {
            String sAction = actionResponse.getFormFieldAsString("ui.windowtitleaction");
            this.writeCustomWindowTitle(sWindowTitleFormat, sAction, sReportName, sAppTitle, sbOutput);
        }
    }

    private void writeOriginalStyleWindowTitle(StringBuilder sbOutput, String sReportName, String sAppTitle) {
        if ("".equals(sReportName)) {
            sbOutput.append("<title>" + sAppTitle + "</title>");
        } else {
            sbOutput.append("<title>" + EncodingUtility.htmlencode(sReportName) + " - " + sAppTitle + "</title>");
        }
    }

    public boolean useOriginalStyleWindowTitle(String sWindowTitleFormat) {
        if (null == sWindowTitleFormat) {
            return true;
        }
        return "".equals(sWindowTitleFormat);
    }

    public void writeCustomWindowTitle(String sWindowTitleFormat, String sCustomWindowTitleAction, String sReportName, String sAppTitle, StringBuilder sbOutput) {
        if ("chromeless_window_action_format".equals(sWindowTitleFormat)) {
            this.writeTitleForChromelessWindowActionFormat(sCustomWindowTitleAction, sReportName, sbOutput);
        } else {
            this.writeOriginalStyleWindowTitle(sbOutput, sReportName, sAppTitle);
        }
    }

    public void writeTitleForChromelessWindowActionFormat(String sCustomWindowTitleAction, String sReportName, StringBuilder sbOutput) {
        if ("".equals(sReportName)) {
            sbOutput.append("<title>" + EncodingUtility.htmlencode(sCustomWindowTitleAction) + "</title>");
        } else {
            sbOutput.append("<title>" + EncodingUtility.htmlencode(sCustomWindowTitleAction) + " - " + EncodingUtility.htmlencode(sReportName) + "</title>");
        }
    }

    protected void writeJavaScriptIncludes(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String sWebContentRoot = actionResponse.getWebContentRoot();
        String sLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        String prmtFile = "qs".equals(actionResponse.getFormFieldAsString("cv.responseFormat")) ? "PRMTcompiled.js" : "prmt_core.js";
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/prompting/" + prmtFile + "\"></script>\n");
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/prompting/prompting.js\"></script>\n");
        if (!"en".equals(sLocale)) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/res/viewer_en.js\"></script>\n");
        }
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/res/viewer_" + EncodingUtility.htmlencode(sLocale) + ".js\"></script>\n");
        boolean bIsBidiEnabled = CognosViewerDispatcherHandlerState.isViewerBidiEnabled(actionResponse);
        if (bIsBidiEnabled) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/ccl/i18n/bidi/BidiUtils.js\"></script>\n");
        }
        DebugLogger debugLogger = actionResponse.getDebugLogger();
        if (!this.usingViewerCoreFile() || debugLogger != null && debugLogger.isJsDebugEnabled()) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/util/CDictionary.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/GUtil.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/notification/CObserver.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/util/XMLParser.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/ui/TabControl.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCDataManager.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CSelectionDefaultStyles.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cvselection.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCognosViewerUtilities.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/ViewerA11YHelper.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCognosViewer.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/configuration/ViewerConfig.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/configuration/ViewerUIConfig.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/configuration/ViewerHttpRequestConfig.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/configuration/ViewerEventsConfig.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/state/ViewerState.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/PinFreezeContainer.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/PinFreezeManager.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/common.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCognosViewerDebugLogger.js\"></script>\n");
        } else if (debugLogger != null && debugLogger.isJsonLoggingOn()) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCognosViewerDebugLogger.js\"></script>\n");
        }
    }

    protected void writeStandaloneRequestJavascriptIncludes(String sWebContentRoot, boolean bJsDebug, StringBuilder sbOutput) {
        if (!this.usingViewerCoreFile() || bJsDebug) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/ajaxWrappers/XmlHttpObject.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/ajaxWrappers/AsynchRequest.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/ajaxWrappers/AsynchDATARequest.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/ajaxWrappers/AsynchJSONRequest.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/IFaultDialog.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/ILogOnDialog.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/IPromptDialog.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/IRequestHandler.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/IRequestIndicator.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/BaseRequestHandler.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/standalone/ViewerBaseWorkingDialog.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/standalone/FaultDialog.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/standalone/LogOnDialog.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/standalone/PromptDialog.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/standalone/WorkingDialog.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/standalone/RequestExecutedIndicator.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/handlers/standalone/RequestHandler.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/ViewerDispatcher.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/helpers/ActionFormFields.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/DispatcherEntry.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/DataDispatcherEntry.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/JSONDispatcherEntry.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/AsynchDataDispatcherEntry.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/AsynchJSONDispatcherEntry.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/ReportDispatcherEntry.js\"></script>\n");
        }
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/requests/standalone/ViewerDispatcherEntry.js\"></script>\n");
    }

    protected boolean usingViewerCoreFile() {
        return true;
    }

    private void writeCSSLinks(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String SKIN_ROOT = actionResponse.getWebContentRoot() + "/skins/";
        String sSkin = SKIN_ROOT + actionResponse.getUserPreference("skin");
        sbOutput.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + sSkin + "/portal/default.css\"/>\n");
    }

    public void writeInlineScript(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput, boolean bUseCDATA) throws CognosViewerException {
        ReportBodyGenerator.writeScriptOpeningTag(sbOutput, bUseCDATA);
        CognosViewerJavaScriptObject cognosViewerJavaScriptObject = this.getCognosViewerJavaScriptObject(actionResponse, sbOutput);
        cognosViewerJavaScriptObject.constructObject();
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        cognosViewerJavaScriptObject.addEnvironmentVariables(actionResponse, sProductLocale);
        this.customizeCognosViewerJavaScriptObject(cognosViewerJavaScriptObject, actionResponse);
        cognosViewerJavaScriptObject.addAdvancedServerProperties();
        this.writeUsePageRequest(actionResponse, cognosViewerJavaScriptObject);
        this.writeSelectionInfo(sbOutput, actionResponse);
        this.insertInlineScript(actionResponse, sbOutput);
        try {
            if (!CognosViewerDispatcherHandlerState.isMasters()) {
                sbOutput.append(CAFLibrary.getJavascriptConfig());
            }
        }
        catch (CAFLibraryException cafLibraryException) {
            IPFLogger.getInstance().error(cafLibraryException.getMessage(), cafLibraryException, this.getClass().getName());
        }
        cognosViewerJavaScriptObject.generateCreateCallback();
        ReportBodyGenerator.writeScriptClosingTag(sbOutput, bUseCDATA);
    }

    protected void writeSelectionInfo(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        String cognosViewerNamespace = actionResponse.getFormFieldAsString("cv.id");
        sbOutput.append("oCVSC" + cognosViewerNamespace + " = new CSelectionController(\"" + cognosViewerNamespace + "\"," + "window.oCV" + cognosViewerNamespace + ");\n");
        String maxSecondarySelection = this.getMaxSecondarySelection();
        try {
            if (maxSecondarySelection != null) {
                Integer.parseInt(maxSecondarySelection);
                sbOutput.append("window.oCVSC" + cognosViewerNamespace + ".m_maxSecondarySelection = " + maxSecondarySelection + ";\n");
            }
        }
        catch (NumberFormatException numberFormatException) {
            IPFLogger.getInstance().error(numberFormatException.getMessage(), numberFormatException, this.getClass().getName());
        }
        String disableSecondarySelection = CognosViewerDispatcherHandler.getConfigValues().getProperty("disableSecondarySelection");
        if (disableSecondarySelection != null && "true".equals(disableSecondarySelection)) {
            sbOutput.append("window.oCVSC" + cognosViewerNamespace + ".m_disableSecondarySelection = true;\n");
        }
    }

    public String getMaxSecondarySelection() {
        return CognosViewerDispatcherHandler.getConfigValues().getProperty("maxSecondarySelection");
    }

    protected void writeUsePageRequest(ICognosViewerActionResponse actionResponse, CognosViewerJavaScriptObject cognosViewerJavaScriptObject) {
        if ("true".equals(actionResponse.getFormFieldAsString("bux")) || "fragment".equals(actionResponse.getFormFieldAsString("cv.responseFormat"))) {
            return;
        }
        if (!actionResponse.useAjax()) {
            cognosViewerJavaScriptObject.setUsePageRequests(true);
        }
    }

    protected void writeAccessibilityNavLinks(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        this.writeJumpToAppBar(actionResponse, sbOutput);
        this.writeJumpToReport(actionResponse, sbOutput);
        this.writeJumpToPageNavigation(actionResponse, sbOutput);
    }

    protected void writeJumpToAppBar(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String responseFormat = actionResponse.getFormFieldAsString("cv.responseFormat");
        if (!"true".equals(actionResponse.getFormFieldAsString("bux")) && !responseFormat.contains("mobile")) {
            String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
            String sNamespace = actionResponse.getFormFieldAsString("cv.id");
            String label = MessageManager.convert("IDS_SKIP_TO_APPBAR", sProductLocale);
            sbOutput.append("<div role=\"navigation\" aria-label=\"" + EncodingUtility.encodeXMLAttribute(label) + "\" id=\"cvSkipToAppBar");
            sbOutput.append(sNamespace);
            sbOutput.append("\" style=\"display:none;\" class=\"skip\">");
            sbOutput.append(EncodingUtility.htmlencode(label));
            sbOutput.append("</div>\n");
        }
    }

    protected void writeJumpToReport(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String responseFormat = actionResponse.getFormFieldAsString("cv.responseFormat");
        if (!"true".equals(actionResponse.getFormFieldAsString("bux")) && !responseFormat.contains("mobile")) {
            String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
            String sNamespace = actionResponse.getFormFieldAsString("cv.id");
            String label = MessageManager.convert("IDS_SKIP_TO_REPORT", sProductLocale);
            sbOutput.append("<div role=\"navigation\" aria-label=\"" + EncodingUtility.encodeXMLAttribute(label) + "\" id=\"cvSkipToReport");
            sbOutput.append(sNamespace);
            sbOutput.append("\" style=\"display:none;\" class=\"skip\"><a accesskey=\"2\"");
            sbOutput.append(" href=\"#RVContent").append(sNamespace).append("\">");
            sbOutput.append(EncodingUtility.htmlencode(label));
            sbOutput.append("</a></div>\n");
        }
    }

    protected void writeJumpToPageNavigation(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        if (!"true".equals(actionResponse.getFormFieldAsString("bux"))) {
            String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
            String sNamespace = actionResponse.getFormFieldAsString("cv.id");
            String label = MessageManager.convert("IDS_SKIP_TO_NAVIGATION", sProductLocale);
            sbOutput.append("<div role=\"navigation\" aria-label=\"" + EncodingUtility.encodeXMLAttribute(label) + "\" id=\"cvSkipToNavigation");
            sbOutput.append(sNamespace);
            sbOutput.append("\" style=\"display:none;\" class=\"skip\"><a accesskey=\"n\" href=\"#CVNavLinks");
            sbOutput.append(sNamespace).append("\">");
            sbOutput.append(EncodingUtility.htmlencode(label));
            sbOutput.append("</a></div>\n");
        }
    }

    protected void writeViewerHeader(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        sbOutput.append(ViewerHeader.render(actionResponse, sProductLocale));
    }
}

