/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.JSONObject;
import com.cognos.viewer.view.CognosViewerJavaScriptObject;
import com.cognos.viewer.view.PageOutput;
import com.cognos.viewer.view.QsResponseStateExtension;
import com.cognos.viewer.view.ReportBodyGenerator;
import org.dom4j.Element;

public class QsOutput
extends PageOutput {
    @Override
    public void writeBody(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        String sGateway = EncodingUtility.htmlencode(actionResponse.getEnvironmentVariable("SCRIPT_NAME"));
        String sStatus = actionResponse.getStatus();
        int iOutputType = 1;
        if ("working".equals(sStatus) || "stillWorking".equals(sStatus)) {
            iOutputType = 0;
        } else if ("prompting".equals(sStatus)) {
            iOutputType = 2;
        }
        sbOutput.append("<body id=\"__BODY__\" class=\"reportBody\" onload=\"goWindowManager.getReportManager().onLoadSetup(" + iOutputType + ");\">\n");
        sbOutput.append("<form action=\"" + sGateway + "\" name=\"formWarpRequest" + sNamespace + "\" id=\"formWarpRequest" + sNamespace + "\" method=\"POST\" style=\"height:100%;margin:0px\" onsubmit=\"if((typeof promptButtonOK).match(/^function$/i)){promptButtonOK();return false;} else if((typeof execute).match(/^function$/i)){execute();return false;}\">\n");
        ReportBodyGenerator.writeReportBody(sbOutput, actionResponse);
        sbOutput.append(ReportBodyGenerator.writeHiddenInputs(actionResponse));
        sbOutput.append(this.getQSHiddenInputs(actionResponse));
        sbOutput.append("</form>\n");
        sbOutput.append("<form name=\"backJaxState\" id=\"backJaxState\" style=\"display: none;\">\n");
        sbOutput.append("<input type=\"hidden\" name=\"undoCnt\" id=\"undoCnt\" value=\"empty\"/>");
        sbOutput.append("<input type=\"hidden\" name=\"redoCnt\" id=\"redoCnt\" value=\"empty\"/>");
        sbOutput.append("<input type=\"hidden\" name=\"id\" id=\"id\" value=\"empty\"/>\n");
        sbOutput.append("</form>\n");
        sbOutput.append("</body>\n");
        ReportBodyGenerator.writeScriptOpeningTag(sbOutput, true);
        CognosViewerJavaScriptObject cognosViewerJavaScriptObject = this.getCognosViewerJavaScriptObject(actionResponse, sbOutput);
        cognosViewerJavaScriptObject.initViewer(actionResponse, new QsResponseStateExtension());
        ReportBodyGenerator.writeScriptClosingTag(sbOutput, true);
    }

    public StringBuffer getQSStyleSheetIncludes(ICognosViewerState state) {
        String SKIN_ROOT = state.getWebContentRoot() + "/skins/";
        String sSkin = SKIN_ROOT + state.getUserPreference("skin");
        StringBuffer sbStyleSheets = new StringBuffer();
        sbStyleSheets.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + sSkin + "/qs/QSReport.css\"/>\n");
        sbStyleSheets.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + sSkin + "/qs/QSSelection.css\"/>\n");
        sbStyleSheets.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + sSkin + "/viewer/QSRVCommonUI.css\"/>\n");
        sbStyleSheets.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + sSkin + "/viewer/QSRVall.css\"/>\n");
        sbStyleSheets.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + sSkin + "/viewer/CRN.css\"/>\n");
        return sbStyleSheets;
    }

    public StringBuffer getQSHiddenInputs(ICognosViewerState state) {
        StringBuffer sbInputs = new StringBuffer();
        sbInputs.append("<input type=\"hidden\" name=\"app\" value=\"QS\"/>\n");
        sbInputs.append("<input type=\"hidden\" name=\"_promptControl\"/>\n");
        sbInputs.append("<input type=\"hidden\" name=\"_autosubmitParameter\"/>\n");
        sbInputs.append("<input type=\"hidden\" name=\"ui.spec\" value=\"\"/>\n");
        sbInputs.append("<input type=\"hidden\" name=\"ui.conversation\" value=\"\"/>\n");
        sbInputs.append("<input type=\"hidden\" name=\"run.prompt\" value=\"\"/>\n");
        sbInputs.append("<input type=\"hidden\" name=\"parameterValues\" value=\"\"/>\n");
        sbInputs.append("<input type=\"hidden\" name=\"disp_trackingInfo\" value=\"\"/>\n");
        sbInputs.append("<input type=\"hidden\" name=\"m_tracking\" value=\"\"/>\n");
        sbInputs.append("<input type=\"hidden\" name=\"ui.command\" value=\"\"/>\n");
        if (!"".equals(state.getFormFieldAsString("model"))) {
            sbInputs.append("<input type=\"hidden\" name=\"model\" value=\"" + EncodingUtility.htmlencode(state.getFormFieldAsString("model")) + "\"/>\n");
        } else if (!"".equals(state.getFormFieldAsString("cmLastModelSearchPath"))) {
            sbInputs.append("<input type=\"hidden\" name=\"model\" value=\"" + EncodingUtility.htmlencode(state.getFormFieldAsString("cmLastModelSearchPath")) + "\"/>\n");
        } else if (!"".equals(state.getFormFieldAsString("cmQueryModelMetadataModelSearchPath"))) {
            sbInputs.append("<input type=\"hidden\" name=\"model\" value=\"" + EncodingUtility.htmlencode(state.getFormFieldAsString("cmQueryModelMetadataModelSearchPath")) + "\"/>\n");
        }
        if (!"".equals(state.getFormFieldAsString("ui.routingServerGroup"))) {
            sbInputs.append("<input type=\"hidden\" name=\"ui.routingServerGroup\" value=\"" + EncodingUtility.htmlencode(state.getFormFieldAsString("ui.routingServerGroup")) + "\"/>\n");
        }
        return sbInputs;
    }

    public StringBuilder getQSScriptIncludes(ICognosViewerState state) {
        StringBuilder sbScripts = new StringBuilder();
        String sWebContentRoot = state.getWebContentRoot();
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/util/CViewerHelper.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/qs/layout.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/qs/classes/CWindowManager.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/qs/reportRun.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CSelectionDefaultStyles.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cvselection.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cvui.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/qs/CReportSelectionObject.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/qs/CReportSelectionController.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/qs/reportSelection.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/qs/contextMenu.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/objectModel/parameters.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CDrillManager.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cvactions.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/utils/DrillContextMenuHelper.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/standalone/DrillAction.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/standalone/DrillDownAction.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/standalone/DrillUpAction.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/drill/CSelectionContextBuilder.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/selectionContext.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/common.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCognosViewerDebugLogger.js\"></script>\n");
        sbScripts.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/serverrequest/legacy/CCognosViewerRequest.js\"></script>\n");
        this.writeStandaloneRequestJavascriptIncludes(sWebContentRoot, true, sbScripts);
        return sbScripts;
    }

    public JSONObject getQSJSONObject(ICognosViewerState state) {
        JSONObject jsonObject = new JSONObject();
        if (!(!"edit".equals(state.getFormFieldAsString("ui.action")) || "".equals(state.getFormFieldAsString("ui.spec")) && "".equals(state.getFormFieldAsString("ui.conversation")))) {
            jsonObject.addMember("checkUpdateState", true, false);
        }
        if ("".equals(state.getFormFieldAsString("cmQueryModelReportName"))) {
            jsonObject.addMember("setNewReport", true, false);
        }
        jsonObject.addMember("currentApp", state.getFormFieldAsString("app"), false, true);
        BIBusEnvelope busResponse = state.getBusEnvelope();
        if (busResponse != null) {
            Element CAFSecureStateElement;
            Element soapHeader;
            Element searchPathValue;
            Element soapBody = busResponse.getBody();
            if (soapBody != null && (searchPathValue = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/bus:sourceObject/item/searchPath/value")) != null && !"".equals(searchPathValue.getText().trim())) {
                jsonObject.addMember("searchPathValue", searchPathValue.getText().trim(), false, true);
            }
            if ((soapHeader = busResponse.getHeader()) != null && (CAFSecureStateElement = (Element)soapHeader.selectSingleNode("./*/*[local-name()='CAF']/*[local-name()='secureState']")) != null) {
                jsonObject.addMember("CAFEnabled", true, false);
            }
        }
        return jsonObject;
    }

    @Override
    public void writeHeadDetails(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        sbOutput.append(this.getQSStyleSheetIncludes(actionResponse));
        sbOutput.append((CharSequence)this.getQSScriptIncludes(actionResponse));
    }

    @Override
    protected void customizeCognosViewerJavaScriptObject(CognosViewerJavaScriptObject cvObject, ICognosViewerActionResponse actionResponse) {
        cvObject.setViewerCapabities();
        cvObject.disableBrowserHotkeyPageNavigation();
        cvObject.addResponseCallback("cancel", "function (){parent.goApplicationManager.getReportManager().cancel()}", false);
        cvObject.addResponseCallback("wait", "function(){window.oCV" + cvObject.getCvId() + ".wait();}", false);
    }

    @Override
    protected void insertInlineScript(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        sbOutput.append("var goWindowManager = new CWindowManager();\n");
        sbOutput.append("var cf = (typeof goWindowManager.getApplicationFrame == \"function\") ? goWindowManager.getApplicationFrame() : null;\n");
        sbOutput.append("var oParams = ");
        JSONObject QSjsonObject = this.getQSJSONObject(actionResponse);
        QSjsonObject.write(sbOutput);
        sbOutput.append(";\n");
        sbOutput.append("goWindowManager.getReportManager().setReportParameters(oParams);\n");
        String enableNewSelectionContext = CognosViewerDispatcherHandler.getConfigValues().getProperty("enableNewSelectionContext");
        if ("false".equals(enableNewSelectionContext)) {
            sbOutput.append("var gUseNewSelectionContext = false;\n");
        }
    }

    @Override
    protected boolean usingViewerCoreFile() {
        return false;
    }
}

