/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.configuration.CognosViewerSystemParams;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerBlankResponse;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.render.Renderer;
import com.cognos.viewer.render.RendererFactory;
import com.cognos.viewer.utility.BrowserUtility;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.view.CognosViewerJSONToolbar;
import com.cognos.viewer.view.ViewOutput;
import com.cognos.xts.ext.XTSExt;
import com.ibm.cognos.i18n.util.Bidi;
import org.dom4j.Element;

public class ReportBodyGenerator {
    public static void render(StringBuilder sbReportBody, ICognosViewerActionResponse actionResponse) throws CognosViewerException {
        boolean isHTML;
        String sHttpUserAgent = actionResponse.getEnvironmentVariable("HTTP_USER_AGENT");
        String sBrowser = BrowserUtility.getBrowser(sHttpUserAgent);
        String sStatus = actionResponse.getStatus();
        String sContentFormat = actionResponse.getContentFormat();
        String sResponseFormat = actionResponse.getResponseFormat();
        boolean bWorking = "working".equals(sStatus) || "stillWorking".equals(sStatus);
        boolean isIE = BrowserUtility.isInternetExplorer(sHttpUserAgent);
        boolean bl = isHTML = sContentFormat.indexOf("HTML") != -1;
        if (sContentFormat.length() > 0 && !bWorking) {
            boolean isInteractiveHTML;
            boolean isXML = "XML".equals(sContentFormat) && "complete".equals(sStatus);
            boolean bl2 = isInteractiveHTML = !CognosViewerDispatcherHandlerState.isIROTReport(actionResponse) && isHTML && !"view".equals(actionResponse.getAction());
            if (isInteractiveHTML || "prompting".equals(sStatus) || isXML) {
                if (isXML) {
                    if ("fragment".equals(sResponseFormat)) {
                        String sFragmentHeight = ReportBodyGenerator.getFragmentHeight(actionResponse, isXML);
                        sbReportBody.append("<textarea readonly=\"true\" style=\"border:none;height:" + sFragmentHeight + ";width:99%;\">");
                    } else {
                        sbReportBody.append("<textarea readonly=\"true\" style=\"border:none;height:99%;width:99%;\">");
                    }
                }
                actionResponse.getDetailOutput(sbReportBody);
                if (isXML) {
                    sbReportBody.append("</textarea>");
                }
            } else if (actionResponse.isBUX() && "view".equals(actionResponse.getAction()) && !CognosViewerDispatcherHandlerState.isIROTReport(actionResponse)) {
                ReportBodyGenerator.renderIWidgetSavedOutputDiv(actionResponse, sbReportBody);
                StringBuilder sbIframeURL = ReportBodyGenerator.buildIframeURL(actionResponse);
                sbReportBody.append("<iframe onload=\"savedOutputDoneLoading('").append(actionResponse.getFormFieldAsString("cv.id")).append("',0);\" id=\"CVHiddenIFrame").append(actionResponse.getFormFieldAsString("cv.id")).append("\" src=\"").append((CharSequence)sbIframeURL).append("\" frameborder=\"0\" style=\"display: none\" title=\"Hidden iframe\"></iframe>");
                ViewOutput viewOutput = new ViewOutput();
                viewOutput.writeHiddenInputs(actionResponse, sbReportBody);
            } else {
                StringBuilder sbIframeURL = ReportBodyGenerator.buildIframeURL(actionResponse);
                if (sbIframeURL.length() > 0) {
                    if (actionResponse.isBUX() && CognosViewerDispatcherHandlerState.isIROTReport(actionResponse)) {
                        if (!"fault".equals(sStatus)) {
                            sbReportBody.append("<iframe width=\"100%\" type=AR src=\"" + EncodingUtility.htmlencode(sbIframeURL.toString()) + "\" ");
                            sbReportBody.append("tabIndex=\"0\"");
                            sbReportBody.append("id=\"CVIFrame" + actionResponse.getFormFieldAsString("cv.id") + "\" ");
                            String sTitle = MessageManager.convert("IDS_IFRAME_TITLE", actionResponse.getFormFieldAsString("lang"), new Object[]{actionResponse.getFormFieldAsString("ui.name"), sContentFormat});
                            sbReportBody.append("title=\"" + EncodingUtility.htmlencode(sTitle) + "\" ");
                            sbReportBody.append("frameborder=\"0\"></iframe>");
                        }
                    } else if (ReportBodyGenerator.isExcelFormat(sContentFormat)) {
                        sbReportBody.append((CharSequence)ReportBodyGenerator.handleExcelOutput(actionResponse, sbIframeURL));
                    } else if (CognosViewerDispatcherHandlerState.isIROTReport(actionResponse)) {
                        if ("view".equals(actionResponse.getAction())) {
                            sbReportBody.append((CharSequence)ReportBodyGenerator.showOutputInNewWindow(actionResponse, sbIframeURL));
                        } else {
                            sbReportBody.append((CharSequence)ReportBodyGenerator.handleIROTPreviewOutput(actionResponse, sbIframeURL));
                        }
                    } else if (actionResponse.isAccessibleMode() && "PDF".equals(sContentFormat) && !"true".equals(actionResponse.getFormFieldAsString("ui.reuseWindow"))) {
                        sbReportBody.append((CharSequence)ReportBodyGenerator.showOutputInNewWindow(actionResponse, sbIframeURL));
                    } else if ("safari".compareTo(sBrowser) == 0 && "PDF".equals(sContentFormat)) {
                        sbReportBody.append((CharSequence)ReportBodyGenerator.showOutputInNewWindow(actionResponse, sbIframeURL));
                    } else if (CognosViewerDispatcherHandlerState.isIROTReport(actionResponse)) {
                        sbReportBody.append((CharSequence)ReportBodyGenerator.showOutputInNewWindow(actionResponse, sbIframeURL));
                    } else if (ReportBodyGenerator.shouldRenderIFrameUsingJavascript(actionResponse)) {
                        ReportBodyGenerator.renderIFrameUsingJavascript(actionResponse, sbReportBody, sbIframeURL);
                    } else {
                        sbReportBody.append("<iframe width=\"100%\" src=\"" + EncodingUtility.htmlencode(sbIframeURL.toString()) + "\" ");
                        if ("fragment".equals(sResponseFormat)) {
                            String sFragmentHeight = ReportBodyGenerator.getFragmentHeight(actionResponse, isXML);
                            sbReportBody.append("style=\"height:" + sFragmentHeight + "\" ");
                        } else if (!(isHTML && "view".equals(actionResponse.getAction()) && isIE)) {
                            sbReportBody.append("style=\"height:99%\" ");
                        }
                        String cognosViewerNamespace = actionResponse.getFormFieldAsString("cv.id");
                        String cvObject = "window.oCV" + cognosViewerNamespace;
                        sbReportBody.append("id=\"CVIFrame" + cognosViewerNamespace + "\" ");
                        String sTitle = MessageManager.convert("IDS_IFRAME_TITLE", actionResponse.getFormFieldAsString("lang"), new Object[]{actionResponse.getFormFieldAsString("ui.name"), sContentFormat});
                        sbReportBody.append("title=\"" + EncodingUtility.htmlencode(sTitle) + "\" ");
                        sbReportBody.append("onload=\"" + cvObject + ".setMaxContentSize(); " + cvObject + ".renderTabs();\" ");
                        sbReportBody.append("frameborder=\"0\"></iframe>");
                    }
                }
            }
        } else if ("mobileScheduled".equals(sResponseFormat)) {
            ReportBodyGenerator.renderMobileScheduledDiv(actionResponse, sbReportBody);
        }
    }

    public static boolean shouldRenderIFrameUsingJavascript(ICognosViewerActionResponse actionResponse) {
        String contentFormat = actionResponse.getContentFormat();
        String responseFormat = actionResponse.getResponseFormat();
        boolean isIE = BrowserUtility.isInternetExplorer(actionResponse.getEnvironmentVariable("HTTP_USER_AGENT"));
        return contentFormat.indexOf("HTML") != -1 && !"fragment".equals(responseFormat) && isIE;
    }

    public static boolean shouldRenderTabs(ICognosViewerActionResponse actionResponse) {
        String contentFormat = actionResponse.getContentFormat();
        String responseFormat = actionResponse.getResponseFormat();
        return contentFormat.indexOf("HTML") != -1 || "mobileScheduled".equals(responseFormat);
    }

    private static void renderMobileScheduledDiv(ICognosViewerActionResponse actionResponse, StringBuilder sbReportBody) {
        String oCVObjectRef = "window.oCV" + actionResponse.getFormFieldAsString("cv.id");
        sbReportBody.append("<div");
        sbReportBody.append(" role=\"presentation\"");
        sbReportBody.append(" onclick=\"").append(oCVObjectRef).append(".rvMainWnd.pageClicked(event);\"");
        sbReportBody.append(" onContextMenu=\"").append(oCVObjectRef).append(".dcm(event, true);\"");
        sbReportBody.append(" style=\"width:100%; height: 1%;\"");
        sbReportBody.append(">");
        sbReportBody.append("####MobileScheduledOutput####");
        sbReportBody.append("</div>");
    }

    private static void renderIWidgetSavedOutputDiv(ICognosViewerActionResponse actionResponse, StringBuilder sbReportBody) throws CognosViewerException {
        String oCVObjectRef = "window.oCV" + actionResponse.getFormFieldAsString("cv.id");
        sbReportBody.append("<div");
        sbReportBody.append(" role=\"presentation\" id=\"CVSavedOutputDiv").append(actionResponse.getFormFieldAsString("cv.id")).append("\"");
        sbReportBody.append(" onmousemove=\"if (typeof ").append(oCVObjectRef).append(" != 'undefined')").append(oCVObjectRef).append(".getSelectionController().pageHover(event);\"");
        sbReportBody.append(" onkeydown=\"if (typeof ").append(oCVObjectRef).append(" != 'undefined')").append(oCVObjectRef).append(".onKeyDown(event);\"");
        sbReportBody.append(" onDblClick=\"if (typeof ").append(oCVObjectRef).append(" != 'undefined')").append(oCVObjectRef).append(".getSelectionController().pageDoubleClicked(event);\"");
        sbReportBody.append(" onmousedown=\"if (typeof ").append(oCVObjectRef).append(" != 'undefined')").append(oCVObjectRef).append(".getViewerWidget().onMouseDown(event);\"");
        sbReportBody.append(" onmouseup=\"if (typeof ").append(oCVObjectRef).append(" != 'undefined')").append(oCVObjectRef).append(".getViewerWidget().onMouseUp(event);\"");
        sbReportBody.append(" oncontextmenu=\"if (typeof ").append(oCVObjectRef).append(" != 'undefined')").append(oCVObjectRef).append(".getViewerWidget().onContextMenu(event);\"");
        sbReportBody.append(" style=\"width:100%; height: 1%;\"");
        sbReportBody.append(">");
        ReportBodyGenerator.writeLoadingTable(actionResponse, sbReportBody);
        sbReportBody.append("</div>");
    }

    public static void writeLoadingTable(ICognosViewerActionResponse actionResponse, StringBuilder sbReportBody) {
        String id = "loading" + actionResponse.getFormFieldAsString("cv.id");
        sbReportBody.append("<table role=\"presentation\" tabindex=\"-1\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"widget_loadContainerOuter\" id=\"" + id + "\"");
        if ("iWidget".equals(actionResponse.getResponseFormat())) {
            sbReportBody.append(" style=\"width: 128px; height: 127px;\"");
        }
        sbReportBody.append(">");
        sbReportBody.append("<tr><td class=\"widget_loadContainer\">");
        sbReportBody.append("<div class=\"widget_loadContainerInsert\">");
        sbReportBody.append("<div class=\"dijitInline widget_load\"> " + MessageManager.convert("GOTO_LOADING", CognosViewerDispatcherHandlerState.getContentLocale(actionResponse)) + "</div>");
        sbReportBody.append("</div>");
        sbReportBody.append("</td></tr></table>");
    }

    public static String getFragmentHeight(ICognosViewerState state, boolean isMozillaXML) {
        String sFragmentHeight = state.getFormFieldAsString("fragment.height");
        if (sFragmentHeight.length() == 0) {
            sFragmentHeight = "365px";
        } else {
            int fragmentHieght = Integer.parseInt(sFragmentHeight) - 5;
            sFragmentHeight = Integer.toString(fragmentHieght) + "px";
        }
        return sFragmentHeight;
    }

    public static String extractSearchPathFromURLQueryString(String sURLQueryString) {
        if (sURLQueryString.length() > 0) {
            sURLQueryString = EncodingUtility.urldecode(sURLQueryString);
            int iSubStringStartIndex = sURLQueryString.indexOf("search=") + "search=".length();
            int iSubStringEndIndex = sURLQueryString.indexOf("&webcompress=true") > 0 ? sURLQueryString.indexOf("&webcompress=true") : sURLQueryString.indexOf("&SA");
            sURLQueryString = sURLQueryString.substring(iSubStringStartIndex, iSubStringEndIndex);
            return sURLQueryString;
        }
        return "";
    }

    public static String extractIDFromStoreID(String storeID) {
        String id = "";
        if (storeID != null && storeID.length() > 0) {
            String prefix = "storeID(\"";
            String suffix = "\")";
            int iSubStringStartIndex = storeID.indexOf(prefix);
            int iSubStringEndIndex = storeID.indexOf(suffix);
            if (iSubStringStartIndex != -1 && iSubStringEndIndex != -1) {
                id = storeID.substring(iSubStringStartIndex + prefix.length(), iSubStringEndIndex);
            }
        }
        return id;
    }

    public static StringBuilder buildIframeURL(ICognosViewerActionResponse actionResponse, Renderer renderer) {
        try {
            StringBuilder sbIframeURL = new StringBuilder();
            if (!"fault".equals(actionResponse.getStatus())) {
                if (CognosViewerDispatcherHandlerState.isIROTReport(actionResponse) && ("view".equals(actionResponse.getAction()) || actionResponse.isBUX())) {
                    String outputDataPath = ((CMServerResponse)actionResponse).getProperty(PropEnum.dataPathInfo.getValue());
                    sbIframeURL.append(outputDataPath + "/mht/content");
                } else {
                    sbIframeURL.append(renderer.renderReportBodyFragment(actionResponse));
                }
                if (sbIframeURL.length() > 0) {
                    if (CognosViewerDispatcherHandlerState.isIROTReport(actionResponse) && sbIframeURL.indexOf("/") != 0) {
                        sbIframeURL.insert(0, '/');
                    }
                    sbIframeURL.insert(0, EncodingUtility.htmlencode(actionResponse.getEnvironmentVariable("SCRIPT_NAME")));
                }
            }
            return new StringBuilder(sbIframeURL.toString());
        }
        catch (CognosViewerException ex) {
            IPFLogger.getInstance().error(ex.getMessage(), ex, ReportBodyGenerator.class.getName());
            return null;
        }
    }

    public static StringBuilder buildIframeURL(ICognosViewerActionResponse actionResponse) {
        return ReportBodyGenerator.buildIframeURL(actionResponse, RendererFactory.getRenderer());
    }

    public static void addURLParamsForCachedSelfContainedSavedReportOutput(ICognosViewerActionResponse actionResponse, StringBuilder sbIframeURL) {
        sbIframeURL.append(((CMServerResponse)actionResponse).getProperty(PropEnum.dataPathInfo.getValue()));
    }

    public static void addURLParamsForSelfContainedSavedReportOutput(String sContentFormat, StringBuilder sbIframeURL, CAMPassport camPassport, String sURLQueryString) {
        sURLQueryString = sContentFormat.compareTo("XLS") == 0 ? XTSExt.web64encode((String)(camPassport.getId() + ";" + sURLQueryString), (boolean)true) : Protect.cafaction("sign_reporturl_setpassportid_" + camPassport.getId(), XTSExt.web64encode((String)(";" + sURLQueryString), (boolean)true));
        sbIframeURL.append("/gd/");
        sbIframeURL.append(sURLQueryString);
        sbIframeURL.append("/");
    }

    public static void renderIFrameUsingJavascript(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput, StringBuilder sbIframeURL) {
        ReportBodyGenerator.writeScriptOpeningTag(sbOutput, actionResponse);
        String sContentFormat = actionResponse.getContentFormat();
        String sTitle = MessageManager.convert("IDS_IFRAME_TITLE", actionResponse.getFormFieldAsString("lang"), new Object[]{actionResponse.getFormFieldAsString("ui.name"), sContentFormat});
        String sCVId = actionResponse.getFormFieldAsString("cv.id");
        sbOutput.append("window.oCV");
        sbOutput.append(sCVId);
        sbOutput.append(".renderSavedOutputIFrame(\"").append(XTSExt.javascriptencode((String)sbIframeURL.toString())).append("\",\"").append(XTSExt.javascriptencode((String)sTitle)).append("\"," + ReportBodyGenerator.shouldRenderTabs(actionResponse) + ");");
        ReportBodyGenerator.writeScriptClosingTag(sbOutput, actionResponse);
    }

    public static StringBuilder showOutputInNewWindow(ICognosViewerActionResponse actionResponse, StringBuilder sbIframeURL) {
        StringBuilder sbPDFOutput = new StringBuilder(512);
        ReportBodyGenerator.writeScriptOpeningTag(sbPDFOutput, actionResponse);
        String sCVId = actionResponse.getFormFieldAsString("cv.id");
        sbPDFOutput.append("window.oCV");
        sbPDFOutput.append(sCVId);
        sbPDFOutput.append(".showOutputInNewWindow(\"").append(XTSExt.javascriptencode((String)sbIframeURL.toString())).append("\");");
        ReportBodyGenerator.writeScriptClosingTag(sbPDFOutput, actionResponse);
        return sbPDFOutput;
    }

    public static StringBuilder handleExcelOutput(ICognosViewerActionResponse actionResponse, StringBuilder sbIframeURL) {
        boolean isIEorFF;
        StringBuilder sbExcelOutput = new StringBuilder(512);
        ReportBodyGenerator.writeScriptOpeningTag(sbExcelOutput, actionResponse);
        sbExcelOutput.append("var sURL = '" + XTSExt.javascriptencode((String)sbIframeURL.toString()) + "';\n");
        String sCVId = actionResponse.getFormFieldAsString("cv.id");
        boolean bIsFragment = "fragment".equals(actionResponse.getFormFieldAsString("cv.responseFormat"));
        boolean bKeepWindowOpen = "true".equals(actionResponse.getFormFieldAsString("cv.keepWindowOpen"));
        String httpUserAgent = actionResponse.getEnvironmentVariable("HTTP_USER_AGENT");
        boolean bl = isIEorFF = BrowserUtility.isInternetExplorer(httpUserAgent) || BrowserUtility.isFirefox(httpUserAgent);
        if (isIEorFF && !bKeepWindowOpen) {
            if (bIsFragment) {
                sbExcelOutput.append("window.open(sURL, \"\", \"\");\n");
            } else {
                sbExcelOutput.append("window.oCV");
                sbExcelOutput.append(sCVId);
                sbExcelOutput.append(".showExcel(sURL);");
            }
        } else {
            sbExcelOutput.append("var myIframe = document.createElement(\"iframe\");\n");
            sbExcelOutput.append("myIframe.style.width = \"0px\";\n");
            sbExcelOutput.append("myIframe.style.height = \"0px\";\n");
            sbExcelOutput.append("myIframe.frameborder = \"0\";\n");
            sbExcelOutput.append("myIframe.marginheight = \"0\";\n");
            sbExcelOutput.append("myIframe.marginwidth = \"0\";\n");
            sbExcelOutput.append("myIframe.style.margin = \"0px\";\n");
            sbExcelOutput.append("myIframe.style.visibility = \"hidden\";\n");
            sbExcelOutput.append("document.body.appendChild(myIframe);\n");
            sbExcelOutput.append("myIframe.src = sURL;\n");
        }
        ReportBodyGenerator.writeScriptClosingTag(sbExcelOutput, actionResponse);
        if (bIsFragment || !isIEorFF || bKeepWindowOpen) {
            String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
            sbExcelOutput.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td style=\"padding-left:10px;\">");
            sbExcelOutput.append("<img src=\"" + actionResponse.getWebContentRoot() + "/ps/portal/images/msg_information.gif\"></img>");
            sbExcelOutput.append("</td><td style=\"padding-left:3px;vertical-align:top;\" class=\"formText\" width=\"100%\">");
            sbExcelOutput.append(MessageManager.convert("RV_REPORT_IS_READY", sProductLocale));
            sbExcelOutput.append("</td></tr></table>\n");
            ReportBodyGenerator.writeScriptOpeningTag(sbExcelOutput, actionResponse);
            sbExcelOutput.append("var oCV = ").append("window.oCV").append(sCVId).append(";\n");
            sbExcelOutput.append("var oBannerToolbar = oCV.rvMainWnd.getBannerToolbar();\n");
            sbExcelOutput.append("if (oBannerToolbar) { oBannerToolbar.draw();\t};");
            sbExcelOutput.append("oCV.hideToolbar(true);");
            ReportBodyGenerator.writeScriptClosingTag(sbExcelOutput, actionResponse);
        }
        return sbExcelOutput;
    }

    public static StringBuilder handleIROTPreviewOutput(ICognosViewerActionResponse actionResponse, StringBuilder sbIframeURL) {
        StringBuilder sbIROTOutput = new StringBuilder(512);
        ReportBodyGenerator.writeScriptOpeningTag(sbIROTOutput, actionResponse);
        String previewPageRoot = sbIframeURL.substring(0, sbIframeURL.lastIndexOf("/"));
        String sCVId = actionResponse.getFormFieldAsString("cv.id");
        sbIROTOutput.append("function notifyARParametersObtained()");
        sbIROTOutput.append("{");
        sbIROTOutput.append("window.oCV");
        sbIROTOutput.append(sCVId);
        sbIROTOutput.append(".updateNewBrowserWindow();");
        sbIROTOutput.append("};");
        sbIROTOutput.append("var AR_Parameters = {};");
        sbIROTOutput.append("AR_Parameters['generatedOutputPath'] = '" + XTSExt.javascriptencode((String)previewPageRoot) + "';");
        sbIROTOutput.append("var sURL = '../irot/irot.htm';");
        sbIROTOutput.append("window.open(sURL, '', '');");
        ReportBodyGenerator.writeScriptClosingTag(sbIROTOutput, actionResponse);
        return sbIROTOutput;
    }

    public static boolean isExcelFormat(String sFormat) {
        return sFormat.compareTo("CSV") == 0 || sFormat.compareTo("xlsxData") == 0 || sFormat.compareTo("XLS") == 0 || sFormat.compareTo("XLWA") == 0 || sFormat.compareTo("singleXLS") == 0 || sFormat.compareTo("spreadsheetML") == 0;
    }

    public static void writeToolbarObject(ICognosViewerActionResponse actionResponse, Element toolbarSpec, StringBuilder sbOutput) {
        String cognosViewerNamespace = actionResponse.getFormFieldAsString("cv.id");
        if (toolbarSpec != null && !"false".equals(actionResponse.getFormFieldAsString("cv.toolbar")) && actionResponse.getCapabilities().hasCapability("canUseCognosViewerToolbar")) {
            sbOutput.append("window.oCV" + cognosViewerNamespace + ".rvMainWnd.setToolbar(");
            CognosViewerJSONToolbar cognosViewerJSONToolbar = new CognosViewerJSONToolbar(actionResponse);
            sbOutput.append(cognosViewerJSONToolbar.render(toolbarSpec));
            sbOutput.append(");\n");
        }
    }

    public static void writeBannerObject(ICognosViewerActionResponse actionResponse, Element bannerSpec, StringBuilder sbOutput) {
        String cognosViewerNamespace = actionResponse.getFormFieldAsString("cv.id");
        if (ReportBodyGenerator.canRenderBanner(actionResponse, bannerSpec)) {
            sbOutput.append("window.oCV" + cognosViewerNamespace + ".rvMainWnd.setBannerToolbar(");
            CognosViewerJSONToolbar cognosViewerJSONToolbar = new CognosViewerJSONToolbar(actionResponse);
            sbOutput.append(cognosViewerJSONToolbar.render(bannerSpec));
            sbOutput.append(");\n");
        }
    }

    private static boolean canRenderBanner(ICognosViewerActionResponse actionResponse, Element bannerSpec) {
        return bannerSpec != null && !"false".equals(actionResponse.getFormFieldAsString("cv.header")) && !"QS".equals(actionResponse.getFormFieldAsString("cv.id")) && !"fragment".equals(actionResponse.getFormFieldAsString("cv.responseFormat"));
    }

    public static StringBuffer writeHiddenInputs(ICognosViewerActionResponse actionResponse) {
        String sShowUnencodedFormFields;
        String sSavedEnv;
        StringBuffer sbHiddenInputs = new StringBuffer();
        ReportBodyGenerator.writeHiddenInput("ui.action", actionResponse.getAction(), sbHiddenInputs);
        String sBackURL = actionResponse.getFormFieldAsString("ui.backURL");
        if ("".equals(sBackURL)) {
            sBackURL = "javascript:window.close();";
        }
        ReportBodyGenerator.writeHiddenInput("ui.backURL", sBackURL, sbHiddenInputs);
        ReportBodyGenerator.writeHiddenInput("cv.id", actionResponse.getFormFieldAsString("cv.id"), sbHiddenInputs);
        ReportBodyGenerator.writeHiddenInput("run.outputFormat", actionResponse.getContentFormat(), sbHiddenInputs);
        ReportBodyGenerator.writeHiddenInput("promptOnRerun", actionResponse.getFormFieldAsString("promptOnRerun"), sbHiddenInputs);
        if (actionResponse.getObjectPath() != null) {
            ReportBodyGenerator.writeHiddenInput("ui.object", actionResponse.getObjectPath().get_value(), sbHiddenInputs);
        }
        String sModelPath = actionResponse.getFormFieldAsString("modelPath");
        ReportBodyGenerator.writeHiddenInput("modelPath", sModelPath, sbHiddenInputs);
        String sPackageBase = actionResponse.getFormFieldAsString("packageBase");
        ReportBodyGenerator.writeHiddenInput("packageBase", sPackageBase, sbHiddenInputs);
        String sContextInfo = actionResponse.getFormFieldAsString("contextInfo");
        ReportBodyGenerator.writeHiddenInput("cv.contextInfo", sContextInfo, sbHiddenInputs);
        String uiPostBack = actionResponse.getFormFieldAsString("ui.postBack");
        if (!"".equals(uiPostBack)) {
            ReportBodyGenerator.writeHiddenInput("ui.postBack", uiPostBack, sbHiddenInputs);
        }
        if (!"".equals(sSavedEnv = actionResponse.getFormFieldAsString("savedEnv"))) {
            ReportBodyGenerator.writeHiddenInput("savedEnv", sSavedEnv, sbHiddenInputs);
        }
        if ("true".equals(sShowUnencodedFormFields = CognosViewerSystemParams.getSystemParam("cvShowUnencodedFormFields"))) {
            Element executionParameters;
            Element soapBody;
            BIBusEnvelope busResponse;
            String sSpec = actionResponse.getFormFieldAsString("ui.spec");
            if (sSpec.length() > 0) {
                if (!sSpec.startsWith("<")) {
                    sSpec = XTSExt.web64decode((String)Protect.cafaction("sign_unwrap", sSpec), (boolean)true);
                }
                ReportBodyGenerator.writeHiddenInput("ui.clientunencodedspec", sSpec, sbHiddenInputs);
            }
            if ((busResponse = actionResponse.getBusEnvelope()) != null && (soapBody = busResponse.getBody()) != null && (executionParameters = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='primaryRequest']/*[local-name()='parameters']")) != null) {
                String sExecutionParameters = executionParameters.asXML();
                ReportBodyGenerator.writeHiddenInput("clientunencodedexecutionparameters", sExecutionParameters, sbHiddenInputs);
            }
        }
        return sbHiddenInputs;
    }

    public static void writeHiddenInput(String sName, String sValue, StringBuffer sbStringBuffer) {
        sbStringBuffer.append("<input type=\"hidden\" ");
        sbStringBuffer.append("name=\"" + sName + "\" ");
        sbStringBuffer.append("value=\"" + EncodingUtility.htmlencode(sValue) + "\">\n");
    }

    public static StringBuffer writeNavigationLinks(ICognosViewerActionResponse actionResponse) {
        StringBuffer sbNavigationLinks = new StringBuffer();
        String showNavLinks = actionResponse.getFormFieldAsString("cv.navlinks");
        if (showNavLinks.compareTo("false") != 0) {
            String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
            String sNamespace = actionResponse.getFormFieldAsString("cv.id");
            sbNavigationLinks.append("<tr id=\"CVNavLinks_Container" + sNamespace + "\">");
            String align = "align=\"left\"";
            if (Bidi.isLocaleRTL((String)sProductLocale)) {
                align = "align=\"right\"";
            }
            String label = MessageManager.convert("IDS_SKIP_NAVIGATION_LINKS_LABEL", sProductLocale);
            sbNavigationLinks.append("<td class=\"viewerNavigation\" role=\"navigation\" aria-label=\"" + EncodingUtility.encodeXMLAttribute(label) + "\" id=\"CVNavLinks" + sNamespace + "\" aria-labelledby=\"CVNavLinks_label" + sNamespace + "\" " + align + ">");
            sbNavigationLinks.append("<span id=\"CVNavLinks_label" + sNamespace + "\" style=\"display:none; visibility:hidden\">");
            sbNavigationLinks.append(EncodingUtility.htmlencode(label));
            sbNavigationLinks.append("</span>");
            sbNavigationLinks.append("</td></tr>");
        }
        return sbNavigationLinks;
    }

    public static void writeReportBody(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) throws CognosViewerException {
        String sResponseFormat = actionResponse.getFormFieldAsString("cv.responseFormat");
        boolean bWidgetOutput = "iWidget".equals(sResponseFormat);
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        sbOutput.append("<tr id=\"mainViewerTR" + sNamespace + "\">");
        if (!bWidgetOutput) {
            sbOutput.append("<td class=\"mainViewerTD\">");
        } else {
            sbOutput.append("<td oncontextmenu=\"gVWEvent('" + sNamespace + "', event, 'onContextMenu');\" width=\"100%\" style=\"vertical-align: top;\">");
        }
        ReportBodyGenerator.writeReportBodyDivs(sbOutput, actionResponse);
        sbOutput.append("</td></tr>");
    }

    public static void writeReportBodyDivs(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) throws CognosViewerException {
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        String httpUserAgent = actionResponse.getEnvironmentVariable("HTTP_USER_AGENT");
        String sResponseFormat = actionResponse.getFormFieldAsString("cv.responseFormat");
        boolean bWidgetOutput = "iWidget".equals(sResponseFormat);
        boolean bFragmentOutput = "fragment".equals(sResponseFormat);
        boolean bStandAloneViewer = !bWidgetOutput && !bFragmentOutput && !"qs".equals(sResponseFormat) && !"rs".equals(sResponseFormat);
        String dirLTR = "";
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        boolean isRtl = Bidi.isLocaleRTL((String)sProductLocale);
        if (isRtl) {
            dirLTR = "dir=\"ltr\" ";
        }
        String classStr = "";
        if (bStandAloneViewer && (!"XML".equals(actionResponse.getContentFormat()) || BrowserUtility.isInternetExplorer(httpUserAgent))) {
            dirLTR = "";
            if (isRtl) {
                dirLTR = " ltr";
            }
            classStr = " class=\"RVContent" + dirLTR + "\"";
        } else if (bFragmentOutput) {
            classStr = " class=\"RVContentFragment\"";
        } else if ("rs".equals(sResponseFormat)) {
            classStr = " class=\"RVContent\"";
        }
        sbOutput.append("<div " + dirLTR + "id=\"RVContent" + sNamespace + "\" name=\"RVContent" + sNamespace + "\" style=\"");
        if ("activeReport".equals(sResponseFormat)) {
            sbOutput.append("visibility:hidden; position:absolute; width:0px; height:0px; ");
        } else if (classStr == "") {
            sbOutput.append("height:100%; ");
        }
        if (!bFragmentOutput) {
            sbOutput.append("position:relative; ");
        }
        sbOutput.append("\"");
        if (actionResponse.isAccessibleMode()) {
            String label = MessageManager.convert("IDS_A11Y_REPORT_DOCUMENT", sProductLocale);
            sbOutput.append(" role=\"document\" aria-label=\"" + EncodingUtility.encodeXMLAttribute(label) + "\"");
        }
        if (classStr != "") {
            sbOutput.append(classStr);
        }
        if (!"view".equals(actionResponse.getAction()) && !CognosViewerDispatcherHandlerState.getContentLocale(actionResponse).equals(CognosViewerDispatcherHandlerState.getProductLocale(actionResponse))) {
            sbOutput.append(" lang=\"").append(EncodingUtility.htmlencode(CognosViewerDispatcherHandlerState.getContentLocale(actionResponse))).append("\"");
        }
        sbOutput.append(">");
        String sInnerDivClass = "";
        if (bStandAloneViewer || "rs".equals(sResponseFormat) || "qs".equals(sResponseFormat)) {
            sInnerDivClass = "RVReport";
        } else if (bFragmentOutput) {
            sInnerDivClass = "RVReportFragment";
        }
        sbOutput.append("<div id=\"CVReport" + sNamespace + "\" class=\"" + sInnerDivClass + "\" style=\"");
        String contentFormat = actionResponse.getContentFormat();
        String bKeepWindowOpen = actionResponse.getFormFieldAsString("cv.keepWindowOpen");
        if (!("view".equals(actionResponse.getAction()) || "noOp".equals(actionResponse.getAction()) || !bStandAloneViewer || "PDF".equals(contentFormat) && !BrowserUtility.isInternetExplorer(httpUserAgent) || ReportBodyGenerator.isExcelFormat(contentFormat) && !BrowserUtility.isInternetExplorer(httpUserAgent) || "true".equals(bKeepWindowOpen))) {
            sbOutput.append("display: none;");
        }
        if ("view".equals(actionResponse.getAction()) && actionResponse.getContentFormat().indexOf("HTML") != -1 && bStandAloneViewer && BrowserUtility.isInternetExplorer(httpUserAgent)) {
            sbOutput.append(" overflow: hidden; ");
        }
        sbOutput.append("\"");
        boolean fragmentOutput = "fragment".equals(actionResponse.getFormFieldAsString("cv.responseFormat"));
        if (!fragmentOutput && !actionResponse.isBUX()) {
            sbOutput.append(" role=\"main\"");
        }
        sbOutput.append(">");
        ReportBodyGenerator.render(sbOutput, actionResponse);
        sbOutput.append("</div>");
        sbOutput.append("</div>");
    }

    public static void writeScriptOpeningTag(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        boolean fragmentOutput = "fragment".equals(actionResponse.getFormFieldAsString("cv.responseFormat"));
        ReportBodyGenerator.writeScriptOpeningTag(sbOutput, !fragmentOutput);
    }

    public static void writeScriptOpeningTag(StringBuilder sbOutput, boolean bUseCDATA) {
        sbOutput.append("<script language=\"javascript\">\n");
        if (bUseCDATA) {
            sbOutput.append("//<![CDATA[\n");
        }
    }

    public static void writeScriptClosingTag(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        boolean fragmentOutput = "fragment".equals(actionResponse.getFormFieldAsString("cv.responseFormat"));
        ReportBodyGenerator.writeScriptClosingTag(sbOutput, !fragmentOutput);
    }

    public static void writeScriptClosingTag(StringBuilder sbOutput, boolean bUseCDATA) {
        if (bUseCDATA) {
            sbOutput.append("\n//]]>");
        }
        sbOutput.append("\n</script>\n");
    }

    public static StringBuffer generateStateParam(ICognosViewerActionResponse actionResponse) {
        StringBuffer sbState = new StringBuffer("<state>");
        CAMPassport passport = actionResponse.getCAMPassport();
        BIBusEnvelope busResponse = actionResponse.getBusEnvelope();
        Element soapBody = busResponse.getBody();
        if (actionResponse.getStatus() != null && soapBody != null) {
            Element asynchRequestNode = (Element)soapBody.selectSingleNode("./*/*[local-name()='result']/*[local-name()='primaryRequest']");
            String sConversation = "";
            if (asynchRequestNode != null) {
                sConversation = asynchRequestNode.asXML();
                sbState.append("<ui.conversation>" + Protect.cafaction("sign_wrap_setpassportid_" + passport.getId(), XTSExt.web64encode((String)sConversation, (boolean)true)) + "</ui.conversation>");
            } else {
                sbState.append("<ui.conversation></ui.conversation>");
            }
        } else {
            sbState.append("<ui.conversation></ui.conversation>");
        }
        Element trackingNode = busResponse.getTracking();
        if (trackingNode != null && !(actionResponse instanceof CMServerResponse)) {
            Element conversationContextNode = trackingNode.element(BIBusEnvelope.BUS_CONVERSATION_CONTEXT);
            String sTracking = "";
            if (conversationContextNode != null) {
                sTracking = conversationContextNode.asXML();
                sbState.append("<m_tracking>" + Protect.cafaction("sign_wrap_setpassportid_" + passport.getId(), XTSExt.web64encode((String)sTracking, (boolean)true)) + "</m_tracking>");
            } else {
                sbState.append("<m_tracking></m_tracking>");
            }
        } else {
            sbState.append("<m_tracking></m_tracking>");
        }
        sbState.append("<executionPrompt>" + actionResponse.getFormFieldAsString("executionPrompt") + "</executionPrompt>");
        sbState.append("<ui.name>" + EncodingUtility.xmlencode(actionResponse.getFormFieldAsString("ui.name")) + "</ui.name>");
        sbState.append("<ui.object>" + EncodingUtility.xmlencode(actionResponse.getFormFieldAsString("ui.object")) + "</ui.object>");
        sbState.append("<ui.routingServerGroup>" + EncodingUtility.xmlencode(actionResponse.getFormFieldAsString("ui.routingServerGroup")) + "</ui.routingServerGroup>");
        String sAction = actionResponse.getBusEnvelope().getFormValue("ui.action");
        if (sAction == null) {
            sAction = actionResponse.getAction();
        }
        if ("noop".equals(sAction)) {
            sAction = actionResponse.getFormFieldAsString("ui.primaryAction");
        }
        if (!(actionResponse instanceof CMServerBlankResponse)) {
            if ("view".equals(sAction) || "output".equals(sAction) || "objectDefault".equals(sAction)) {
                sbState.append("<ui.action>output</ui.action>");
                sbState.append("<ui.format>" + actionResponse.getFormFieldAsString("ui.format") + "</ui.format>");
                sbState.append("<ui.reportVersion>" + EncodingUtility.xmlencode(actionResponse.getReportVersion()) + "</ui.reportVersion>");
            } else {
                if ("complete".equals(actionResponse.getStatus())) {
                    sbState.append("<ui.action>currentPage</ui.action>");
                } else {
                    sbState.append("<ui.action>run</ui.action>");
                }
                sbState.append("<run.outputFormat>" + actionResponse.getFormFieldAsString("run.outputFormat") + "</run.outputFormat>");
            }
        }
        sbState.append("</state>");
        return sbState;
    }

    public static StringBuffer generateDefaultStateParam(ICognosViewerState state) {
        StringBuffer sbState = new StringBuffer("<defaultState>");
        sbState.append("<cv.header>" + state.getFormFieldAsString("cv.header") + "</cv.header>");
        sbState.append("<cv.toolbar>" + state.getFormFieldAsString("cv.toolbar") + "</cv.toolbar>");
        sbState.append("</defaultState>");
        return sbState;
    }

    public static void writeOpeningFormWarpRequest(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput, String sNamespace) {
        String sGateway = EncodingUtility.htmlencode(actionResponse.getEnvironmentVariable("SCRIPT_NAME"));
        String sBrowser = BrowserUtility.getBrowser(actionResponse.getEnvironmentVariable("HTTP_USER_AGENT"));
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        String label = MessageManager.convert("IDS_A11Y_HIDDEN_MAIN_FORM", sProductLocale);
        sbOutput.append("<form aria-label=\"" + EncodingUtility.encodeXMLAttribute(label) + "\" action=\"" + sGateway + "\" name=\"formWarpRequest" + sNamespace + "\" id=\"formWarpRequest" + sNamespace + "\" method=\"post\" class=\"formWarpRequest\"");
        if ("safari".equals(sBrowser)) {
            sbOutput.append(" target=\"_self\"");
        }
        sbOutput.append(">");
    }

    public static void writeClosingFormWarpRequest(StringBuilder sbOutput) {
        sbOutput.append("</form>");
    }
}

