/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.view.CognosViewerJavaScriptObject;
import com.cognos.viewer.view.CognosViewerJavaScriptObjectForIWidgets;
import com.cognos.viewer.view.CvOutput;
import com.cognos.viewer.view.ICognosViewerOutput;
import com.cognos.viewer.view.ICognosViewerOutputResponse;
import com.cognos.viewer.view.PageOutputResponse;
import com.cognos.viewer.view.PowerPlayOutput;

public abstract class StringBufferedOutput
implements ICognosViewerOutput {
    @Override
    public void initialize(ICognosViewerState state) throws CognosViewerException {
    }

    @Override
    public ICognosViewerOutputResponse render(ICognosViewerActionResponse actionResponse) throws CognosViewerException {
        Object originalState = null;
        IPFLogger logger = null;
        IPFLogger.PerfData curPerfData = null;
        logger = actionResponse.getIPFLogger();
        if (logger != null) {
            curPerfData = logger.startPerf(10000, "Perf.VIEWER", "Entering " + this.getClass().getName() + " render", "ENTER");
        }
        StringBuilder sbOutput = new StringBuilder(4096);
        this.generateOutput(actionResponse, sbOutput);
        PageOutputResponse outputResponse = new PageOutputResponse(sbOutput);
        if (logger != null && curPerfData != null) {
            logger.stopPerf(curPerfData, "Leaving " + this.getClass().getName() + " render", "EXIT");
        }
        return outputResponse;
    }

    public abstract void generateOutput(ICognosViewerActionResponse var1, StringBuilder var2) throws CognosViewerException;

    public static CvOutput getOutputObject(ICognosViewerActionResponse actionResponse) throws CognosViewerException {
        String sObjectClass = actionResponse.getFormFieldAsString("ui.objectClass");
        CvOutput pageOutput = null;
        pageOutput = "powerPlayReport".equals(sObjectClass) || "powerPlay8Report".equals(sObjectClass) || "powerPlay8ReportView".equals(sObjectClass) ? new PowerPlayOutput() : new CvOutput();
        ((StringBufferedOutput)pageOutput).initialize(actionResponse);
        return pageOutput;
    }

    @Override
    public ICognosViewerOutputResponse handleFault(ICognosViewerActionResponse faultResponse) {
        return null;
    }

    protected CognosViewerJavaScriptObject getCognosViewerJavaScriptObject(ICognosViewerState state, StringBuilder sbOutput) {
        if (state.isBUX()) {
            return new CognosViewerJavaScriptObjectForIWidgets(state, sbOutput);
        }
        return new CognosViewerJavaScriptObject(state, sbOutput);
    }
}

