/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionLanguageArray;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.model.ICognosViewerState;
import com.cognos.viewer.model.OptionManager;
import com.cognos.viewer.model.marshallers.ParameterValuesMarshaller;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.view.HtmlOutput;
import com.cognos.xts.ext.XTSExt;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class StudioLaunchOutput
extends HtmlOutput {
    private static String COGNOS_LAUNCH_METHOD = "cognosLaunch";
    private static String COGNOS_LAUNCH_IN_WINDOW_METHOD = "cognosLaunchInWindow";

    @Override
    public void generateHTML(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        this.writeOpeningHTMLElement(sbOutput, actionResponse);
        this.writeHead(sbOutput, actionResponse);
        this.writeBody(sbOutput, actionResponse);
        sbOutput.append("</html>");
    }

    public void writeHead(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        sbOutput.append("<head>\n");
        this.addScriptLibraries(sbOutput, actionResponse);
        this.addLaunchMethod(sbOutput, actionResponse);
        sbOutput.append("</head>\n");
    }

    public void addScriptLibraries(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        String sWebContentRoot = actionResponse.getWebContentRoot();
        sbOutput.append("<script language=\"javascript\" src=\"" + sWebContentRoot + "/cr1/caf.js\"></script>\n");
        sbOutput.append("<script language=\"javascript\" src=\"" + sWebContentRoot + "/ps/../cognoslaunch.js\"></script>\n");
    }

    public void addLaunchMethod(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        sbOutput.append("<script language=\"JavaScript\">\n");
        sbOutput.append("function launchStudio()\n{\n");
        String sGateway = XTSExt.javascriptencode((String)actionResponse.getEnvironmentVariable("SCRIPT_NAME"));
        String sObjectPath = XTSExt.javascriptencode((String)actionResponse.getFormFieldAsString("ui.object"));
        OptionManager optionManager = actionResponse.getOptionManager();
        String sPromptValue = this.getPromptValueArgument(optionManager);
        String sLocaleValue = this.getLocaleValueArgument(optionManager);
        String sParameterValues = this.getParameterValues(actionResponse);
        String sTool = this.getTool(actionResponse);
        String sLaunchMethod = this.getLaunchMethod(actionResponse);
        sbOutput.append(sLaunchMethod + "(" + "'_blank', " + "'menubar=no,toolbar=no,status=yes,location=no,resizable=yes,width=650,height=480'," + "'ui.gateway', '" + sGateway + "'," + "'ui.tool', '" + sTool + "'," + "'ui.backURL', ''," + "'ui.object', '" + sObjectPath + "'," + "'ui.drillThroughTargetParameterValues', '" + sParameterValues + "'," + "'ui.action', 'edit'," + "'run.prompt', '" + sPromptValue + "'," + "'run.outputLocale', '" + sLocaleValue + "'" + ");\n");
        if (sLaunchMethod.equals(COGNOS_LAUNCH_IN_WINDOW_METHOD)) {
            if (actionResponse.getFormFieldAsString("dfemail").indexOf("1") >= 0) {
                sbOutput.append("history.go(-(history.length));\n");
            } else {
                sbOutput.append("if(typeof window.opener == \"object\")\n{\n");
                sbOutput.append("window.close();\n}\n");
                sbOutput.append("else\n{\n");
                sbOutput.append("history.go(-1);\n}\n");
            }
        }
        sbOutput.append("}\n</script>\n");
    }

    public void writeBody(StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
        sbOutput.append("<body style=\"background-color: #FFFFFF;\" onload=\"launchStudio();\"/>\n");
    }

    public String getPromptValueArgument(OptionManager optionManager) {
        RunOptionBoolean promptRunOption = (RunOptionBoolean)optionManager.getOption("prompt");
        String sPromptValue = promptRunOption != null ? Boolean.toString(promptRunOption.isValue()) : "";
        return sPromptValue;
    }

    public String getLocaleValueArgument(OptionManager optionManager) {
        RunOptionLanguageArray runOptionLanguageArray = (RunOptionLanguageArray)optionManager.getOption("outputLocale");
        String sLocaleValue = runOptionLanguageArray != null && runOptionLanguageArray.getValue().length == 1 ? runOptionLanguageArray.getValue()[0] : "";
        return sLocaleValue;
    }

    public String getParameterValues(ICognosViewerState state) {
        String sParameterValues = "";
        try {
            ParameterValue[] parameterValues = state.getParameterValueManager().toArray();
            if (parameterValues.length > 0) {
                Element rootNode = DocumentHelper.createElement((String)"root");
                ParameterValuesMarshaller parameterValuesMarshaller = new ParameterValuesMarshaller(parameterValues, DocumentHelper.createQName((String)"parameters", (Namespace)BIBusEnvelope.NS_BUS));
                parameterValuesMarshaller.marshall(rootNode);
                sParameterValues = XTSExt.javascriptencode((String)rootNode.element("parameters").asXML());
            }
        }
        catch (Exception exception) {
            IPFLogger.getInstance().error(exception.getMessage(), exception, StudioLaunchOutput.class.getName());
        }
        return sParameterValues;
    }

    public String getTool(ICognosViewerState state) {
        String sObjectClass = state.getFormFieldAsString("ui.objectClass");
        String sTool = "query".equals(sObjectClass) ? "QueryStudio" : ("analysis".equals(sObjectClass) ? "AnalysisStudio" : "ReportStudio");
        return sTool;
    }

    public String getLaunchMethod(ICognosViewerState state) {
        String sObjectClass = state.getFormFieldAsString("ui.objectClass");
        if ("query".equals(sObjectClass)) {
            return COGNOS_LAUNCH_METHOD;
        }
        return COGNOS_LAUNCH_IN_WINDOW_METHOD;
    }
}

