/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.model.DeliveryServiceResponse;
import com.cognos.viewer.model.MultipleServerResponse;
import com.cognos.viewer.utility.JSONObject;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.view.JSONOutput;
import com.ibm.cognos.i18n.util.Bidi;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;

public class SubscriptionManagerOutput
extends JSONOutput {
    @Override
    public void generateText(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        MultipleServerResponse multipleServerResponse = (MultipleServerResponse)actionResponse;
        CMServerResponse cmResponse = (CMServerResponse)multipleServerResponse.getSoapResponse(0);
        sbOutput.append("{ \"subscriptionInfo\" : {  ");
        StringBuilder sbSubscriptionInfo = new StringBuilder(512);
        JSONObject jsonObject = new JSONObject(sbSubscriptionInfo);
        boolean bInitialized = actionResponse.getFormFieldAsString("initialized").equalsIgnoreCase("true");
        if (!bInitialized) {
            this.initializeSubscriptionManager(jsonObject, cmResponse, multipleServerResponse);
        }
        if (!actionResponse.getFormFieldAsString("contextMenu").equalsIgnoreCase("true")) {
            DeliveryServiceResponse dsResponse = (DeliveryServiceResponse)multipleServerResponse.getSoapResponse(1);
            jsonObject.addMember("sQueryNotificationResponse", dsResponse.getStringValue("*[local-name()='queryNotificationResponse']/result/details/details/status"), false, true);
            jsonObject.addArrayMember("aWatchRules", false);
            String queryPosition = bInitialized ? "1" : "3";
            List ruleList = cmResponse.getNodes("*[local-name()='queryResponse']/returns/item[position()=" + queryPosition + "]/queryResult/item");
            ListIterator iterator = ruleList.listIterator();
            while (iterator.hasNext()) {
                Element searchPath;
                if (iterator.hasPrevious()) {
                    sbSubscriptionInfo.append(" , ");
                }
                Element reportDataServiceAgentDefinition = (Element)iterator.next();
                JSONObject ruleObject = new JSONObject(sbSubscriptionInfo);
                sbSubscriptionInfo.append(" { ");
                Element defaultName = (Element)reportDataServiceAgentDefinition.selectSingleNode("defaultName/value");
                if (defaultName != null) {
                    ruleObject.addMember("name", defaultName.getStringValue(), false, true);
                }
                if ((searchPath = (Element)reportDataServiceAgentDefinition.selectSingleNode("searchPath/value")) != null) {
                    ruleObject.addMember("searchPath", searchPath.getStringValue(), false, true);
                }
                sbSubscriptionInfo.append(" } ");
            }
            jsonObject.endArray();
        }
        sbOutput.append((CharSequence)sbSubscriptionInfo);
        sbOutput.append(" } }");
    }

    private void initializeSubscriptionManager(JSONObject jsonObject, CMServerResponse cmResponse, ICognosViewerActionResponse actionResponse) {
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        String sEmailAddress = cmResponse.getProperty("notificationEMail", 1);
        if (sEmailAddress.length() == 0) {
            sEmailAddress = cmResponse.getProperty("email", 1);
        }
        if (CognosViewerDispatcherHandlerState.isViewerBidiEnabled(actionResponse)) {
            sEmailAddress = Bidi.sttInjectUCCIntoStr((String)sEmailAddress, (String)"email");
        }
        jsonObject.addMember("sEmail", sEmailAddress, false, true);
        jsonObject.addMember("bAllowNotification", cmResponse.getProperty("allowNotification", 2).compareTo("true") == 0, false);
        jsonObject.addMember("bAllowSubscription", cmResponse.getProperty("allowSubscription", 2).compareTo("true") == 0, false);
        jsonObject.addMember("sAlertNewVersionConfirm", MessageManager.convert("RV_ALERT_NEW_VERSION_CONFIRM", sProductLocale, new Object[]{sEmailAddress}), false, true);
    }
}

