/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.caf.CAFLibrary;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.BrowserUtility;
import com.cognos.viewer.utility.DebugLogger;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.view.CognosViewerJSONToolbar;
import com.cognos.viewer.view.CognosViewerJavaScriptObject;
import com.cognos.viewer.view.PageOutput;
import com.cognos.viewer.view.ReportBodyGenerator;
import com.ibm.cognos.i18n.util.Bidi;

public class ViewOutput
extends PageOutput {
    @Override
    protected void writeHeadDetails(ICognosViewerActionResponse response, StringBuilder sbOutput) {
        this.writeCSSLinks(response, sbOutput);
    }

    @Override
    protected void customizeCognosViewerJavaScriptObject(CognosViewerJavaScriptObject cvObject, ICognosViewerActionResponse actionResponse) {
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        cvObject.addNavigationLinks(sProductLocale);
        cvObject.setCustomizableFeatures();
        cvObject.setViewerCapabities();
        cvObject.setBlackListedItems();
        if ("true".equals(actionResponse.getFormFieldAsString("cv.disableBrowserHotkeyPageNavigation"))) {
            cvObject.disableBrowserHotkeyPageNavigation();
        }
    }

    @Override
    protected void insertInlineScript(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        String sContentFormat = actionResponse.getContentFormat();
        String cognosViewerNamespace = actionResponse.getFormFieldAsString("cv.id");
        String cvObject = "window.oCV" + cognosViewerNamespace;
        sbOutput.append(cvObject + ".rvMainWnd = new CMainWnd(" + cvObject + ");\n");
        sbOutput.append(cvObject + ".rvMainWnd.init();\n");
        this.writeToolbarSpecifications(actionResponse, sbOutput);
        sbOutput.append("window.oCVSC" + cognosViewerNamespace + ".m_disableSecondarySelection = true;\n");
        sbOutput.append("window.oCVSC" + cognosViewerNamespace + ".attachObserver(" + cvObject + ".rvMainWnd);\n");
        if (!"fragment".equals(actionResponse.getResponseFormat()) && !"true".equals(actionResponse.getFormFieldAsString("bux"))) {
            sbOutput.append(cvObject + ".setUsePageRequest(true);");
        }
        sbOutput.append("function init" + cognosViewerNamespace + "()\n{\n");
        if (!ReportBodyGenerator.isExcelFormat(sContentFormat)) {
            if (!"false".equals(actionResponse.getFormFieldAsString("cv.toolbar")) || !"false".equals(actionResponse.getFormFieldAsString("cv.banner"))) {
                sbOutput.append(cvObject + ".rvMainWnd.draw();\n");
            }
            if (sContentFormat.indexOf("HTML") != -1 && BrowserUtility.isInternetExplorer(actionResponse.getEnvironmentVariable("HTTP_USER_AGENT"))) {
                sbOutput.append("resizeIFrame();\n");
                sbOutput.append("if (window.attachEvent) {\n");
                sbOutput.append("window.attachEvent(\"onresize\", resizeIFrame);\n");
                sbOutput.append("}\n");
            }
            if (ReportBodyGenerator.shouldRenderTabs(actionResponse) && !ReportBodyGenerator.shouldRenderIFrameUsingJavascript(actionResponse)) {
                sbOutput.append(cvObject + ".renderTabs();\n");
            }
        }
        sbOutput.append(cvObject + ".updateOutputForA11ySupport();");
        sbOutput.append("}\n");
    }

    protected void writeToolbarSpecifications(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        CognosViewerJSONToolbar.writeJavaScript(actionResponse, this.getToolbarSpec(), sbOutput);
        ReportBodyGenerator.writeToolbarObject(actionResponse, this.getToolbarSpec(), sbOutput);
        CognosViewerJSONToolbar.writeJavaScript(actionResponse, this.getBannerSpec(), sbOutput);
        ReportBodyGenerator.writeBannerObject(actionResponse, this.getBannerSpec(), sbOutput);
    }

    public void writeCSSLinks(ICognosViewerActionResponse actionResponse, StringBuilder sbCSSLinks) {
        String SKIN_ROOT = actionResponse.getWebContentRoot() + "/skins/";
        String sSkin = SKIN_ROOT + actionResponse.getUserPreference("skin");
        sbCSSLinks.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + sSkin + "/viewer/QSRVCommonUI.css\"/>\n");
        sbCSSLinks.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + sSkin + "/viewer/QSRVall.css\"/>\n");
        sbCSSLinks.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + sSkin + "/viewer/CRN.css\"/>\n");
    }

    @Override
    protected void writeJavaScriptIncludes(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        DebugLogger debugLogger;
        boolean isJsDebugEnabled;
        String sWebContentRoot = actionResponse.getWebContentRoot();
        String sLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        if (!"en".equals(sLocale)) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/res/viewer_en.js\"></script>\n");
        }
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/res/viewer_" + EncodingUtility.htmlencode(sLocale) + ".js\"></script>\n");
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/cr1/caf.js\"></script>\n");
        boolean bIsBidiEnabled = CognosViewerDispatcherHandlerState.isViewerBidiEnabled(actionResponse);
        if (bIsBidiEnabled) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/ccl/i18n/bidi/BidiUtils.js\"></script>\n");
        }
        boolean bl = isJsDebugEnabled = (debugLogger = actionResponse.getDebugLogger()) != null && debugLogger.isJsDebugEnabled();
        if (isJsDebugEnabled) {
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/notification/CObserver.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/util/CDictionary.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/util/CViewerHelper.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/util/XMLParser.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/objectModel/parameters.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/common/framework/ui/TabControl.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/ActionFactory.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cvui.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/cr1/drill.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCDataManager.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CSelectionDefaultStyles.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cvselection.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cv.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCognosViewerUtilities.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/ViewerA11YHelper.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCognosViewer.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/configuration/ViewerConfig.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/configuration/ViewerUIConfig.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/configuration/ViewerHttpRequestConfig.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/configuration/ViewerEventsConfig.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/state/ViewerState.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CDrillManager.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cvSelectionXml.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cvSubscriptionManager.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/GUtil.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CViewerToolbar.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/common.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/cvactions.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/GlossaryAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/utils/DrillContextMenuHelper.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/actions/AuthoredDrillAction.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCognosViewerDebugLogger.js\"></script>\n");
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/selectionContext.js\"></script>\n");
        } else {
            if (debugLogger != null && debugLogger.isJsonLoggingOn()) {
                sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/CCognosViewerDebugLogger.js\"></script>\n");
            }
            sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/rv/viewer.standalone.core.js\"></script>\n");
        }
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/mdsrv/lineage.js\"></script>\n");
        sbOutput.append("<script type=\"text/javascript\" src=\"" + sWebContentRoot + "/drill/CSelectionContextBuilder.js\"></script>\n");
        this.writeStandaloneRequestJavascriptIncludes(sWebContentRoot, isJsDebugEnabled, sbOutput);
        this.writeCustomJavascriptIncludes(sWebContentRoot, isJsDebugEnabled, sbOutput, actionResponse);
    }

    protected void writeCustomJavascriptIncludes(String sWebContentRoot, boolean isJsDebugEnabled, StringBuilder sbOutput, ICognosViewerActionResponse actionResponse) {
    }

    @Override
    public void writeBody(ICognosViewerActionResponse actionResponse, StringBuilder sbBodyOutput) throws CognosViewerException {
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        String dirAttribute = "";
        String dirClass = "";
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        if (Bidi.isLocaleRTL((String)sProductLocale)) {
            dirAttribute = " dir=\"rtl\"";
            dirClass = " rtl";
        }
        sbBodyOutput.append("<body" + dirAttribute + " role=\"document\" aria-label=\"" + EncodingUtility.htmlencode(MessageManager.convert("IMAGE_COGNOS_LOGO", sProductLocale)) + "\" onload=\"init" + sNamespace + "();\" onclick=\"if (typeof " + "window.oCV" + sNamespace + " != 'undefined'){" + "window.oCV" + sNamespace + ".rvMainWnd.hideOpenMenus();}\" class=\"viewer" + dirClass + "\">\n");
        this.writeBodyContents(actionResponse, sbBodyOutput);
        sbBodyOutput.append("</body>");
    }

    public void writeBodyContents(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        this.writeAccessibilityNavLinks(actionResponse, sbOutput);
        this.writeForm(actionResponse, sbOutput);
    }

    public void writeForm(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        String sNamespace = actionResponse.getFormFieldAsString("cv.id");
        ReportBodyGenerator.writeOpeningFormWarpRequest(actionResponse, sbOutput, sNamespace);
        this.writeHiddenInputs(actionResponse, sbOutput);
        sbOutput.append("<table class=\"mainViewerTable\" id=\"mainViewerTable" + sNamespace + "\" role=\"presentation\">");
        this.writeViewerHeader(actionResponse, sbOutput);
        ReportBodyGenerator.writeReportBody(sbOutput, actionResponse);
        if ("iWidget".equals(actionResponse.getFormFieldAsString("cv.responseFormat"))) {
            sbOutput.append(ReportBodyGenerator.writeNavigationLinks(actionResponse));
        }
        sbOutput.append("</table>");
        ReportBodyGenerator.writeClosingFormWarpRequest(sbOutput);
    }

    public void writeHiddenInputs(ICognosViewerActionResponse actionResponse, StringBuilder sbHiddenInputs) {
        String sLang;
        String sUIBookmark;
        String sSavedEnv;
        this.writeHiddenInput("ui.action", "view", sbHiddenInputs);
        this.writeHiddenInput("cv.id", actionResponse.getFormFieldAsString("cv.id"), sbHiddenInputs);
        this.writeHiddenInput("ui.format", actionResponse.getContentFormat(), sbHiddenInputs);
        this.writeHiddenInput("ui.object", actionResponse.getObjectPath().get_value(), sbHiddenInputs);
        this.writeHiddenInput("ui.name", actionResponse.getFormFieldAsString("ui.name"), sbHiddenInputs);
        String sBackURL = actionResponse.getFormFieldAsString("ui.backURL");
        if ("".equals(sBackURL)) {
            sBackURL = "javascript:window.close();";
        }
        this.writeHiddenInput("ui.backURL", sBackURL, sbHiddenInputs);
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        this.writeHiddenInput("ui.reportTitle", MessageManager.convert("REPORT_VIEWER_WINDOW_TITLE", sProductLocale) + " - " + actionResponse.getFormFieldAsString("ui.name"), sbHiddenInputs);
        String sContentLocale = CognosViewerDispatcherHandlerState.getContentLocale(actionResponse);
        this.writeHiddenInput("ui.contentLocale", sContentLocale, sbHiddenInputs);
        try {
            CMServerResponse cmResponse = (CMServerResponse)actionResponse;
            String sOutputLocale = "";
            if (cmResponse.getProperty("locale").length() > 0) {
                sOutputLocale = cmResponse.getProperty("locale");
            }
            this.writeHiddenInput("ui.outputLocale", sOutputLocale, sbHiddenInputs);
            String sBurstKey = "";
            if (cmResponse.getProperty("burstKey").length() > 0) {
                sBurstKey = cmResponse.getProperty("burstKey");
            }
            this.writeHiddenInput("ui.burstKey", sBurstKey, sbHiddenInputs);
            String sBurstID = "";
            if (cmResponse.getProperty("burstID").length() > 0) {
                sBurstID = cmResponse.getProperty("burstID");
            }
            this.writeHiddenInput("ui.burstID", sBurstID, sbHiddenInputs);
        }
        catch (Exception cmResponse) {
            // empty catch block
        }
        this.writeHiddenInput("reRunObj", actionResponse.getReRunObj(), sbHiddenInputs);
        this.writeHiddenInput("ui.reportVersion", actionResponse.getReportVersion(), sbHiddenInputs);
        String uiPostBack = actionResponse.getFormFieldAsString("ui.postBack");
        if (!"".equals(uiPostBack)) {
            this.writeHiddenInput("ui.postBack", uiPostBack, sbHiddenInputs);
        }
        if (!"".equals(sSavedEnv = actionResponse.getFormFieldAsString("savedEnv"))) {
            this.writeHiddenInput("savedEnv", sSavedEnv, sbHiddenInputs);
        }
        if (!"".equals(sUIBookmark = actionResponse.getFormFieldAsString("ui.bookmark"))) {
            this.writeHiddenInput("ui.bookmark", sUIBookmark, sbHiddenInputs);
        }
        if (!"".equals(sLang = actionResponse.getFormFieldAsString("lang"))) {
            this.writeHiddenInput("lang", sLang, sbHiddenInputs);
        }
        CAMPassport passport = actionResponse.getCAMPassport();
        String sCAFContextId = "";
        try {
            sCAFContextId = CAFLibrary.getContextId((String)"rv", (String)passport.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writeHiddenInput("ui.cafcontextid", sCAFContextId, sbHiddenInputs);
        String sModelPath = actionResponse.getFormFieldAsString("modelPath");
        this.writeHiddenInput("modelPath", sModelPath, sbHiddenInputs);
        String sPackageBase = actionResponse.getFormFieldAsString("packageBase");
        this.writeHiddenInput("packageBase", sPackageBase, sbHiddenInputs);
    }

    public void writeHiddenInput(String sName, String sValue, StringBuilder sbStringBuffer) {
        sbStringBuffer.append("<input type=\"hidden\" ");
        sbStringBuffer.append("name=\"" + sName + "\" ");
        sbStringBuffer.append("value=\"" + EncodingUtility.htmlencode(sValue) + "\"/>");
    }

    @Override
    protected void writeAccessibilityNavLinks(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) {
        this.writeJumpToReport(actionResponse, sbOutput);
    }
}

