/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.portal.skin.SkinCache;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.configuration.CognosViewerBlacklist;
import com.cognos.viewer.configuration.CognosViewerSystemParams;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.MessageManager;
import com.ibm.cognos.i18n.util.Bidi;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ViewerHeader {
    public static StringBuffer render(ICognosViewerActionResponse actionResponse, String sProductLocale) {
        StringBuffer sbViewerHeader = new StringBuffer("");
        if (!actionResponse.isBUX()) {
            sbViewerHeader.append(ViewerHeader.addHeaders(actionResponse, sProductLocale));
            sbViewerHeader.append(ViewerHeader.addToolbarPlaceholder(actionResponse));
        }
        return sbViewerHeader;
    }

    public static StringBuffer addHeaders(ICognosViewerActionResponse actionResponse, String sProductLocale) {
        StringBuffer sbHeader = new StringBuffer();
        String sCVId = actionResponse.getFormFieldAsString("cv.id");
        if (ViewerHeader.canRenderHeader(actionResponse)) {
            sbHeader.append("<tr>");
            sbHeader.append("<td class=\"topRow\" id=\"CVHeader" + sCVId + "\" valign=\"top\">");
            sbHeader.append("<div id=\"headerBack\">");
            sbHeader.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"width: 100%\" class=\"mainHeader1\" role=\"banner\">");
            sbHeader.append("<tr>");
            sbHeader.append("<td class=\"logoContainer\"><div class=\"logo\"></div></td>");
            sbHeader.append(ViewerHeader.addViewerTitle(actionResponse, sProductLocale));
            if (actionResponse.getDebugLogger() != null && actionResponse.getDebugLogger().isWriteToFileSystem()) {
                sbHeader.append("<td style=\"text-align: center; font-weight:bold; color: white;\">DEBUG ENABLED</td>");
            }
            sbHeader.append(ViewerHeader.addBannerToolbarPlaceholder(actionResponse));
            sbHeader.append("<td id=\"ibmLogo\"></td>");
            sbHeader.append("</tr></table>");
            sbHeader.append("<div class=\"headerBannerLip\"></div>");
            sbHeader.append("</div></td></tr>");
        }
        return sbHeader;
    }

    private static boolean canRenderHeader(ICognosViewerActionResponse actionResponse) {
        CognosViewerBlacklist cognosViewerBlacklist = actionResponse.getUIBlacklist();
        return !"false".equals(actionResponse.getFormFieldAsString("cv.header")) && !"fragment".equals(actionResponse.getFormFieldAsString("cv.responseFormat")) && !cognosViewerBlacklist.isBlacklisted("RV_HEADER");
    }

    public static StringBuffer addBannerToolbarPlaceholder(ICognosViewerActionResponse actionResponse) {
        StringBuffer sbToolbarPlaceholder = new StringBuffer();
        String cvId = actionResponse.getFormFieldAsString("cv.id");
        sbToolbarPlaceholder.append("<td class=\"mainHeader1Middle\" style=\"text-align: right;\" id=\"CVBanner" + cvId + "\"></td>");
        return sbToolbarPlaceholder;
    }

    public static StringBuffer addToolbarPlaceholder(ICognosViewerActionResponse actionResponse) {
        StringBuffer sbToolbarPlaceholder = new StringBuffer();
        String sWebRoot = actionResponse.getWebContentRoot();
        String cvId = actionResponse.getFormFieldAsString("cv.id");
        String sProductLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
        sbToolbarPlaceholder.append("<tr><td class=\"topRow\">");
        sbToolbarPlaceholder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"width: 100%\" role=\"presentation\"><tr>");
        if (!"false".equals(actionResponse.getFormFieldAsString("cv.toolbar"))) {
            sbToolbarPlaceholder.append("<td class=\"mainViewerHeader3\" style=\"width: 100%\"><img height=\"1\" alt=\"\" src=\"" + sWebRoot + "/ps/images/space.gif\"/></td>");
        }
        sbToolbarPlaceholder.append("<td id=\"CVToolbar" + cvId + "\" style=\"text-align: right;\" role=\"toolbar\" aria-label=\"" + MessageManager.convert("IDS_A11Y_TOOLBAR", sProductLocale) + "\"></td>");
        sbToolbarPlaceholder.append("</tr></table></td></tr>");
        return sbToolbarPlaceholder;
    }

    public static boolean canShowViewerTitle(CognosViewerBlacklist cognosViewerBlacklist) {
        return !cognosViewerBlacklist.isBlacklisted("CRN_HEADER") && !cognosViewerBlacklist.isBlacklisted("CRN_HEADER_TITLE") && !cognosViewerBlacklist.isBlacklisted("RV_HEADER_TITLE");
    }

    public static StringBuffer addViewerTitle(ICognosViewerActionResponse actionResponse, String sProductLocale) {
        StringBuffer sbViewerTitle = new StringBuffer();
        CognosViewerBlacklist cognosViewerBlacklist = actionResponse.getUIBlacklist();
        if (ViewerHeader.canShowViewerTitle(cognosViewerBlacklist)) {
            Element oemParamNode = CognosViewerSystemParams.getSystemParamNode("OEM");
            String sSkin = actionResponse.getUserPreference("skin");
            Pattern maliciousPattern = Pattern.compile("(document|evaluate)\\s*\\(", 10);
            Matcher scriptMatcher = maliciousPattern.matcher(sSkin);
            if (scriptMatcher.find()) {
                sSkin = "";
            }
            boolean customHeaderAdded = false;
            String customHeaderPropertyName = "/uiSkin/branding/header/value[@name='cognos.connection.header']";
            String camPassportCookie = actionResponse.getCookieValue("cam_passport");
            String skinCustomHeader = SkinCache.getSkinPropertyStatic((String)sSkin, (String)customHeaderPropertyName, (String)camPassportCookie);
            if (skinCustomHeader != null && skinCustomHeader.trim().length() > 0) {
                sbViewerTitle.append(ViewerHeader.addOEMLogo(actionResponse, skinCustomHeader, true, " - "));
                customHeaderAdded = true;
            }
            Element oemCustomHeader = null;
            if (!customHeaderAdded && oemParamNode != null && (oemCustomHeader = (Element)oemParamNode.selectSingleNode("customHeader/style[@styleFolderName = '" + sSkin + "']")) != null) {
                sbViewerTitle.append(ViewerHeader.addOEMLogo(actionResponse, oemCustomHeader));
                customHeaderAdded = true;
            }
            if (!customHeaderAdded) {
                sbViewerTitle.append("<td tabIndex=\"0\" class=\"headerTitle\" nowrap=\"nowrap\">");
                sbViewerTitle.append(MessageManager.convert("REPORT_VIEWER_WINDOW_TITLE", sProductLocale));
                String sReportName = actionResponse.getFormFieldAsString("ui.name");
                if (sReportName.length() > 0) {
                    sbViewerTitle.append(" - ");
                    if (CognosViewerDispatcherHandlerState.isViewerBidiEnabled(actionResponse)) {
                        String btd = CognosViewerDispatcherHandlerState.getViewerBaseTextDirection(actionResponse);
                        sReportName = Bidi.enforceBTD((String)sReportName, (String)btd, (String)sProductLocale);
                    }
                    sbViewerTitle.append(EncodingUtility.htmlencode(sReportName));
                }
                sbViewerTitle.append("</td>");
            }
        }
        return sbViewerTitle;
    }

    public static StringBuffer addOEMLogo(ICognosViewerActionResponse actionResponse, Element customHeader) {
        StringBuffer sbOEMLogo = new StringBuffer();
        List headerElements = customHeader.elements();
        int iNumberOfHeaderElements = headerElements.size();
        if (iNumberOfHeaderElements > 0) {
            for (int iIndex = 0; iIndex < iNumberOfHeaderElements; ++iIndex) {
                Element headerElement = (Element)headerElements.get(iIndex);
                if (headerElement == null) continue;
                sbOEMLogo.append(headerElement.asXML());
            }
        } else {
            sbOEMLogo.append(customHeader.asXML());
        }
        boolean isContextVisible = false;
        String contextDelimiter = null;
        Element parentElement = customHeader.getParent();
        Attribute showContextAttribute = parentElement.attribute("showContext");
        if (showContextAttribute != null && showContextAttribute.getStringValue().compareTo("true") == 0) {
            isContextVisible = true;
            Attribute contextDelimiterAttribute = parentElement.attribute("contextDelimiter");
            if (!"".equals(actionResponse.getFormFieldAsString("ui.name")) && contextDelimiterAttribute != null) {
                contextDelimiter = contextDelimiterAttribute.getStringValue();
            }
        }
        return ViewerHeader.addOEMLogo(actionResponse, sbOEMLogo.toString(), isContextVisible, contextDelimiter);
    }

    public static StringBuffer addOEMLogo(ICognosViewerActionResponse actionResponse, String customHeader, boolean isContextVisible, String contextDelimiter) {
        StringBuffer sbOEMLogo = new StringBuffer();
        sbOEMLogo.append("<td tabIndex=\"0\" nowrap=\"nowrap\" class=\"headerTitle\">");
        sbOEMLogo.append(customHeader);
        sbOEMLogo.append("</td>");
        if (isContextVisible) {
            sbOEMLogo.append("<td tabIndex=\"0\" class=\"headerTitle\" nowrap=\"nowrap\">");
            if (!"".equals(actionResponse.getFormFieldAsString("ui.name")) && contextDelimiter != null) {
                sbOEMLogo.append(contextDelimiter);
            }
            sbOEMLogo.append(EncodingUtility.htmlencode(actionResponse.getFormFieldAsString("ui.name")));
            sbOEMLogo.append("</td>");
        }
        return sbOEMLogo;
    }
}

