/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view;

import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.Protect;
import com.cognos.viewer.view.ICognosViewerOutputResponse;
import com.cognos.viewer.view.PageOutputResponse;
import com.cognos.viewer.view.StringBufferedOutput;
import com.cognos.xts.ext.XTSExt;
import java.io.IOException;
import org.dom4j.Element;

public class XmlOutput
extends StringBufferedOutput {
    @Override
    public void generateOutput(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        this.addResponseHeader(sbOutput);
        if (actionResponse.getFormFieldAsString("XMLOutput").length() > 0) {
            actionResponse.getDebugLogger().setGenerateJSONLogs(false);
            sbOutput.append(actionResponse.getFormFieldAsString("XMLOutput"));
        } else {
            this.generateXML(actionResponse, sbOutput);
        }
    }

    protected void addResponseHeader(StringBuilder sbOutput) {
        sbOutput.append("Content-Type: application/xml; charset=utf-8");
        sbOutput.append("\r\n\r\n");
    }

    public void generateXML(ICognosViewerActionResponse actionResponse, StringBuilder sbOutput) throws CognosViewerException {
        Object soapResponse = actionResponse.getObject("SOAPResponse");
        if (soapResponse != null) {
            try {
                sbOutput.append(((BIBusEnvelope)soapResponse).getAsString(SOAPEnvelope.STANDARD_FORMAT));
            }
            catch (IOException e) {
                throw new CognosViewerException(null, null, e);
            }
        } else {
            sbOutput.append("<response>");
            if (actionResponse.getObject("XMLOutput") != null) {
                sbOutput.append((String)actionResponse.getObject("XMLOutput"));
            } else if (actionResponse.getObject("XMLOutput_reportSpec") != null) {
                if (!actionResponse.getCapabilities().hasCapability("canUseReportStudio") && actionResponse.isBUX()) {
                    CAMPassport passport = actionResponse.getCAMPassport();
                    sbOutput.append(Protect.cafaction("sign_wrap_setpassportid_" + passport.getId(), XTSExt.web64encode((String)((String)actionResponse.getObject("XMLOutput_reportSpec")), (boolean)true)));
                } else {
                    sbOutput.append(EncodingUtility.xmlencode((String)actionResponse.getObject("XMLOutput_reportSpec")));
                }
            }
            sbOutput.append("</response>");
        }
    }

    @Override
    public ICognosViewerOutputResponse handleFault(ICognosViewerActionResponse faultResponse) {
        StringBuilder sbOutput = new StringBuilder();
        this.addResponseHeader(sbOutput);
        sbOutput.append("<response>");
        sbOutput.append("<fault>");
        BIBusEnvelope faultEnvelope = faultResponse.getBusEnvelope();
        Element camHeader = faultEnvelope.getCAM();
        if (camHeader != null) {
            sbOutput.append(camHeader.asXML());
        }
        Element fault = faultEnvelope.getFault();
        sbOutput.append(fault.asXML());
        sbOutput.append("</fault>");
        sbOutput.append("</response>");
        return new PageOutputResponse(sbOutput);
    }
}

