/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.viewer.view.helper;

import com.cognos.viewer.action.ICognosViewerActionResponse;
import com.cognos.viewer.controller.CognosViewerDispatcherHandler;
import com.cognos.viewer.controller.CognosViewerException;
import com.cognos.viewer.model.CMServerBlankResponse;
import com.cognos.viewer.model.CMServerResponse;
import com.cognos.viewer.model.CognosViewerDispatcherHandlerState;
import com.cognos.viewer.render.Renderer;
import com.cognos.viewer.render.RendererFactory;
import com.cognos.viewer.render.RendererHelper;
import com.cognos.viewer.utility.EncodingUtility;
import com.cognos.viewer.utility.IPFLogger;
import com.cognos.viewer.utility.MessageManager;
import com.cognos.viewer.view.ReportBodyGenerator;
import com.cognos.xts.ext.XTSExt;

public class DownloadObject {
    public static String generateDownloadUrl(ICognosViewerActionResponse actionResponse) {
        return DownloadObject.generateDownloadUrl(actionResponse, RendererFactory.getRenderer());
    }

    public static boolean isCMResponse(ICognosViewerActionResponse actionResponse) {
        return actionResponse instanceof CMServerResponse || actionResponse instanceof CMServerBlankResponse;
    }

    public static String getSearchPath(ICognosViewerActionResponse actionResponse) {
        if (DownloadObject.isCMResponse(actionResponse)) {
            return actionResponse.getFormFieldAsString("ui.object");
        }
        return DownloadObject.getDetailOutput(actionResponse);
    }

    public static String generateDownloadUrl(ICognosViewerActionResponse actionResponse, Renderer renderer) {
        StringBuilder url = new StringBuilder();
        String sOutputLocation = CognosViewerDispatcherHandler.getOutputLocation(actionResponse);
        if ("http://developer.cognos.com/ceba/constants/temporaryObjectLocationEnum#serverFileSystem".equals(sOutputLocation)) {
            String searchPath = DownloadObject.getSearchPath(actionResponse);
            if ((searchPath = RendererHelper.appendDownloadParameter(searchPath)).startsWith("?")) {
                searchPath = searchPath.substring(1);
            }
            url.append(XTSExt.javascriptencode((String)searchPath));
        } else {
            String searchPath = "";
            boolean cmResponse = actionResponse instanceof CMServerResponse || actionResponse instanceof CMServerBlankResponse;
            searchPath = cmResponse ? actionResponse.getFormFieldAsString("ui.object") : DownloadObject.getDetailOutput(actionResponse);
            if (CognosViewerDispatcherHandler.useRestAPI() && cmResponse) {
                url.append(XTSExt.javascriptencode((String)searchPath));
                RendererHelper.appendDownloadParameter(url);
            } else {
                if (!cmResponse) {
                    searchPath = ReportBodyGenerator.extractSearchPathFromURLQueryString(searchPath);
                }
                url.append("b_action=xts.run&m=portal/download.xts");
                String fileName = actionResponse.getFormFieldAsString("ui.name");
                if (CognosViewerDispatcherHandlerState.isIROTReport(actionResponse)) {
                    if (!cmResponse) {
                        searchPath = XTSExt.web64decode((String)searchPath, (boolean)true);
                    }
                    url.append("&webcompress=true");
                    url.append("&m_obj=" + XTSExt.javascriptencode((String)XTSExt.validator((String)"prepare", (String)"m_obj", (String)XTSExt.web64encode((String)searchPath, (boolean)true))));
                    if ("".equals(fileName)) {
                        String productLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
                        fileName = MessageManager.convert("RV_NEW", productLocale);
                    }
                    url.append("&m_name=" + XTSExt.javascriptencode((String)XTSExt.validator((String)"prepare", (String)"m_name", (String)XTSExt.web64encode((String)fileName, (boolean)true))));
                } else {
                    url.append("&m_obj=" + XTSExt.javascriptencode((String)EncodingUtility.urlencode(searchPath)));
                    if ("".equals(fileName)) {
                        String productLocale = CognosViewerDispatcherHandlerState.getProductLocale(actionResponse);
                        fileName = MessageManager.convert("RV_NEW", productLocale);
                    }
                    url.append("&m_name=" + XTSExt.javascriptencode((String)EncodingUtility.urlencode(fileName)));
                }
                url.append("&format=" + actionResponse.getContentFormat());
            }
        }
        return url.toString();
    }

    public static String getDetailOutput(ICognosViewerActionResponse actionResponse) {
        String searchPath = "";
        try {
            if (actionResponse.getStatus().equals("complete")) {
                StringBuilder sbDetailOutput = actionResponse.getDetailOutput();
                searchPath = sbDetailOutput.toString();
            }
        }
        catch (CognosViewerException exception) {
            IPFLogger.getInstance().error(exception.getLocalizedMessage(), DownloadObject.class.getName());
        }
        return searchPath;
    }
}

