/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.renderingservice.util;

import com.ibm.vipr.renderingservice.api.IRSCatEncoding;
import com.ibm.vipr.renderingservice.api.IRSCatEncodingEntry;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.api.IRSDataContext;
import com.ibm.vipr.renderingservice.api.IRSEncoding;
import com.ibm.vipr.renderingservice.data.IRSCatDataItem;
import com.ibm.vipr.renderingservice.data.IRSDataNode;
import com.ibm.vipr.renderingservice.data.IRSDecorated;
import com.ibm.vipr.renderingservice.data.IRSItem;
import com.ibm.vipr.renderingservice.data.IRSItemClassSet;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.IRSSubCaptioned;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.renderingservice.property.IRSCatPaletteProperty;
import com.ibm.vipr.renderingservice.util.CatEncodingEntry;
import com.ibm.vipr.renderingservice.util.Encoding;
import com.ibm.vipr.renderingservice.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class CatEncoding
extends Encoding
implements IRSCatEncoding {
    private final List<IRSCatEncodingEntry> entries;

    public CatEncoding(String _slot, String _channel, String _caption, String _subCaption, IRSDataNode _ref, List<IRSCatEncodingEntry> _entries) {
        super(IRSEncoding.EncodingType.Cat, _slot, _channel, _caption, _subCaption, _ref);
        this.entries = Collections.unmodifiableList(_entries);
    }

    public static CatEncoding fromDataSlot(IRSSlot _slot, String _channel, int _dataItemIndex, RSFormatKind _formatKind, IRSCatPaletteProperty _palette, IRSDataContext _dataContext, String _shape, Integer _level) {
        int itemClassCount;
        Boolean hasSelection;
        IRSCatDataItem dataItem = _slot.getDataItems().get(_dataItemIndex).asCat();
        HashSet<String> itemKeys = null;
        if (_level != null) {
            itemKeys = new HashSet<String>();
        }
        boolean ignoreSelection = false;
        boolean selectedByDefault = true;
        if (_dataContext != null && (hasSelection = (Boolean)dataItem.getDataSet(_dataContext).getDecoration("hasSelection", null)) != null) {
            selectedByDefault = hasSelection == false;
            ignoreSelection = selectedByDefault;
        }
        ArrayList<IRSCatEncodingEntry> entries = new ArrayList<IRSCatEncodingEntry>();
        for (IRSTuple tuple : dataItem.getTuples()) {
            IRSColor color = null;
            int itemLevel = -1;
            IRSDecorated ref = tuple;
            if (_level != null && tuple != null) {
                itemClassCount = tuple.getItemClassCount();
                if (itemClassCount < 1) continue;
                itemLevel = _level;
                itemLevel = NumberUtil.clamp(0, itemLevel < 0 ? itemLevel + itemClassCount : itemLevel, itemClassCount - 1);
                ref = tuple.getItem(itemLevel);
                if (itemKeys.contains(((IRSItem)ref).getUniqueName())) {
                    ref = null;
                } else {
                    itemKeys.add(((IRSItem)ref).getUniqueName());
                }
            }
            if (ref == null) continue;
            if (_palette != null) {
                color = itemLevel < 0 ? _palette.getColor(tuple) : _palette.getColor(tuple, itemLevel);
            }
            entries.add(new CatEncodingEntry(ref.getCaption(_formatKind), color, _shape, ignoreSelection || (Boolean)((IRSDecorated)ref).getDecoration("selected", selectedByDefault) != false, (Boolean)((IRSDecorated)ref).getDecoration("highlighted", false), ref));
        }
        IRSSubCaptioned ref = dataItem;
        if (_level != null) {
            IRSItemClassSet itemClassSet = dataItem.getItemClassSet(0);
            itemClassCount = itemClassSet.getItemClassCount();
            int itemClassLevel = _level;
            itemClassLevel = NumberUtil.clamp(0, itemClassLevel < 0 ? itemClassLevel + itemClassCount : itemClassLevel, itemClassCount - 1);
            ref = itemClassSet.getItemClass(itemClassLevel);
        }
        return new CatEncoding(_slot.getName(), _channel, ref.getCaption(_formatKind), ref.getSubCaption(_formatKind), ref, entries);
    }

    public static CatEncoding fromDataSlot(IRSSlot _slot, String _channel, int _dataItemIndex, RSFormatKind _formatKind, IRSCatPaletteProperty _palette, IRSDataContext _dataContext, String _shape) {
        return CatEncoding.fromDataSlot(_slot, _channel, _dataItemIndex, _formatKind, _palette, _dataContext, _shape, null);
    }

    @Override
    public List<IRSCatEncodingEntry> getEntries() {
        return this.entries;
    }
}

