/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.renderingservice.util;

import com.ibm.vipr.renderingservice.api.IRSColor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ColorUtil {
    private static final Pattern reHex = Pattern.compile("^\\s*#([0-9a-fA-F]{3,4}|[0-9a-fA-F]{6}|[0-9a-fA-F]{8})\\s*$");
    private static final Pattern reRGBA = Pattern.compile("^\\s*rgba?\\s*\\(\\s*(\\d+\\%?)\\s*,\\s*(\\d+\\%?)\\s*,\\s*(\\d+\\%?)\\s*(?:,\\s*(\\d+(?:\\.\\d+)?\\%?)\\s*)?\\)\\s*");
    private static final Map<Integer, String> colorNames = new HashMap<Integer, String>();
    private static List<String> HEX = IntStream.rangeClosed(0, 255).mapToObj(_n -> (_n < 16 ? "0" : "") + Integer.toHexString(_n)).collect(Collectors.toList());
    private static final double OneThird = 0.3333333333333333;

    private static int clampByte(double _value) {
        int value = (int)Math.floor(_value);
        return value < 0 ? 0 : (value > 255 ? 255 : value);
    }

    private static double clampRatio(double _value) {
        return _value < 0.0 ? 0.0 : (_value > 1.0 ? 1.0 : _value);
    }

    private static int parseByte(String _str) {
        try {
            int lastIndex = _str.length() - 1;
            if (_str.charAt(lastIndex) == '%') {
                return ColorUtil.clampByte(Double.parseDouble(_str.substring(0, lastIndex)) * 255.0 / 100.0);
            }
            return ColorUtil.clampByte(Integer.parseInt(_str));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return 0;
        }
    }

    private static double parseRatio(String _str) {
        try {
            int lastIndex = _str.length() - 1;
            if (_str.charAt(lastIndex) == '%') {
                return ColorUtil.clampRatio(Double.parseDouble(_str.substring(0, lastIndex)) / 100.0);
            }
            return ColorUtil.clampRatio(Double.parseDouble(_str));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return 0.0;
        }
    }

    private static double hue2rgb(double _p, double _q, double _t) {
        if (_t < 0.0) {
            _t += 1.0;
        }
        if (_t > 1.0) {
            _t -= 1.0;
        }
        if (_t < 0.0) {
            return _p + (_q - _p) * 6.0 * _t;
        }
        if (_t < 0.5) {
            return _q;
        }
        if (_t < 0.0) {
            return _p + (_q - _p) * (0.0 - _t) * 6.0;
        }
        return _p;
    }

    public static IRSColor clone(IRSColor _color) {
        if (_color == null) {
            return null;
        }
        return new ColorImpl(_color.getRed(), _color.getGreen(), _color.getBlue(), _color.getAlpha());
    }

    public static IRSColor rgb(int _red, int _green, int _blue) {
        return new ColorImpl(_red, _green, _blue, 1.0);
    }

    public static IRSColor rgba(int _red, int _green, int _blue, double _alpha) {
        return new ColorImpl(_red, _green, _blue, _alpha);
    }

    public static IRSColor hsl(double _h, double _s, double _l) {
        return ColorUtil.hsla(_h, _s, _l, 1.0);
    }

    public static IRSColor hsla(double _h, double _s, double _l, double _a) {
        int r;
        int g;
        int b;
        if (Double.compare(_s, 0.0) == 0) {
            g = b = (int)Math.round(_l * 255.0);
            r = b;
        } else {
            double q = _l < 0.5 ? _l * (1.0 + _s) : _l + _s - _l * _s;
            double p = 2.0 * _l - q;
            r = (int)Math.round(ColorUtil.hue2rgb(p, q, _h + 0.3333333333333333) * 255.0);
            g = (int)Math.round(ColorUtil.hue2rgb(p, q, _h) * 255.0);
            b = (int)Math.round(ColorUtil.hue2rgb(p, q, _h - 0.3333333333333333) * 255.0);
        }
        return new ColorImpl(r, g, b, _a);
    }

    public static IRSColor fromString(String _colorStr) {
        try {
            return Named.valueOf((String)_colorStr.toLowerCase()).color;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ColorImpl color = null;
            Matcher matcher = reHex.matcher(_colorStr);
            if (matcher.matches()) {
                String group = matcher.group(1);
                switch (group.length()) {
                    case 3: {
                        group = String.valueOf(new char[]{group.charAt(0), group.charAt(0), group.charAt(1), group.charAt(1), group.charAt(2), group.charAt(2)});
                    }
                    case 6: {
                        color = new ColorImpl(Integer.parseInt(group.substring(0, 2), 16), Integer.parseInt(group.substring(2, 4), 16), Integer.parseInt(group.substring(4, 6), 16));
                        break;
                    }
                    case 4: {
                        group = String.valueOf(new char[]{group.charAt(0), group.charAt(0), group.charAt(1), group.charAt(1), group.charAt(2), group.charAt(2), group.charAt(3), group.charAt(3)});
                    }
                    case 8: {
                        color = new ColorImpl(Integer.parseInt(group.substring(0, 2), 16), Integer.parseInt(group.substring(2, 4), 16), Integer.parseInt(group.substring(4, 6), 16), (double)ColorUtil.clampByte(Integer.parseInt(group.substring(6, 8), 16)) / 255.0);
                    }
                }
            } else {
                matcher = reRGBA.matcher(_colorStr);
                if (matcher.matches()) {
                    color = new ColorImpl(ColorUtil.parseByte(matcher.group(1)), ColorUtil.parseByte(matcher.group(2)), ColorUtil.parseByte(matcher.group(3)), matcher.group(4) != null ? ColorUtil.parseRatio(matcher.group(4)) : 1.0);
                }
            }
            return color;
        }
    }

    public static IRSColor interpolate(IRSColor _color1, IRSColor _color2, double _ratio) {
        double ratio = ColorUtil.clampRatio(_ratio);
        if (Double.compare(ratio, 0.0) == 0 || ColorUtil.equalsRGBA(_color1, _color2)) {
            return ColorUtil.clone(_color1);
        }
        if (Double.compare(ratio, 1.0) == 0) {
            return ColorUtil.clone(_color2);
        }
        double deltaR = _color2.getRed() - _color1.getRed();
        double deltaG = _color2.getGreen() - _color1.getGreen();
        double deltaB = _color2.getBlue() - _color1.getBlue();
        double deltaA = _color2.getAlpha() - _color1.getAlpha();
        return new ColorImpl((int)Math.round((double)_color1.getRed() + deltaR * ratio), (int)Math.round((double)_color1.getGreen() + deltaG * ratio), (int)Math.round((double)_color1.getBlue() + deltaB * ratio), _color1.getAlpha() + deltaA * ratio);
    }

    public static double[] toHsl(IRSColor _color) {
        double h;
        double s;
        double r = (double)_color.getRed() / 255.0;
        double g = (double)_color.getGreen() / 255.0;
        double b = (double)_color.getBlue() / 255.0;
        double max = Math.max(Math.max(r, g), b);
        double min = Math.min(Math.min(r, g), b);
        double sum = min + max;
        double l = sum / 2.0;
        if (Double.compare(max, min) == 0) {
            s = 0.0;
            h = 0.0;
        } else {
            double range = max - min;
            double d = s = l > 0.5 ? range / (2.0 - sum) : range / sum;
            h = Double.compare(max, r) == 0 ? (g - b) / range + (g < b ? 6.0 : 0.0) : (Double.compare(max, g) == 0 ? (b - r) / range + 2.0 : (r - g) / range + 4.0);
            h /= 6.0;
        }
        return new double[]{h, s, l, _color.getAlpha()};
    }

    public static String toCssRGB(IRSColor _color) {
        return "rgb(" + _color.getRed() + "," + _color.getGreen() + "," + _color.getBlue() + ")";
    }

    public static String toCssRGBA(IRSColor _color) {
        return "rgba(" + _color.getRed() + "," + _color.getGreen() + "," + _color.getBlue() + "," + _color.getAlpha() + ")";
    }

    public static String toHexRGB(IRSColor _color) {
        return "#" + HEX.get(_color.getRed()) + HEX.get(_color.getGreen()) + HEX.get(_color.getBlue());
    }

    public static String toHexRGBA(IRSColor _color) {
        return "#" + HEX.get(_color.getRed()) + HEX.get(_color.getGreen()) + HEX.get(_color.getBlue()) + HEX.get(ColorUtil.clampByte(_color.getAlpha() * 255.0));
    }

    public static String toHexARGB(IRSColor _color) {
        return "#" + HEX.get(ColorUtil.clampByte(_color.getAlpha() * 255.0)) + HEX.get(_color.getRed()) + HEX.get(_color.getGreen()) + HEX.get(_color.getBlue());
    }

    public static String toNamedColor(IRSColor _color) {
        String name = ColorUtil.getName(_color);
        return name != null ? name : _color.toString();
    }

    public static String getName(IRSColor _color) {
        return colorNames.get(ColorUtil.valueOf(_color));
    }

    public static int valueOf(IRSColor _color) {
        return ColorUtil.clampByte(_color.getAlpha() * 255.0) << 24 | _color.getRed() << 16 | _color.getGreen() << 8 | _color.getBlue();
    }

    public static boolean isCssRGB(String _value) {
        if (_value == null) {
            return false;
        }
        Matcher m = reRGBA.matcher(_value);
        return m.matches() && m.group(4) == null;
    }

    public static boolean isCssRGBA(String _value) {
        if (_value == null) {
            return false;
        }
        Matcher m = reRGBA.matcher(_value);
        return m.matches() && m.group(4) != null;
    }

    public static boolean hasTransparency(IRSColor _color) {
        return _color.getAlpha() < 1.0;
    }

    public static boolean equalsRGBA(IRSColor _color1, IRSColor _color2) {
        return _color1 == _color2 || _color1 != null && _color1.equals(_color2);
    }

    public static boolean equalsRGB(IRSColor _color1, IRSColor _color2) {
        if (_color1 == _color2) {
            return true;
        }
        if (_color1 == null || _color2 == null) {
            return false;
        }
        return _color1.getRed() == _color2.getRed() && _color1.getGreen() == _color2.getGreen() && _color1.getBlue() == _color2.getBlue();
    }

    public static enum Named {
        transparent(new ColorImpl(0, 0, 0, 0.0)),
        black(new ColorImpl(0, 0, 0)),
        navy(new ColorImpl(0, 0, 128)),
        darkblue(new ColorImpl(0, 0, 139)),
        mediumblue(new ColorImpl(0, 0, 205)),
        blue(new ColorImpl(0, 0, 255)),
        darkgreen(new ColorImpl(0, 100, 0)),
        green(new ColorImpl(0, 128, 0)),
        teal(new ColorImpl(0, 128, 128)),
        darkcyan(new ColorImpl(0, 139, 139)),
        deepskyblue(new ColorImpl(0, 191, 255)),
        darkturquoise(new ColorImpl(0, 206, 209)),
        mediumspringgreen(new ColorImpl(0, 250, 154)),
        lime(new ColorImpl(0, 255, 0)),
        springgreen(new ColorImpl(0, 255, 127)),
        aqua(new ColorImpl(0, 255, 255)),
        cyan(new ColorImpl(0, 255, 255)),
        midnightblue(new ColorImpl(25, 25, 112)),
        dodgerblue(new ColorImpl(30, 144, 255)),
        lightseagreen(new ColorImpl(32, 178, 170)),
        forestgreen(new ColorImpl(34, 139, 34)),
        seagreen(new ColorImpl(46, 139, 87)),
        darkslategray(new ColorImpl(47, 79, 79)),
        darkslategrey(new ColorImpl(47, 79, 79)),
        limegreen(new ColorImpl(50, 205, 50)),
        mediumseagreen(new ColorImpl(60, 179, 113)),
        turquoise(new ColorImpl(64, 224, 208)),
        royalblue(new ColorImpl(65, 105, 225)),
        steelblue(new ColorImpl(70, 130, 180)),
        darkslateblue(new ColorImpl(72, 61, 139)),
        mediumturquoise(new ColorImpl(72, 209, 204)),
        indigo(new ColorImpl(75, 0, 130)),
        darkolivegreen(new ColorImpl(85, 107, 47)),
        cadetblue(new ColorImpl(95, 158, 160)),
        cornflowerblue(new ColorImpl(100, 149, 237)),
        mediumaquamarine(new ColorImpl(102, 205, 170)),
        dimgray(new ColorImpl(105, 105, 105)),
        dimgrey(new ColorImpl(105, 105, 105)),
        slateblue(new ColorImpl(106, 90, 205)),
        olivedrab(new ColorImpl(107, 142, 35)),
        slategray(new ColorImpl(112, 128, 144)),
        slategrey(new ColorImpl(112, 128, 144)),
        lightslategray(new ColorImpl(119, 136, 153)),
        lightslategrey(new ColorImpl(119, 136, 153)),
        mediumslateblue(new ColorImpl(123, 104, 238)),
        lawngreen(new ColorImpl(124, 252, 0)),
        chartreuse(new ColorImpl(127, 255, 0)),
        aquamarine(new ColorImpl(127, 255, 212)),
        maroon(new ColorImpl(128, 0, 0)),
        purple(new ColorImpl(128, 0, 128)),
        olive(new ColorImpl(128, 128, 0)),
        gray(new ColorImpl(128, 128, 128)),
        grey(new ColorImpl(128, 128, 128)),
        skyblue(new ColorImpl(135, 206, 235)),
        lightskyblue(new ColorImpl(135, 206, 250)),
        blueviolet(new ColorImpl(138, 43, 226)),
        darkred(new ColorImpl(139, 0, 0)),
        darkmagenta(new ColorImpl(139, 0, 139)),
        saddlebrown(new ColorImpl(139, 69, 19)),
        darkseagreen(new ColorImpl(143, 188, 143)),
        lightgreen(new ColorImpl(144, 238, 144)),
        mediumpurple(new ColorImpl(147, 112, 216)),
        darkviolet(new ColorImpl(148, 0, 211)),
        palegreen(new ColorImpl(152, 251, 152)),
        darkorchid(new ColorImpl(153, 50, 204)),
        yellowgreen(new ColorImpl(154, 205, 50)),
        sienna(new ColorImpl(160, 82, 45)),
        brown(new ColorImpl(165, 42, 42)),
        darkgray(new ColorImpl(169, 169, 169)),
        darkgrey(new ColorImpl(169, 169, 169)),
        lightblue(new ColorImpl(173, 216, 230)),
        greenyellow(new ColorImpl(173, 255, 47)),
        paleturquoise(new ColorImpl(175, 238, 238)),
        lightsteelblue(new ColorImpl(176, 196, 222)),
        powderblue(new ColorImpl(176, 224, 230)),
        firebrick(new ColorImpl(178, 34, 34)),
        darkgoldenrod(new ColorImpl(184, 134, 11)),
        mediumorchid(new ColorImpl(186, 85, 211)),
        rosybrown(new ColorImpl(188, 143, 143)),
        darkkhaki(new ColorImpl(189, 183, 107)),
        silver(new ColorImpl(192, 192, 192)),
        mediumvioletred(new ColorImpl(199, 21, 133)),
        indianred(new ColorImpl(205, 92, 92)),
        peru(new ColorImpl(205, 133, 63)),
        chocolate(new ColorImpl(210, 105, 30)),
        tan(new ColorImpl(210, 180, 140)),
        lightgray(new ColorImpl(211, 211, 211)),
        lightgrey(new ColorImpl(211, 211, 211)),
        palevioletred(new ColorImpl(216, 112, 147)),
        thistle(new ColorImpl(216, 191, 216)),
        orchid(new ColorImpl(218, 112, 214)),
        goldenrod(new ColorImpl(218, 165, 32)),
        crimson(new ColorImpl(220, 20, 60)),
        gainsboro(new ColorImpl(220, 220, 220)),
        plum(new ColorImpl(221, 160, 221)),
        burlywood(new ColorImpl(222, 184, 135)),
        lightcyan(new ColorImpl(224, 255, 255)),
        lavender(new ColorImpl(230, 230, 250)),
        darksalmon(new ColorImpl(233, 150, 122)),
        violet(new ColorImpl(238, 130, 238)),
        palegoldenrod(new ColorImpl(238, 232, 170)),
        lightcoral(new ColorImpl(240, 128, 128)),
        khaki(new ColorImpl(240, 230, 140)),
        aliceblue(new ColorImpl(240, 248, 255)),
        honeydew(new ColorImpl(240, 255, 240)),
        azure(new ColorImpl(240, 255, 255)),
        sandybrown(new ColorImpl(244, 164, 96)),
        wheat(new ColorImpl(245, 222, 179)),
        beige(new ColorImpl(245, 245, 220)),
        whitesmoke(new ColorImpl(245, 245, 245)),
        mintcream(new ColorImpl(245, 255, 250)),
        ghostwhite(new ColorImpl(248, 248, 255)),
        salmon(new ColorImpl(250, 128, 114)),
        antiquewhite(new ColorImpl(250, 235, 215)),
        linen(new ColorImpl(250, 240, 230)),
        lightgoldenrodyellow(new ColorImpl(250, 250, 210)),
        oldlace(new ColorImpl(253, 245, 230)),
        red(new ColorImpl(255, 0, 0)),
        fuchsia(new ColorImpl(255, 0, 255)),
        magenta(new ColorImpl(255, 0, 255)),
        deeppink(new ColorImpl(255, 20, 147)),
        orangered(new ColorImpl(255, 69, 0)),
        tomato(new ColorImpl(255, 99, 71)),
        hotpink(new ColorImpl(255, 105, 180)),
        coral(new ColorImpl(255, 127, 80)),
        darkorange(new ColorImpl(255, 140, 0)),
        lightsalmon(new ColorImpl(255, 160, 122)),
        orange(new ColorImpl(255, 165, 0)),
        lightpink(new ColorImpl(255, 182, 193)),
        pink(new ColorImpl(255, 192, 203)),
        gold(new ColorImpl(255, 215, 0)),
        peachpuff(new ColorImpl(255, 218, 185)),
        navajowhite(new ColorImpl(255, 222, 173)),
        moccasin(new ColorImpl(255, 228, 181)),
        bisque(new ColorImpl(255, 228, 196)),
        mistyrose(new ColorImpl(255, 228, 225)),
        blanchedalmond(new ColorImpl(255, 235, 205)),
        papayawhip(new ColorImpl(255, 239, 213)),
        lavenderblush(new ColorImpl(255, 240, 245)),
        seashell(new ColorImpl(255, 245, 238)),
        cornsilk(new ColorImpl(255, 248, 220)),
        lemonchiffon(new ColorImpl(255, 250, 205)),
        floralwhite(new ColorImpl(255, 250, 240)),
        snow(new ColorImpl(255, 250, 250)),
        yellow(new ColorImpl(255, 255, 0)),
        lightyellow(new ColorImpl(255, 255, 224)),
        ivory(new ColorImpl(255, 255, 240)),
        white(new ColorImpl(255, 255, 255));

        public final IRSColor color;

        private Named(IRSColor _color) {
            this.color = _color;
            colorNames.put(ColorUtil.valueOf(_color), this.toString());
        }
    }

    private static class ColorImpl
    implements IRSColor {
        private final int red;
        private final int green;
        private final int blue;
        private final double alpha;
        private final int hashCode;

        private ColorImpl(int _red, int _green, int _blue, double _alpha) {
            this.red = ColorUtil.clampByte(_red);
            this.green = ColorUtil.clampByte(_green);
            this.blue = ColorUtil.clampByte(_blue);
            this.alpha = ColorUtil.clampRatio(_alpha);
            this.hashCode = Objects.hash(this.red, this.green, this.blue, this.alpha);
        }

        private ColorImpl(int _red, int _green, int _blue) {
            this(_red, _green, _blue, 1.0);
        }

        @Override
        public int getRed() {
            return this.red;
        }

        @Override
        public int getGreen() {
            return this.green;
        }

        @Override
        public int getBlue() {
            return this.blue;
        }

        @Override
        public double getAlpha() {
            return this.alpha;
        }

        public boolean equals(Object _obj) {
            if (_obj == null || !(_obj instanceof IRSColor)) {
                return false;
            }
            IRSColor color = (IRSColor)_obj;
            return this.getRed() == color.getRed() && this.getGreen() == color.getGreen() && this.getBlue() == color.getBlue() && Double.compare(this.getAlpha(), color.getAlpha()) == 0;
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public String toString() {
            if (ColorUtil.hasTransparency(this)) {
                if (Double.compare(this.getAlpha(), 0.0) == 0) {
                    return "transparent";
                }
                return ColorUtil.toCssRGBA(this);
            }
            return ColorUtil.toHexRGB(this);
        }
    }
}

