/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.renderingservice.util;

import com.ibm.vipr.renderingservice.api.IRSCapability;
import com.ibm.vipr.renderingservice.api.IRSColorStop;
import com.ibm.vipr.renderingservice.api.IRSContEncoding;
import com.ibm.vipr.renderingservice.api.IRSEncoding;
import com.ibm.vipr.renderingservice.data.IRSContDataItem;
import com.ibm.vipr.renderingservice.data.IRSContDomain;
import com.ibm.vipr.renderingservice.data.IRSDataNode;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.renderingservice.property.IRSContPaletteProperty;
import com.ibm.vipr.renderingservice.util.Encoding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContEncoding
extends Encoding
implements IRSContEncoding {
    private static final List<IRSColorStop> EmptyStops = new ArrayList<IRSColorStop>(0);
    private final IRSContDomain domain;
    private final List<IRSColorStop> stops;

    @Override
    public IRSContDomain getDomain() {
        return this.domain;
    }

    @Override
    public List<IRSColorStop> getStops() {
        return this.stops;
    }

    public static ContEncoding fromDataSlot(IRSSlot _slot, String _channel, int _dataItemIndex, RSFormatKind _formatKind, IRSCapability _aggregation, IRSContPaletteProperty _palette) {
        IRSContDataItem dataItem = _slot.getDataItems().get(_dataItemIndex).asCont();
        IRSContDomain domain = dataItem.getDomain(_aggregation);
        List<IRSColorStop> stops = EmptyStops;
        if (_palette != null) {
            stops = _palette.getColorStops(dataItem).getStops();
        }
        return new ContEncoding(_slot.getName(), _channel, dataItem.getCaption(_formatKind), dataItem.getSubCaption(_formatKind), dataItem, domain, stops);
    }

    public ContEncoding(String _slot, String _channel, String _caption, String _subCaption, IRSDataNode _ref, IRSContDomain _domain, List<IRSColorStop> _stops) {
        super(IRSEncoding.EncodingType.Cont, _slot, _channel, _caption, _subCaption, _ref);
        this.domain = _domain;
        this.stops = Collections.unmodifiableList(_stops);
    }
}

