/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr;

import com.ibm.vipr.internal.manifest.ServiceDescription;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class BundleClassLoader {
    public static final String ERROR_LOADING_CLASS = "Could not load rendering service class";
    public static boolean LoadFromClassPath = false;
    private final Map<Object, CompletableFuture<Class<?>>> classLoaders = new HashMap();
    private final List<URLClassLoader> urlLoaders = new ArrayList<URLClassLoader>();
    private final URL location;

    public BundleClassLoader(URL _location) {
        this.location = _location;
    }

    public URL getLocation() {
        return this.location;
    }

    public synchronized CompletableFuture<Class<?>> loadClass(ServiceDescription _desc) {
        if (this.classLoaders.containsKey(_desc)) {
            return this.classLoaders.get(_desc);
        }
        CompletableFuture loader = new CompletableFuture();
        try {
            ClassLoader classLoader;
            String[] splitPath = _desc.getClassPath().split("/", 2);
            String jarName = splitPath[0];
            if (!jarName.isEmpty() && !jarName.endsWith(".jar")) {
                jarName = jarName + ".jar";
            }
            String className = splitPath[1].replaceAll("/", ".");
            ClassLoader classLoader2 = classLoader = this.getClass().getClassLoader() != null ? this.getClass().getClassLoader() : ClassLoader.getSystemClassLoader();
            if (jarName.isEmpty() || LoadFromClassPath) {
                loader.complete(classLoader.loadClass(className));
            } else {
                URL[] urls = new URL[]{new URL(this.location, jarName)};
                URLClassLoader urlClassLoader = URLClassLoader.newInstance(urls, classLoader);
                this.urlLoaders.add(urlClassLoader);
                Class<?> bundleClass = urlClassLoader.loadClass(className);
                loader.complete(bundleClass);
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            loader.completeExceptionally(new CompletionException(ERROR_LOADING_CLASS, ex));
        }
        this.classLoaders.put(_desc, loader);
        return loader;
    }

    public void finalize() {
        for (URLClassLoader loader : this.urlLoaders) {
            try {
                loader.close();
            }
            catch (Exception exception) {}
        }
    }
}

