/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr;

import com.ibm.vipr.RenderInvalidation;
import com.ibm.vipr.RenderMessage;
import com.ibm.vipr.RenderStatus;
import com.ibm.vipr.api.IRenderMessage;
import com.ibm.vipr.renderingservice.api.IRSRenderInvalidation;
import com.ibm.vipr.renderingservice.api.IRSRenderNotification;
import com.ibm.vipr.renderingservice.api.IRSRequest;
import com.ibm.vipr.renderingservice.api.IRenderingService;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

class RenderTask {
    public final CompletableFuture<IRenderMessage> result;
    public final String vizBundleId;
    public final String format;
    public final int timeout;
    public final Consumer<IRenderMessage> progress;
    private Timer timer;
    private boolean done;

    private void finish(CompletableFuture<RenderMessage> _future, RenderStatus _status, String _id, String _msg, Object _data) {
        if (!this.done) {
            this.done = true;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            _future.complete(new RenderMessage(_status, _id, _msg, _data, 1.0));
        }
    }

    private void progress(CompletableFuture<RenderMessage> _future, Consumer<RenderMessage> _progress, double _value, String _id, String _msg) {
        if (!this.done) {
            this.startTimer(_future);
            if (_progress != null) {
                _progress.accept(new RenderMessage(RenderStatus.Pending, _id, _msg, null, _value));
            }
        }
    }

    private void startTimer(final CompletableFuture<RenderMessage> _future) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.timeout > 0) {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    RenderTask.this.finish(_future, RenderStatus.Timeout, null, null, null);
                }
            }, this.timeout);
        }
    }

    public CompletableFuture<RenderMessage> execute(IRenderingService _renderer, RenderInvalidation _invalidation, final Consumer<RenderMessage> _progress) {
        final CompletableFuture<RenderMessage> future = new CompletableFuture<RenderMessage>();
        this.startTimer(future);
        IRSRenderNotification notification = new IRSRenderNotification(){

            public void complete() {
                this.complete(null, null);
            }

            public void complete(String _id, Object _data) {
                RenderTask.this.finish(future, RenderStatus.Complete, _id, null, _data);
            }

            public void fail(String _id, String _msg, Object _data) {
                RenderTask.this.finish(future, RenderStatus.Failed, _id, _msg, _data);
            }

            public void error(Throwable _e) {
                this.fail("error", _e.getMessage(), _e);
            }

            public void progress(double _value, String _id, String _msg) {
                RenderTask.this.progress(future, _progress, _value, _id, _msg);
            }

            public boolean waitingFor(IRSRequest _request) {
                return false;
            }
        };
        try {
            _renderer.render(this.format, (IRSRenderInvalidation)_invalidation, notification);
        }
        catch (Exception ex) {
            this.finish(future, RenderStatus.Failed, "error", ex.toString(), ex);
        }
        return future;
    }

    RenderTask(String _vizBundleId, String _format, int _timeout, Consumer<IRenderMessage> _progress) {
        this.vizBundleId = _vizBundleId;
        this.format = _format;
        this.timeout = _timeout;
        this.progress = _progress;
        this.timer = null;
        this.done = false;
        this.result = new CompletableFuture();
    }
}

