/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr;

import com.ibm.vipr.VizBundle;
import com.ibm.vipr.api.IHostAPI;
import com.ibm.vipr.api.IVizBundle;
import com.ibm.vipr.api.IVizService;
import com.ibm.vipr.renderingservice.api.IRenderSurface;
import com.ibm.vipr.vizdef.UserConfig;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class VIPR {
    public static final String ERROR_BUNDLE_ID_NULL_OR_EMPTY = "VizBundle Id cannot be null or empty";
    public static final String ERROR_BUNDLE_ALREADY_REGISTERED = "VizBundle is already registered";
    public static final String ERROR_BUNDLE_ID_NOT_REGISTERED = "The specified VizBundle Id is not registered";
    private final Map<String, BundleEntry> vizBundles = new HashMap<String, BundleEntry>();

    public static VIPR create() {
        return new VIPR();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String _id, URL _location, UserConfig _userConfig, String _fileName, Object _userData) {
        if (_id == null || _id.length() == 0) {
            throw new IllegalArgumentException(ERROR_BUNDLE_ID_NULL_OR_EMPTY);
        }
        Map<String, BundleEntry> map = this.vizBundles;
        synchronized (map) {
            if (this.vizBundles.containsKey(_id)) {
                throw new IllegalArgumentException(ERROR_BUNDLE_ALREADY_REGISTERED);
            }
            this.vizBundles.put(_id, new BundleEntry(_id, _location, _userConfig, _fileName, _userData));
        }
    }

    public void register(String _id, URL _location) {
        this.register(_id, _location, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(String _id) {
        if (_id == null || _id.length() == 0) {
            throw new IllegalArgumentException(ERROR_BUNDLE_ID_NULL_OR_EMPTY);
        }
        Map<String, BundleEntry> map = this.vizBundles;
        synchronized (map) {
            return this.vizBundles.remove(_id) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(String _id) {
        Map<String, BundleEntry> map = this.vizBundles;
        synchronized (map) {
            return this.vizBundles.containsKey(_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> bundleIds() {
        Map<String, BundleEntry> map = this.vizBundles;
        synchronized (map) {
            return Collections.unmodifiableSet(this.vizBundles.keySet());
        }
    }

    public CompletableFuture<IVizBundle> load(String _id) {
        return this.load(_id, Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<IVizBundle> load(String _id, Locale _lc) {
        BundleEntry entry;
        if (_id == null || _id.length() == 0) {
            throw new IllegalArgumentException(ERROR_BUNDLE_ID_NULL_OR_EMPTY);
        }
        Map<String, BundleEntry> map = this.vizBundles;
        synchronized (map) {
            entry = this.vizBundles.get(_id);
        }
        if (entry == null) {
            throw new IllegalArgumentException(ERROR_BUNDLE_ID_NOT_REGISTERED);
        }
        return entry.load(_lc != null ? _lc : Locale.getDefault());
    }

    public CompletableFuture<IVizService> newViz(String _id, String _format, IRenderSurface _surface, IHostAPI _hostApi, Object _userData) {
        return this.newViz(_id, Locale.getDefault(), _format, _surface, _hostApi, _userData);
    }

    public CompletableFuture<IVizService> newViz(String _id, Locale _lc, String _format, IRenderSurface _surface, IHostAPI _hostApi, Object _userData) {
        return this.load(_id, _lc).thenCompose(_bundle -> _bundle.create(_format, _surface, _hostApi, _userData, null, null));
    }

    private class BundleEntry {
        private final String id;
        private final URL location;
        private final UserConfig userConfig;
        private final String fileName;
        private final Object userData;
        private final Map<Locale, CompletableFuture<IVizBundle>> bundles;

        public BundleEntry(String _id, URL _location, UserConfig _userConfig, String _fileName, Object _userData) {
            this.id = _id;
            this.location = _location;
            this.userConfig = _userConfig;
            this.fileName = _fileName;
            this.userData = _userData;
            this.bundles = new HashMap<Locale, CompletableFuture<IVizBundle>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<IVizBundle> load(Locale _lc) {
            CompletableFuture<IVizBundle> loader;
            boolean loaderFound = false;
            Map<Locale, CompletableFuture<IVizBundle>> map = this.bundles;
            synchronized (map) {
                if (this.bundles.containsKey(_lc)) {
                    loader = this.bundles.get(_lc);
                    loaderFound = true;
                } else {
                    loader = new CompletableFuture();
                    this.bundles.put(_lc, loader);
                }
            }
            if (loaderFound) {
                try {
                    loader.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
                return loader;
            }
            VizBundle.load(this.id, this.location, this.userConfig, this.fileName, this.userData, _lc).handle((_bundle, _ex) -> {
                if (_ex == null) {
                    return loader.complete((IVizBundle)_bundle);
                }
                Map<Locale, CompletableFuture<IVizBundle>> map = this.bundles;
                synchronized (map) {
                    this.bundles.remove(_lc);
                }
                return loader.completeExceptionally((Throwable)_ex);
            });
            return loader;
        }
    }
}

