/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr;

import com.ibm.vipr.BundleClassLoader;
import com.ibm.vipr.VizService;
import com.ibm.vipr.api.IHostAPI;
import com.ibm.vipr.api.IVizBundle;
import com.ibm.vipr.api.IVizService;
import com.ibm.vipr.api.ResourceType;
import com.ibm.vipr.data.ISlotMapping;
import com.ibm.vipr.data.IVIPRData;
import com.ibm.vipr.info.IVIPRDataInfo;
import com.ibm.vipr.internal.data.VIPRDataApi;
import com.ibm.vipr.internal.manifest.Manifest;
import com.ibm.vipr.internal.manifest.ServiceDescription;
import com.ibm.vipr.internal.util.ResourceLoader;
import com.ibm.vipr.internal.util.VIPRNls;
import com.ibm.vipr.internal.util.XmlParser;
import com.ibm.vipr.renderingservice.api.IRenderSurface;
import com.ibm.vipr.renderingservice.api.IRenderingService;
import com.ibm.vipr.vizdef.PropertyDef;
import com.ibm.vipr.vizdef.SlotGroupDef;
import com.ibm.vipr.vizdef.UserConfig;
import com.ibm.vipr.vizdef.ValuePropertyDef;
import com.ibm.vipr.vizdef.VizDef;
import com.ibm.vipr.vizdef.VizDefParser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.w3c.dom.Document;

class VizBundle
implements IVizBundle {
    public static final String ERROR_BUNDLE_ALREADY_LOADED = "VizBundle is already loaded";
    public static final String ERROR_BUNDLE_NOT_LOADED = "VizBundle is not loaded";
    public static final String ERROR_UNSUPPORTED_FORMAT = "VizBundle does not support the requested format";
    public static final String ERROR_CANNOT_OPEN_MANIFEST = "Cannot open manifest file";
    public static final String ERROR_INVALID_MANIFEST = "Invalid manifest file";
    public static final String ERROR_CANNOT_OPEN_VIZDEF = "Cannot open vizdef file";
    public static final String ERROR_INVALID_VIZDEF = "Invalid vizdef file";
    public static final String ERROR_CREATING_CLASS = "Could not create rendering service class";
    public static final String ERROR_LOADING_NLS = "Could not load NLS file";
    public static final String ERROR_DURING_INIT = "Initialization of the rendering service failed";
    private static final String DEFAULT_MANIFEST = "manifest.xml";
    private final String id;
    private final String fileName;
    private final UserConfig userConfig;
    private final Object userData;
    private final VIPRNls nls;
    private final Locale locale;
    private final BundleClassLoader bundleClassLoader;
    private Manifest manifest;
    private VizDef vizDef;
    private ResourceLoader resLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CompletableFuture<IVizBundle> load(String _id, URL _location, UserConfig _config, String _fileName, Object _userData, Locale _locale) {
        VizDef vizDef;
        Manifest manifest;
        URLConnection connection;
        String fileName = _fileName == null ? DEFAULT_MANIFEST : _fileName;
        CompletableFuture<IVizBundle> loader = new CompletableFuture<IVizBundle>();
        try {
            URL urlManifest = new URL(_location, fileName);
            connection = urlManifest.openConnection();
            connection.connect();
        }
        catch (IOException ex) {
            loader.completeExceptionally(new CompletionException(ERROR_CANNOT_OPEN_MANIFEST, ex));
            return loader;
        }
        try {
            manifest = Manifest.fromXml(XmlParser.parse(connection.getInputStream()));
        }
        catch (Exception ex) {
            loader.completeExceptionally(new CompletionException(ERROR_INVALID_MANIFEST, ex));
            return loader;
        }
        VIPRNls nls = new VIPRNls();
        Locale locale = _locale == null ? Locale.getDefault() : _locale;
        try {
            nls.addBundle(ResourceBundle.getBundle("Messages", locale));
            for (String nlsPath : manifest.getNls().split(";")) {
                String name = nlsPath.trim();
                URL urlNls = _location;
                int i = nlsPath.lastIndexOf("/");
                if (i != -1) {
                    name = nlsPath.substring(i + 1);
                    urlNls = new URL(_location, nlsPath.substring(0, i + 1));
                }
                if (name.isEmpty()) continue;
                URL[] urls = new URL[]{urlNls};
                try (URLClassLoader bundleLoader = URLClassLoader.newInstance(urls, null);){
                    nls.addBundle(ResourceBundle.getBundle(name, locale, bundleLoader));
                }
            }
        }
        catch (IOException | MissingResourceException ex) {
            loader.completeExceptionally(new CompletionException(ERROR_LOADING_NLS, ex));
            return loader;
        }
        try {
            URL urlVizDef = new URL(_location, manifest.getServiceDefinition());
            connection = urlVizDef.openConnection();
            connection.connect();
        }
        catch (IOException ex) {
            loader.completeExceptionally(new CompletionException(ERROR_CANNOT_OPEN_VIZDEF, ex));
            return loader;
        }
        try {
            Document doc = XmlParser.parse(connection.getInputStream());
            vizDef = VizDef.applyUserConfig(VizDefParser.fromXML(doc, nls), _config);
        }
        catch (Exception ex) {
            loader.completeExceptionally(new CompletionException(ERROR_INVALID_VIZDEF, ex));
            return loader;
        }
        loader.complete(new VizBundle(_id, _location, _config, fileName, _userData, vizDef, manifest, nls, locale));
        return loader;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public URL getLocation() {
        return this.bundleClassLoader.getLocation();
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public UserConfig getUserConfig() {
        return this.userConfig;
    }

    @Override
    public VizDef getVizDef() {
        return this.vizDef;
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public CompletableFuture<IVizService> create(String _format, IRenderSurface _surface, IHostAPI _hostApi, Object _userData, VizDef _hostVizDef) {
        return this.create(_format, _surface, _hostApi, _userData, _hostVizDef, null);
    }

    @Override
    public CompletableFuture<IVizService> create(String _format, IRenderSurface _surface, IHostAPI _hostApi, Object _userData, VizDef _hostVizDef, Locale _formatLocale) {
        ServiceDescription desc = this.manifest.getServiceDescription(_format, "java");
        if (desc == null) {
            throw new IllegalArgumentException(ERROR_UNSUPPORTED_FORMAT);
        }
        VIPRNls nls = this.nls;
        return this.bundleClassLoader.loadClass(desc).thenCompose(_cls -> {
            try {
                IRenderingService renderer = (IRenderingService)_cls.newInstance();
                VizService service = new VizService(this, this.vizDef, _hostVizDef, desc, _format, _hostApi, _surface, _userData, renderer, nls, _formatLocale);
                return service.init().thenApply(_service -> _service);
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException ex) {
                throw new CompletionException(ERROR_CREATING_CLASS, ex);
            }
            catch (Exception e) {
                throw new CompletionException(ERROR_DURING_INIT, e);
            }
        });
    }

    @Override
    public IVIPRDataInfo processData(IVIPRData _viprData, ISlotMapping _slotMapping, VizDef _hostVizDef) {
        if (_viprData == null) {
            return null;
        }
        return VIPRDataApi.processData(_viprData, _slotMapping, _hostVizDef, this.vizDef, this.nls);
    }

    @Override
    public IVIPRDataInfo processData(IVIPRData _viprData, ISlotMapping _slotMapping) {
        return this.processData(_viprData, _slotMapping, this.vizDef);
    }

    @Override
    public CompletableFuture<Object> loadResource(String _location, ResourceType _resourceType) throws MalformedURLException {
        if (this.resLoader == null) {
            this.resLoader = new ResourceLoader(new URL(this.bundleClassLoader.getLocation(), "resources"));
        }
        switch (_resourceType) {
            case Json: {
                return this.resLoader.loadJSON(_location);
            }
            case Raw: {
                return this.resLoader.loadStream(_location);
            }
            case Text: {
                return this.resLoader.loadText(_location);
            }
        }
        throw new IllegalArgumentException(ERROR_UNSUPPORTED_FORMAT);
    }

    @Override
    public VIPRNls getNls() {
        return this.nls;
    }

    @Override
    public VizDef extendVizDef(VizDef _vizDef, SlotGroupDef _slotGroup, Iterable<PropertyDef> _properties, Iterable<ValuePropertyDef<?>> _configuration) {
        VizDef vizDef = this.vizDef;
        if (_vizDef != null) {
            vizDef = _vizDef;
        }
        return VizDef.applyUserConfig(vizDef.extend(_slotGroup, _properties, _configuration), this.userConfig);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    private VizBundle(String _id, URL _location, UserConfig _config, String _fileName, Object _userData, VizDef _vizDef, Manifest _manifest, VIPRNls _nls, Locale _locale) {
        this.id = _id;
        this.bundleClassLoader = new BundleClassLoader(_location);
        this.userConfig = _config;
        this.fileName = _fileName;
        this.userData = _userData;
        this.vizDef = _vizDef;
        this.manifest = _manifest;
        this.nls = _nls;
        this.locale = _locale;
    }
}

