/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr;

import com.ibm.vipr.Capability;
import com.ibm.vipr.Encoding;
import com.ibm.vipr.RenderException;
import com.ibm.vipr.RenderInvalidation;
import com.ibm.vipr.RenderMessage;
import com.ibm.vipr.RenderStatus;
import com.ibm.vipr.RenderTask;
import com.ibm.vipr.VizBundle;
import com.ibm.vipr.VizServiceNotification;
import com.ibm.vipr.VizServiceRequestHandle;
import com.ibm.vipr.api.ICapability;
import com.ibm.vipr.api.ICoordinate;
import com.ibm.vipr.api.IEncoding;
import com.ibm.vipr.api.IHostAPI;
import com.ibm.vipr.api.IInteractivity;
import com.ibm.vipr.api.IPoint;
import com.ibm.vipr.api.IRegion;
import com.ibm.vipr.api.IRenderMessage;
import com.ibm.vipr.api.IVizBundle;
import com.ibm.vipr.api.IVizPalette;
import com.ibm.vipr.api.IVizPalettes;
import com.ibm.vipr.api.IVizService;
import com.ibm.vipr.data.ISlotMapping;
import com.ibm.vipr.data.IVIPRData;
import com.ibm.vipr.event.Evented;
import com.ibm.vipr.event.IEventListener;
import com.ibm.vipr.info.IInfo;
import com.ibm.vipr.info.IVIPRDataInfo;
import com.ibm.vipr.internal.data.SliceResult;
import com.ibm.vipr.internal.data.VIPRDataApi;
import com.ibm.vipr.internal.manifest.ServiceDescription;
import com.ibm.vipr.internal.property.Properties;
import com.ibm.vipr.internal.property.PropertyApi;
import com.ibm.vipr.internal.util.VIPRNls;
import com.ibm.vipr.internal.util.VisualizationImage;
import com.ibm.vipr.property.IVizProperties;
import com.ibm.vipr.property.PropertyType;
import com.ibm.vipr.property.PropertyValueEventArgs;
import com.ibm.vipr.renderingservice.api.ICustomDataDecorated;
import com.ibm.vipr.renderingservice.api.IRSDataContext;
import com.ibm.vipr.renderingservice.api.IRSHostAPI;
import com.ibm.vipr.renderingservice.api.IRSInitializationParameters;
import com.ibm.vipr.renderingservice.api.IRSNls;
import com.ibm.vipr.renderingservice.api.IRSRequest;
import com.ibm.vipr.renderingservice.api.IRSVisualizationImage;
import com.ibm.vipr.renderingservice.api.IRenderSurface;
import com.ibm.vipr.renderingservice.api.IRenderingService;
import com.ibm.vipr.renderingservice.api.RSSeverity;
import com.ibm.vipr.renderingservice.data.IRenderingServiceData;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import com.ibm.vipr.renderingservice.property.IRSValueProperty;
import com.ibm.vipr.vizdef.PropertyDef;
import com.ibm.vipr.vizdef.VizDef;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class VizService
implements IVizService,
IRSHostAPI {
    private static final List<ICapability> EmptyCapabilities = new ArrayList<ICapability>(0);
    private static final List<IEncoding> EmptyEncodings = new ArrayList<IEncoding>(0);
    private static final int DefaultTimeout = 15000;
    private static AtomicInteger nextRequestId = new AtomicInteger(0);
    public final VizBundle vizBundle;
    public final VizDef vizDef;
    public final ServiceDescription serviceDescription;
    public final String format;
    public final Object userData;
    private final VIPRNls nls;
    private final IRSDataContext dataContext;
    private final IVizPalettes palettes;
    private final Properties properties;
    private final Map<String, Object> resources;
    private final IHostAPI hostAPI;
    private final IRenderingService service;
    private final List<VizServiceRequestHandle> requests;
    private final IRenderSurface surface;
    private final Locale locale;
    private boolean truncate;
    private boolean responseReceived;
    private List<RenderTask> renderQueue;
    private int renderTimeout;
    private int activeRenderTask;
    private IRenderingServiceData data;
    private IRenderingServiceData renderedData;
    private int renderedDecoVer;
    private int renderedWidth;
    private int renderedHeight;
    private List<ICapability> lastCapabilities;

    VizService(VizBundle _vizBundle, VizDef _rsVizDef, VizDef _hostVizDef, ServiceDescription _serviceDescription, String _format, IHostAPI _hostAPI, IRenderSurface _surface, Object _userData, IRenderingService _service, VIPRNls _nls, Locale _locale) {
        VizDef originalVizDef = _rsVizDef != null ? _rsVizDef : _vizBundle.getVizDef();
        this.vizBundle = _vizBundle;
        this.vizDef = _hostVizDef != null ? _hostVizDef : originalVizDef;
        this.serviceDescription = _serviceDescription;
        this.format = _format;
        this.userData = _userData;
        this.truncate = false;
        PropertyApi propertyApi = new PropertyApi(_service.getPropertyApi());
        this.nls = _nls;
        this.locale = _locale != null ? _locale : _vizBundle.getLocale();
        this.dataContext = VIPRDataApi.createDataContext();
        this.properties = Properties.create(originalVizDef, this.vizDef, propertyApi, this.dataContext);
        this.properties.on("value", (_args, _sender) -> this.onPropertyChange((PropertyValueEventArgs)_args));
        this.resources = new LinkedHashMap<String, Object>();
        this.hostAPI = _hostAPI;
        this.service = _service;
        this.requests = new ArrayList<VizServiceRequestHandle>();
        this.surface = _surface;
        this.truncate = true;
        this.responseReceived = false;
        this.renderQueue = new LinkedList<RenderTask>();
        this.renderTimeout = 15000;
        this.activeRenderTask = -1;
        this.data = null;
        this.renderedData = null;
        this.renderedDecoVer = -1;
        this.renderedWidth = -1;
        this.renderedHeight = -1;
        this.palettes = new IVizPalettes(){

            @Override
            public Evented.Handle on(String _name, IEventListener _listener) {
                return null;
            }

            @Override
            public Iterator<IVizPalette> iterator() {
                ArrayList palettes = new ArrayList();
                return palettes.iterator();
            }

            @Override
            public IVizPalette get(String _name) {
                return null;
            }

            @Override
            public IVizPalette get(int _index) {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }
        };
    }

    private void onPropertyChange(PropertyValueEventArgs _args) {
        IRSValueProperty rsProperty;
        PropertyDef def = _args.property.getDef();
        if (def.type != PropertyType.Group && !def.deprecated && (rsProperty = this.properties.toRS().get(def.name)) != null) {
            this.service.setProperty(def.name, rsProperty.peekValue());
        }
    }

    CompletableFuture<VizService> init() {
        IRSInitializationParameters params = new IRSInitializationParameters(){

            public IRSProperties getProperties() {
                return VizService.this.properties.toRS();
            }

            public String getFormat() {
                return VizService.this.format;
            }

            public IRSNls getNls() {
                return VizService.this.nls;
            }

            public Locale getLocale() {
                return VizService.this.locale;
            }

            public IRenderSurface getRenderSurface() {
                return VizService.this.surface;
            }

            public IRSDataContext getDataContext() {
                return VizService.this.dataContext;
            }
        };
        CompletableFuture<VizService> result = new CompletableFuture<VizService>();
        this.service.init(params, (IRSHostAPI)this, this.resources, () -> result.complete(this), _msg -> result.completeExceptionally(new Error(_msg)));
        return result;
    }

    @Override
    public CompletableFuture<Void> destroy(int _delay) {
        this.service.destroy();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> destroy() {
        return this.destroy(0);
    }

    @Override
    public void setData(IVIPRData _data, ISlotMapping _slotMapping) {
        this.setData(this.vizBundle.processData(_data, _slotMapping, this.vizDef));
    }

    @Override
    public void setData(IVIPRDataInfo _data) {
        IRenderingServiceData data;
        if (VIPRDataApi.isSliced(_data)) {
            data = VIPRDataApi.toRS(_data);
        } else {
            List<ICapability> capabilities = null;
            if (this.truncate) {
                capabilities = this.lastCapabilities != null ? this.lastCapabilities : this.getCapabilities();
            }
            SliceResult sliced = VIPRDataApi.slice(_data, null, capabilities, this.hostAPI, this.vizBundle.getNls());
            data = VIPRDataApi.toRS(sliced.slices.get(0));
        }
        this.data = VIPRDataApi.initDataContext(this.dataContext, data);
        this.service.setData(data);
        this.lastCapabilities = null;
    }

    @Override
    public List<ICapability> getCapabilities() {
        List rsCapabilities = this.service.getCapabilities();
        this.lastCapabilities = rsCapabilities == null ? EmptyCapabilities : rsCapabilities.stream().map(Capability::fromRS).collect(Collectors.toList());
        return this.lastCapabilities;
    }

    @Override
    public List<IEncoding> getEncodings() {
        List rsEncodings = this.service.getEncodings();
        if (rsEncodings == null) {
            return EmptyEncodings;
        }
        return rsEncodings.stream().map(Encoding::fromRS).collect(Collectors.toList());
    }

    @Override
    public IVizBundle getVizBundle() {
        return this.vizBundle;
    }

    @Override
    public VizDef getVizDef() {
        return this.vizDef;
    }

    @Override
    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public IRenderSurface getRenderSurface() {
        return this.surface;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setTruncate(boolean _truncate) {
        this.truncate = _truncate;
    }

    @Override
    public boolean getTruncate() {
        return this.truncate;
    }

    @Override
    public IVizPalettes getPalettes() {
        return this.palettes;
    }

    @Override
    public IVizProperties getProperties() {
        return this.properties.toHost();
    }

    @Override
    public CompletableFuture<IRenderMessage> render() {
        return this.render(null);
    }

    @Override
    public CompletableFuture<IRenderMessage> render(Consumer<IRenderMessage> _progress) {
        RenderTask task = new RenderTask(this.vizBundle.getId(), this.format, this.renderTimeout, _progress);
        this.renderQueue.add(task);
        if (this.activeRenderTask == -1) {
            this.executeRender();
        }
        return task.result;
    }

    @Override
    public int getRenderTimeout() {
        return this.renderTimeout;
    }

    @Override
    public void setRenderTimeout(int _renderTimeout) {
        this.renderTimeout = _renderTimeout;
    }

    private void executeRender() {
        this.activeRenderTask = this.renderQueue.size() - 1;
        RenderTask task = this.renderQueue.get(this.activeRenderTask);
        boolean hadResponse = this.responseReceived;
        this.responseReceived = false;
        int width = this.surface.getWidth();
        int height = this.surface.getHeight();
        int currentDecoVer = VIPRDataApi.refreshDecorations(this.data);
        RenderInvalidation invalidation = new RenderInvalidation(this.renderedData != this.data, this.renderedDecoVer != currentDecoVer, this.properties.rsDirty(), this.renderedWidth != width || this.renderedHeight != height, hadResponse);
        this.properties.lock();
        task.execute(this.service, invalidation, _operation -> this.onRenderProgress((RenderMessage)_operation)).thenAccept(_operation -> this.onRenderFinished((RenderMessage)_operation, width, height, currentDecoVer));
    }

    private void onRenderProgress(RenderMessage _operation) {
        Consumer<IRenderMessage> progress;
        if (this.activeRenderTask > 0) {
            RenderMessage obsolete = _operation.makeObsolete();
            for (int i = 0; i < this.activeRenderTask; ++i) {
                progress = this.renderQueue.get((int)i).progress;
                if (progress == null) continue;
                progress.accept(obsolete);
            }
        }
        if ((progress = this.renderQueue.get((int)this.activeRenderTask).progress) != null) {
            progress.accept(_operation);
        }
    }

    private void onRenderFinished(RenderMessage _operation, int _width, int _height, int _decoVer) {
        boolean success = _operation.getStatus() == RenderStatus.Complete;
        RenderMessage operation = _operation;
        if (operation.getData() instanceof IRSVisualizationImage) {
            operation = new RenderMessage(_operation.getStatus(), _operation.getId(), _operation.getMessage(), VisualizationImage.create((IRSVisualizationImage)_operation.getData()), _operation.getProgress());
        }
        if (this.activeRenderTask == 0) {
            CompletableFuture<IRenderMessage> result = this.renderQueue.remove((int)0).result;
            if (success) {
                result.complete(operation);
            } else {
                result.completeExceptionally(new RenderException(operation));
            }
        } else {
            RenderMessage obsolete = operation.makeObsolete();
            if (success) {
                for (int i = 0; i < this.activeRenderTask; ++i) {
                    this.renderQueue.remove((int)0).result.complete(obsolete);
                }
                this.renderQueue.remove((int)0).result.complete(operation);
            } else {
                RenderException exObsolete = new RenderException(obsolete);
                for (int i = 0; i < this.activeRenderTask; ++i) {
                    this.renderQueue.remove((int)0).result.completeExceptionally(exObsolete);
                }
                this.renderQueue.remove((int)0).result.completeExceptionally(new RenderException(operation));
            }
        }
        this.activeRenderTask = -1;
        if (success) {
            this.renderedData = this.data;
            this.renderedWidth = _width;
            this.renderedHeight = _height;
            this.renderedDecoVer = _decoVer;
        }
        this.properties.unlock(success);
        if (this.renderQueue.size() > 0) {
            this.executeRender();
        }
    }

    @Override
    public IInteractivity getInteractivity() {
        return null;
    }

    @Override
    public ICoordinate getVisCoordinate(final double _clientX, final double _clientY) {
        return new ICoordinate(){

            @Override
            public double getX() {
                return _clientX;
            }

            @Override
            public double getY() {
                return _clientY;
            }
        };
    }

    @Override
    public IPoint getClientPoint(final ICoordinate _coord) {
        return new IPoint(){

            @Override
            public double getX() {
                return _coord.getX();
            }

            @Override
            public double getY() {
                return _coord.getY();
            }
        };
    }

    @Override
    public IRegion getRegionAtPoint(ICoordinate _coord) {
        return null;
    }

    @Override
    public List<IInfo> getItemsAtPoint(ICoordinate coord) {
        return new ArrayList<IInfo>();
    }

    @Override
    public List<IInfo> getItemsInPolygon(List<ICoordinate> _coords) {
        return new ArrayList<IInfo>();
    }

    public void requestRender() {
        this.render(null);
    }

    public IRSRequest request(String _name, int _version, Object _payload) {
        VizServiceRequestHandle request = new VizServiceRequestHandle(nextRequestId.incrementAndGet(), _name, _version, _payload, this.hostAPI, _request -> {
            this.responseReceived = true;
            if (!_request.isActive()) {
                this.requests.remove(_request);
            }
        });
        this.requests.add(request);
        return request.toRS();
    }

    public void notify(RSSeverity _level, String _id, String _message, Object _payload) {
        if (_level == null) {
            throw new IllegalArgumentException("Invalid notify level");
        }
        if (this.hostAPI != null) {
            VizServiceNotification notification = new VizServiceNotification(_level.value(), _id, _message, _payload);
            try {
                this.hostAPI.notify(notification);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void error(String _id, String _message, Object _payload) {
        this.notify(RSSeverity.Error, _id, _message, _payload);
    }

    public void warn(String _id, String _message, Object _payload) {
        this.notify(RSSeverity.Warning, _id, _message, _payload);
    }

    public void info(String _id, String _message, Object _payload) {
        this.notify(RSSeverity.Info, _id, _message, _payload);
    }

    public void setCustomData(String _name, List<ICustomDataDecorated> _data) {
        if (this.hostAPI != null) {
            try {
                this.hostAPI.setCustomData(_name, _data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

