/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr;

import com.ibm.vipr.api.IHostAPI;
import com.ibm.vipr.api.IVizServiceRequest;
import com.ibm.vipr.renderingservice.api.IRSRequest;
import java.util.ArrayList;
import java.util.List;

class VizServiceRequestHandle {
    public static final String ERROR_EXEC_NOT_CALLED = "Request has not been executed yet";
    public static final String ERROR_EXEC_ALREADY_CALLED = "Request has already been executed";
    public static final String ERROR_NO_REQUEST_HANDLER = "The host did not provide a request handler";
    private final int id;
    private final String name;
    private final int version;
    private final Object payload;
    private final IHostAPI hostAPI;
    private final IRequestNotification notification;
    private boolean executed;
    private Status status;
    private Object result;
    private final List<IRSRequest.IHostResponseCallback> subscribers;
    private final IVizServiceRequest host;
    private final IRSRequest rs;

    private void update(Status _status, Object _detail) {
        Object error = null;
        Object data = null;
        if (_status == Status.Pending || _status == Status.Complete) {
            data = _detail;
        } else {
            error = _detail;
        }
        if (_status != Status.Pending && _status != Status.Inactive) {
            this.result = _detail;
        }
        if (_status != Status.Pending) {
            this.status = _status;
        }
        for (IRSRequest.IHostResponseCallback subscriber : this.subscribers) {
            try {
                subscriber.call(error, data, this.rs);
            }
            catch (Exception exception) {}
        }
        if (this.status != Status.Pending) {
            this.subscribers.clear();
            if (this.notification != null) {
                try {
                    this.notification.update(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    VizServiceRequestHandle(int _id, String _name, int _version, Object _payload, IHostAPI _hostAPI, IRequestNotification _notification) {
        this.id = _id;
        this.name = _name;
        this.version = _version;
        this.payload = _payload;
        this.hostAPI = _hostAPI;
        this.notification = _notification;
        this.subscribers = new ArrayList<IRSRequest.IHostResponseCallback>();
        this.status = Status.Inactive;
        this.host = new VizServiceRequest();
        this.rs = new RSRequest();
    }

    public boolean isActive() {
        return this.status == Status.Pending;
    }

    public IVizServiceRequest toHost() {
        return this.host;
    }

    public IRSRequest toRS() {
        return this.rs;
    }

    private class RSRequest
    implements IRSRequest {
        private RSRequest() {
        }

        public int getId() {
            return VizServiceRequestHandle.this.id;
        }

        public String getName() {
            return VizServiceRequestHandle.this.name;
        }

        public Number getVersion() {
            return VizServiceRequestHandle.this.version;
        }

        public Object getPayload() {
            return VizServiceRequestHandle.this.payload;
        }

        public void subscribe(IRSRequest.IHostResponseCallback _callback) {
            if (_callback == null) {
                return;
            }
            VizServiceRequestHandle request = VizServiceRequestHandle.this;
            switch (request.status) {
                case Inactive: 
                case Pending: {
                    request.subscribers.add(_callback);
                    break;
                }
                case Complete: {
                    _callback.call(null, request.result, (IRSRequest)this);
                    break;
                }
                default: {
                    _callback.call(request.result, null, (IRSRequest)this);
                }
            }
        }

        public RSRequest exec(IRSRequest.IHostResponseCallback _callback) {
            VizServiceRequestHandle request = VizServiceRequestHandle.this;
            if (request.executed) {
                throw new IllegalStateException(VizServiceRequestHandle.ERROR_EXEC_ALREADY_CALLED);
            }
            request.executed = true;
            if (_callback != null) {
                this.subscribe(_callback);
            }
            if (request.status == Status.Inactive) {
                request.status = Status.Pending;
                if (request.hostAPI != null) {
                    try {
                        request.hostAPI.request(request.toHost());
                    }
                    catch (Exception ex) {
                        request.update(Status.Failed, ex);
                    }
                } else {
                    request.update(Status.Failed, new Error(VizServiceRequestHandle.ERROR_NO_REQUEST_HANDLER));
                }
            }
            return this;
        }

        public void abort(Object _detail) {
            VizServiceRequestHandle request = VizServiceRequestHandle.this;
            if (request.status == Status.Inactive || request.status == Status.Pending) {
                request.update(Status.Aborted, _detail);
            }
        }

        public boolean isAborted() {
            return VizServiceRequestHandle.this.status == Status.Aborted;
        }

        public boolean isCompleted() {
            return VizServiceRequestHandle.this.status == Status.Complete;
        }

        public boolean isFailed() {
            return VizServiceRequestHandle.this.status == Status.Failed;
        }

        public boolean isActive() {
            return VizServiceRequestHandle.this.status == Status.Pending;
        }
    }

    private class VizServiceRequest
    implements IVizServiceRequest {
        private VizServiceRequest() {
        }

        @Override
        public int getId() {
            return VizServiceRequestHandle.this.id;
        }

        @Override
        public String getName() {
            return VizServiceRequestHandle.this.name;
        }

        @Override
        public int getVersion() {
            return VizServiceRequestHandle.this.version;
        }

        @Override
        public Object getPayload() {
            return VizServiceRequestHandle.this.payload;
        }

        @Override
        public boolean isAborted() {
            return VizServiceRequestHandle.this.status == Status.Aborted;
        }

        @Override
        public boolean isCompleted() {
            return VizServiceRequestHandle.this.status == Status.Complete;
        }

        @Override
        public boolean isFailed() {
            return VizServiceRequestHandle.this.status == Status.Failed;
        }

        @Override
        public boolean isActive() {
            return VizServiceRequestHandle.this.status == Status.Pending;
        }

        @Override
        public void reply(Object _payload) {
            VizServiceRequestHandle request = VizServiceRequestHandle.this;
            if (request.status == Status.Inactive) {
                throw new IllegalStateException(VizServiceRequestHandle.ERROR_EXEC_NOT_CALLED);
            }
            if (request.status == Status.Pending) {
                request.update(Status.Pending, _payload);
            }
        }

        @Override
        public void complete(Object _payload) {
            VizServiceRequestHandle request = VizServiceRequestHandle.this;
            if (request.status == Status.Inactive) {
                throw new IllegalStateException(VizServiceRequestHandle.ERROR_EXEC_NOT_CALLED);
            }
            if (request.status == Status.Pending) {
                request.update(Status.Complete, _payload);
            }
        }

        @Override
        public void fail(Object _payload) {
            VizServiceRequestHandle request = VizServiceRequestHandle.this;
            if (request.status == Status.Inactive) {
                throw new IllegalStateException(VizServiceRequestHandle.ERROR_EXEC_NOT_CALLED);
            }
            if (request.status == Status.Pending) {
                request.update(Status.Failed, _payload);
            }
        }
    }

    private static enum Status {
        Inactive,
        Pending,
        Complete,
        Failed,
        Aborted;

    }

    @FunctionalInterface
    public static interface IRequestNotification {
        public void update(VizServiceRequestHandle var1);
    }
}

