/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.data.DataItemType;
import com.ibm.vipr.data.FormatKind;
import com.ibm.vipr.data.ICatDataItem;
import com.ibm.vipr.data.ITuple;
import com.ibm.vipr.info.ICatDataItemInfo;
import com.ibm.vipr.info.IItemClassSetInfo;
import com.ibm.vipr.info.ITupleInfo;
import com.ibm.vipr.internal.data.DataContext;
import com.ibm.vipr.internal.data.DataItem;
import com.ibm.vipr.internal.data.DataSet;
import com.ibm.vipr.internal.data.ItemClassSet;
import com.ibm.vipr.internal.data.Tuple;
import com.ibm.vipr.internal.util.JoinUtil;
import com.ibm.vipr.renderingservice.data.IRSCatDataItem;
import com.ibm.vipr.renderingservice.data.IRSContDataItem;
import com.ibm.vipr.renderingservice.data.IRSItemClassSet;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.renderingservice.data.RSDataItemType;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.vizdef.SlotRef;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class CatDataItem
extends DataItem<ICatDataItem>
implements IRSCatDataItem,
ICatDataItemInfo {
    protected static final String JOIN_CAPTIONS = " \u00d7 ";
    public final int tupleCount;
    public final int start;
    public final int end;
    public final List<IRSItemClassSet> itemClassSets;
    public final List<IRSTuple> tuples;

    public CatDataItem(ICatDataItem _source, Set<String> _decoFilter, SlotRef _slotRef, int _sourceIndex, boolean _mapped, int _colIndex, int _tupleCount, int _start, int _end, List<IRSItemClassSet> _itemClassSets, List<IRSTuple> _tuples) {
        super(_source, _decoFilter, _slotRef, _sourceIndex, _mapped, _colIndex);
        this.tupleCount = _tupleCount;
        this.start = _start;
        this.end = _end;
        this.itemClassSets = _itemClassSets;
        this.tuples = _tuples;
    }

    public RSDataItemType getType() {
        return RSDataItemType.Cat;
    }

    public String getCaption(RSFormatKind _kind) {
        return JoinUtil.joinCaptions(this.itemClassSets, _kind, JOIN_CAPTIONS);
    }

    public String getSubCaption(RSFormatKind _kind) {
        return JoinUtil.joinSubCaptions(this.itemClassSets, _kind, JOIN_CAPTIONS);
    }

    public String combineCaptions(RSFormatKind _kind) {
        return JoinUtil.joinCombinedCaptions(this.itemClassSets, _kind, JOIN_CAPTIONS);
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public int getTupleCount() {
        return this.tupleCount;
    }

    public List<IRSItemClassSet> getItemClassSets() {
        return this.itemClassSets;
    }

    public int getItemClassSetCount() {
        return this.itemClassSets.size();
    }

    public IRSItemClassSet getItemClassSet(int _index) {
        return _index >= 0 && _index < this.itemClassSets.size() ? this.itemClassSets.get(_index) : null;
    }

    public List<IRSTuple> getTuples() {
        return this.tuples;
    }

    public IRSTuple getTuple(int _index) {
        return _index >= this.start && _index < this.end ? this.tuples.get(_index - this.start) : null;
    }

    public IRSCatDataItem asCat() {
        return this;
    }

    public IRSContDataItem asCont() {
        return null;
    }

    @Override
    public DataItemType getDataItemInfoType() {
        return DataItemType.Cat;
    }

    @Override
    public String getCaption(FormatKind _kind) {
        return this.getCaption(CatDataItem.toRS(_kind));
    }

    @Override
    public String getSubCaption(FormatKind _kind) {
        return this.getSubCaption(CatDataItem.toRS(_kind));
    }

    @Override
    public String combineCaptions(FormatKind _kind) {
        return this.combineCaptions(CatDataItem.toRS(_kind));
    }

    @Override
    public List<IItemClassSetInfo> getItemClassSetInfos() {
        return CatDataItem.toInfo(this.itemClassSets);
    }

    @Override
    public List<ITupleInfo> getTupleInfos() {
        return CatDataItem.toInfo(this.tuples);
    }

    @Override
    public ITupleInfo getTupleInfo(int _index) {
        return (ITupleInfo)this.getTuple(_index);
    }

    CatDataItem clone(Set<String> _decoFilter, SlotRef _slotRef, int _colIndex) {
        return this.clone(_decoFilter, _slotRef, _colIndex, 0);
    }

    CatDataItem clone(Set<String> _decoFilter, SlotRef _slotRef, int _colIndex, int _limit) {
        int len = this.itemClassSets.size();
        ArrayList<IRSItemClassSet> itemClassSets = new ArrayList<IRSItemClassSet>(len);
        for (int i = 0; i < len; ++i) {
            itemClassSets.add(((ItemClassSet)this.itemClassSets.get(i)).clone(_decoFilter, _slotRef));
        }
        int start = this.start;
        int end = this.end;
        len = end - start;
        if (_limit > 0) {
            end = Math.min(start + _limit, end);
        }
        ArrayList<IRSTuple> tuples = new ArrayList<IRSTuple>(len);
        for (int i = 0; i < len; ++i) {
            Tuple tuple = (Tuple)this.tuples.get(i);
            int ics = tuple.source != null ? ((ITuple)tuple.source).getItemClassSetIndex() : 0;
            tuples.add(tuple.clone(_decoFilter, (ItemClassSet)itemClassSets.get(ics)));
        }
        return this.createClone((ICatDataItem)this.source, _decoFilter, _slotRef, this.sourceIndex, this.mapped, _colIndex, this.tupleCount, start, end, itemClassSets, tuples);
    }

    protected CatDataItem createClone(ICatDataItem _source, Set<String> _decoFilter, SlotRef _slotRef, int _sourceIndex, boolean _mapped, int _colIndex, int _tupleCount, int _start, int _end, List<IRSItemClassSet> _itemClassSets, List<IRSTuple> _tuples) {
        return new CatDataItem(_source, _decoFilter, _slotRef, _sourceIndex, _mapped, _colIndex, _tupleCount, _start, _end, _itemClassSets, _tuples);
    }

    @Override
    void applyContext(DataContext _context, DataSet _dataSet) {
        super.applyContext(_context, _dataSet);
        for (IRSItemClassSet rsItemClassSet : this.itemClassSets) {
            assert (rsItemClassSet != null);
            ((ItemClassSet)rsItemClassSet).applyContext(_context, this);
        }
        for (IRSTuple rsTuple : this.tuples) {
            assert (rsTuple != null);
            ((Tuple)rsTuple).applyContext(_context, this);
        }
    }
}

