/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.data.ICatDataItem;
import com.ibm.vipr.data.IItemClassSet;
import com.ibm.vipr.data.ITuple;
import com.ibm.vipr.internal.data.CatDataItem;
import com.ibm.vipr.internal.data.Item;
import com.ibm.vipr.internal.data.ItemClass;
import com.ibm.vipr.internal.data.ItemClassSet;
import com.ibm.vipr.internal.data.Tuple;
import com.ibm.vipr.internal.data.VirtualItem;
import com.ibm.vipr.internal.data.VirtualItemClass;
import com.ibm.vipr.internal.util.VIPRNls;
import com.ibm.vipr.renderingservice.data.IRSItem;
import com.ibm.vipr.renderingservice.data.IRSItemClass;
import com.ibm.vipr.renderingservice.data.IRSItemClassSet;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.renderingservice.util.NumberUtil;
import com.ibm.vipr.vizdef.SlotRef;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class CatDataItemFactory {
    CatDataItem create(ICatDataItem _dataItemSource, Set<String> _decoFilter, SlotRef _slotRef, int _sourceIndex, boolean _mapped, int _colIndex) {
        int iItemClass;
        List<IRSItemClass> itemClasses;
        int itemClassCount;
        int tupleCount = _dataItemSource.getTupleCount();
        int start = NumberUtil.clamp((int)0, (int)_dataItemSource.getDataWindowStart(), (int)tupleCount);
        int end = NumberUtil.clamp((int)start, (int)_dataItemSource.getDataWindowEnd(), (int)tupleCount);
        int itemClassSetCount = _dataItemSource.getItemClassSetCount();
        ArrayList<IRSItemClassSet> itemClassSets = new ArrayList<IRSItemClassSet>(itemClassSetCount);
        this.init(_dataItemSource);
        for (int iItemClassSet = 0; iItemClassSet < itemClassSetCount; ++iItemClassSet) {
            IItemClassSet itemClassSetSource = _dataItemSource.getItemClassSet(iItemClassSet);
            itemClassCount = itemClassSetSource.getItemClassCount();
            itemClasses = new ArrayList<IRSItemClass>(itemClassCount);
            for (iItemClass = 0; iItemClass < itemClassCount; ++iItemClass) {
                itemClasses.add(new ItemClass(itemClassSetSource.getItemClass(iItemClass), _decoFilter, _slotRef, iItemClass));
            }
            itemClassSets.add(new ItemClassSet(itemClassSetSource, _slotRef, itemClasses));
        }
        ArrayList<IRSTuple> tuples = new ArrayList<IRSTuple>(Math.max(0, end - start));
        for (int iTuple = start; iTuple < end; ++iTuple) {
            ITuple tupleSource = _dataItemSource.getTuple(iTuple);
            ItemClassSet itemClassSet = (ItemClassSet)itemClassSets.get(tupleSource.getItemClassSetIndex());
            itemClasses = itemClassSet.itemClasses;
            itemClassCount = itemClasses.size();
            ArrayList<IRSItem> items = new ArrayList<IRSItem>(itemClassCount);
            for (iItemClass = 0; iItemClass < itemClassCount; ++iItemClass) {
                items.add(new Item(tupleSource.getItem(iItemClass), _decoFilter, _slotRef, (ItemClass)itemClassSet.itemClasses.get(iItemClass)));
            }
            tuples.add(this.createTuple(tupleSource, _decoFilter, _slotRef, iTuple, itemClassSet, items));
        }
        return this.createDataItem(_dataItemSource, _decoFilter, _slotRef, _sourceIndex, _mapped, end - start > 1 ? _colIndex : -1, tupleCount, start, end, itemClassSets, tuples);
    }

    CatDataItem virtual(Set<String> _decoFilter, SlotRef _slotRef, VIPRNls _nls) {
        ArrayList<IRSItemClass> itemClasses = new ArrayList<IRSItemClass>(1);
        ArrayList<IRSItem> items = new ArrayList<IRSItem>(1);
        ArrayList<IRSItemClassSet> itemClassSets = new ArrayList<IRSItemClassSet>(1);
        ArrayList<IRSTuple> tuples = new ArrayList<IRSTuple>(1);
        this.init(null);
        VirtualItemClass itemClass = new VirtualItemClass(_decoFilter, _slotRef, _nls.get("virtual_item"));
        itemClasses.add(itemClass);
        items.add(new VirtualItem(_decoFilter, _slotRef, itemClass, _nls.get("virtual_item")));
        itemClassSets.add(new ItemClassSet(null, _slotRef, itemClasses));
        tuples.add(this.createTuple(null, _decoFilter, _slotRef, 0, (ItemClassSet)itemClassSets.get(0), items));
        return this.createDataItem(null, _decoFilter, _slotRef, -1, false, -1, 1, 0, 1, itemClassSets, tuples);
    }

    protected void init(ICatDataItem _dataItemSource) {
    }

    protected Tuple createTuple(ITuple _source, Set<String> _decoFilter, SlotRef _slotRef, int _index, ItemClassSet _itemClassSet, List<IRSItem> _items) {
        return new Tuple(_source, _decoFilter, _slotRef, _index, _itemClassSet, _items);
    }

    protected CatDataItem createDataItem(ICatDataItem _dataItem, Set<String> _decoFilter, SlotRef _slotRef, int _sourceIndex, boolean _mapped, int _colIndex, int _tupleCount, int _start, int _end, List<IRSItemClassSet> _itemClassSets, List<IRSTuple> _tuples) {
        return new CatDataItem(_dataItem, _decoFilter, _slotRef, _sourceIndex, _mapped, _colIndex, _tupleCount, _start, _end, _itemClassSets, _tuples);
    }
}

