/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.Capability;
import com.ibm.vipr.api.ContDomain;
import com.ibm.vipr.api.ICapability;
import com.ibm.vipr.data.DataItemType;
import com.ibm.vipr.data.FormatKind;
import com.ibm.vipr.data.IContDataItem;
import com.ibm.vipr.data.IContDomain;
import com.ibm.vipr.data.IFormatter;
import com.ibm.vipr.info.IContDataItemInfo;
import com.ibm.vipr.info.IItemClassInfo;
import com.ibm.vipr.internal.data.DataContext;
import com.ibm.vipr.internal.data.DataItem;
import com.ibm.vipr.internal.data.DataSet;
import com.ibm.vipr.internal.data.DomainResolver;
import com.ibm.vipr.internal.data.FormatterUtil;
import com.ibm.vipr.internal.data.ItemClass;
import com.ibm.vipr.internal.data.ItemClassSet;
import com.ibm.vipr.renderingservice.api.IRSCapability;
import com.ibm.vipr.renderingservice.data.IRSCatDataItem;
import com.ibm.vipr.renderingservice.data.IRSContDataItem;
import com.ibm.vipr.renderingservice.data.IRSContDomain;
import com.ibm.vipr.renderingservice.data.IRSFormatter;
import com.ibm.vipr.renderingservice.data.IRSItemClass;
import com.ibm.vipr.renderingservice.data.RSDataItemType;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.vizdef.SlotRef;
import java.util.Set;

class ContDataItem
extends DataItem<IContDataItem>
implements IRSContDataItem,
IContDataItemInfo {
    public final ItemClassSet itemClassSet;
    public final ItemClass itemClass;
    private final DomainResolver domain;
    private IRSFormatter mfData;
    private IRSFormatter mfLabel;

    public ContDataItem(IContDataItem _source, Set<String> _decoFilter, SlotRef _slotRef, int _sourceIndex, boolean _mapped, int _colIndex, ItemClass _itemClass, DomainResolver _domain) {
        super(_source, _decoFilter, _slotRef, _sourceIndex, _mapped, _colIndex);
        assert (this.colIndex >= 0);
        this.itemClassSet = ItemClassSet.create(_itemClass);
        this.itemClass = _itemClass;
        this.domain = _domain;
        this.mfData = null;
        this.mfLabel = null;
    }

    public RSDataItemType getType() {
        return RSDataItemType.Cont;
    }

    public String getCaption(RSFormatKind _kind) {
        return this.itemClass.getCaption(_kind);
    }

    public String getSubCaption(RSFormatKind _kind) {
        return this.itemClass.getSubCaption(_kind);
    }

    public String combineCaptions(RSFormatKind _kind) {
        return this.itemClass.combineCaptions(_kind);
    }

    public IRSItemClass getItemClass() {
        return this.itemClass;
    }

    public IRSFormatter getFormatter(RSFormatKind _kind) {
        IFormatter formatter = ((IContDataItem)this.source).getFormatter(ContDataItem.fromRS(_kind));
        if (formatter != null) {
            return FormatterUtil.createHostFormatter(formatter);
        }
        return FormatterUtil.createDefaultFormatter(_kind);
    }

    public IRSContDomain getDomain(IRSCapability _aggregation) {
        IContDomain sourceDomain;
        Capability capability = _aggregation != null ? Capability.fromRS(_aggregation) : null;
        IContDomain iContDomain = sourceDomain = this.source != null ? ((IContDataItem)this.source).getDomain(capability, null) : null;
        if (sourceDomain != null) {
            return ContDomain.from(sourceDomain);
        }
        if (this.domain != null) {
            return this.domain.resolve(this, _aggregation);
        }
        return null;
    }

    public IRSContDomain getDomain() {
        return this.getDomain(null);
    }

    public IRSCatDataItem asCat() {
        return null;
    }

    public IRSContDataItem asCont() {
        return this;
    }

    @Override
    public DataItemType getDataItemInfoType() {
        return DataItemType.Cont;
    }

    @Override
    public String getCaption(FormatKind _kind) {
        return this.getCaption(ContDataItem.toRS(_kind));
    }

    @Override
    public String getSubCaption(FormatKind _kind) {
        return this.getSubCaption(ContDataItem.toRS(_kind));
    }

    @Override
    public String combineCaptions(FormatKind _kind) {
        return this.combineCaptions(ContDataItem.toRS(_kind));
    }

    @Override
    public IItemClassInfo getItemClassInfo() {
        return this.itemClass;
    }

    @Override
    public IFormatter getFormatter(FormatKind _kind) {
        return ((IContDataItem)this.source).getFormatter(_kind);
    }

    @Override
    public IContDomain getDomainInfo(ICapability _aggregation) {
        return ((IContDataItem)this.source).getDomain(_aggregation, null);
    }

    @Override
    public IContDomain getDomainInfo() {
        return ((IContDataItem)this.source).getDomain(null, null);
    }

    ContDataItem clone(Set<String> _decoFilter, SlotRef _slotRef, int _colIndex) {
        return this.clone(_decoFilter, _slotRef, _colIndex, this.domain);
    }

    ContDataItem clone(Set<String> _decoFilter, SlotRef _slotRef, int _colIndex, DomainResolver _domain) {
        return new ContDataItem((IContDataItem)this.source, _decoFilter, _slotRef, this.sourceIndex, this.mapped, _colIndex, this.itemClass.clone(_decoFilter, _slotRef), _domain != null ? _domain : this.domain);
    }

    String missingCaption(RSFormatKind _kind) {
        IRSFormatter formatter;
        IRSFormatter iRSFormatter = formatter = _kind == RSFormatKind.Data ? this.mfData : this.mfLabel;
        if (formatter == null) {
            formatter = this.getFormatter(_kind);
            if (_kind == RSFormatKind.Data) {
                this.mfData = formatter;
            } else {
                this.mfLabel = formatter;
            }
        }
        return formatter.format(null);
    }

    @Override
    void applyContext(DataContext _context, DataSet _dataSet) {
        super.applyContext(_context, _dataSet);
        this.itemClassSet.applyContext(_context, this);
    }
}

