/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.data.IDataPoint;
import com.ibm.vipr.info.IDataPointInfo;
import com.ibm.vipr.info.IDatumInfo;
import com.ibm.vipr.info.InfoType;
import com.ibm.vipr.internal.data.CatDataItem;
import com.ibm.vipr.internal.data.ContDataItem;
import com.ibm.vipr.internal.data.DataContext;
import com.ibm.vipr.internal.data.DataItem;
import com.ibm.vipr.internal.data.DataSet;
import com.ibm.vipr.internal.data.Decorated;
import com.ibm.vipr.internal.data.Slot;
import com.ibm.vipr.internal.data.Tuple;
import com.ibm.vipr.internal.data.Value;
import com.ibm.vipr.renderingservice.api.IRSDataContext;
import com.ibm.vipr.renderingservice.data.IRSDataItem;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDatum;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.RSDataItemType;
import com.ibm.vipr.renderingservice.data.RSSlotType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class DataPoint
extends Decorated<IDataPoint>
implements IRSDataPoint,
IDataPointInfo {
    final List<DataItem<?>> dataItems;
    final List<Slot> slots;
    public final int index;
    public final long ordinal;
    public final int offset;
    private final List<IRSDatum> rowData;
    private final int rowStart;
    private String key;
    private String keyS;

    public DataPoint(IDataPoint _source, Set<String> _decoFilter, List<DataItem<?>> _dataItems, List<Slot> _slots, int _index, long _ordinal, List<IRSDatum> _rowData, int _rowStart, int _offset) {
        super(_source, _decoFilter);
        this.dataItems = _dataItems;
        this.slots = _slots;
        this.index = _index;
        this.ordinal = _ordinal;
        this.rowData = _rowData;
        this.rowStart = _rowStart;
        this.offset = _offset;
        this.key = null;
        this.keyS = null;
    }

    public DataSet getDataSet(IRSDataContext _context) {
        return (DataSet)DataContext.getOwner(_context, this);
    }

    public String getKey() {
        return this.getKey(true);
    }

    @Override
    public String getKey(boolean _sorted) {
        String key;
        String string = key = _sorted ? this.keyS : this.key;
        if (key == null) {
            ArrayList<String> parts = new ArrayList<String>();
            for (Slot slot : this.slots) {
                if (!slot.mapped || !slot.forViz) continue;
                for (IRSDataItem dataItem : slot.dataItems) {
                    if (dataItem.getType() != RSDataItemType.Cat) continue;
                    ((Tuple)this.datum(dataItem)).addKeyParts(parts);
                }
            }
            if (parts.size() < 1) {
                parts.add(Long.toString(this.ordinal));
            } else if (_sorted) {
                parts.sort((a, b) -> a.compareTo((String)b));
            }
            if (this.offset > 0) {
                parts.add("[" + Integer.toString(this.offset) + "]");
            }
            key = Tuple.joinKey(parts);
            if (_sorted) {
                this.keyS = key;
            } else {
                this.key = key;
            }
        }
        return key;
    }

    public List<IRSDatum> all(String _slotName) {
        for (Slot slot : this.slots) {
            if (!slot.slotRef.name.equals(_slotName)) continue;
            return this.all(slot);
        }
        return null;
    }

    public List<IRSDatum> all(IRSSlot _slot) {
        ArrayList<IRSDatum> result = null;
        if (_slot != null) {
            result = new ArrayList<IRSDatum>(_slot.getDataItemCount());
            for (IRSDataItem dataItem : _slot.getDataItems()) {
                result.add(this.datum(dataItem));
            }
        }
        return result;
    }

    public IRSDatum get(String _slotName, int _dataItemIndex) {
        for (Slot slot : this.slots) {
            if (!slot.slotRef.name.equals(_slotName)) continue;
            return this.get(slot, _dataItemIndex);
        }
        return null;
    }

    public IRSDatum get(IRSSlot _slot, int _dataItemIndex) {
        IRSDatum result = null;
        if (_slot != null && _dataItemIndex >= 0 && _dataItemIndex < _slot.getDataItemCount()) {
            result = this.datum(_slot.getDataItem(_dataItemIndex));
        }
        return result;
    }

    public IRSDatum get(String _slotName) {
        return this.get(_slotName, 0);
    }

    public IRSDatum get(IRSSlot _slot) {
        return this.get(_slot, 0);
    }

    @Override
    public InfoType getInfoType() {
        return InfoType.DataPoint;
    }

    @Override
    public List<IDatumInfo> getRowInfo() {
        int len;
        if (this.index < 0) {
            return null;
        }
        for (len = this.dataItems.size(); len > 0 && this.dataItems.get(len - 1) != null && this.dataItems.get((int)(len - 1)).source == null; --len) {
        }
        ArrayList<IDatumInfo> result = new ArrayList<IDatumInfo>(len);
        for (int i = 0; i < len; ++i) {
            result.add((IDatumInfo)this.datum(this.dataItems.get(i)));
        }
        return result;
    }

    @Override
    public List<IDatumInfo> allInfo(String _slotName) {
        return DataPoint.toInfo(this.all(_slotName));
    }

    @Override
    public IDatumInfo getInfo(String _slotName) {
        return (IDatumInfo)this.get(_slotName);
    }

    @Override
    public IDatumInfo getInfo(String _slotName, int _dataItemIndex) {
        return (IDatumInfo)this.get(_slotName, _dataItemIndex);
    }

    IRSDatum datum(IRSDataItem _dataItem) {
        if (_dataItem == null) {
            return null;
        }
        int colIndex = ((DataItem)_dataItem).colIndex;
        return colIndex < 0 ? ((CatDataItem)_dataItem).getTuple(((CatDataItem)_dataItem).start) : this.rowData.get(this.rowStart + colIndex);
    }

    void applyContext(DataContext _context, DataSet _dataSet) {
        if (_dataSet != null) {
            _context.setOwner(this, _dataSet);
        }
        if (_context != DataContext.vipr) {
            for (Slot slot : this.slots) {
                if (slot.getType() == RSSlotType.Cat) continue;
                for (IRSDataItem rsDataItem : slot.dataItems) {
                    if (rsDataItem.getType() != RSDataItemType.Cont) continue;
                    ((Value)this.datum(rsDataItem)).applyContext(_context, (ContDataItem)rsDataItem);
                }
            }
        }
    }
}

