/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.api.ICapability;
import com.ibm.vipr.data.IDataSet;
import com.ibm.vipr.data.IDataSetMapping;
import com.ibm.vipr.info.ICatDataItemInfo;
import com.ibm.vipr.info.IDataItemInfo;
import com.ibm.vipr.info.IDataPointInfo;
import com.ibm.vipr.info.IDataSetInfo;
import com.ibm.vipr.info.ISlotInfo;
import com.ibm.vipr.info.InfoType;
import com.ibm.vipr.internal.data.CatDataItem;
import com.ibm.vipr.internal.data.ContDataItem;
import com.ibm.vipr.internal.data.DataContext;
import com.ibm.vipr.internal.data.DataItem;
import com.ibm.vipr.internal.data.DataPoint;
import com.ibm.vipr.internal.data.Decorated;
import com.ibm.vipr.internal.data.DomainResolver;
import com.ibm.vipr.internal.data.Slot;
import com.ibm.vipr.internal.data.TruncationFactory;
import com.ibm.vipr.internal.data.Tuple;
import com.ibm.vipr.internal.data.VIPRData;
import com.ibm.vipr.internal.data.Value;
import com.ibm.vipr.renderingservice.data.IRSDataItem;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.data.IRSDatum;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.RSDataItemType;
import com.ibm.vipr.vizdef.DataSetDef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DataSet
extends Decorated<IDataSet>
implements IRSDataSet,
IDataSetInfo {
    private final DataSetDef dataSetDef;
    private final List<Slot> slots;
    private final List<DataItem<?>> dataItems;
    private final List<IRSDataPoint> dataPoints;
    private final IDataSetMapping mapping;
    private final boolean overflow;
    private final boolean emptied;
    private final Map<String, Boolean> dataPointDecorationMap;

    private static ICapability findLimit(List<ICapability> _capabilities, String _slotName) {
        if (_capabilities != null) {
            for (ICapability capability : _capabilities) {
                if (capability.getName() != "limit" || capability.getSlot() != _slotName) continue;
                return capability;
            }
        }
        return null;
    }

    private static int readLimit(ICapability _capability) {
        Map<String, Object> attributes;
        Map<String, Object> map = attributes = _capability == null ? null : _capability.getAttributes();
        if (attributes == null || !attributes.containsKey("n")) {
            return 0;
        }
        return ((Number)attributes.get("n")).intValue();
    }

    public DataSet(IDataSet _source, Set<String> _decoFilter, DataSetDef _dataSetDef, List<Slot> _slots, List<DataItem<?>> _dataItems, List<IRSDataPoint> _dataPoints, IDataSetMapping _mapping, boolean _overflow, boolean _emptied, Map<String, Boolean> _dataPointDecorationMap) {
        super(_source, _decoFilter);
        this.dataSetDef = _dataSetDef;
        this.slots = Collections.unmodifiableList(_slots);
        this.dataItems = _dataItems;
        this.dataPoints = _dataPoints;
        this.mapping = _mapping;
        this.overflow = _overflow;
        this.emptied = _emptied;
        this.dataPointDecorationMap = _dataPointDecorationMap != null ? _dataPointDecorationMap : new HashMap();
    }

    @Override
    public String getName() {
        return this.dataSetDef.name;
    }

    @Override
    public String getCaption() {
        return this.dataSetDef.caption;
    }

    public List<IRSDataPoint> getDataPoints() {
        return this.dataPoints;
    }

    public IRSSlot getSlot(String _name) {
        for (IRSSlot iRSSlot : this.slots) {
            if (!iRSSlot.getName().equals(_name)) continue;
            return iRSSlot;
        }
        return null;
    }

    @Override
    public boolean hasValues() {
        for (DataItem<?> dataItem : this.dataItems) {
            if (dataItem == null || !dataItem.mapped || dataItem.getType() != RSDataItemType.Cont) continue;
            return true;
        }
        return false;
    }

    public boolean hasDecorationOnDataPoints(String _decoration) {
        if (this.dataPointDecorationMap.containsKey(_decoration)) {
            return this.dataPointDecorationMap.get(_decoration);
        }
        boolean found = false;
        if (!this.decoFilter.contains(_decoration)) {
            IRSDataPoint dataPoint;
            Iterator<IRSDataPoint> iterator = this.dataPoints.iterator();
            while (iterator.hasNext() && !(found = (dataPoint = iterator.next()).hasDecoration(_decoration))) {
            }
        }
        this.dataPointDecorationMap.put(_decoration, found);
        return found;
    }

    public void setDataPointDecorationsDirty() {
        this.dataPointDecorationMap.clear();
    }

    @Override
    public InfoType getInfoType() {
        return InfoType.DataSet;
    }

    @Override
    public IDataSetMapping getMapping() {
        return this.mapping;
    }

    @Override
    public DataSetDef getDataSetDef() {
        return this.dataSetDef;
    }

    @Override
    public List<IDataItemInfo> getDataItemInfos() {
        return DataSet.toInfo(this.dataItems);
    }

    @Override
    public List<IDataPointInfo> getDataPointInfos() {
        return DataSet.toInfo(this.dataPoints);
    }

    @Override
    public ISlotInfo getSlotInfo(String _name) {
        return (ISlotInfo)this.getSlot(_name);
    }

    DataSet empty() {
        if (this.emptied) {
            return this;
        }
        return new DataSet((IDataSet)this.source, this.decoFilter, this.dataSetDef, this.slots, this.dataItems, new ArrayList<IRSDataPoint>(0), this.mapping, false, true, this.dataPointDecorationMap);
    }

    List<DataSet> slice(List<String> _slotNames, List<ICatDataItemInfo> _sliceItems, List<ICapability> _capabilities, TruncationFactory _truncationFactory) {
        boolean generateMissing = !this.dataSetDef.suppressMissing;
        ArrayList<CatDataItem> ordinalItems = new ArrayList<CatDataItem>();
        ArrayList<CatDataItem> sliceItems = new ArrayList<CatDataItem>();
        ArrayList<ContDataItem> contDataItems = null;
        int colDataItemCount = 0;
        long vizVolume = 1L;
        int sliceVolume = 1;
        boolean slotTruncation = false;
        List<Slot> slots = this.slots;
        if (generateMissing) {
            contDataItems = new ArrayList<ContDataItem>();
            for (DataItem<?> dataItem : this.dataItems) {
                if (dataItem == null) continue;
                if (!dataItem.mapped && dataItem.getType() == RSDataItemType.Cont) {
                    contDataItems.add((ContDataItem)dataItem);
                }
                if (dataItem.colIndex < colDataItemCount) continue;
                colDataItemCount = dataItem.colIndex + 1;
            }
        }
        int slotCount = slots.size();
        for (int iSlot = 0; iSlot < slotCount; ++iSlot) {
            Slot slot = slots.get(iSlot);
            List<IRSDataItem> slotDataItems = slot.getDataItems();
            ICapability capability = DataSet.findLimit(_capabilities, slot.getName());
            int limit = DataSet.readLimit(capability);
            boolean isSlice = _slotNames != null && _slotNames.contains(slot.getName());
            int dataItemCount = slotDataItems.size();
            for (int iDataItem = 0; iDataItem < dataItemCount; ++iDataItem) {
                DataItem dataItem = (DataItem)slotDataItems.get(iDataItem);
                if (dataItem != null && dataItem.getType() == RSDataItemType.Cat && dataItem.sourceIndex >= 0) {
                    CatDataItem catDataItem = (CatDataItem)dataItem;
                    int size = catDataItem.end - catDataItem.start;
                    if (size > 1) {
                        if (limit > 0 && size > limit) {
                            if (slotDataItems == slot.getDataItems()) {
                                slotDataItems = new ArrayList<IRSDataItem>(slotDataItems);
                            }
                            catDataItem = catDataItem.clone(this.decoFilter, slot.getSlotRef(), dataItem.colIndex, limit);
                            slotTruncation = true;
                            slotDataItems.set(iDataItem, catDataItem);
                            _truncationFactory.addSlot(capability, limit, size, slot.slotRef, catDataItem);
                            size = limit;
                        }
                        if (!isSlice) {
                            ordinalItems.add(catDataItem);
                        }
                        if (slot.forViz) {
                            vizVolume *= (long)size;
                        }
                        if (isSlice && vizVolume > 0L) {
                            sliceVolume *= size;
                        }
                    } else if (size < 1) {
                        vizVolume = 0L;
                        sliceVolume = 1;
                    }
                    if (isSlice) {
                        sliceItems.add(catDataItem);
                    }
                }
                if (dataItem == null || !generateMissing) continue;
                if (dataItem.getType() == RSDataItemType.Cont) {
                    contDataItems.add((ContDataItem)dataItem);
                }
                if (dataItem.colIndex < colDataItemCount) continue;
                colDataItemCount = dataItem.colIndex + 1;
            }
            if (slotDataItems == slot.getDataItems()) continue;
            slot = slot.clone(slotDataItems);
            if (slots == this.slots) {
                slots = new ArrayList<Slot>(slots);
            }
            slots.set(iSlot, slot);
        }
        if (sliceItems.size() > 0 && _sliceItems.size() < 1) {
            _sliceItems.addAll(sliceItems);
        }
        int vizItemCount = ordinalItems.size();
        for (DataItem<?> dataItem : this.dataItems) {
            if (dataItem == null || dataItem.mapped || dataItem.getType() != RSDataItemType.Cat) continue;
            CatDataItem catDataItem = (CatDataItem)dataItem;
            int size = catDataItem.end - catDataItem.start;
            if (size > 1) {
                ordinalItems.add(catDataItem);
                continue;
            }
            if (size >= 1) continue;
            vizVolume = 0L;
            sliceVolume = 1;
        }
        int[] offsets = DomainResolver.buildOffsets(ordinalItems, false);
        int ordinalItemCount = offsets.length;
        int[] sliceOffsets = DomainResolver.buildOffsets(sliceItems, false);
        int sliceItemCount = sliceOffsets.length;
        ArrayList<IRSDataPoint> slicedDataPoints = null;
        int slicedDataPointCount = 0;
        ArrayList dataPointsPerSlice = new ArrayList(sliceVolume);
        List<IRSDataPoint> allPoints = this.dataPoints;
        int dataPointCount = allPoints.size();
        ArrayList<DataSet> slices = new ArrayList<DataSet>(sliceVolume);
        ICapability capability = DataSet.findLimit(_capabilities, null);
        int limit = DataSet.readLimit(capability);
        boolean dataPointTruncation = false;
        boolean uniqueDataPoints = generateMissing || this.dataSetDef.uniqueDataPoints;
        boolean unaggregatedTruncation = false;
        if (!(sliceVolume != 1 && !this.emptied || generateMissing || slotTruncation || this.overflow)) {
            for (int iDataSet = 0; iDataSet < sliceVolume; ++iDataSet) {
                slices.add(this);
            }
            return slices;
        }
        if (limit < 1) {
            limit = generateMissing ? (int)vizVolume : dataPointCount;
        } else if (generateMissing && (long)limit > vizVolume) {
            limit = (int)vizVolume;
        }
        if (generateMissing && vizVolume > (long)limit) {
            _truncationFactory.addData(capability, limit, vizVolume);
            dataPointTruncation = true;
        }
        for (int iDataSet = 0; iDataSet < sliceVolume; ++iDataSet) {
            dataPointsPerSlice.add(generateMissing ? DomainResolver.createFixed(limit) : new ArrayList());
        }
        for (IRSDataPoint rsDataPoint : this.dataPoints) {
            int tupleIndex;
            CatDataItem catDataItem;
            int iDataItem;
            DataPoint dataPoint = (DataPoint)rsDataPoint;
            boolean include = true;
            int sliceOrdinal = 0;
            int localOrdinal = 0;
            if (uniqueDataPoints && dataPoint.offset > 0) {
                include = false;
                if (!unaggregatedTruncation) {
                    _truncationFactory.addUnaggregated();
                    unaggregatedTruncation = true;
                }
            }
            for (iDataItem = 0; include && iDataItem < ordinalItemCount; ++iDataItem) {
                catDataItem = (CatDataItem)ordinalItems.get(iDataItem);
                tupleIndex = ((Tuple)dataPoint.datum((IRSDataItem)catDataItem)).index;
                if (tupleIndex < catDataItem.end) {
                    localOrdinal += (tupleIndex - catDataItem.start) * offsets[iDataItem];
                    continue;
                }
                include = false;
            }
            if (include) {
                include = (long)localOrdinal < (generateMissing ? (long)limit : vizVolume);
            }
            for (iDataItem = 0; include && iDataItem < sliceItemCount; ++iDataItem) {
                catDataItem = (CatDataItem)sliceItems.get(iDataItem);
                tupleIndex = ((Tuple)dataPoint.datum((IRSDataItem)catDataItem)).index;
                if (tupleIndex < catDataItem.end) {
                    sliceOrdinal += (tupleIndex - catDataItem.start) * sliceOffsets[iDataItem];
                    continue;
                }
                include = false;
            }
            if (!include) continue;
            List dataPoints = (List)dataPointsPerSlice.get(sliceOrdinal);
            if (generateMissing) {
                dataPoints.set(localOrdinal, dataPoint);
                ++slicedDataPointCount;
                continue;
            }
            if (dataPoints.size() < limit) {
                dataPoints.add(dataPoint);
                ++slicedDataPointCount;
                continue;
            }
            if (dataPointTruncation) continue;
            _truncationFactory.addData(capability, limit, -1L);
            dataPointTruncation = true;
        }
        if (slotTruncation || dataPointTruncation) {
            int slotCount2 = this.slots.size();
            if (slots == this.slots) {
                slots = new ArrayList<Slot>(slots);
            }
            List<DataItem<?>> dataItems = DomainResolver.createFixed(this.dataItems.size());
            slicedDataPoints = new ArrayList<IRSDataPoint>(slicedDataPointCount);
            DomainResolver resolver = new DomainResolver(dataItems, slicedDataPoints, slots);
            for (int iSlot = 0; iSlot < slotCount2; ++iSlot) {
                Slot slot = slots.get(iSlot);
                List<IRSDataItem> slotDataItems = slot.dataItems;
                int dataItemCount = slotDataItems.size();
                for (int iDataItem = 0; iDataItem < dataItemCount; ++iDataItem) {
                    DataItem dataItem = (DataItem)slotDataItems.get(iDataItem);
                    if (dataItem.getType() == RSDataItemType.Cont) {
                        dataItem = ((ContDataItem)dataItem).clone(this.decoFilter, slot.slotRef, dataItem.colIndex, resolver);
                        if (slotDataItems == slot.dataItems) {
                            slotDataItems = new ArrayList<IRSDataItem>(slotDataItems);
                        }
                        slotDataItems.set(iDataItem, dataItem);
                    }
                    if (dataItems.get(dataItem.sourceIndex) != null) continue;
                    dataItems.set(dataItem.sourceIndex, dataItem);
                }
                if (slotDataItems == slot.dataItems) continue;
                slots.set(iSlot, slot.clone(slotDataItems));
            }
        }
        if (generateMissing) {
            ArrayList<IRSDatum> missingRowData = new ArrayList<IRSDatum>();
            IRSDatum[] missingRow = new IRSDatum[colDataItemCount];
            for (CatDataItem catDataItem : ordinalItems) {
                missingRow[catDataItem.colIndex] = catDataItem.getTuple(catDataItem.start);
            }
            for (ContDataItem contDataItem : contDataItems) {
                missingRow[contDataItem.colIndex] = new Value(null, this.decoFilter, contDataItem.slotRef, contDataItem);
            }
            int iDataSet = 0;
            int sliceOrdinal = 0;
            while (iDataSet < sliceVolume) {
                List dataPoints = (List)dataPointsPerSlice.get(iDataSet);
                for (int iDataItem = sliceItemCount - 1; iDataItem >= 0; --iDataItem) {
                    CatDataItem catDataItem = (CatDataItem)sliceItems.get(iDataItem);
                    int size = sliceOffsets[iDataItem];
                    int tupleIndex = 0;
                    if (size > 1) {
                        tupleIndex = sliceOrdinal / size;
                        sliceOrdinal %= size;
                    } else if (size > 0) {
                        tupleIndex = sliceOrdinal;
                        sliceOrdinal = 0;
                    }
                    missingRow[catDataItem.colIndex] = (IRSDatum)catDataItem.tuples.get(tupleIndex);
                }
                int iDataPoint = 0;
                int localOrdinal = 0;
                while (iDataPoint < limit) {
                    if (dataPoints.get(iDataPoint) == null) {
                        for (int iDataItem = vizItemCount - 1; iDataItem >= 0; --iDataItem) {
                            CatDataItem catDataItem = (CatDataItem)ordinalItems.get(iDataItem);
                            int size = offsets[iDataItem];
                            int tupleIndex = 0;
                            if (size > 1) {
                                tupleIndex = localOrdinal / size;
                                localOrdinal %= size;
                            } else if (size > 0) {
                                tupleIndex = localOrdinal;
                                localOrdinal = 0;
                            }
                            missingRow[catDataItem.colIndex] = catDataItem.getTuple(tupleIndex + catDataItem.start);
                        }
                        int missingRowStart = missingRowData.size();
                        for (IRSDatum datum : missingRow) {
                            missingRowData.add(datum);
                        }
                        dataPoints.set(iDataPoint, new DataPoint(null, this.decoFilter, this.dataItems, slots, -1, iDataPoint, missingRowData, missingRowStart, 0));
                    }
                    localOrdinal = ++iDataPoint;
                }
                sliceOrdinal = ++iDataSet;
            }
        }
        for (int iDataSet = 0; iDataSet < sliceVolume; ++iDataSet) {
            List dataPoints = (List)dataPointsPerSlice.get(iDataSet);
            dataPointCount = dataPoints.size();
            if (slicedDataPoints != null && dataPointCount > 0) {
                for (int iDataPoint = 0; iDataPoint < dataPointCount; ++iDataPoint) {
                    DataPoint dataPoint = (DataPoint)dataPoints.get(iDataPoint);
                    if (generateMissing && dataPoint.source == null) continue;
                    slicedDataPoints.add(dataPoint);
                }
            }
            slices.add(new DataSet((IDataSet)this.source, this.decoFilter, this.dataSetDef, slots, this.dataItems, dataPoints, this.mapping, false, this.emptied, this.dataPointDecorationMap));
        }
        return slices;
    }

    void applyContext(DataContext _context, VIPRData _viprData) {
        for (Slot slot : this.slots) {
            for (IRSDataItem rsDataItem : slot.dataItems) {
                assert (rsDataItem != null);
                ((DataItem)rsDataItem).applyContext(_context, this);
            }
        }
        for (DataItem dataItem : this.dataItems) {
            if (dataItem == null || dataItem.mapped) continue;
            dataItem.applyContext(_context, this);
        }
        for (IRSDataPoint iRSDataPoint : this.dataPoints) {
            assert (iRSDataPoint != null);
            ((DataPoint)iRSDataPoint).applyContext(_context, this);
        }
    }
}

