/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.data.DataItemType;
import com.ibm.vipr.data.ICatDataItem;
import com.ibm.vipr.data.IContDataItem;
import com.ibm.vipr.data.IDataItem;
import com.ibm.vipr.data.IDataPoint;
import com.ibm.vipr.data.IDataSet;
import com.ibm.vipr.data.IDataSetMapping;
import com.ibm.vipr.data.IGeoDataItem;
import com.ibm.vipr.data.ITemporalDataItem;
import com.ibm.vipr.internal.data.CatDataItem;
import com.ibm.vipr.internal.data.CatDataItemFactory;
import com.ibm.vipr.internal.data.ContDataItem;
import com.ibm.vipr.internal.data.ContDataItemFactory;
import com.ibm.vipr.internal.data.DataItem;
import com.ibm.vipr.internal.data.DataPoint;
import com.ibm.vipr.internal.data.DataSet;
import com.ibm.vipr.internal.data.DomainResolver;
import com.ibm.vipr.internal.data.GeoDataItemFactory;
import com.ibm.vipr.internal.data.GeoSegmentDataItemFactory;
import com.ibm.vipr.internal.data.Slot;
import com.ibm.vipr.internal.data.TemporalDataItemFactory;
import com.ibm.vipr.internal.data.Tuple;
import com.ibm.vipr.internal.data.Value;
import com.ibm.vipr.internal.util.VIPRNls;
import com.ibm.vipr.renderingservice.data.IRSDataItem;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDatum;
import com.ibm.vipr.renderingservice.data.RSDataItemType;
import com.ibm.vipr.vizdef.DataSetDef;
import com.ibm.vipr.vizdef.GeoSegmentRef;
import com.ibm.vipr.vizdef.GeoSlotRef;
import com.ibm.vipr.vizdef.SlotRef;
import com.ibm.vipr.vizdef.SlotSubType;
import com.ibm.vipr.vizdef.SlotType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

class DataSetFactory {
    private static final ContDataItemFactory difContinuous = new ContDataItemFactory();
    private static final CatDataItemFactory difCategorical = new CatDataItemFactory();
    private static final GeoDataItemFactory difGeoSpatial = new GeoDataItemFactory();
    private static final TemporalDataItemFactory difTemporal = new TemporalDataItemFactory();

    private static int getCount(Iterable<IDataPoint> _iterable) {
        if (_iterable instanceof Collection) {
            return ((Collection)_iterable).size();
        }
        return -1;
    }

    private static Iterable<IDataPoint> toArrayList(Iterable<IDataPoint> _iterable) {
        ArrayList<IDataPoint> result = new ArrayList<IDataPoint>();
        for (IDataPoint dataPoint : _iterable) {
            result.add(dataPoint);
        }
        return result;
    }

    private static List<SlotRef> gatherSlots(DataSetDef _hostDataSetDef, DataSetDef _dataSetDef) {
        ArrayList<SlotRef> dataSetSlots = new ArrayList<SlotRef>(_dataSetDef.slots.size() + 2);
        for (SlotRef slotRef : _dataSetDef.slots) {
            dataSetSlots.add(slotRef);
        }
        for (SlotRef slotRef : _hostDataSetDef.slots) {
            if (_dataSetDef.hasSlot(slotRef.name)) continue;
            dataSetSlots.add(slotRef);
        }
        return dataSetSlots;
    }

    private static int validateDataItemIndex(Integer _index, SlotType _slotType, List<IDataItem> _dataItems) {
        int iDataItem;
        int n = iDataItem = _index == null ? -1 : _index;
        if (iDataItem < 0) {
            return -1;
        }
        if (iDataItem >= _dataItems.size()) {
            throw new RuntimeException("Invalid DataItem index: " + iDataItem);
        }
        IDataItem dataItem = _dataItems.get(iDataItem);
        if (dataItem == null) {
            throw new RuntimeException("Cannot map to null DataItem at index: " + iDataItem);
        }
        if (_slotType == SlotType.Cat && dataItem.getType() != DataItemType.Cat || _slotType == SlotType.Cont && dataItem.getType() != DataItemType.Cont) {
            throw new Error("Cannot map a " + (Object)((Object)dataItem.getType()) + " dataItem to a " + (Object)((Object)_slotType) + " slot");
        }
        return iDataItem;
    }

    private static boolean hasSubType(SlotSubType _subType, IDataItem _dataItem) {
        if (_subType == SlotSubType.GeoSpatial && _dataItem instanceof IGeoDataItem) {
            return true;
        }
        return _subType == SlotSubType.Temporal && _dataItem instanceof ITemporalDataItem;
    }

    private static SlotSubType getSubType(List<SlotRef> _slotRefs, IDataItem _dataItem) {
        int len;
        SlotSubType subType = SlotSubType.None;
        int n = len = _slotRefs != null ? _slotRefs.size() : 0;
        for (int i = 0; i < len && subType == SlotSubType.None; ++i) {
            SlotRef slotRef = _slotRefs.get(i);
            if (!(slotRef instanceof GeoSegmentRef || slotRef.subTypeOptional && !DataSetFactory.hasSubType(slotRef.subType, _dataItem))) {
                subType = slotRef.subType;
            }
            if (subType != null) continue;
            subType = SlotSubType.None;
        }
        return subType;
    }

    private static CatDataItemFactory determineFactory(List<SlotRef> _slotRefs, IDataItem _dataItem) {
        switch (DataSetFactory.getSubType(_slotRefs, _dataItem)) {
            case GeoSpatial: {
                return difGeoSpatial;
            }
            case Temporal: {
                return difTemporal;
            }
        }
        return difCategorical;
    }

    private static Slot createSlot(Set<String> _decoFilter, SlotRef _slotRef, List<Integer> _mapping, List<DataItem<?>> _dataItems, List<DataItem<?>> _colDataItems, boolean _forViz, VIPRNls _nls) {
        ArrayList<IRSDataItem> dataItems;
        boolean mapped;
        int dataItemCount = _mapping.size();
        boolean bl = mapped = dataItemCount > 0;
        if (mapped) {
            dataItems = new ArrayList<IRSDataItem>(dataItemCount);
            for (int iDataItem = 0; iDataItem < dataItemCount; ++iDataItem) {
                DataItem<?> dataItem = _dataItems.get(_mapping.get(iDataItem));
                if (dataItem.slotRef != _slotRef) {
                    dataItem = dataItem.clone(_decoFilter, _slotRef, dataItem.colIndex < 0 ? dataItem.colIndex : _colDataItems.size());
                    if (dataItem.colIndex >= 0) {
                        _colDataItems.add(dataItem);
                    }
                }
                dataItems.add(dataItem);
            }
        } else {
            dataItems = new ArrayList(_slotRef.type == SlotType.Cat ? 1 : 0);
            if (_slotRef.type == SlotType.Cat) {
                dataItems.add(difCategorical.virtual(_decoFilter, _slotRef, _nls));
            }
        }
        return new Slot(_slotRef, mapped, dataItems, _forViz);
    }

    private static List<DataItem<?>> sortBySlot(List<DataItem<?>> _dataItems, List<Slot> _slots) {
        int dataItemCount = _dataItems.size();
        ArrayList dataItemsSorted = new ArrayList(_dataItems.size());
        for (Slot slot : _slots) {
            for (IRSDataItem rsDataItem : slot.dataItems) {
                DataItem dataItem = (DataItem)rsDataItem;
                if (dataItem.colIndex < 0) continue;
                dataItemsSorted.add(dataItem);
            }
        }
        if (dataItemsSorted.size() < dataItemCount) {
            for (DataItem dataItem : _dataItems) {
                if (dataItemsSorted.indexOf(dataItem) >= 0) continue;
                dataItemsSorted.add(dataItem);
            }
        }
        if (dataItemsSorted.size() != dataItemCount) {
            throw new Error("Data processing error: not all data items are resolved");
        }
        return dataItemsSorted;
    }

    private static void addReverseMapping(List<List<SlotRef>> _reverseMappings, int _dataItemIndex, SlotRef _slotRef) {
        List<SlotRef> mapping = _reverseMappings.get(_dataItemIndex);
        if (mapping == null) {
            mapping = new ArrayList<SlotRef>();
            _reverseMappings.set(_dataItemIndex, mapping);
        }
        mapping.add(_slotRef);
    }

    static List<List<Integer>> createMappings(DataSetDef _hostDataSetDef, List<SlotRef> _slots, IDataSetMapping _mapping, List<IDataItem> _dataItems, Set<String> _decoFilter, List<List<SlotRef>> _reverseMappings) {
        int slotCount = _slots.size();
        int dataItemCount = _dataItems.size();
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>(slotCount);
        for (int slotIndex = 0; slotIndex < slotCount; ++slotIndex) {
            SlotRef slotRef = _slots.get(slotIndex);
            GeoSlotRef geoSlotRef = slotRef.subType == SlotSubType.GeoSpatial ? (GeoSlotRef)slotRef : null;
            int segmentCount = geoSlotRef == null ? 0 : geoSlotRef.segments.size();
            int mappedCount = 0;
            ArrayList<Integer> mapping = null;
            if (_mapping != null) {
                int dataItemIndex;
                int sourceItemCount;
                List<Integer> source = null;
                if (_hostDataSetDef.hasSlot(slotRef.name)) {
                    source = _mapping.getDataItemsFor(slotRef);
                }
                int n = sourceItemCount = source == null ? 0 : source.size();
                if (!slotRef.multiDataItem && sourceItemCount > 1) {
                    throw new Error("Multiple DataItems mapped to slot " + slotRef.name + ", which is not allowed");
                }
                if (sourceItemCount < 1 && segmentCount > 0) {
                    ArrayList<Integer> segmentMappings = new ArrayList<Integer>(segmentCount);
                    for (int iSegment = 0; iSegment < segmentCount; ++iSegment) {
                        GeoSegmentRef segmentRef = geoSlotRef.segments.get(iSegment);
                        dataItemIndex = -1;
                        source = _mapping.getDataItemsFor(segmentRef);
                        int n2 = sourceItemCount = source == null ? 0 : source.size();
                        if (sourceItemCount > 1) {
                            throw new Error("Only one dataItem may be mapped to segment " + segmentRef.name);
                        }
                        if (sourceItemCount > 0) {
                            dataItemIndex = DataSetFactory.validateDataItemIndex(source.get(0), segmentRef.type, _dataItems);
                        }
                        if (dataItemIndex >= 0) {
                            segmentMappings.add(dataItemIndex);
                            DataSetFactory.addReverseMapping(_reverseMappings, dataItemIndex, segmentRef);
                            if (mappedCount >= 1 || "caption".equals((Object)segmentRef.part)) continue;
                            mappedCount = 1;
                            continue;
                        }
                        if (!segmentRef.optional) {
                            throw new Error("Cannot leave segment " + segmentRef.name + " unmapped, it is not optional");
                        }
                        segmentMappings.add(null);
                    }
                    mapping = new ArrayList(mappedCount);
                    if (mappedCount > 0) {
                        dataItemIndex = _dataItems.size();
                        mapping.add(dataItemIndex);
                        _dataItems.add(new GeoSegmentDataItemFactory(dataItemIndex, _decoFilter, geoSlotRef, segmentMappings));
                    }
                } else {
                    mapping = new ArrayList(sourceItemCount);
                    for (int sourceIndex = 0; sourceIndex < sourceItemCount; ++sourceIndex) {
                        dataItemIndex = DataSetFactory.validateDataItemIndex(source.get(sourceIndex), slotRef.type, _dataItems);
                        if (dataItemIndex < 0) continue;
                        mapping.add(dataItemIndex);
                        ++mappedCount;
                        DataSetFactory.addReverseMapping(_reverseMappings, dataItemIndex, slotRef);
                    }
                }
            } else if (slotIndex < dataItemCount && _dataItems.get(slotIndex) != null) {
                mapping = new ArrayList<Integer>(1);
                mapping.add(slotIndex);
                ++mappedCount;
                DataSetFactory.addReverseMapping(_reverseMappings, slotIndex, slotRef);
            }
            if (mappedCount < 1 && !slotRef.optional) {
                throw new Error("Cannot leave slot " + slotRef.name + " unmapped, it is not optional");
            }
            result.add(mapping != null ? mapping : new ArrayList<Integer>(0));
        }
        return result;
    }

    private static int compareDataPoint(IRSDataPoint _a, IRSDataPoint _b) {
        DataPoint a = (DataPoint)_a;
        DataPoint b = (DataPoint)_b;
        return a.ordinal == b.ordinal ? a.offset - b.offset : (a.ordinal < b.ordinal ? -1 : 1);
    }

    public DataSet process(DataSetDef _hostDataSetDef, DataSetDef _dataSetDef, IDataSet _dataSetSource, IDataSetMapping _mapping, Set<String> _decoFilter, VIPRNls _nls) {
        int size;
        CatDataItem catDataItem;
        int iDataItem;
        List<SlotRef> dataSetSlots = DataSetFactory.gatherSlots(_hostDataSetDef, _dataSetDef);
        int slotCount = dataSetSlots.size();
        ArrayList<Slot> slots = new ArrayList<Slot>(slotCount);
        DomainResolver domain = null;
        int sourceVolume = -1;
        int sourceDataItemCount = _dataSetSource.getDataItemCount();
        List<DataItem<?>> colDataItems = new ArrayList();
        ArrayList<IDataItem> dataItemSources = new ArrayList<IDataItem>(sourceDataItemCount + 1);
        for (int iDataItem2 = 0; iDataItem2 < sourceDataItemCount; ++iDataItem2) {
            IDataItem dataItem = _dataSetSource.getDataItem(iDataItem2);
            if (dataItem != null) {
                if (sourceVolume < 0) {
                    sourceVolume = 1;
                }
                if (dataItem.getType() == null) {
                    throw new Error("DataItem type must be set to categorical or continuous");
                }
            }
            dataItemSources.add(dataItem);
        }
        List<List<SlotRef>> reverseMappings = DomainResolver.createFixed(sourceDataItemCount);
        List<List<Integer>> mappings = DataSetFactory.createMappings(_hostDataSetDef, dataSetSlots, _mapping, dataItemSources, _decoFilter, reverseMappings);
        int dataItemCount = dataItemSources.size();
        Iterable<IDataPoint> dataPointSources = _dataSetSource.getDataPoints();
        int dataPointCount = DataSetFactory.getCount(dataPointSources);
        if (dataPointCount < 0) {
            dataPointSources = DataSetFactory.toArrayList(dataPointSources);
            dataPointCount = DataSetFactory.getCount(dataPointSources);
        }
        ArrayList<IRSDataPoint> dataPoints = new ArrayList<IRSDataPoint>(dataPointCount);
        ArrayList dataItems = new ArrayList(dataItemCount);
        for (iDataItem = 0; iDataItem < sourceDataItemCount; ++iDataItem) {
            IDataItem dataItemSource = (IDataItem)dataItemSources.get(iDataItem);
            DataItem dataItem = null;
            if (dataItemSource != null) {
                SlotRef slotRef;
                if (sourceVolume < 0) {
                    sourceVolume = 1;
                }
                DataItemType type = dataItemSource.getType();
                List<SlotRef> reverseMapping = reverseMappings.get(iDataItem);
                boolean mapped = reverseMapping != null && reverseMapping.size() > 0;
                SlotRef slotRef2 = slotRef = mapped ? reverseMapping.get(0) : null;
                if (type == DataItemType.Cat) {
                    dataItem = catDataItem = DataSetFactory.determineFactory(reverseMapping, dataItemSource).create((ICatDataItem)dataItemSource, _decoFilter, slotRef, iDataItem, mapped, colDataItems.size());
                    if (sourceVolume > 0) {
                        size = catDataItem.end - catDataItem.start;
                        if (size > 1) {
                            sourceVolume *= size;
                        } else if (size < 1) {
                            sourceVolume = 0;
                        }
                    }
                    sourceVolume *= catDataItem.end - catDataItem.start;
                } else {
                    assert (type == DataItemType.Cont);
                    if (domain == null) {
                        domain = new DomainResolver(dataItems, dataPoints, slots);
                    }
                    dataItem = difContinuous.create((IContDataItem)dataItemSource, _decoFilter, slotRef, iDataItem, mapped, colDataItems.size(), domain, _nls);
                }
                if (dataItem.colIndex >= 0) {
                    colDataItems.add(dataItem);
                }
            }
            dataItems.add(dataItem);
        }
        for (iDataItem = sourceDataItemCount; iDataItem < dataItemCount; ++iDataItem) {
            CatDataItem catDataItem2 = ((GeoSegmentDataItemFactory)dataItemSources.get(iDataItem)).create(dataItems, dataPointSources, colDataItems.size());
            dataItems.add(catDataItem2);
            if (catDataItem2.colIndex < 0) continue;
            colDataItems.add(catDataItem2);
        }
        if (sourceVolume < 0) {
            sourceVolume = 0;
        }
        long vizVolume = sourceVolume > 0 ? 1L : 0L;
        for (int iSlot = 0; iSlot < slotCount; ++iSlot) {
            SlotRef slotRef = dataSetSlots.get(iSlot);
            Slot slot = DataSetFactory.createSlot(_decoFilter, slotRef, mappings.get(iSlot), dataItems, colDataItems, _dataSetDef.hasSlot(slotRef.name), _nls);
            slots.add(slot);
            dataItemCount = slot.dataItems.size();
            for (int iDataItem3 = 0; iDataItem3 < dataItemCount; ++iDataItem3) {
                DataItem dataItem = (DataItem)slot.dataItems.get(iDataItem3);
                if (dataItem.getType() != RSDataItemType.Cat || dataItem.sourceIndex < 0) continue;
                catDataItem = (CatDataItem)dataItem;
                size = catDataItem.end - catDataItem.start;
                if (size > 1 && vizVolume > 0L && slot.forViz) {
                    vizVolume *= (long)size;
                    continue;
                }
                if (size >= 1) continue;
                vizVolume = 0L;
            }
        }
        dataItemCount = dataItems.size();
        colDataItems = DataSetFactory.sortBySlot(colDataItems, slots);
        int colDataItemCount = colDataItems.size();
        IRSDatum[] sourceRow = new IRSDatum[dataItemCount];
        IRSDatum[] rowData = new IRSDatum[colDataItemCount * dataPointCount];
        HashMap<Long, DataPoint> dataPointByOrdinal = new HashMap<Long, DataPoint>();
        int[] colOffsets = DomainResolver.buildOffsets(colDataItems, false);
        boolean overflow = false;
        int iDataPoint = -1;
        int rowStart = -colDataItemCount;
        for (IDataPoint dataPointSource : dataPointSources) {
            int offset;
            int tupleIndex;
            int iDataItem4;
            ++iDataPoint;
            rowStart += colDataItemCount;
            long ordinal = 0L;
            for (iDataItem4 = 0; iDataItem4 < dataItemCount; ++iDataItem4) {
                Object datum = null;
                if (iDataItem4 >= sourceDataItemCount) {
                    datum = ((GeoSegmentDataItemFactory)dataItemSources.get(iDataItem4)).resolveTuple(iDataPoint);
                } else {
                    DataItem dataItem = (DataItem)dataItems.get(iDataItem4);
                    if (dataItem != null) {
                        if (dataItem.getType() == RSDataItemType.Cat) {
                            CatDataItem catDataItem3 = (CatDataItem)dataItem;
                            tupleIndex = dataPointSource.getTupleIndex(iDataItem4);
                            if (tupleIndex < catDataItem3.start || tupleIndex >= catDataItem3.end) {
                                throw new IndexOutOfBoundsException(String.format("Invalid tuple index %d for DataItem %d, must be between %d and %d", tupleIndex, catDataItem3.sourceIndex, catDataItem3.start, catDataItem3.end));
                            }
                            datum = catDataItem3.getTuple(tupleIndex);
                        } else {
                            datum = new Value(dataPointSource.getValue(iDataItem4), _decoFilter, dataItem.slotRef, (ContDataItem)dataItem);
                        }
                    }
                }
                sourceRow[iDataItem4] = datum;
            }
            for (iDataItem4 = 0; iDataItem4 < colDataItemCount; ++iDataItem4) {
                boolean isCat;
                DataItem<?> dataItem = colDataItems.get(iDataItem4);
                Object datum = sourceRow[dataItem.sourceIndex];
                boolean bl = isCat = dataItem.getType() == RSDataItemType.Cat;
                if (isCat && ((Tuple)datum).getDataItemInfo() != dataItem) {
                    datum = ((CatDataItem)dataItem).getTuple(((Tuple)datum).index);
                } else if (!isCat && ((Value)datum).getDataItemInfo() != dataItem) {
                    datum = ((Value)datum).clone(_decoFilter, (ContDataItem)dataItem);
                }
                if (isCat) {
                    tupleIndex = ((Tuple)datum).index - ((CatDataItem)dataItem).start;
                    int offset2 = colOffsets[iDataItem4];
                    if (tupleIndex > 0 && offset2 > 0) {
                        ordinal += (long)(tupleIndex * offset2);
                    }
                }
                rowData[rowStart + dataItem.colIndex] = datum;
            }
            DataPoint dataPoint = (DataPoint)dataPointByOrdinal.get(ordinal);
            int n = offset = dataPoint != null ? dataPoint.offset + 1 : 0;
            if (!(overflow || ordinal <= vizVolume && offset <= 0)) {
                overflow = true;
            }
            dataPoint = new DataPoint(dataPointSource, _decoFilter, dataItems, slots, iDataPoint, ordinal, Arrays.asList(rowData), rowStart, offset);
            dataPointByOrdinal.put(ordinal, dataPoint);
            dataPoints.add(dataPoint);
        }
        if (_dataSetDef.needsSorted || !_dataSetDef.suppressMissing) {
            dataPoints.sort(DataSetFactory::compareDataPoint);
        }
        return new DataSet(_dataSetSource, _decoFilter, _hostDataSetDef, slots, dataItems, dataPoints, _mapping, overflow, false, null);
    }
}

