/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.api.ContDomain;
import com.ibm.vipr.internal.data.CatDataItem;
import com.ibm.vipr.internal.data.ContDataItem;
import com.ibm.vipr.internal.data.DataItem;
import com.ibm.vipr.internal.data.DataPoint;
import com.ibm.vipr.internal.data.Slot;
import com.ibm.vipr.internal.data.Tuple;
import com.ibm.vipr.internal.data.Value;
import com.ibm.vipr.renderingservice.api.IRSCapability;
import com.ibm.vipr.renderingservice.data.IRSDataItem;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.RSDataItemType;
import com.ibm.vipr.renderingservice.data.RSValueType;
import com.ibm.vipr.renderingservice.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DomainResolver {
    private static final String TYPE_FIT = "fit";
    private static final String TYPE_SUM = "sum";
    private static final String TYPE_AVERAGE = "average";
    private static final String TYPE_ACCUMULATE = "accumulate";
    private static final String NEGATIVE_IGNORE = "ignore";
    private static final String NEGATIVE_ABSOLUTE = "absolute";
    private static final String NEGATIVE_AGGREGATE = "aggregate";
    private static final String NEGATIVE_SEPARATE = "separate";
    private final List<DataItem<?>> dataItems;
    private final List<IRSDataPoint> dataPoints;
    private final List<Slot> slots;
    private final Map<String, ContDomain> cache;

    static int[] buildOffsets(List<? extends DataItem<?>> _dataItems, boolean _includeVolume) {
        int len = _dataItems.size();
        int[] result = new int[len + (_includeVolume ? 1 : 0)];
        int volume = 1;
        for (int i = 0; i < len; ++i) {
            DataItem<?> dataItem = _dataItems.get(i);
            if (dataItem.getType() == RSDataItemType.Cat) {
                CatDataItem catDataItem = (CatDataItem)dataItem;
                int size = catDataItem.end - catDataItem.start;
                result[i] = size == 1 ? 0 : volume;
                volume *= size;
                continue;
            }
            result[i] = -1;
        }
        if (_includeVolume) {
            result[len] = volume;
        }
        return result;
    }

    static <T> List<T> createFixed(int _size) {
        ArrayList<Object> result = new ArrayList<Object>(_size);
        for (int i = 0; i < _size; ++i) {
            result.add(null);
        }
        return result;
    }

    public DomainResolver(List<DataItem<?>> _dataItems, List<IRSDataPoint> _dataPoints, List<Slot> _slots) {
        this.dataItems = _dataItems;
        this.dataPoints = _dataPoints;
        this.slots = _slots;
        this.cache = new HashMap<String, ContDomain>();
    }

    public ContDomain resolve(ContDataItem _contDataItem, IRSCapability _aggregation) {
        Aggregator domain;
        String name;
        ContDomain result;
        String type = TYPE_FIT;
        String negative = null;
        String over = null;
        if (_aggregation != null) {
            Map attr = _aggregation.getAttributes();
            if (attr.containsKey("type")) {
                type = (String)attr.get("type");
            }
            if (attr.containsKey("over")) {
                over = (String)attr.get("over");
            }
            if (attr.containsKey("negative")) {
                negative = (String)attr.get("negative");
            }
        }
        if (negative == null) {
            negative = TYPE_FIT.equals(type) || TYPE_ACCUMULATE.equals(type) ? NEGATIVE_AGGREGATE : NEGATIVE_SEPARATE;
        }
        if ((result = this.cache.get(name = StringUtil.format((String)"{0}[{1}-{2}:{3}]", (Object[])new Object[]{_contDataItem.sourceIndex, type, negative, over != null ? over : ""}))) != null) {
            return result;
        }
        Slot overSlot = null;
        ArrayList<CatDataItem> ordinalItems = new ArrayList<CatDataItem>();
        int[] offsets = null;
        int dataItemCount = 0;
        List<Aggregator> bins = null;
        for (Slot slot : this.slots) {
            if (over == null && slot.forViz) continue;
            if (slot.forViz && slot.getName().equals(over)) {
                overSlot = slot;
                continue;
            }
            for (IRSDataItem rsDataItem : slot.getDataItems()) {
                CatDataItem catDataItem = rsDataItem.getType() == RSDataItemType.Cat ? (CatDataItem)rsDataItem : null;
                if (catDataItem == null || catDataItem.sourceIndex < 0 || catDataItem.colIndex < 0 || ordinalItems.contains(catDataItem = (CatDataItem)this.dataItems.get(catDataItem.sourceIndex))) continue;
                ordinalItems.add(catDataItem);
            }
        }
        if (over != null && overSlot == null) {
            throw new Error("Invalid over slot: " + over);
        }
        for (DataItem dataItem : this.dataItems) {
            if (dataItem == null || dataItem.getType() != RSDataItemType.Cat || dataItem.mapped || dataItem.colIndex < 0) continue;
            ordinalItems.add((CatDataItem)dataItem);
        }
        if (!TYPE_FIT.equals(type) && ordinalItems.size() > 0) {
            offsets = DomainResolver.buildOffsets(ordinalItems, true);
            dataItemCount = ordinalItems.size();
            bins = DomainResolver.createFixed(offsets[dataItemCount]);
            domain = new Aggregator(TYPE_FIT, NEGATIVE_AGGREGATE);
        } else {
            domain = new Aggregator(type, negative);
        }
        for (IRSDataPoint rsDP : this.dataPoints) {
            DataPoint dp = (DataPoint)rsDP;
            Value value = (Value)dp.datum(_contDataItem);
            assert (value != null);
            if (value.getValueType() != RSValueType.Numeric || value.getValue() == null) continue;
            double v = ((Number)value.getValue()).doubleValue();
            if (bins != null) {
                int ordinal = 0;
                for (int iDataItem = 0; iDataItem < dataItemCount; ++iDataItem) {
                    CatDataItem catDataItem = (CatDataItem)ordinalItems.get(iDataItem);
                    ordinal += offsets[iDataItem] * (((Tuple)dp.datum((IRSDataItem)catDataItem)).index - catDataItem.start);
                }
                Aggregator bin = bins.get(ordinal);
                if (bin == null) {
                    bin = new Aggregator(type, negative);
                    bins.set(ordinal, bin);
                }
                bin.visit(v);
                continue;
            }
            domain.visit(v);
        }
        if (bins != null) {
            for (Aggregator bin : bins) {
                if (bin == null) continue;
                bin.applyTo(domain);
            }
        }
        result = domain.toContDomain();
        this.cache.put(name, result);
        return result;
    }

    private static class Aggregator {
        final String type;
        final String negative;
        private double _min;
        private double _max;
        private double _vPos;
        private double _vNeg;
        private int _cPos;
        private int _cNeg;

        public Aggregator(String _type, String _negative) {
            this.type = _type;
            this.negative = _negative;
            this._min = 1.0;
            this._max = 0.0;
            this._vPos = 0.0;
            this._vNeg = 0.0;
            this._cPos = 0;
            this._cNeg = 0;
        }

        public boolean isEmpty() {
            return this._cPos < 1 && this._cNeg < 1;
        }

        public void visit(double _value) {
            boolean isNegative;
            double v = _value;
            boolean bl = isNegative = Double.compare(v, 0.0) < 0;
            if (isNegative) {
                switch (this.negative) {
                    case "ignore": {
                        return;
                    }
                    case "absolute": {
                        v = Math.abs(v);
                    }
                    case "aggregate": {
                        isNegative = false;
                        break;
                    }
                    case "separate": {
                        break;
                    }
                    default: {
                        throw new Error("Unhandled negative handling: " + this.negative);
                    }
                }
            }
            boolean fit = false;
            switch (this.type) {
                case "accumulate": {
                    if (isNegative) {
                        this._vNeg += v;
                        v = this._vNeg;
                    } else {
                        this._vPos += v;
                        v = this._vPos;
                    }
                }
                case "fit": {
                    fit = true;
                    break;
                }
                case "average": 
                case "sum": {
                    if (isNegative) {
                        this._vNeg += v;
                        break;
                    }
                    this._vPos += v;
                    break;
                }
                default: {
                    throw new Error("Unhandled aggregation type: " + this.type);
                }
            }
            if (isNegative) {
                ++this._cNeg;
            } else {
                ++this._cPos;
            }
            if (fit) {
                this._fit(v);
            }
        }

        public ContDomain toContDomain() {
            if (this.isEmpty()) {
                return ContDomain.EMPTY;
            }
            this._aggregate();
            return new ContDomain(this._min, this._max);
        }

        public void applyTo(Aggregator _output) {
            if (!this.isEmpty()) {
                this._aggregate();
                _output.visit(this._min);
                _output.visit(this._max);
            }
        }

        private void _fit(double _value) {
            boolean initDomain;
            boolean bl = initDomain = Double.compare(this._min, this._max) > 0;
            if (initDomain || Double.compare(_value, this._min) < 0) {
                this._min = _value;
            }
            if (initDomain || Double.compare(_value, this._max) > 0) {
                this._max = _value;
            }
        }

        private void _aggregate() {
            if (DomainResolver.TYPE_SUM.equals(this.type) || DomainResolver.TYPE_AVERAGE.equals(this.type)) {
                double valuePos = this._vPos;
                double valueNeg = this._vNeg;
                if (DomainResolver.TYPE_AVERAGE.equals(this.type)) {
                    if (this._cNeg > 1) {
                        valueNeg /= (double)this._cNeg;
                    }
                    if (this._cPos > 1) {
                        valuePos /= (double)this._cPos;
                    }
                }
                if (this._cNeg > 0) {
                    this._fit(valueNeg);
                }
                if (this._cPos > 0) {
                    this._fit(valuePos);
                }
            }
        }
    }
}

