/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.data.IFormatter;
import com.ibm.vipr.renderingservice.data.IRSFormatter;
import com.ibm.vipr.renderingservice.data.IRSTemporalAttributes;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

class FormatterUtil {
    private static final String DATE_SEP = "-";
    private static final String DATETIME_SEP = " ";
    private static final String TIME_SEP = ":";
    private static final String FRACTION_SEP = ".";
    private static IRSFormatter labelFormatter = new IRSFormatter(){

        public String format(Object _value) {
            return _value.toString();
        }
    };
    private static IRSFormatter dataFormatter = new IRSFormatter(){

        public String format(Object _value) {
            if (_value instanceof Number) {
                return NumberFormat.getNumberInstance().format(((Number)_value).doubleValue());
            }
            return _value.toString();
        }
    };

    FormatterUtil() {
    }

    public static IRSFormatter createHostFormatter(IFormatter _hostFormatter) {
        return new HostFormatter(_hostFormatter);
    }

    public static IRSFormatter createDefaultFormatter(RSFormatKind _kind) {
        switch (_kind) {
            case Data: {
                return dataFormatter;
            }
            case Label: {
                return labelFormatter;
            }
        }
        throw new Error("Unknown format kind");
    }

    public static IRSFormatter createDefaultTemporalFormatter(RSFormatKind _kind, IRSTemporalAttributes _attributes) {
        StringBuilder pattern = new StringBuilder();
        if (_attributes.hasDate()) {
            if (_attributes.hasYear()) {
                pattern.append("yyyy");
            }
            if (_attributes.hasMonth()) {
                if (pattern.length() > 0) {
                    pattern.append(DATE_SEP);
                }
                pattern.append("MM");
            }
            if (_attributes.hasDay()) {
                if (pattern.length() > 0) {
                    pattern.append(DATE_SEP);
                }
                pattern.append("dd");
            }
        }
        if (_attributes.hasTime()) {
            if (pattern.length() > 0) {
                pattern.append(DATETIME_SEP);
            }
            if (_attributes.hasHour()) {
                pattern.append("HH");
            }
            if (_attributes.hasMinute()) {
                if (_attributes.hasHour()) {
                    pattern.append(TIME_SEP);
                }
                pattern.append("mm");
            }
            if (_attributes.hasSecond()) {
                if (pattern.length() > 0) {
                    pattern.append(TIME_SEP);
                }
                pattern.append("ss");
            }
            if (_attributes.hasFraction()) {
                if (pattern.length() > 0) {
                    pattern.append(FRACTION_SEP);
                }
                pattern.append("S");
            }
        }
        final SimpleDateFormat formatter = new SimpleDateFormat(pattern.toString());
        return new IRSFormatter(){

            public String format(Object _value) {
                if (_value instanceof Date) {
                    return formatter.format((Date)_value);
                }
                return "";
            }
        };
    }

    private static class HostFormatter
    implements IRSFormatter {
        private final IFormatter hostFormatter;

        public String format(Object _value) {
            return this.hostFormatter.format(_value);
        }

        private HostFormatter(IFormatter _hostFormatter) {
            this.hostFormatter = _hostFormatter;
        }
    }
}

