/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.data.ICatDataItem;
import com.ibm.vipr.data.IGeoAttributes;
import com.ibm.vipr.data.IGeoDataItem;
import com.ibm.vipr.data.IGeoTuple;
import com.ibm.vipr.data.ITuple;
import com.ibm.vipr.internal.data.CatDataItem;
import com.ibm.vipr.internal.data.CatDataItemFactory;
import com.ibm.vipr.internal.data.GeoAttributes;
import com.ibm.vipr.internal.data.GeoDataItem;
import com.ibm.vipr.internal.data.GeoTuple;
import com.ibm.vipr.internal.data.ItemClassSet;
import com.ibm.vipr.internal.data.Tuple;
import com.ibm.vipr.renderingservice.data.IRSItem;
import com.ibm.vipr.renderingservice.data.IRSItemClassSet;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.vizdef.SlotRef;
import java.util.List;
import java.util.Set;

class GeoDataItemFactory
extends CatDataItemFactory {
    GeoDataItemFactory() {
    }

    @Override
    protected Tuple createTuple(ITuple _source, Set<String> _decoFilter, SlotRef _slotRef, int _index, ItemClassSet _itemClassSet, List<IRSItem> _items) {
        Double latitude = null;
        Double longitude = null;
        String featureId = null;
        if (_source instanceof IGeoTuple) {
            IGeoTuple geoTuple = (IGeoTuple)_source;
            latitude = geoTuple.getLatitude();
            longitude = geoTuple.getLongitude();
            featureId = geoTuple.getFeatureId();
        }
        return this.createGeoTuple(_source, _decoFilter, _slotRef, _index, _itemClassSet, _items, latitude, longitude, featureId);
    }

    protected GeoTuple createGeoTuple(ITuple _source, Set<String> _decoFilter, SlotRef _slotRef, int _index, ItemClassSet _itemClassSet, List<IRSItem> _items, Double _latitude, Double _longitude, String _featureId) {
        return new GeoTuple(_source, _decoFilter, _slotRef, _index, _itemClassSet, _items, _latitude, _longitude, _featureId);
    }

    @Override
    protected CatDataItem createDataItem(ICatDataItem _dataItem, Set<String> _decoFilter, SlotRef _slotRef, int _sourceIndex, boolean _mapped, int _colIndex, int _tupleCount, int _start, int _end, List<IRSItemClassSet> _itemClassSets, List<IRSTuple> _tuples) {
        GeoAttributes geoAttr = null;
        if (_dataItem == null) {
            geoAttr = this.createGeoAttributes();
        } else {
            IGeoAttributes attributes = ((IGeoDataItem)_dataItem).getGeoAttributes();
            geoAttr = new GeoAttributes(attributes.hasCaption(), attributes.hasLatitude(), attributes.hasLongitude(), attributes.hasFeatureId());
        }
        return new GeoDataItem(_dataItem, _decoFilter, _slotRef, _sourceIndex, _mapped, _colIndex, _tupleCount, _start, _end, _itemClassSets, _tuples, geoAttr);
    }

    protected GeoAttributes createGeoAttributes() {
        throw new UnsupportedOperationException("GeoDataItemFactory must receive a valid IGeoDataItem");
    }
}

