/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.data.DataItemType;
import com.ibm.vipr.data.ICatDataItem;
import com.ibm.vipr.data.IDataPoint;
import com.ibm.vipr.data.IItemClassSet;
import com.ibm.vipr.data.ITuple;
import com.ibm.vipr.data.IValue;
import com.ibm.vipr.data.ValueType;
import com.ibm.vipr.internal.data.CatDataItem;
import com.ibm.vipr.internal.data.ContDataItem;
import com.ibm.vipr.internal.data.DataItem;
import com.ibm.vipr.internal.data.GeoAttributes;
import com.ibm.vipr.internal.data.GeoDataItem;
import com.ibm.vipr.internal.data.GeoDataItemFactory;
import com.ibm.vipr.internal.data.GeoTuple;
import com.ibm.vipr.internal.data.ItemClassSet;
import com.ibm.vipr.internal.data.Tuple;
import com.ibm.vipr.renderingservice.data.IRSItem;
import com.ibm.vipr.renderingservice.data.IRSItemClass;
import com.ibm.vipr.renderingservice.data.IRSItemClassSet;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.vizdef.GeoSlotRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class GeoSegmentDataItemFactory
extends GeoDataItemFactory
implements ICatDataItem {
    private static List<IRSItem> EMPTY_ITEMS = Collections.unmodifiableList(new ArrayList(0));
    private static List<IRSItemClass> EMPTY_ITEMCLASSES = Collections.unmodifiableList(new ArrayList(0));
    public final int index;
    private final Set<String> decoFilter;
    public final GeoSlotRef slotRef;
    public final List<Integer> mapping;
    private GeoDataItem dataItem;
    private GeoAttributes geoAttributes;

    private static Double latLongFromSource(IValue _value) {
        Number v;
        Double result = null;
        if (_value != null && _value.getValueType() == ValueType.Numeric && (v = (Number)_value.getValue()) != null) {
            result = v.doubleValue();
        }
        return result;
    }

    public GeoSegmentDataItemFactory(int _index, Set<String> _decoFilter, GeoSlotRef _slotRef, List<Integer> _mapping) {
        this.index = _index;
        this.decoFilter = _decoFilter;
        this.slotRef = _slotRef;
        this.mapping = _mapping;
        this.dataItem = null;
        this.geoAttributes = null;
    }

    CatDataItem create(List<DataItem<?>> _dataItems, Iterable<IDataPoint> _dataPointSources, int _colIndex) {
        ArrayList<IRSItemClassSet> itemClassSets = new ArrayList<IRSItemClassSet>();
        ArrayList<IRSTuple> tuples = new ArrayList<IRSTuple>();
        ItemClassSet emptyIcs = null;
        CatDataItem captionDI = null;
        CatDataItem featureIdDI = null;
        ContDataItem latitudeDI = null;
        ContDataItem longitudeDI = null;
        int len = this.slotRef.segments.size();
        block6: for (int i = 0; i < len; ++i) {
            Integer mapping = this.mapping.get(i);
            if (mapping == null) continue;
            DataItem<?> dataItem = _dataItems.get(mapping);
            switch (this.slotRef.segments.get((int)i).part) {
                case Caption: {
                    captionDI = (CatDataItem)dataItem;
                    continue block6;
                }
                case FeatureId: {
                    featureIdDI = (CatDataItem)dataItem;
                    continue block6;
                }
                case Latitude: {
                    latitudeDI = (ContDataItem)dataItem;
                    continue block6;
                }
                case Longitude: {
                    longitudeDI = (ContDataItem)dataItem;
                    continue block6;
                }
                default: {
                    throw new Error("Unknown segment part: " + (Object)((Object)this.slotRef.segments.get((int)i).part));
                }
            }
        }
        for (IDataPoint dataPoint : _dataPointSources) {
            List<IRSItem> items;
            ItemClassSet itemClassSet;
            IRSTuple tuple;
            Tuple caption = null;
            String featureId = null;
            Double latitude = null;
            Double longitude = null;
            if (captionDI != null) {
                caption = (Tuple)captionDI.getTuple(dataPoint.getTupleIndex(captionDI.sourceIndex));
            }
            if (featureIdDI != null && (tuple = featureIdDI.getTuple(dataPoint.getTupleIndex(featureIdDI.sourceIndex))) != null) {
                featureId = tuple.getCaption(RSFormatKind.Label);
            }
            if (latitudeDI != null) {
                latitude = GeoSegmentDataItemFactory.latLongFromSource(dataPoint.getValue(latitudeDI.sourceIndex));
            }
            if (longitudeDI != null) {
                longitude = GeoSegmentDataItemFactory.latLongFromSource(dataPoint.getValue(longitudeDI.sourceIndex));
            }
            if (caption != null) {
                itemClassSet = caption.itemClassSet;
                items = caption.items;
            } else {
                itemClassSet = emptyIcs;
                items = EMPTY_ITEMS;
                if (itemClassSet == null) {
                    emptyIcs = itemClassSet = new ItemClassSet(null, this.slotRef, EMPTY_ITEMCLASSES);
                }
            }
            if (itemClassSets.indexOf(itemClassSet) < 0) {
                itemClassSets.add(itemClassSet);
            }
            GeoTuple tuple2 = this.createGeoTuple(caption != null ? (ITuple)caption.source : null, this.decoFilter, this.slotRef, tuples.size(), itemClassSet, items, latitude, longitude, featureId);
            tuples.add(tuple2);
        }
        this.geoAttributes = new GeoAttributes(captionDI != null, latitudeDI != null, longitudeDI != null, featureIdDI != null);
        int tupleCount = tuples.size();
        this.dataItem = (GeoDataItem)this.createDataItem(null, this.decoFilter, this.slotRef, this.index, true, _colIndex, tupleCount, 0, tupleCount, itemClassSets, tuples);
        return this.dataItem;
    }

    IRSTuple resolveTuple(int _dataPointIndex) {
        return (IRSTuple)this.dataItem.tuples.get(_dataPointIndex);
    }

    @Override
    protected GeoAttributes createGeoAttributes() {
        return this.geoAttributes;
    }

    @Override
    public boolean hasDecoration(String _name) {
        return false;
    }

    @Override
    public Object getDecoration(String _name) {
        return null;
    }

    @Override
    public DataItemType getType() {
        return DataItemType.Cat;
    }

    @Override
    public int getItemClassSetCount() {
        return 0;
    }

    @Override
    public IItemClassSet getItemClassSet(int _index) {
        return null;
    }

    @Override
    public int getTupleCount() {
        return 0;
    }

    @Override
    public int getDataWindowStart() {
        return 0;
    }

    @Override
    public int getDataWindowEnd() {
        return 0;
    }

    @Override
    public ITuple getTuple(int _indexOnDataItem) {
        return null;
    }
}

