/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.data.FormatKind;
import com.ibm.vipr.data.IItemClass;
import com.ibm.vipr.info.IItemClassInfo;
import com.ibm.vipr.info.InfoType;
import com.ibm.vipr.internal.data.DataContext;
import com.ibm.vipr.internal.data.ItemClassSet;
import com.ibm.vipr.internal.data.Slotted;
import com.ibm.vipr.internal.util.JoinUtil;
import com.ibm.vipr.renderingservice.data.IRSItemClass;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.vizdef.SlotRef;
import java.util.Set;

class ItemClass
extends Slotted<IItemClass>
implements IRSItemClass,
IItemClassInfo {
    public final int index;

    public ItemClass(IItemClass _source, Set<String> _decoFilter, SlotRef _slotRef, int _index) {
        super(_source, _decoFilter, _slotRef);
        this.index = _index;
    }

    @Override
    public InfoType getInfoType() {
        return InfoType.ItemClass;
    }

    @Override
    public String getUniqueName() {
        return ((IItemClass)this.source).getUniqueName();
    }

    public int getIndex() {
        return this.index;
    }

    public String getCaption(RSFormatKind _kind) {
        return this.getCaption(ItemClass.fromRS(_kind));
    }

    public String getSubCaption(RSFormatKind _kind) {
        return this.getSubCaption(ItemClass.fromRS(_kind));
    }

    public String combineCaptions(RSFormatKind _kind) {
        return this.combineCaptions(ItemClass.fromRS(_kind));
    }

    @Override
    public String getCaption(FormatKind _kind) {
        return JoinUtil.normalize(((IItemClass)this.source).getCaption(FormatKind.validate(_kind)));
    }

    @Override
    public String getSubCaption(FormatKind _kind) {
        return JoinUtil.normalize(((IItemClass)this.source).getSubCaption(FormatKind.validate(_kind)));
    }

    @Override
    public String combineCaptions(FormatKind _kind) {
        String caption = this.getCaption(_kind);
        String subCaption = this.getSubCaption(_kind);
        if (!subCaption.isEmpty()) {
            if (!subCaption.startsWith("(") || !subCaption.endsWith(")")) {
                subCaption = String.format("(%s)", subCaption);
            }
            if (!caption.isEmpty()) {
                caption = caption + " ";
            }
            caption = caption + subCaption;
        }
        return caption;
    }

    ItemClass clone(Set<String> _decoFilter, SlotRef _slotRef) {
        return new ItemClass((IItemClass)this.source, _decoFilter, _slotRef, this.index);
    }

    void applyContext(DataContext _context, ItemClassSet _itemClassSet) {
        if (_itemClassSet != null) {
            _context.setOwner(this, _itemClassSet);
        }
    }
}

