/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.data.FormatKind;
import com.ibm.vipr.data.IItemClassSet;
import com.ibm.vipr.info.IItemClassInfo;
import com.ibm.vipr.info.IItemClassSetInfo;
import com.ibm.vipr.info.InfoType;
import com.ibm.vipr.internal.data.DataContext;
import com.ibm.vipr.internal.data.DataItem;
import com.ibm.vipr.internal.data.DataObject;
import com.ibm.vipr.internal.data.ItemClass;
import com.ibm.vipr.internal.util.JoinUtil;
import com.ibm.vipr.renderingservice.data.IRSItemClass;
import com.ibm.vipr.renderingservice.data.IRSItemClassSet;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.vizdef.SlotRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class ItemClassSet
extends DataObject<IItemClassSet>
implements IRSItemClassSet,
IItemClassSetInfo {
    private static final String ITEMCLASSSET_CAPTION_JOIN = " - ";
    public final SlotRef slotRef;
    public final List<IRSItemClass> itemClasses;

    static ItemClassSet create(ItemClass _itemClass) {
        ArrayList<IRSItemClass> itemClasses = new ArrayList<IRSItemClass>(1);
        itemClasses.add(_itemClass);
        return new ItemClassSet(null, _itemClass.slotRef, itemClasses);
    }

    public ItemClassSet(IItemClassSet _source, SlotRef _slotRef, List<IRSItemClass> _itemClasses) {
        super(_source);
        this.slotRef = _slotRef;
        this.itemClasses = Collections.unmodifiableList(_itemClasses);
    }

    public List<IRSItemClass> getItemClasses() {
        return this.itemClasses;
    }

    public int getItemClassCount() {
        return this.itemClasses.size();
    }

    public IRSItemClass getItemClass(int _index) {
        return _index >= 0 && _index < this.itemClasses.size() ? this.itemClasses.get(_index) : null;
    }

    public String getCaption(RSFormatKind _kind) {
        return JoinUtil.joinCaptions(this.itemClasses, _kind, ITEMCLASSSET_CAPTION_JOIN);
    }

    public String getSubCaption(RSFormatKind _kind) {
        return JoinUtil.joinSubCaptions(this.itemClasses, _kind, ITEMCLASSSET_CAPTION_JOIN);
    }

    public String combineCaptions(RSFormatKind _kind) {
        return JoinUtil.joinCombinedCaptions(this.itemClasses, _kind, ITEMCLASSSET_CAPTION_JOIN);
    }

    @Override
    public SlotRef getSlotRef() {
        return this.slotRef;
    }

    @Override
    public InfoType getInfoType() {
        return InfoType.ItemClassSet;
    }

    @Override
    public List<IItemClassInfo> getItemClassInfos() {
        return ItemClassSet.toInfo(this.itemClasses);
    }

    @Override
    public String getCaption(FormatKind _kind) {
        return this.getCaption(ItemClassSet.toRS(_kind));
    }

    @Override
    public String getSubCaption(FormatKind _kind) {
        return this.getSubCaption(ItemClassSet.toRS(_kind));
    }

    @Override
    public String combineCaptions(FormatKind _kind) {
        return this.combineCaptions(ItemClassSet.toRS(_kind));
    }

    ItemClassSet clone(Set<String> _decoFilter, SlotRef _slotRef) {
        int len = this.itemClasses.size();
        ArrayList<IRSItemClass> itemClasses = new ArrayList<IRSItemClass>(len);
        for (int i = 0; i < len; ++i) {
            itemClasses.add(((ItemClass)this.itemClasses.get(i)).clone(_decoFilter, _slotRef));
        }
        return new ItemClassSet((IItemClassSet)this.source, _slotRef, itemClasses);
    }

    void applyContext(DataContext _context, DataItem<?> _dataItem) {
        if (_dataItem != null) {
            _context.setOwner(this, _dataItem);
        }
        for (IRSItemClass rsItemClass : this.itemClasses) {
            assert (rsItemClass != null);
            ((ItemClass)rsItemClass).applyContext(_context, this);
        }
    }
}

