/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vipr.internal.data;

import com.ibm.vipr.api.ICapability;
import com.ibm.vipr.api.INls;
import com.ibm.vipr.info.ICatDataItemInfo;
import com.ibm.vipr.renderingservice.util.StringUtil;
import com.ibm.vipr.truncation.LimitTruncation;
import com.ibm.vipr.truncation.Truncation;
import com.ibm.vipr.truncation.TruncationInfo;
import com.ibm.vipr.truncation.UnaggregatedTruncation;
import com.ibm.vipr.vizdef.SlotRef;
import java.util.ArrayList;
import java.util.List;

class TruncationFactory {
    private final INls nls;
    private final List<Truncation> truncations;

    public TruncationFactory(INls _nls) {
        this.nls = _nls;
        this.truncations = new ArrayList<Truncation>();
    }

    public void addSlot(ICapability _capability, int _limit, int _full, SlotRef _slotRef, ICatDataItemInfo _dataItem) {
        if (_slotRef == null || _dataItem == null) {
            throw new IllegalArgumentException("_slotRef and _dataItem are mandatory");
        }
        this.addLimit(_capability, _limit, _full, _slotRef, _dataItem);
    }

    public void addData(ICapability _capability, long _limit, long _full) {
        this.addLimit(_capability, _limit, _full, null, null);
    }

    public void addUnaggregated() {
        if (this.findUnaggregated() == null) {
            this.truncations.add(new UnaggregatedTruncation(this.nls.get("duplicate_truncation")));
        }
    }

    public TruncationInfo create() {
        return this.truncations.size() < 1 ? null : new TruncationInfo(this.nls.get("data_truncation"), this.truncations);
    }

    private LimitTruncation findLimit(ICapability _capability, SlotRef _slotRef, ICatDataItemInfo _dataItem) {
        for (Truncation trunc : this.truncations) {
            if (!(trunc instanceof LimitTruncation)) continue;
            LimitTruncation limit = (LimitTruncation)trunc;
            if (limit.capability != _capability || limit.slotRef != _slotRef || limit.dataItem != _dataItem) continue;
            return limit;
        }
        return null;
    }

    private UnaggregatedTruncation findUnaggregated() {
        for (Truncation trunc : this.truncations) {
            if (!(trunc instanceof UnaggregatedTruncation)) continue;
            return (UnaggregatedTruncation)trunc;
        }
        return null;
    }

    private LimitTruncation addLimit(ICapability _capability, long _limit, long _full, SlotRef _slotRef, ICatDataItemInfo _dataItem) {
        LimitTruncation trunc = this.findLimit(_capability, _slotRef, _dataItem);
        if (trunc == null) {
            trunc = new LimitTruncation(_slotRef != null ? StringUtil.format((String)this.nls.get("tuple_truncation"), (Object[])new Object[]{_slotRef.caption, _limit, _full}) : StringUtil.format((String)this.nls.get("datapoint_truncation"), (Object[])new Object[]{_limit}), _capability, _limit, _full, _slotRef, _dataItem);
            this.truncations.add(trunc);
        }
        return trunc;
    }
}

